#pragma once

#ifndef tlogclass_H
#define tlogclass_H

#include <time.h>

#include "util/system/mutex.h"
#include "util/generic/string.h"
#include "util/generic/hash.h"
#include <library/cpp/logger/log.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifdef _win_
#include <io.h>
#endif

#include "tkconfig.h"

typedef enum { KERROR,
               KMESSAGE,
               KWARNING,
               KINFO } TLogStatus;

//**************************************************************************************
//                              TBaseLogClass
//**************************************************************************************

class TBaseLogClass {
protected:
    //#ifdef VERSION_TAG
    TMutex m_Mutex;
    //#else
    //         Os::Thread_Mutex  m_Mutex;
    //#endif
    bool enable_write;

    void Lock();
    void UnLock();
    TString KTrim(TString s);

public:
    TBaseLogClass();
    virtual ~TBaseLogClass();

    void DisableWrite();
    void EnableWrite();
    bool GetWriteStatus();     //true - enable, false - disable
    TString GetWriteStatusS(); //� ��������� �������������

    virtual TString GetTekFilename() = 0;
    virtual TString FFlushStatus() = 0;

    virtual bool WriteMessage(const char* msg, ...) = 0;
    virtual bool WriteMessageBUFF(const char* BUFF, ui32 BUFFSize) = 0;
    virtual bool WriteMessageAndData(const char* msg, ...) = 0;
    virtual bool WriteMessageAndDataBUFF(const char* BUFF, ui32 BUFFSize) = 0;
    virtual bool WriteMessageAndDataBUFFExt(const char* prefix, const char* postfix, const char* BUFF, ui32 BUFFSize) = 0;
    virtual bool WriteMessageAndDataStatus(TLogStatus status, const char* msg, ...) = 0;
    virtual bool WriteMessageAndDataStatusBUFF(TLogStatus status, const char* BUFF, ui32 BUFFSize) = 0;
    virtual bool IsOpenFile() = 0;
};

//**************************************************************************************
//                               TLogClass
//**************************************************************************************

class TLogClass: public TBaseLogClass {
private:
    TString filename;
    TString filenamearx;
    FILE* handle;
    bool fadddate;
    ui16 fyear;
    ui16 fmon;
    ui16 fday;
    TString tfilename;
    TString openfilemode;
    ui16 lifetime;
    ui16 lifetimeArx;
    volatile bool disable_fflush;
    TString fileshap;
    fpos_t m_diffpos;
    bool m_isset_diffpos;

    TString GetFilename();
    bool filename_change(); //true - ��� ����� ���������� (���������� ���� � ����� �����)
    void CreateFileIfNotExists(const TString& filename);

public:
    TLogClass(const TString& filenameA, bool AddDate = true);
    TLogClass(const TString& filenameA, bool AddDate, const TString& shapA);
    ~TLogClass();

    void SetDiffPoint();
    TString GetDiff();
    TString GetDiff2();
    bool TruncLog();
    bool WriteMessage(const char* msg, ...);
    bool WriteMessageBUFF(const char* BUFF, ui32 BUFFSize);
    bool WriteMessageAndData(const char* msg, ...);
    bool WriteMessageAndDataBUFF(const char* BUFF, ui32 BUFFSize);
    bool WriteMessageAndDataBUFFExt(const char* prefix, const char* postfix, const char* BUFF, ui32 BUFFSize);
    bool WriteMessageAndDataStatus(TLogStatus status, const char* msg, ...);
    bool WriteMessageAndDataStatusBUFF(TLogStatus status, const char* BUFF, ui32 BUFFSize);
    TString GetTekFilename();
    void SetLifeTime(ui16 lifetimeA);
    ui16 GetLifeTime();
    void SetLifeTimeArx(ui16 lifetimeA);
    ui16 GetLifeTimeArx();
    TString GetBaseFilename();
    TString GetTimeFilename(time_t ttek, bool& del);
    TString GetTimeFilenameArx(time_t ttek, bool& del);
    TString GetTimeOnlyFilenameArx(time_t ttek);
    void SetArchivePath(TString ArchivePath);
    void SetDisableFFlush(bool disable);
    TString FFlushStatus();
    bool IsOpenFile();

    void FFlush();
    void RotateLogs();

    void SetFileShap(TString& shapA);
};

//*************************************************************************************
//                                TGroupLogClass
//*************************************************************************************

typedef THashMap<TString, TLogClass*> TGroupLogHash;
typedef TGroupLogHash::iterator TGroupLogHashIt;

class TGroupLogClass: public TBaseLogClass {
private:
    TGroupLogHash data;
    THashMap<TString, TLog> loggers;
    TString       filename; //Ident - ��� ������, filename - ����.
    bool          fadddate;
    volatile bool disable_fflush;
    TKConfig      *IniFile;
    TString       DEFAULTIDENT;

    TString       AddIdentToFilename(const TString &ident, bool& enabled);
    TLogClass*    GetLogClass(const TString &Ident);
    const TLog&          GetLoggerClass(const TString &Ident);

public:
    TGroupLogClass(TKConfig *IniFileA, TString filenameA, bool AddDate);
    ~TGroupLogClass();

    bool WriteMessage(const char* msg, ...);
    bool WriteMessage(TString Ident, const char* msg, ...);
    bool WriteMessageBUFF(const char* BUFF, ui32 BUFFSize);
    bool WriteMessageAndData(const char* msg, ...);
    bool WriteMessageAndData(TString Ident, const char* msg, ...);
    bool WriteMessageAndDataBUFF(const char* BUFF, ui32 BUFFSize);
    bool WriteMessageAndDataBUFFExt(const char* prefix, const char* postfix, const char* BUFF, ui32 BUFFSize);
    bool WriteMessageAndDataStatus(TLogStatus status, const char* msg, ...);
    bool WriteMessageAndDataStatus(const TString &Ident, TLogStatus status, const char* msg, ...);
    bool WriteMessageAndDataStatusBUFF(TLogStatus status, const char* BUFF, ui32 BUFFSize);

    void    SetDisableFFlush(bool disable);
    TString FFlushStatus();
    bool    TruncLog();

    TString GetTekFilename() {
        return "";
    }

    TLogClass* GetLog(const TString &Ident);
    const TLog& GetLogger(const TString &Ident);

    bool IsOpenFile() {
        return true;
    }
};

//*************************************************************************************

#endif
