#pragma once

#include <util/generic/string.h>
#include <util/system/mutex.h>

#include "tkinifile.h"
#include "tkconfig.h"
#include "tlogclass.h"
#include "tlogclass.h"

//****************************************************************************************************************************************
//                                              TLogsGroup
//****************************************************************************************************************************************

class TLogsGroupBase {
public:
    bool m_debug_mode;
    TMutex m_Mutex;
    TString m_server_id;

    int m_longrequest_mode;
    int m_longrequest_treshold;

public:
    TLogsGroupBase();
    virtual ~TLogsGroupBase();

    virtual bool Init(TKConfig* iniobjA) = 0;
    virtual TLogClass* GetServerLog() = 0;
    virtual TLogClass* GetDebugInfoLog() = 0;
    virtual TLogClass* GetInputLog() = 0;
    virtual TLogClass* GetLongRequestLog() = 0;
    virtual void DisableFFlush(bool dsb) = 0;
    virtual bool TruncLog() = 0;
    virtual TLogClass* GetStorageLog() = 0;

    void SetDebugMode(bool debug);

    bool GetDebugMode()
    {
        return m_debug_mode;
    }

    void SetServerID(const TString& server_id);

    TString GetServerID()
    {
        return m_server_id;
    }

    int GetLongrequestMode()
    {
        return m_longrequest_mode;
    }

    int GetLongrequestTreshold()
    {
        return m_longrequest_treshold;
    }

    TLogClass *CreateLog(const TString &log_filename, bool add_date = true)
    {
       TLogClass *res = NULL;

       if (!log_filename.empty())
       {
           res = new TLogClass(log_filename, add_date);
           if (res != NULL)
              ((TLogClass *)res)->EnableWrite();
       }

       return res;
    }

    void DeleteLog(TLogClass *log_obj)
    {
       if (log_obj != NULL)
       {
          delete log_obj;
          log_obj = NULL;
       }
    }
};

//******************************************************************************************************************************************
