#pragma once

#ifndef tparseddlvlogtypes_H
#define tparseddlvlogtypes_H

#include <array>
#include "tkipv6.h"
#include "kfunc.h"
#include <list>

class TTBuffStruct {
private:
    static const int buff_size = 65000;

private:
    char* m_buff;

public:
    TTBuffStruct() {
        m_buff = new char[buff_size];
    }

    ~TTBuffStruct() {
        if (m_buff != nullptr) {
            delete[] m_buff;
            m_buff = nullptr;
        }
    }

    size_t size() {
        size_t res = 0;

        if (m_buff != nullptr)
            res = buff_size;

        return res;
    }

    void Clear() {
        if (m_buff != nullptr)
            memset(m_buff, 0, buff_size);
    }

    char* GetBuff() {
        return m_buff;
    }

    void SetLastSymbToNull() {
        if ((m_buff != nullptr) && (buff_size > 0))
            m_buff[buff_size - 1] = 0x00;
    }

    bool ValidBuffer() {
        bool res = false;

        if ((m_buff != nullptr) && (buff_size > 0))
            res = true;

        return res;
    }

    TString GetDlvPrefix() {
        TString res = "";
        char symb = 0x00;
        const char* p = nullptr;
        int count = 0;
        bool bad_symb = false;

        if ((m_buff != nullptr) && (buff_size > 0)) {
            p = strchr(m_buff, ':');
            if (p != nullptr) {
                count = p - m_buff;
                if ((count > 0) && (count <= 30)) {
                    bad_symb = false;
                    for (int i = 0; i < count; i++) {
                        symb = *(m_buff + i);
                        if ((symb >= 0) && (symb < ' ')) {
                            bad_symb = true;
                            break;
                        }
                    }
                    if (!bad_symb)
                        res = TString(m_buff, count);
                }
            }
        }

        return res;
    }
};

struct TSummaryIPInfo {
    TKIPv6 m_ip;
    TString m_rdns;
    TString m_rdns2;
    TString m_rdns3;
    TString m_helo;

    Y_SAVELOAD_DEFINE(m_ip, m_rdns, m_rdns2, m_rdns3, m_helo)

    TSummaryIPInfo() = default;

    TSummaryIPInfo(const TKIPv6 ipA, const TString& rdnsA, const TString& heloA) {
        m_ip = ipA;
        m_rdns = rdnsA;
        m_rdns2 = GetDomen2level(m_rdns);
        m_rdns3 = GetDomen3level(m_rdns);
        m_helo = heloA;
    }

    TSummaryIPInfo(const TKIPv6 ipA, const TString& rdnsA, const TString& rdns2A, const TString& rdns3A, const TString& heloA) {
        m_ip = ipA;
        m_rdns = rdnsA;
        m_rdns2 = rdns2A;
        m_rdns3 = rdns3A;
        m_helo = heloA;
    }

    TString PrintVirtualDlvLogSource() const {
        TString bold_start_tag = ""; //"<b>";
        TString bold_end_tag = "";   //"</b>";
        TString cr_tag = "";         //"<br>";

        return bold_start_tag + "rcvd:" + bold_end_tag + " source ip = " + m_ip.toStroka() + "  rdns = " + m_rdns + "  helo = " + m_helo + cr_tag + "\n";
    }

    TString PrintVirtualDlvLogNext() const {
        TString bold_start_tag = ""; //"<b>";
        TString bold_end_tag = "";   //"</b>";
        TString cr_tag = "";         //"<br>";

        return bold_start_tag + "rcvd:" + bold_end_tag + " next ip = " + m_ip.toStroka() + "  rdns = " + m_rdns + "  helo = " + m_helo + cr_tag + "\n";
    }

    TString ToStroka() const {
        TString res = "";

        res = res + m_ip.toStroka() + "~";
        res = res + m_rdns + "~";
        res = res + m_rdns2 + "~";
        res = res + m_rdns3 + "~";
        res = res + m_helo + "~";

        return res;
    }
};

typedef std::list<TSummaryIPInfo> TIpInfoList;

struct TIPAddresses {
    TSummaryIPInfo sourceip;
    TIpInfoList nextip;

    Y_SAVELOAD_DEFINE(sourceip, nextip)

    TIPAddresses() = default;

    TString PrintVirtualDlvLog() const {
        TString res = "";

        res += sourceip.PrintVirtualDlvLogSource();
        auto it = nextip.begin();
        while (it != nextip.end()) {
            res += (*it).PrintVirtualDlvLogNext();

            ++it;
        }

        return res;
    }
};

using TTempArrayK = std::pair<std::array<std::byte, 128>, std::array<std::byte, 128>>;
using TBoolArrayK = std::array<bool, 15>;

struct TWRuleStat {
    TString rulename;
    ui32 count_ham{};
    ui32 count_spam{};
    ui32 count_malic{};

    Y_SAVELOAD_DEFINE(rulename, count_ham, count_spam, count_malic)

    TWRuleStat() = default;

    TWRuleStat(TString rulename, ui32 countspamA, ui32 counthamA, ui32 countmalicA) noexcept : rulename(std::move(rulename)) {
        count_spam = countspamA;
        count_ham = counthamA;
        count_malic = countmalicA;
    }

    TString ToPrint() const {
        return rulename + " " + IntToStroka(count_ham) + " " + IntToStroka(count_spam) + " " + IntToStroka(count_malic);
    }
};

typedef TList<TWRuleStat> TWorkRuleListExt;

struct TSrvcErrExt {
    int clt_error = 1;
    int conn_err = 1;
    int exterr{};

    Y_SAVELOAD_DEFINE(clt_error, conn_err, exterr)

    TSrvcErrExt() = default;

    TSrvcErrExt(int clt_errorA, int conn_errA, int exterrA) noexcept {
        clt_error = clt_errorA;
        conn_err = conn_errA;
        exterr = exterrA;
    }

    TString ToText() const {
        TString res = "";

        res = IntToStroka(clt_error) + IntToStroka(conn_err) + IntToStroka(exterr);

        return res;
    }
};

struct TSrvcErr {
    TSrvcErrExt m_urlreputation;
    TSrvcErrExt m_textprocessor;
    TSrvcErrExt m_reputation_get;
    TSrvcErrExt m_reputation_put;
    TSrvcErrExt m_shingler_get;
    TSrvcErrExt m_shingler_put;
    TSrvcErrExt m_statipserver;
    TSrvcErrExt m_dlvlogserver;
    TSrvcErrExt m_freemail_get;
    TSrvcErrExt m_freemail_put;
    TSrvcErrExt m_reserv0;
    TSrvcErrExt m_reserv1;
    TSrvcErrExt m_reserv2;
    TSrvcErrExt m_reserv3;
    TSrvcErrExt m_reserv4;
    TSrvcErrExt m_reserv5;
    TSrvcErrExt m_reserv6;
    TSrvcErrExt m_reserv7;
    TSrvcErrExt m_reserv8;
    TSrvcErrExt m_reserv9;

    Y_SAVELOAD_DEFINE(
        m_urlreputation,
        m_textprocessor,
        m_reputation_get,
        m_reputation_put,
        m_shingler_get,
        m_shingler_put,
        m_statipserver,
        m_dlvlogserver,
        m_freemail_get,
        m_freemail_put,
        m_reserv0,
        m_reserv1,
        m_reserv2,
        m_reserv3,
        m_reserv4,
        m_reserv5,
        m_reserv6,
        m_reserv7,
        m_reserv8,
        m_reserv9
    )

    TSrvcErr() = default;

    TString ToText() const {
        TString res = "";

        res = res + m_urlreputation.ToText() + "~";
        res = res + m_textprocessor.ToText() + "~";
        res = res + m_reputation_get.ToText() + "~";
        res = res + m_reputation_put.ToText() + "~";
        res = res + m_shingler_get.ToText() + "~";
        res = res + m_shingler_put.ToText() + "~";
        res = res + m_statipserver.ToText() + "~";
        res = res + m_dlvlogserver.ToText() + "~";
        res = res + m_freemail_get.ToText() + "~";
        res = res + m_freemail_put.ToText() + "~";
        res = res + m_reserv0.ToText() + "~";
        res = res + m_reserv1.ToText() + "~";
        res = res + m_reserv2.ToText() + "~";
        res = res + m_reserv3.ToText() + "~";
        res = res + m_reserv4.ToText() + "~";
        res = res + m_reserv5.ToText() + "~";
        res = res + m_reserv6.ToText() + "~";
        res = res + m_reserv7.ToText() + "~";
        res = res + m_reserv8.ToText() + "~";
        res = res + m_reserv9.ToText();

        return res;
    }
};

typedef enum {
    enMETA_SHINGLES_1,
    enMETA_SHINGLES_2_5,
    enMETA_SHINGLES_5_10,
    enMETA_SHINGLES_10_100,
    enMETA_SHINGLES_100_200,
    enMETA_SHINGLES_200_1000,
    enMETA_SHINGLES_MAX
} TSpMetaShingles;

typedef enum {
    enMCOUNT_0,
    enMCOUNT_0_1,
    enMCOUNT_1_2,
    enMCOUNT_2_3,
    enMCOUNT_3_10,
    enMCOUNT_10_50,
    enMCOUNT_50_200,
    enMCOUNT_MAX
} TSpMCount;

enum TSTRTYPEDLV { DST_UNKNOWN,
                   DST_RECEIVED,
                   DST_WEIGHT,
                   DST_SPAM,
                   DST_REPORT_SPAM,
                   DST_REPORT_DLV,
                   DST_REPORT_NULL,
                   DST_RULE_STAT,
                   DST_SOURCE,
                   DST_FIXED_BY_RULE,
                   DST_MESSAGE,
                   DST_LOG,
                   DST_SUBJ,
                   DST_HTTP,
                   DST_PHONE,
                   DST_GEO,
                   DST_MESSID,
                   DST_QUEUEID,
                   DST_EXTSRVERRORS };

//**************************************************************************************************************************************

#endif
