#include <library/cpp/digest/old_crc/crc.h>

#include "tparsedlvlog_data.h"
#include "sobase64.h"

//*************************************************************************************************************************************
//                                        TParsedDlvLogDataExport
//*************************************************************************************************************************************

TString TParsedDlvLogDataExport::PrintVirtualDlvLog() const {
    TString res = "";
    char tbuff[256];
    TString bold_start_tag = ""; //"<b>";
    TString bold_end_tag = "";   //"</b>";
    TString cr_tag = "";         //"<br>";

    /*dlvtypehash["rcvd"]              = DST_RECEIVED;
         dlvtypehash["wght"]              = DST_WEIGHT;
         dlvtypehash["spam"]              = DST_SPAM;
         dlvtypehash["r_sp"]              = DST_REPORT_SPAM;
         dlvtypehash["r_dl"]              = DST_REPORT_DLV;
         dlvtypehash["r_nl"]              = DST_REPORT_NULL;
         dlvtypehash["r_st"]              = DST_RULE_STAT;
         dlvtypehash["srce"]              = DST_SOURCE;
         dlvtypehash["fxrl"]              = DST_FIXED_BY_RULE;
         dlvtypehash["mess"]              = DST_MESSAGE;
         dlvtypehash["log "]              = DST_LOG;
         dlvtypehash["subj"]              = DST_SUBJ;
         dlvtypehash["http"]              = DST_HTTP;
         dlvtypehash["phon"]              = DST_PHONE;
         dlvtypehash["iy-geozone"]        = DST_GEO;
         dlvtypehash["messageid"]         = DST_MESSID;
         dlvtypehash["x-yandex-queueid"]  = DST_QUEUEID;
         dlvtypehash["clnt"]              = DST_EXTSRVERRORS;
         */

    res += bold_start_tag + "mess:" + bold_end_tag + " " + messfull + cr_tag + "\n";
    res += bold_start_tag + "IY-Geozone:" + bold_end_tag + " " + m_geo + cr_tag + "\n";
    res += bold_start_tag + "X-Yandex-QueueID:" + bold_end_tag + " " + m_queueid + cr_tag + "\n";
    res += bold_start_tag + "subj:" + bold_end_tag + " " + m_subj + cr_tag + "\n";
    res += bold_start_tag + "MESSAGEID:" + bold_end_tag + " " + m_MessId + cr_tag + "\n";

    res += ipaddresses.PrintVirtualDlvLog();

    if (m_fFixedByRule) {
        res += bold_start_tag + "srce:" + bold_end_tag + " source fixed by rule" + cr_tag + "\n";
        res += bold_start_tag + "fxrl:" + bold_end_tag + " source fixed by rule" + cr_tag + "\n";
    }
    if (m_fFixedSource)
        res += bold_start_tag + "srce:" + bold_end_tag + " source fixed for domen name" + cr_tag + "\n";

    if (m_frwd_pr1 && m_frwd_pr2)
        res += bold_start_tag + "log :" + bold_end_tag + " frwd_pr1, frwd_pr2" + cr_tag + "\n";
    else if (m_frwd_pr1 && !m_frwd_pr2)
        res += bold_start_tag + "log :" + bold_end_tag + " frwd_pr1" + cr_tag + "\n";
    else if (!m_frwd_pr1 && m_frwd_pr2)
        res += bold_start_tag + "log :" + bold_end_tag + " frwd_pr2" + cr_tag + "\n";

    memset(tbuff, 0, sizeof(tbuff));
    snprintf(tbuff, sizeof(tbuff) - 1, "%0.2f %0.2f", m_sp_wght, m_dlv_wght);
    res += bold_start_tag + "wght:" + bold_end_tag + " " + TString(tbuff) + cr_tag + "\n";

    switch (m_messclass) {
            //case spUnknown:
            //                        break;
        case TSpClass::HAM:
            res += bold_start_tag + "spam:" + bold_end_tag + " no" + cr_tag + "\n";
            break;
        case TSpClass::DLVR:
            res += bold_start_tag + "spam:" + bold_end_tag + " dlv" + cr_tag + "";
            break;
        case TSpClass::SPAM:
            res += bold_start_tag + "spam:" + bold_end_tag + " yes" + cr_tag + "\n";
            break;
        default:
            break;
    };

    return res;
}

bool TParsedDlvLogDataExport::IsMalicSpam() const {
    return m_malicspam && (m_messclass == TSpClass::SPAM);
}

//*************************************************************************************************************************************
//                                        TParsedDlvLogData
//*************************************************************************************************************************************

TString TParsedDlvLogData::PrintVirtualDlvLog() {
    TString res = "";
    TString bold_start_tag = ""; //"<b>";
    TString bold_end_tag = "";   //"</b>";
    TString cr_tag = "";         //"<br>";

    res += m_exportdata.PrintVirtualDlvLog();

    res += bold_start_tag + "r_sp:" + bold_end_tag + " ";
    auto it = rsp_list.begin();
    while (it != rsp_list.end()) {
        res += (*it).first + ", ";

        ++it;
    }
    res += cr_tag + "\n";

    res += bold_start_tag + "r_dl:" + bold_end_tag + " ";
    it = rdl_list.begin();
    while (it != rdl_list.end()) {
        res += (*it).first + ", ";

        ++it;
    }
    res += cr_tag + "\n";

    res += bold_start_tag + "r_nl:" + bold_end_tag + " ";
    it = rnl_list.begin();
    while (it != rnl_list.end()) {
        res += (*it).first + ", ";

        ++it;
    }
    res += cr_tag + "\n";

    res += bold_start_tag + "r_st:" + bold_end_tag + " ";
    auto eit = rst_list.begin();
    while (eit != rst_list.end()) {
        res += (*eit).ToPrint() + ", ";

        ++eit;
    }
    res += cr_tag + "\n";

    return res;
}

bool TParsedDlvLogData::Find_rsp_rule(const TString& rule) {
    bool res = false;
    const char* p = nullptr;

    if (!rule.empty()) {
        auto rit = rsp_list.begin();
        while (rit != rsp_list.end()) {
            if (!(*rit).first.empty()) {
                p = strstr((*rit).first.c_str(), rule.c_str());
                if (p != nullptr) {
                    res = true;
                    break;
                }
            }

            ++rit;
        }
    }

    return res;
}

bool TParsedDlvLogData::Find_rdl_rule(const TString& rule) {
    bool res = false;

    if (!rule.empty()) {
        auto rit = rdl_list.begin();
        while (rit != rdl_list.end()) {
            if (!(*rit).first.empty()) {
                auto p = strstr((*rit).first.c_str(), rule.c_str());
                if (p != nullptr) {
                    res = true;
                    break;
                }
            }

            ++rit;
        }
    }

    return res;
}

bool TParsedDlvLogData::Find_rnl_rule(const TString& rule) {
    bool res = false;
    const char* p = nullptr;

    if (!rule.empty()) {
        auto rit = rnl_list.begin();
        while (rit != rnl_list.end()) {
            if (!(*rit).first.empty()) {
                p = strstr((*rit).first.c_str(), rule.c_str());
                if (p != nullptr) {
                    res = true;
                    break;
                }
            }

            ++rit;
        }
    }

    return res;
}

//**************************************************************************************************************************************
//                                              TParsedDlvLogDataEx
//**************************************************************************************************************************************

ui32 TParsedDlvLogDataEx::GetSizeStruct(const TParsedDlvLogData& data) {
    ui32 res = 0;
    ui16 strsize = 0;

    res = res + ident_pack.length(); //identificator
    res = res + sizeof(ui8);         //version
    res = res + sizeof(ui32);        //full size
    res = res + sizeof(ui32);        //crc32

    res = res + sizeof(strsize); //messfull size
    res = res + data.m_exportdata.messfull.length();

    res = res + sizeof(data.m_exportdata.m_sp_wght);   //m_sp_wght
    res = res + sizeof(data.m_exportdata.m_dlv_wght);  //m_dlv_wght
    res = res + sizeof(data.m_exportdata.m_messclass); //m_messclass

    res = res + sizeof(strsize); //m_pmesstype size
    res = res + data.m_exportdata.m_pmesstype.length();

    res = res + sizeof(data.m_exportdata.m_fDSN);               //m_fDSN
    res = res + sizeof(data.m_exportdata.m_Uwl);                //m_Uwl
    res = res + sizeof(data.m_exportdata.m_fDsl_first);         //m_fDsl_first
    res = res + sizeof(data.m_exportdata.m_fNoresolv_first);    //m_fNoresolv_first
    res = res + sizeof(data.m_exportdata.m_fSource_level_1);    //m_fSource_level_1
    res = res + sizeof(data.m_exportdata.m_fSource_level_2);    //m_fSource_level_2
    res = res + sizeof(data.m_exportdata.m_fDsl_first8);        //m_fDsl_first8
    res = res + sizeof(data.m_exportdata.m_f100mails);          //m_f100mails
    res = res + sizeof(data.m_exportdata.m_malicspam);          //m_malicspam
    res = res + sizeof(data.m_exportdata.m_mcrit_spam);         //m_mcrit_spam
    res = res + sizeof(data.m_exportdata.m_mcrit_crit);         //m_mcrit_crit
    res = res + sizeof(data.m_exportdata.m_mcrit_hour);         //m_mcrit_hour
    res = res + sizeof(data.m_exportdata.m_fmails_criterion);   //m_fmails_criterion
    res = res + sizeof(data.m_exportdata.m_fDsl_first67891014); //m_fDsl_first67891014
    res = res + sizeof(data.m_exportdata.m_fSHM);               //m_fSHM
    res = res + sizeof(data.m_exportdata.m_fBW);                //m_fBW
    res = res + sizeof(data.m_exportdata.m_f20);                //m_f20
    res = res + sizeof(data.m_exportdata.m_f21);                //m_f21
    res = res + sizeof(data.m_exportdata.m_f22);                //m_f22
    res = res + sizeof(data.m_exportdata.m_f__HELO_LOCALHOST);  //m_f__HELO_LOCALHOST
    res = res + sizeof(data.m_exportdata.m_fDlvrRules);         //m_fDlvrRules
    res = res + sizeof(data.m_exportdata.m_fOurUser);           //m_fOurUser
    res = res + sizeof(data.m_exportdata.m_fBounce);            //m_fBounce
    res = res + sizeof(data.m_exportdata.m_fSpf);               //m_fSpf
    res = res + sizeof(data.m_exportdata.m_fRBL4);              //m_fRBL4
    res = res + sizeof(data.m_exportdata.m_fRBL);               //m_fRBL
    res = res + sizeof(data.m_exportdata.m_mcount);             //m_mcount
    res = res + sizeof(data.m_exportdata.m_metash);             //m_metash
    res = res + sizeof(data.m_exportdata.parray);               //parray
    res = res + sizeof(data.m_exportdata.m_fPop3);              //m_fPop3
    res = res + sizeof(data.m_exportdata.m_fSMTP);              //m_fSMTP
    res = res + sizeof(data.m_exportdata.m_fCOMBL);             //m_fCOMBL
    res = res + sizeof(data.m_exportdata.mSH_17_2);             //mSH_17_2
    res = res + sizeof(data.m_exportdata.m_fFixedByRule);       //m_fFixedByRule
    res = res + sizeof(data.m_exportdata.m_fFixedSource);       //m_fFixedSource
    res = res + sizeof(data.m_exportdata.m_frwd_pr1);           //m_frwd_pr1
    res = res + sizeof(data.m_exportdata.m_frwd_pr2);           //m_frwd_pr2

    res = res + sizeof(strsize); //size m_subj
    res = res + data.m_exportdata.m_subj.length();

    res = res + sizeof(strsize); //size m_geo
    res = res + data.m_exportdata.m_geo.length();
    res = res + sizeof(strsize); //size m_geotime
    res = res + data.m_exportdata.m_geotime.length();

    res = res + sizeof(strsize); //size m_MessId
    res = res + data.m_exportdata.m_MessId.length();

    res = res + sizeof(data.m_exportdata.m_uid); //m_uid

    res = res + sizeof(strsize); //size m_queueid
    res = res + data.m_exportdata.m_queueid.length();

    res = res + sizeof(data.m_exportdata.m_srvcerr); //m_srvcerr
    res = res + sizeof(data.m_exportdata.mbox);      //mbox

    res = res + sizeof(data.m_exportdata.ipaddresses.sourceip.m_ip); //source ip
    res = res + sizeof(strsize);                                     //source m_rdns
    res = res + data.m_exportdata.ipaddresses.sourceip.m_rdns.length();
    res = res + sizeof(strsize); //source m_rdns2
    res = res + data.m_exportdata.ipaddresses.sourceip.m_rdns2.length();
    res = res + sizeof(strsize); //source m_rdns3
    res = res + data.m_exportdata.ipaddresses.sourceip.m_rdns3.length();
    res = res + sizeof(strsize); //source m_helo
    res = res + data.m_exportdata.ipaddresses.sourceip.m_helo.length();

    res = res + sizeof(ui8); //count next ip
    auto iti = data.m_exportdata.ipaddresses.nextip.begin();
    while (iti != data.m_exportdata.ipaddresses.nextip.end()) {
        res = res + sizeof((*iti).m_ip); //next ip
        res = res + sizeof(strsize);     //next m_rdns
        res = res + (*iti).m_rdns.length();
        res = res + sizeof(strsize); //next m_rdns2
        res = res + (*iti).m_rdns2.length();
        res = res + sizeof(strsize); //next m_rdns3
        res = res + (*iti).m_rdns3.length();
        res = res + sizeof(strsize); //next m_helo
        res = res + (*iti).m_helo.length();

        ++iti;
    }

    res = res + sizeof(ui32);         //size block rsp_list
    auto wit = data.rsp_list.begin(); //rsp_list
    while (wit != data.rsp_list.end()) {
        res = res + (*wit).first.length() + 1;

        ++wit;
    }

    res = res + sizeof(ui32);    //size block rdl_list
    wit = data.rdl_list.begin(); //rdl_list
    while (wit != data.rdl_list.end()) {
        res = res + (*wit).first.length() + 1;

        ++wit;
    }

    res = res + sizeof(ui32);    //size block rnl_list
    wit = data.rnl_list.begin(); //rnl_list
    while (wit != data.rnl_list.end()) {
        res = res + (*wit).first.length() + 1;

        ++wit;
    }

    res = res + sizeof(ui32);     //size block rst_list
    auto weit = data.rst_list.begin(); //rst_list
    while (weit != data.rst_list.end()) {
        res = res + sizeof((*weit).count_ham) + sizeof((*weit).count_spam) + sizeof((*weit).count_malic) + (*weit).rulename.length() + 1;

        ++weit;
    }

    res = res + sizeof(ui32); //size dlvlog
    res = res + data.dlv_log.length();

    return res;
}

int TParsedDlvLogDataEx::ReadStroka(const char* pbuff, TString& value) {
    ui16 stsize = 0;

    memcpy(&stsize, pbuff, sizeof(stsize));
    int res = sizeof(stsize);
    if (stsize > 0) {
        value.assign(pbuff + res, stsize);
        res += stsize;
    }

    return res;
}

int TParsedDlvLogDataEx::ReadLongStroka(const char* pbuff, TString& value) {
    int res = 0;
    ui32 stsize = 0;

    memcpy(&stsize, pbuff + res, sizeof(stsize));
    res += sizeof(stsize);
    if ((stsize > 0) && (stsize < MAX_BAD_SIZE)) {
        value.assign(pbuff + res, stsize);
        res += stsize;
    }

    return res;
}

std::pair<const char*, const char*> TrimRangeComma(const TString& s) {
    const char* begin = s.c_str();
    const char* end = begin + s.size();

    if (begin == end)
        return std::make_pair(begin, end);

    const char* firstChar = begin;

    while ((firstChar != end) && ((*firstChar <= ' ') || (*firstChar == ',')))
        ++firstChar;

    if (firstChar == end)
        return std::make_pair(firstChar, end);

    const char* lastChar = end - 1;

    while ((lastChar != firstChar) && ((*lastChar <= ' ') || (*lastChar == ',')))
        --lastChar;

    return std::make_pair(firstChar, lastChar + 1);
}

void TParsedDlvLogDataEx::DeleteRuleComma(TString& rulename) {
    const char* p = nullptr;

    p = strchr(rulename.c_str(), ',');
    if (p != nullptr) {
        std::pair<const char*, const char*> range = TrimRangeComma(rulename);
        rulename = TString(range.first, range.second);
    }
}

int TParsedDlvLogDataEx::ReadRuleList(const char* pbuff, VP_STR_DBL& rulelist) {
    int res = 0;
    ui32 sizerule = 0;
    char dsymb = '#';
    char* rulepointer_pb = nullptr;
    char* rulepointer_pn = nullptr;
    long stsize = 0;
    char stbuff[257];
    TString rulename = "";

    rulelist.clear();
    if (pbuff != nullptr) {
        memcpy(&sizerule, pbuff + res, sizeof(sizerule));
        res += sizeof(sizerule);
        if ((sizerule > 0) && (sizerule < MAX_BAD_SIZE)) {
            TBuffer rulepointer(sizerule + 1);
            rulepointer.Fill(0, sizerule + 1);
            memcpy(rulepointer.Data(), pbuff + res, sizerule);

            rulepointer_pb = rulepointer.Data();
            rulepointer_pn = strchr(rulepointer_pb, dsymb);
            while ((rulepointer_pn != nullptr) && (rulepointer_pb != nullptr)) {
                stsize = rulepointer_pn - rulepointer_pb;
                if ((stsize > 0) && (stsize < 256)) {
                    memset(stbuff, 0, sizeof(stbuff));
                    memcpy(stbuff, rulepointer_pb, stsize);

                    rulename = TString(stbuff);
                    DeleteRuleComma(rulename);

                    rulelist.emplace_back(rulename, 0.);
                }

                rulepointer_pb = rulepointer_pn + 1;
                rulepointer_pn = strchr(rulepointer_pb, dsymb);
            }
            res += sizerule;
        }
    }

    return res;
}

int TParsedDlvLogDataEx::ReadRuleListExt(const char* pbuff, TWorkRuleListExt& rulelist) {
    int res = 0;
    ui32 sizerule = 0;
    char dsymb = '#';
    char* rulepointer = nullptr;
    char* rulepointer_pp = nullptr;
    char* rulepointer_pb = nullptr;
    char* rulepointer_pn = nullptr;
    ui32 ham = 0;
    ui32 spam = 0;
    ui32 malic = 0;
    long stsize = 0;

    rulelist.clear();
    if (pbuff != nullptr) {
        memcpy(&sizerule, pbuff + res, sizeof(sizerule));
        res += sizeof(sizerule);
        if ((sizerule > 0) && (sizerule < MAX_BAD_SIZE)) {
            rulepointer = new char[sizerule + 1];
            if (rulepointer != nullptr) {
                memset(rulepointer, 0, sizerule + 1);
                memcpy(rulepointer, pbuff + res, sizerule);

                rulepointer_pp = rulepointer;
                memcpy(&ham, rulepointer_pp, sizeof(ham));
                memcpy(&spam, rulepointer_pp + sizeof(ham), sizeof(spam));
                memcpy(&malic, rulepointer_pp + sizeof(ham) + sizeof(spam), sizeof(malic));
                rulepointer_pb = rulepointer_pp + sizeof(ham) + sizeof(spam) + sizeof(malic);
                rulepointer_pn = strchr(rulepointer_pb, dsymb);
                while ((rulepointer_pn != nullptr) && (rulepointer_pb != nullptr)) {
                    stsize = rulepointer_pn - rulepointer_pb;
                    if ((stsize > 0) && (stsize < 256)) {

                        TString rulename(rulepointer_pb, stsize);
                        DeleteRuleComma(rulename);

                        rulelist.emplace_back(std::move(rulename), spam, ham, malic);
                    }
                    rulepointer_pp = rulepointer_pn + 1;
                    if (rulepointer_pp != nullptr) {
                        memcpy(&ham, rulepointer_pp, sizeof(ham));
                        memcpy(&spam, rulepointer_pp + sizeof(ham), sizeof(spam));
                        memcpy(&malic, rulepointer_pp + sizeof(ham) + sizeof(spam), sizeof(malic));
                        rulepointer_pb = rulepointer_pp + sizeof(ham) + sizeof(spam) + sizeof(malic);
                        rulepointer_pn = strchr(rulepointer_pb, dsymb);
                    } else
                        break;
                }

                delete[] rulepointer;
                rulepointer = nullptr;
            }
            res += sizerule;
        }
    }

    return res;
}

bool TParsedDlvLogDataEx::UnPack(const char* buff, size_t buffsize) {
    bool res = false;
    ui8 dversion = 0;
    char dident[5];
    TString dident_s = "";
    ui32 dsize = 0;
    ui32 dcrc32 = 0;
    ui32 crc32val = 0;
    ui32 shap_size = 0;
    int pos = 0;
    ui8 nextipcount = 0;
    ui8 version = version_base;

    shap_size = ident_pack.length() + sizeof(version) + sizeof(dsize) + sizeof(dcrc32);
    if ((buff != nullptr) && (buffsize > shap_size)) {
        memset(dident, 0, sizeof(dident)); //ident
        memcpy(dident, buff + pos, ident_pack.length());
        pos += ident_pack.length();
        dident_s = TString(dident);
        if (dident_s == ident_pack) {
            memcpy(&dversion, buff + pos, sizeof(dversion)); //version
            pos += sizeof(dversion);
            if (dversion <= version) {
                memcpy(&dsize, buff + pos, sizeof(dsize)); //dsize
                pos += sizeof(dsize);
                if ((dsize > 0) && ((buffsize - shap_size) == dsize)) {
                    memcpy(&dcrc32, buff + pos, sizeof(dcrc32)); //crc32
                    pos += sizeof(dcrc32);
                    crc32val = crc32((const unsigned char*)(buff + shap_size), dsize);
                    if (crc32val == dcrc32) {
                        pos += ReadStroka(buff + pos, data.m_exportdata.messfull); //messfull

                        memcpy(&data.m_exportdata.m_sp_wght, buff + pos, sizeof(data.m_exportdata.m_sp_wght)); //m_sp_wght
                        pos += sizeof(data.m_exportdata.m_sp_wght);

                        memcpy(&data.m_exportdata.m_dlv_wght, buff + pos, sizeof(data.m_exportdata.m_dlv_wght)); //m_dlv_wght
                        pos += sizeof(data.m_exportdata.m_dlv_wght);

                        memcpy(&data.m_exportdata.m_messclass, buff + pos, sizeof(data.m_exportdata.m_messclass)); //m_messclass
                        pos += sizeof(data.m_exportdata.m_messclass);

                        pos += ReadStroka(buff + pos, data.m_exportdata.m_pmesstype); //m_pmesstype

                        memcpy(&data.m_exportdata.m_fDSN, buff + pos, sizeof(data.m_exportdata.m_fDSN)); //m_fDSN
                        pos += sizeof(data.m_exportdata.m_fDSN);

                        memcpy(&data.m_exportdata.m_Uwl, buff + pos, sizeof(data.m_exportdata.m_Uwl)); //m_Uwl
                        pos += sizeof(data.m_exportdata.m_Uwl);

                        memcpy(&data.m_exportdata.m_fDsl_first, buff + pos, sizeof(data.m_exportdata.m_fDsl_first)); //m_fDsl_first
                        pos += sizeof(data.m_exportdata.m_fDsl_first);

                        memcpy(&data.m_exportdata.m_fNoresolv_first, buff + pos, sizeof(data.m_exportdata.m_fNoresolv_first)); //m_fNoresolv_first
                        pos += sizeof(data.m_exportdata.m_fNoresolv_first);

                        memcpy(&data.m_exportdata.m_fSource_level_1, buff + pos, sizeof(data.m_exportdata.m_fSource_level_1)); //m_fSource_level_1
                        pos += sizeof(data.m_exportdata.m_fSource_level_1);

                        memcpy(&data.m_exportdata.m_fSource_level_2, buff + pos, sizeof(data.m_exportdata.m_fSource_level_2)); //m_fSource_level_2
                        pos += sizeof(data.m_exportdata.m_fSource_level_2);

                        memcpy(&data.m_exportdata.m_fDsl_first8, buff + pos, sizeof(data.m_exportdata.m_fDsl_first8)); //m_fDsl_first8
                        pos += sizeof(data.m_exportdata.m_fDsl_first8);

                        memcpy(&data.m_exportdata.m_f100mails, buff + pos, sizeof(data.m_exportdata.m_f100mails)); //m_f100mails
                        pos += sizeof(data.m_exportdata.m_f100mails);

                        memcpy(&data.m_exportdata.m_malicspam, buff + pos, sizeof(data.m_exportdata.m_malicspam)); //m_malicspam
                        pos += sizeof(data.m_exportdata.m_malicspam);

                        memcpy(&data.m_exportdata.m_mcrit_spam, buff + pos, sizeof(data.m_exportdata.m_mcrit_spam)); //m_mcrit_spam
                        pos += sizeof(data.m_exportdata.m_mcrit_spam);

                        memcpy(&data.m_exportdata.m_mcrit_crit, buff + pos, sizeof(data.m_exportdata.m_mcrit_crit)); //m_mcrit_crit
                        pos += sizeof(data.m_exportdata.m_mcrit_crit);

                        memcpy(&data.m_exportdata.m_mcrit_hour, buff + pos, sizeof(data.m_exportdata.m_mcrit_hour)); //m_mcrit_hour
                        pos += sizeof(data.m_exportdata.m_mcrit_hour);

                        memcpy(&data.m_exportdata.m_fmails_criterion, buff + pos, sizeof(data.m_exportdata.m_fmails_criterion)); //m_fmails_criterion
                        pos += sizeof(data.m_exportdata.m_fmails_criterion);

                        memcpy(&data.m_exportdata.m_fDsl_first67891014, buff + pos, sizeof(data.m_exportdata.m_fDsl_first67891014)); //m_fDsl_first67891014
                        pos += sizeof(data.m_exportdata.m_fDsl_first67891014);

                        memcpy(&data.m_exportdata.m_fSHM, buff + pos, sizeof(data.m_exportdata.m_fSHM)); //m_fSHM
                        pos += sizeof(data.m_exportdata.m_fSHM);

                        memcpy(&data.m_exportdata.m_fBW, buff + pos, sizeof(data.m_exportdata.m_fBW)); //m_fBW
                        pos += sizeof(data.m_exportdata.m_fBW);

                        memcpy(&data.m_exportdata.m_f20, buff + pos, sizeof(data.m_exportdata.m_f20)); //m_f20
                        pos += sizeof(data.m_exportdata.m_f20);

                        memcpy(&data.m_exportdata.m_f21, buff + pos, sizeof(data.m_exportdata.m_f21)); //m_f21
                        pos += sizeof(data.m_exportdata.m_f21);

                        memcpy(&data.m_exportdata.m_f22, buff + pos, sizeof(data.m_exportdata.m_f22)); //m_f22
                        pos += sizeof(data.m_exportdata.m_f22);

                        memcpy(&data.m_exportdata.m_f__HELO_LOCALHOST, buff + pos, sizeof(data.m_exportdata.m_f__HELO_LOCALHOST)); //m_f__HELO_LOCALHOST
                        pos += sizeof(data.m_exportdata.m_f__HELO_LOCALHOST);

                        memcpy(&data.m_exportdata.m_fDlvrRules, buff + pos, sizeof(data.m_exportdata.m_fDlvrRules)); //m_fDlvrRules
                        pos += sizeof(data.m_exportdata.m_fDlvrRules);

                        memcpy(&data.m_exportdata.m_fOurUser, buff + pos, sizeof(data.m_exportdata.m_fOurUser)); //m_fOurUser
                        pos += sizeof(data.m_exportdata.m_fOurUser);

                        memcpy(&data.m_exportdata.m_fBounce, buff + pos, sizeof(data.m_exportdata.m_fBounce)); //m_fBounce
                        pos += sizeof(data.m_exportdata.m_fBounce);

                        memcpy(&data.m_exportdata.m_fSpf, buff + pos, sizeof(data.m_exportdata.m_fSpf)); //m_fSpf
                        pos += sizeof(data.m_exportdata.m_fSpf);

                        memcpy(&data.m_exportdata.m_fRBL4, buff + pos, sizeof(data.m_exportdata.m_fRBL4)); //m_fRBL4
                        pos += sizeof(data.m_exportdata.m_fRBL4);

                        memcpy(&data.m_exportdata.m_fRBL, buff + pos, sizeof(data.m_exportdata.m_fRBL)); //m_fRBL
                        pos += sizeof(data.m_exportdata.m_fRBL);

                        memcpy(&data.m_exportdata.m_mcount, buff + pos, sizeof(data.m_exportdata.m_mcount)); //m_mcount
                        pos += sizeof(data.m_exportdata.m_mcount);

                        memcpy(&data.m_exportdata.m_metash, buff + pos, sizeof(data.m_exportdata.m_metash)); //m_metash
                        pos += sizeof(data.m_exportdata.m_metash);

                        memcpy(&data.m_exportdata.parray, buff + pos, sizeof(data.m_exportdata.parray)); //parray
                        pos += sizeof(data.m_exportdata.parray);

                        memcpy(&data.m_exportdata.m_fPop3, buff + pos, sizeof(data.m_exportdata.m_fPop3)); //m_fPop3
                        pos += sizeof(data.m_exportdata.m_fPop3);

                        memcpy(&data.m_exportdata.m_fSMTP, buff + pos, sizeof(data.m_exportdata.m_fSMTP)); //m_fSMTP
                        pos += sizeof(data.m_exportdata.m_fSMTP);

                        memcpy(&data.m_exportdata.m_fCOMBL, buff + pos, sizeof(data.m_exportdata.m_fCOMBL)); //m_fCOMBL
                        pos += sizeof(data.m_exportdata.m_fCOMBL);

                        memcpy(&data.m_exportdata.mSH_17_2, buff + pos, sizeof(data.m_exportdata.mSH_17_2)); //mSH_17_2
                        pos += sizeof(data.m_exportdata.mSH_17_2);

                        memcpy(&data.m_exportdata.m_fFixedByRule, buff + pos, sizeof(data.m_exportdata.m_fFixedByRule)); //m_fFixedByRule
                        pos += sizeof(data.m_exportdata.m_fFixedByRule);

                        memcpy(&data.m_exportdata.m_fFixedSource, buff + pos, sizeof(data.m_exportdata.m_fFixedSource)); //m_fFixedSource
                        pos += sizeof(data.m_exportdata.m_fFixedSource);

                        memcpy(&data.m_exportdata.m_frwd_pr1, buff + pos, sizeof(data.m_exportdata.m_frwd_pr1)); //m_frwd_pr1
                        pos += sizeof(data.m_exportdata.m_frwd_pr1);

                        memcpy(&data.m_exportdata.m_frwd_pr2, buff + pos, sizeof(data.m_exportdata.m_frwd_pr2)); //m_frwd_pr2
                        pos += sizeof(data.m_exportdata.m_frwd_pr2);

                        pos += ReadStroka(buff + pos, data.m_exportdata.m_subj); //m_subj

                        pos += ReadStroka(buff + pos, data.m_exportdata.m_geo); //m_geo

                        pos += ReadStroka(buff + pos, data.m_exportdata.m_geotime); //m_geotime

                        pos += ReadStroka(buff + pos, data.m_exportdata.m_MessId); //m_MessId

                        memcpy(&data.m_exportdata.m_uid, buff + pos, sizeof(data.m_exportdata.m_uid)); //m_uid
                        pos += sizeof(data.m_exportdata.m_uid);

                        pos += ReadStroka(buff + pos, data.m_exportdata.m_queueid); //m_queueid

                        memcpy(&data.m_exportdata.m_srvcerr, buff + pos, sizeof(data.m_exportdata.m_srvcerr)); //m_srvcerr
                        pos += sizeof(data.m_exportdata.m_srvcerr);

                        memcpy(&data.m_exportdata.mbox, buff + pos, sizeof(data.m_exportdata.mbox)); //mbox
                        pos += sizeof(data.m_exportdata.mbox);

                        memcpy(&data.m_exportdata.ipaddresses.sourceip.m_ip, buff + pos, sizeof(data.m_exportdata.ipaddresses.sourceip.m_ip)); //source ip
                        pos += sizeof(data.m_exportdata.ipaddresses.sourceip.m_ip);
                        pos += ReadStroka(buff + pos, data.m_exportdata.ipaddresses.sourceip.m_rdns);
                        pos += ReadStroka(buff + pos, data.m_exportdata.ipaddresses.sourceip.m_rdns2);
                        pos += ReadStroka(buff + pos, data.m_exportdata.ipaddresses.sourceip.m_rdns3);
                        pos += ReadStroka(buff + pos, data.m_exportdata.ipaddresses.sourceip.m_helo);

                        memcpy(&nextipcount, buff + pos, sizeof(nextipcount)); //count next ip
                        pos += sizeof(nextipcount);
                        if (nextipcount > 0) {
                            for (int i = 0; i < nextipcount; i++) {
                                TSummaryIPInfo nextip;

                                memcpy(&nextip.m_ip, buff + pos, sizeof(nextip.m_ip)); //next ip
                                pos += sizeof(nextip.m_ip);
                                pos += ReadStroka(buff + pos, nextip.m_rdns);
                                pos += ReadStroka(buff + pos, nextip.m_rdns2);
                                pos += ReadStroka(buff + pos, nextip.m_rdns3);
                                pos += ReadStroka(buff + pos, nextip.m_helo);

                                data.m_exportdata.ipaddresses.nextip.push_back(nextip);
                            }
                        }

                        pos += ReadRuleList(buff + pos, data.rsp_list);    //rsp_list
                        pos += ReadRuleList(buff + pos, data.rdl_list);    //rdl_list
                        pos += ReadRuleList(buff + pos, data.rnl_list);    //rnl_list
                        pos += ReadRuleListExt(buff + pos, data.rst_list); //rst_list

                        pos += ReadLongStroka(buff + pos, data.dlv_log); //dlv log

                        res = true;
                    }
                }
            }
        }
    }

    return res;
}

int TParsedDlvLogDataEx::AppendStroka(char* pbuff, const TString& s) {
    int res = 0;
    ui16 longstrsize = 0;

    if (pbuff != nullptr) {
        longstrsize = (s.length() > 0xFFFF) ? 0xFFFF : s.length();
        memcpy(pbuff + res, &longstrsize, sizeof(longstrsize));
        res += sizeof(longstrsize);
        if (longstrsize > 0) {
            memcpy(pbuff + res, s.c_str(), longstrsize);
            res += longstrsize;
        }
    }

    return res;
}

int TParsedDlvLogDataEx::AppendLongStroka(char* pbuff, const TString& s) {
    int res = 0;
    ui32 longstrsize = 0;

    if (pbuff != nullptr) {
        longstrsize = s.length();
        memcpy(pbuff + res, &longstrsize, sizeof(longstrsize));
        res += sizeof(longstrsize);
        if (longstrsize > 0) {
            memcpy(pbuff + res, s.c_str(), longstrsize);
            res += longstrsize;
        }
    }

    return res;
}

int TParsedDlvLogDataEx::AppendRuleList(char* pbuff, const VP_STR_DBL& rulelist) {
    int res = 0;
    ui32 sizerule = 0;
    char dsymb = '#';

    if (pbuff != nullptr) {
        sizerule = 0;
        res += sizeof(sizerule);
        auto wit = rulelist.begin();
        while (wit != rulelist.end()) {
            sizerule += (*wit).first.length() + 1;
            memcpy(pbuff + res, (*wit).first.c_str(), (*wit).first.length());
            res += (*wit).first.length();
            memcpy(pbuff + res, &dsymb, sizeof(dsymb));
            res += sizeof(dsymb);

            ++wit;
        }
        memcpy(pbuff, &sizerule, sizeof(sizerule));
    }

    return res;
}

int TParsedDlvLogDataEx::AppendRuleListExt(char* pbuff, TWorkRuleListExt& rulelist) {
    int res = 0;
    ui32 sizerule = 0;
    char dsymb = '#';

    if (pbuff != nullptr) {
        sizerule = 0;
        res += sizeof(sizerule);
        auto weit = rulelist.begin();
        while (weit != rulelist.end()) {
            sizerule += sizeof((*weit).count_ham) + sizeof((*weit).count_spam) + sizeof((*weit).count_malic) + (*weit).rulename.length() + 1;
            memcpy(pbuff + res, &(*weit).count_ham, sizeof((*weit).count_ham));
            res += sizeof((*weit).count_ham);
            memcpy(pbuff + res, &(*weit).count_spam, sizeof((*weit).count_spam));
            res += sizeof((*weit).count_spam);
            memcpy(pbuff + res, &(*weit).count_malic, sizeof((*weit).count_malic));
            res += sizeof((*weit).count_malic);
            memcpy(pbuff + res, (*weit).rulename.c_str(), (*weit).rulename.length());
            res += (*weit).rulename.length();
            memcpy(pbuff + res, &dsymb, sizeof(dsymb));
            res += sizeof(dsymb);

            ++weit;
        }
        memcpy(pbuff, &sizerule, sizeof(sizerule));
    }

    return res;
}

bool TParsedDlvLogDataEx::Pack() {
    bool res = false;
    ui32 needbuffsize = 0;
    ui32 needbuffsize_without_shap = 0;
    int pos = 0;
    int pos_crc32 = 0;
    ui32 crc32val = 0;
    ui8 nextipcount = 0;
    ui32 shap_size = 0;
    ui8 version = version_base;

    needbuffsize = GetSizeStruct(data);
    if (needbuffsize > 0) {
        buff_pack.Resize(needbuffsize);
        buff_pack.Fill(0, needbuffsize);
        buff_pack_size = needbuffsize;

        shap_size = ident_pack.length() + sizeof(version) + sizeof(needbuffsize) + sizeof(crc32val);
        needbuffsize_without_shap = needbuffsize - shap_size;

        memcpy(buff_pack.Data() + pos, ident_pack.c_str(), ident_pack.length()); //identificator
        pos += ident_pack.length();

        memcpy(buff_pack.Data() + pos, &version, sizeof(version)); //version
        pos += sizeof(version);

        memcpy(buff_pack.Data() + pos, &needbuffsize_without_shap, sizeof(needbuffsize_without_shap)); //full size
        pos += sizeof(needbuffsize_without_shap);

        memcpy(buff_pack.Data() + pos, &crc32val, sizeof(crc32val)); //crc32
        pos_crc32 = pos;
        pos += sizeof(crc32val);

        pos += AppendStroka(buff_pack.Data() + pos, data.m_exportdata.messfull); //messfull

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_sp_wght, sizeof(data.m_exportdata.m_sp_wght)); //m_sp_wght
        pos += sizeof(data.m_exportdata.m_sp_wght);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_dlv_wght, sizeof(data.m_exportdata.m_dlv_wght)); //m_dlv_wght
        pos += sizeof(data.m_exportdata.m_dlv_wght);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_messclass, sizeof(data.m_exportdata.m_messclass)); //m_messclass
        pos += sizeof(data.m_exportdata.m_messclass);

        pos += AppendStroka(buff_pack.Data() + pos, data.m_exportdata.m_pmesstype); //m_pmesstype size

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fDSN, sizeof(data.m_exportdata.m_fDSN)); //m_fDSN
        pos += sizeof(data.m_exportdata.m_fDSN);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_Uwl, sizeof(data.m_exportdata.m_Uwl)); //m_Uwl
        pos += sizeof(data.m_exportdata.m_Uwl);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fDsl_first, sizeof(data.m_exportdata.m_fDsl_first)); //m_fDsl_first
        pos += sizeof(data.m_exportdata.m_fDsl_first);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fNoresolv_first,
               sizeof(data.m_exportdata.m_fNoresolv_first)); //m_fNoresolv_first
        pos += sizeof(data.m_exportdata.m_fNoresolv_first);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fSource_level_1,
               sizeof(data.m_exportdata.m_fSource_level_1)); //m_fSource_level_1
        pos += sizeof(data.m_exportdata.m_fSource_level_1);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fSource_level_2,
               sizeof(data.m_exportdata.m_fSource_level_2)); //m_fSource_level_2
        pos += sizeof(data.m_exportdata.m_fSource_level_2);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fDsl_first8,
               sizeof(data.m_exportdata.m_fDsl_first8)); //m_fDsl_first8
        pos += sizeof(data.m_exportdata.m_fDsl_first8);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_f100mails, sizeof(data.m_exportdata.m_f100mails)); //m_f100mails
        pos += sizeof(data.m_exportdata.m_f100mails);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_malicspam, sizeof(data.m_exportdata.m_malicspam)); //m_malicspam
        pos += sizeof(data.m_exportdata.m_malicspam);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_mcrit_spam, sizeof(data.m_exportdata.m_mcrit_spam)); //m_mcrit_spam
        pos += sizeof(data.m_exportdata.m_mcrit_spam);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_mcrit_crit, sizeof(data.m_exportdata.m_mcrit_crit)); //m_mcrit_crit
        pos += sizeof(data.m_exportdata.m_mcrit_crit);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_mcrit_hour, sizeof(data.m_exportdata.m_mcrit_hour)); //m_mcrit_hour
        pos += sizeof(data.m_exportdata.m_mcrit_hour);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fmails_criterion,
               sizeof(data.m_exportdata.m_fmails_criterion)); //m_fmails_criterion
        pos += sizeof(data.m_exportdata.m_fmails_criterion);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fDsl_first67891014,
               sizeof(data.m_exportdata.m_fDsl_first67891014)); //m_fDsl_first67891014
        pos += sizeof(data.m_exportdata.m_fDsl_first67891014);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fSHM, sizeof(data.m_exportdata.m_fSHM)); //m_fSHM
        pos += sizeof(data.m_exportdata.m_fSHM);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fBW, sizeof(data.m_exportdata.m_fBW)); //m_fBW
        pos += sizeof(data.m_exportdata.m_fBW);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_f20, sizeof(data.m_exportdata.m_f20)); //m_f20
        pos += sizeof(data.m_exportdata.m_f20);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_f21, sizeof(data.m_exportdata.m_f21)); //m_f21
        pos += sizeof(data.m_exportdata.m_f21);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_f22, sizeof(data.m_exportdata.m_f22)); //m_f22
        pos += sizeof(data.m_exportdata.m_f22);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_f__HELO_LOCALHOST,
               sizeof(data.m_exportdata.m_f__HELO_LOCALHOST)); //m_f__HELO_LOCALHOST
        pos += sizeof(data.m_exportdata.m_f__HELO_LOCALHOST);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fDlvrRules, sizeof(data.m_exportdata.m_fDlvrRules)); //m_fDlvrRules
        pos += sizeof(data.m_exportdata.m_fDlvrRules);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fOurUser, sizeof(data.m_exportdata.m_fOurUser)); //m_fOurUser
        pos += sizeof(data.m_exportdata.m_fOurUser);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fBounce, sizeof(data.m_exportdata.m_fBounce)); //m_fBounce
        pos += sizeof(data.m_exportdata.m_fBounce);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fSpf, sizeof(data.m_exportdata.m_fSpf)); //m_fSpf
        pos += sizeof(data.m_exportdata.m_fSpf);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fRBL4, sizeof(data.m_exportdata.m_fRBL4)); //m_fRBL4
        pos += sizeof(data.m_exportdata.m_fRBL4);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fRBL, sizeof(data.m_exportdata.m_fRBL)); //m_fRBL
        pos += sizeof(data.m_exportdata.m_fRBL);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_mcount, sizeof(data.m_exportdata.m_mcount)); //m_mcount
        pos += sizeof(data.m_exportdata.m_mcount);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_metash, sizeof(data.m_exportdata.m_metash)); //m_metash
        pos += sizeof(data.m_exportdata.m_metash);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.parray, sizeof(data.m_exportdata.parray)); //parray
        pos += sizeof(data.m_exportdata.parray);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fPop3, sizeof(data.m_exportdata.m_fPop3)); //m_fPop3
        pos += sizeof(data.m_exportdata.m_fPop3);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fSMTP, sizeof(data.m_exportdata.m_fSMTP)); //m_fSMTP
        pos += sizeof(data.m_exportdata.m_fSMTP);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fCOMBL, sizeof(data.m_exportdata.m_fCOMBL)); //m_fCOMBL
        pos += sizeof(data.m_exportdata.m_fCOMBL);

        ///////////////////////

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.mSH_17_2, sizeof(data.m_exportdata.mSH_17_2)); //mSH_17_2
        pos += sizeof(data.m_exportdata.mSH_17_2);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fFixedByRule,
               sizeof(data.m_exportdata.m_fFixedByRule)); //m_fFixedByRule
        pos += sizeof(data.m_exportdata.m_fFixedByRule);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_fFixedSource,
               sizeof(data.m_exportdata.m_fFixedSource)); //m_fFixedSource
        pos += sizeof(data.m_exportdata.m_fFixedSource);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_frwd_pr1, sizeof(data.m_exportdata.m_frwd_pr1)); //m_frwd_pr1
        pos += sizeof(data.m_exportdata.m_frwd_pr1);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_frwd_pr2, sizeof(data.m_exportdata.m_frwd_pr2)); //m_frwd_pr2
        pos += sizeof(data.m_exportdata.m_frwd_pr2);

        pos += AppendStroka(buff_pack.Data() + pos, data.m_exportdata.m_subj); //m_subj

        pos += AppendStroka(buff_pack.Data() + pos, data.m_exportdata.m_geo); //m_geo

        pos += AppendStroka(buff_pack.Data() + pos, data.m_exportdata.m_geotime); //m_geotime

        pos += AppendStroka(buff_pack.Data() + pos, data.m_exportdata.m_MessId); //m_MessId

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_uid, sizeof(data.m_exportdata.m_uid)); //m_uid
        pos += sizeof(data.m_exportdata.m_uid);

        pos += AppendStroka(buff_pack.Data() + pos, data.m_exportdata.m_queueid); //m_queueid

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.m_srvcerr, sizeof(data.m_exportdata.m_srvcerr)); //m_srvcerr
        pos += sizeof(data.m_exportdata.m_srvcerr);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.mbox, sizeof(data.m_exportdata.mbox)); //mbox
        pos += sizeof(data.m_exportdata.mbox);

        memcpy(buff_pack.Data() + pos, &data.m_exportdata.ipaddresses.sourceip.m_ip,
               sizeof(data.m_exportdata.ipaddresses.sourceip.m_ip)); //source ip
        pos += sizeof(data.m_exportdata.ipaddresses.sourceip.m_ip);
        pos += AppendStroka(buff_pack.Data() + pos, data.m_exportdata.ipaddresses.sourceip.m_rdns);  //source m_rdns
        pos += AppendStroka(buff_pack.Data() + pos, data.m_exportdata.ipaddresses.sourceip.m_rdns2); //source m_rdns2
        pos += AppendStroka(buff_pack.Data() + pos, data.m_exportdata.ipaddresses.sourceip.m_rdns3); //source m_rdns3
        pos += AppendStroka(buff_pack.Data() + pos, data.m_exportdata.ipaddresses.sourceip.m_helo);  //source m_helo

        nextipcount = data.m_exportdata.ipaddresses.nextip.size(); //count next ip
        memcpy(buff_pack.Data() + pos, &nextipcount, sizeof(nextipcount));
        pos += sizeof(nextipcount);
        auto iti = data.m_exportdata.ipaddresses.nextip.begin();
        while (iti != data.m_exportdata.ipaddresses.nextip.end()) {
            memcpy(buff_pack.Data() + pos, &(*iti).m_ip, sizeof((*iti).m_ip)); //next ip
            pos += sizeof((*iti).m_ip);
            pos += AppendStroka(buff_pack.Data() + pos, (*iti).m_rdns);  //next m_rdns
            pos += AppendStroka(buff_pack.Data() + pos, (*iti).m_rdns2); //next m_rdns2
            pos += AppendStroka(buff_pack.Data() + pos, (*iti).m_rdns3); //next m_rdns3
            pos += AppendStroka(buff_pack.Data() + pos, (*iti).m_helo);  //next m_helo

            ++iti;
        }

        pos += AppendRuleList(buff_pack.Data() + pos, data.rsp_list);    //rsp_list
        pos += AppendRuleList(buff_pack.Data() + pos, data.rdl_list);    //rdl_list
        pos += AppendRuleList(buff_pack.Data() + pos, data.rnl_list);    //rnl_list
        pos += AppendRuleListExt(buff_pack.Data() + pos, data.rst_list); //rst_list

        pos += AppendLongStroka(buff_pack.Data() + pos, data.dlv_log); //dlv log

        crc32val = crc32(buff_pack.Data() + shap_size, needbuffsize_without_shap);
        memcpy(buff_pack.Data() + pos_crc32, &crc32val, sizeof(crc32val));

        res = true;
    }

    return res;
}

TString TParsedDlvLogDataEx::PrintToStroka(const TString& div) {
    TString res = "";
    TPDLStrokaList strlist;
    TPDLStrokaListIt it;

    PrintData(data, strlist);

    it = strlist.begin();
    while (it != strlist.end()) {
        res = res + (*it) + div;

        ++it;
    }

    return res;
}

void TParsedDlvLogDataEx::PrintData(const TParsedDlvLogData& data, TPDLStrokaList& strlist) {
    TString text = "";
    TString delit = "";

    strlist.clear();

    text = "[MESSFULL]" + data.m_exportdata.messfull + delit; //messfull
    strlist.push_back(text);
    text = "[SP_WGHT]" + FloatToStr(data.m_exportdata.m_sp_wght) + delit; //m_sp_wght
    strlist.push_back(text);
    text = "[DLV_WGHT]" + FloatToStr(data.m_exportdata.m_dlv_wght) + delit; //m_dlv_wght
    strlist.push_back(text);
    text = "[MESSCLASS]" + IntToStroka(int(data.m_exportdata.m_messclass)) + delit; //m_messclass
    strlist.push_back(text);
    text = "[MESSTYPE]" + data.m_exportdata.m_pmesstype + delit; //m_pmesstype size
    strlist.push_back(text);
    text = "[FDSN]" + BoolToStroka(data.m_exportdata.m_fDSN) + delit; //m_fDSN
    strlist.push_back(text);
    text = "[UWL]" + IntToStroka(data.m_exportdata.m_Uwl) + delit; //m_Uwl
    strlist.push_back(text);
    text = "[DSL_FIRST]" + BoolToStroka(data.m_exportdata.m_fDsl_first) + delit; //m_fDsl_first
    strlist.push_back(text);
    text = "[NORESOLV_FIRST]" + BoolToStroka(data.m_exportdata.m_fNoresolv_first) + delit; //m_fNoresolv_first
    strlist.push_back(text);
    text = "[SOURCE_LEVEL_1]" + BoolToStroka(data.m_exportdata.m_fSource_level_1) + delit; //m_fSource_level_1
    strlist.push_back(text);
    text = "[SOURCE_LEVEL_2]" + BoolToStroka(data.m_exportdata.m_fSource_level_2) + delit; //m_fSource_level_2
    strlist.push_back(text);
    text = "[DSL_FIRST8]" + BoolToStroka(data.m_exportdata.m_fDsl_first8) + delit; //m_fDsl_first8
    strlist.push_back(text);
    text = "[100MAILS]" + BoolToStroka(data.m_exportdata.m_f100mails) + delit; //m_f100mails
    strlist.push_back(text);
    text = "[MALICSPAM]" + BoolToStroka(data.m_exportdata.m_malicspam) + delit; //m_malicspam
    strlist.push_back(text);
    text = "[MCRIT_SPAM]" + IntToStroka(data.m_exportdata.m_mcrit_spam) + delit; //m_mcrit_spam
    strlist.push_back(text);
    text = "[MCRIT_CRIT]" + IntToStroka(data.m_exportdata.m_mcrit_crit) + delit; //m_mcrit_crit
    strlist.push_back(text);
    text = "[MCRIT_HOUR]" + IntToStroka(data.m_exportdata.m_mcrit_hour) + delit; //m_mcrit_hour
    strlist.push_back(text);
    text = "[MAILS_CRITERION]" + BoolToStroka(data.m_exportdata.m_fmails_criterion) + delit; //m_fmails_criterion
    strlist.push_back(text);
    text = "[DSL_FIRST67891014]" + BoolToStroka(data.m_exportdata.m_fDsl_first67891014) + delit; //m_fDsl_first67891014
    strlist.push_back(text);
    text = "[SHM]" + BoolToStroka(data.m_exportdata.m_fSHM) + delit; //m_fSHM
    strlist.push_back(text);
    text = "[BW]" + BoolToStroka(data.m_exportdata.m_fBW) + delit; //m_fBW
    strlist.push_back(text);
    text = "[F20]" + BoolToStroka(data.m_exportdata.m_f20) + delit; //m_f20
    strlist.push_back(text);
    text = "[F21]" + BoolToStroka(data.m_exportdata.m_f21) + delit; //m_f21
    strlist.push_back(text);
    text = "[F22]" + BoolToStroka(data.m_exportdata.m_f22) + delit; //m_f22
    strlist.push_back(text);
    text = "[HELO_LOCALHOST]" + BoolToStroka(data.m_exportdata.m_f__HELO_LOCALHOST) + delit; //m_f__HELO_LOCALHOST
    strlist.push_back(text);
    text = "[DLVR_RULES]" + BoolToStroka(data.m_exportdata.m_fDlvrRules) + delit; //m_fDlvrRules
    strlist.push_back(text);
    text = "[OUR_USER]" + BoolToStroka(data.m_exportdata.m_fOurUser) + delit; //m_fOurUser
    strlist.push_back(text);
    text = "[BOUNCE]" + BoolToStroka(data.m_exportdata.m_fBounce) + delit; //m_fBounce
    strlist.push_back(text);
    text = "[SPF]" + BoolToStroka(data.m_exportdata.m_fSpf) + delit; //m_fSpf
    strlist.push_back(text);
    text = "[RBL4]" + BoolToStroka(data.m_exportdata.m_fRBL4) + delit; //m_fRBL4
    strlist.push_back(text);
    text = "[RBL]" + BoolToStroka(data.m_exportdata.m_fRBL) + delit; //m_fRBL
    strlist.push_back(text);
    text = "[MCOUNT]" + IntToStroka(data.m_exportdata.m_mcount) + delit; //m_mcount
    strlist.push_back(text);
    text = "[METASH]" + IntToStroka(data.m_exportdata.m_metash) + delit; //m_metash
    strlist.push_back(text);

    text = "[PATTERNT_STAT]"; //parray
    for (bool i : data.m_exportdata.parray)
        text = text + BoolToStroka(i);
    text = text + delit;
    strlist.push_back(text);

    text = "[POP3]" + BoolToStroka(data.m_exportdata.m_fPop3) + delit; //m_fPop3
    strlist.push_back(text);
    text = "[SMTP]" + BoolToStroka(data.m_exportdata.m_fSMTP) + delit; //m_fSMTP
    strlist.push_back(text);
    text = "[COMBL]" + BoolToStroka(data.m_exportdata.m_fCOMBL) + delit; //m_fCOMBL
    strlist.push_back(text);
    text = "[SH_17_2]" + BoolToStroka(data.m_exportdata.mSH_17_2) + delit; //mSH_17_2
    strlist.push_back(text);
    text = "[FIXED_BY_RULE]" + BoolToStroka(data.m_exportdata.m_fFixedByRule) + delit; //m_fFixedByRule
    strlist.push_back(text);
    text = "[FIXED_SOURCE]" + BoolToStroka(data.m_exportdata.m_fFixedSource) + delit; //m_fFixedSource
    strlist.push_back(text);
    text = "[FRWD_PR1]" + BoolToStroka(data.m_exportdata.m_frwd_pr1) + delit; //m_frwd_pr1
    strlist.push_back(text);
    text = "[FRWD_PR2]" + BoolToStroka(data.m_exportdata.m_frwd_pr2) + delit; //m_frwd_pr2
    strlist.push_back(text);
    text = "[SUBJ]" + data.m_exportdata.m_subj + delit; //m_subj
    strlist.push_back(text);
    text = "[GEO]" + data.m_exportdata.m_geo + delit; //m_geo
    strlist.push_back(text);
    text = "[GEOTIME]" + data.m_exportdata.m_geotime + delit; //m_geotime
    strlist.push_back(text);
    text = "[MESSID]" + data.m_exportdata.m_MessId + delit; //m_MessId
    strlist.push_back(text);
    text = "[UID]" + ShingleToStroka(data.m_exportdata.m_uid) + delit; //m_uid
    strlist.push_back(text);
    text = "[QUEUE_ID]" + data.m_exportdata.m_queueid + delit; //m_queueid
    strlist.push_back(text);
    text = "[SRVC_ERRORS]" + data.m_exportdata.m_srvcerr.ToText() + delit; //m_srvcerr
    strlist.push_back(text);
    text = "[MBOX]" + data.m_exportdata.mbox.ToText() + delit; //mbox
    strlist.push_back(text);
    text = "[SOURCE_IP]" + data.m_exportdata.ipaddresses.sourceip.ToStroka() + delit; //source ip
    strlist.push_back(text);

    text = "[NEXT_IP_COUNT]" + IntToStroka(data.m_exportdata.ipaddresses.nextip.size()) + delit; //count next ip
    text = text + "[NEXT_IP]";                                                                           //next ip
    auto iti = data.m_exportdata.ipaddresses.nextip.begin();
    while (iti != data.m_exportdata.ipaddresses.nextip.end()) {
        text = text + (*iti).ToStroka() + "~";

        ++iti;
    }
    text = text + delit;
    strlist.push_back(text);

    text = "[RSP_COUNT]" + IntToStroka(data.rsp_list.size()) + delit; //rsp_list
    text = text + "[RSP]";
    auto wit = data.rsp_list.begin();
    while (wit != data.rsp_list.end()) {
        text = text + (*wit).first + ",";

        ++wit;
    }
    text = text + delit;
    strlist.push_back(text);

    text = "[RDL_COUNT]" + IntToStroka(data.rdl_list.size()) + delit; //rdl_list
    text = text + "[RDL]";
    wit = data.rdl_list.begin();
    while (wit != data.rdl_list.end()) {
        text = text + (*wit).first + ",";

        ++wit;
    }
    text = text + delit;
    strlist.push_back(text);

    text = "[RNL_COUNT]" + IntToStroka(data.rnl_list.size()) + delit; //rnl_list
    text = text + "[RNL]";
    wit = data.rnl_list.begin();
    while (wit != data.rnl_list.end()) {
        text = text + (*wit).first + ",";

        ++wit;
    }
    text = text + delit;
    strlist.push_back(text);

    text = "[RST_COUNT]" + IntToStroka(data.rst_list.size()) + delit; //rst_list
    text = text + "[RST]";
    auto weit = data.rst_list.begin();
    while (weit != data.rst_list.end()) {
        text = text + IntToStroka((*weit).count_ham) + "~" + IntToStroka((*weit).count_spam) + "~" + IntToStroka((*weit).count_malic) + "~" + (*weit).rulename + ",";

        ++weit;
    }
    text = text + delit;
    strlist.push_back(text);

    text = "[DLVLOG]" + data.dlv_log + delit; //dlv log
    strlist.push_back(text);
}

bool TParsedDlvLogDataEx::PackCompress() {
    bool res = false;

    buff_compress = "";
    if (Pack()) {
        if ((GetPackSerializeData() != nullptr) && (GetPackSerializeDataSize() > 0)) {
            TString buffer_lzo = "";
            TString err_lzo = "";
            ui32 crc32val = 0;
            char buff[32];

            if (CompressAndBase64(GetPackSerializeData(), GetPackSerializeDataSize(), buffer_lzo, err_lzo)) {
                if (!buffer_lzo.empty()) {
                    crc32val = crc32((const unsigned char*)buffer_lzo.c_str(), buffer_lzo.length());
                    memset(buff, 0, sizeof(buff));
                    snprintf(buff, sizeof(buff) - 1, "%s%08" PRIx64 "%08" PRIx32, ident_compress.c_str(), buffer_lzo.length(), crc32val);
                    buff_compress = TString(buff) + buffer_lzo;
                    res = true;
                }
            }
        }
    }

    return res;
}

bool TParsedDlvLogDataEx::UnPackCompress(const char* buff, size_t buffsize) {
    bool res = false;
    TString st = "";
    ui32 data_size = 0;
    ui32 data_crc32 = 0;
    ui32 crc32val = 0;
    size_t shap_size = ident_compress.length() + 8 + 8;
    char BUFF[16];
    TString uncmprdata = "";
    TString uncmprerr = "";
    bool warning_size = 0;

    if ((buff != nullptr) && (buffsize > shap_size)) {
        memset(BUFF, 0, sizeof(BUFF));
        memcpy(BUFF, buff, ident_compress.length());
        st = TString(BUFF);
        if (st == ident_compress) {
            memset(BUFF, 0, sizeof(BUFF));
            memcpy(BUFF, buff + ident_compress.length(), 8);
            st = TString(BUFF);
            if ((sscanf(BUFF, "%x", &data_size) > 0) && (data_size == (buffsize - shap_size))) {
                memset(BUFF, 0, sizeof(BUFF));
                memcpy(BUFF, buff + ident_compress.length() + 8, 8);
                st = TString(BUFF);
                if ((sscanf(BUFF, "%x", &data_crc32) > 0)) {
                    crc32val = crc32((const unsigned char*)(buff + shap_size), buffsize - shap_size);
                    if (crc32val == data_crc32) {
                        if (Unbase64AndUncompress(buff + shap_size, buffsize - shap_size, warning_size, uncmprdata, uncmprerr)) {
                            res = UnPack(uncmprdata.c_str(), uncmprdata.length());
                        }
                    }
                }
            }
        }
    }

    return res;
}

bool TParsedDlvLogDataEx::UnPackAll(const char* buff, size_t buffsize) {
    bool res = false;
    char tbuff[5];
    TString ident = "";

    memset(tbuff, 0, sizeof(tbuff));
    if ((buff != nullptr) && (buffsize > 4)) {
        memcpy(tbuff, buff, 4);
        ident = TString(tbuff);
        if (ident == ident_pack)
            res = UnPack(buff, buffsize);
        else if (ident == ident_compress)
            res = UnPackCompress(buff, buffsize);
    }

    return res;
}

TMailBox TMailBox::Parse_mailboxByID(const char* pmessA, int messsize) {
    ;
    const char* p = nullptr;
    const char* pe = nullptr;
    const char* pe1 = nullptr;
    const char* pe2 = nullptr;
    TString id_ident = "id=";
    int count = 0;
    TString id = "";
    int clogin = 0;
    ui64 shingle = 0;
    char sshingle[32];

    TMailBox res;
    memset(&res, 0, sizeof(res));
    p = strstr(pmessA, id_ident.c_str());
    while ((p != nullptr) && ((p - pmessA) <= messsize) && (clogin < 100)) {
        pe1 = strchr(p, ';');
        pe2 = strchr(p, ':');
        if ((pe1 == nullptr) && (pe2 != nullptr))
            pe = pe2;
        else if ((pe1 != nullptr) && (pe2 == nullptr))
            pe = pe1;
        else if ((pe1 != nullptr) && (pe2 != nullptr))
            pe = (pe1 < pe2) ? pe1 : pe2;
        else
            pe = nullptr;

        if (pe != nullptr) {
            count = pe - p - id_ident.length();
            if (count > 0) {
                id = TString(p + id_ident.length(), count);
                calc_strcrc64(id.c_str(), id.length(), sshingle);
                sscanf(sshingle, "%" PRIx64, &shingle);
                res.MailBoxShingle[clogin] = shingle;
                res.MailBoxCount = clogin + 1;

                clogin++;
            }
            p = strstr(pe, id_ident.c_str());
        } else {
            count = pmessA + messsize - p - id_ident.length();
            if (count > 0) {
                id = TString(p + id_ident.length(), count);
                calc_strcrc64(id.c_str(), id.length(), sshingle);
                sscanf(sshingle, "%" PRIx64, &shingle);
                res.MailBoxShingle[clogin] = shingle;
                res.MailBoxCount = clogin + 1;

                clogin++;
            }
            break;
        }
    }

    return res;
}

//*************************************************************************************************************************************
