#pragma once

#include "util/generic/string.h"
#include "sputil.h"
#include "kfunc.h"
#include "tparseddlvlogtypes.h"

//*************************************************************************************************************************************
//                                        TParsedDlvLogDataExport
//*************************************************************************************************************************************


struct TMailBox {
    static const size_t MBS_Max = 100;
    ui64 MailBoxShingle[MBS_Max]{};
    ui8 MailBoxCount{};

    Y_SAVELOAD_DEFINE(MailBoxShingle, MailBoxCount)

    TMailBox() = default;

    TString ToText() const {
        TString res = "";

        for (unsigned long i : MailBoxShingle)
            res = res + ShingleToStroka(i) + "~";
        res = res + IntToStroka(MailBoxCount);

        return res;
    }

    static TMailBox Parse_mailboxByID(const char *pmessA, int messsize);
};

struct TParsedDlvLogDataExport {
    TString messfull;
    float m_sp_wght{};
    float m_dlv_wght{};
    TSpClass m_messclass = TSpClass::UNKNOWN;
    TString m_pmesstype = "unknown";
    bool m_fDSN{};
    ui16 m_Uwl{};
    bool m_fDsl_first{}; //r_sp or r_nl
    bool m_fNoresolv_first{};
    bool m_fSource_level_1{};
    bool m_fSource_level_2{};
    bool m_fDsl_first8{};
    bool m_f100mails{};
    bool m_malicspam{};
    int m_mcrit_spam{};
    int m_mcrit_crit{};
    int m_mcrit_hour{};
    bool m_fmails_criterion{};
    bool m_fDsl_first67891014{};
    bool m_fSHM{};
    bool m_fBW{};
    bool m_f20{};
    bool m_f21{};
    bool m_f22{};
    bool m_f__HELO_LOCALHOST{};
    bool m_fDlvrRules{};
    bool m_fOurUser{};
    bool m_fBounce{}; //r_sp or r_nl
    bool m_fSpf{};
    bool m_fRBL4{};
    bool m_fRBL{};
    TSpMCount m_mcount = enMCOUNT_0;
    TSpMetaShingles m_metash = enMETA_SHINGLES_1;
    //rule lists
    TBoolArrayK parray;
    //r_nl
    bool m_fPop3{};
    bool m_fSMTP{};
    bool m_fCOMBL{};
    bool mSH_17_2{};
    //srce
    bool m_fFixedByRule{};
    bool m_fFixedSource{};
    //log
    bool m_frwd_pr1{};
    bool m_frwd_pr2{};

    TString m_subj;
    TString m_geo;
    TString m_geotime;
    TString m_MessId;
    ui64 m_uid{};
    TString m_queueid;

    TSrvcErr m_srvcerr;
    TMailBox mbox;
    TIPAddresses ipaddresses;

    Y_SAVELOAD_DEFINE(
        messfull,
        m_sp_wght,
        m_dlv_wght,
        m_messclass,
        m_pmesstype,
        m_fDSN,
        m_Uwl,
        m_fDsl_first,
        m_fNoresolv_first,
        m_fSource_level_1,
        m_fSource_level_2,
        m_fDsl_first8,
        m_f100mails,
        m_malicspam,
        m_mcrit_spam,
        m_mcrit_crit,
        m_mcrit_hour,
        m_fmails_criterion,
        m_fDsl_first67891014,
        m_fSHM,
        m_fBW,
        m_f20,
        m_f21,
        m_f22,
        m_f__HELO_LOCALHOST,
        m_fDlvrRules,
        m_fOurUser,
        m_fBounce,
        m_fSpf,
        m_fRBL4,
        m_fRBL,
        m_mcount,
        m_metash,
        parray,
        m_fPop3,
        m_fSMTP,
        m_fCOMBL,
        mSH_17_2,
        m_fFixedByRule,
        m_fFixedSource,
        m_frwd_pr1,
        m_frwd_pr2,
        m_subj,
        m_geo,
        m_geotime,
        m_MessId,
        m_uid,
        m_queueid,
        m_srvcerr,
        mbox,
        ipaddresses
    );

    TParsedDlvLogDataExport() = default;

    TString PrintVirtualDlvLog() const;

    bool IsMalicSpam() const;
};

//*************************************************************************************************************************************
//                                        TParsedDlvLogData
//*************************************************************************************************************************************

typedef TVector<std::pair<TString, double>> VP_STR_DBL;
typedef TVector<std::pair<TString, double>>::iterator VPI_STR_DBL;

struct TParsedDlvLogData {
    TParsedDlvLogDataExport m_exportdata;
    VP_STR_DBL rsp_list;
    VP_STR_DBL rdl_list;
    VP_STR_DBL rnl_list;
    TString sr_null;
    TWorkRuleListExt rst_list;
    TString dlv_log;

    Y_SAVELOAD_DEFINE(m_exportdata, rsp_list, rdl_list, rnl_list, rst_list, dlv_log)

    TString PrintVirtualDlvLog();

    bool Find_rsp_rule(const TString& rule);

    bool Find_rdl_rule(const TString& rule);

    bool Find_rnl_rule(const TString& rule);
};

//**************************************************************************************************************************************
//                                              TParsedDlvLogDataEx
//**************************************************************************************************************************************

class TParsedDlvLogDataEx {
private:
    static const ui32 MAX_BAD_SIZE = 10000000;
    static const ui8 version_base = 1;

    typedef TList<TString> TPDLStrokaList;
    typedef TList<TString>::iterator TPDLStrokaListIt;

private:
    TBuffer buff_pack{};
    size_t buff_pack_size{};
    TString buff_compress;
    TString ident_pack = "ESDL";
    TString ident_compress = "ESDP";

    ui32 GetSizeStruct(const TParsedDlvLogData& data);

    void PrintData(const TParsedDlvLogData& data, TPDLStrokaList& strlist);

    int AppendStroka(char *pbuff, const TString& s);

    int AppendLongStroka(char *pbuff, const TString& s);

    int AppendRuleList(char *pbuff, const VP_STR_DBL& rulelist);

    int AppendRuleListExt(char *pbuff, TWorkRuleListExt& rulelist);

    void DeleteRuleComma(TString& rulename);

    int ReadStroka(const char *pbuff, TString& value);

    int ReadLongStroka(const char *pbuff, TString& value);

    int ReadRuleList(const char *pbuff, VP_STR_DBL& rulelist);

    int ReadRuleListExt(const char *pbuff, TWorkRuleListExt& rulelist);

public:
    TParsedDlvLogData data;

public:
    TParsedDlvLogDataEx() = default;

    bool UnPackAll(const char *buff, size_t buffsize);

    //serialize
    bool Pack();

    bool UnPack(const char *buff, size_t buffsize);

    const char *GetPackSerializeData() {
        return buff_pack.Data();
    }

    size_t GetPackSerializeDataSize() {
        return buff_pack_size;
    }

    //serialize and compress
    bool PackCompress();

    bool UnPackCompress(const char *buff, size_t buffsize);

    const char *GetPackCompressData() {
        return buff_compress.c_str();
    }

    size_t GetPackCompressDataSize() {
        return buff_compress.length();
    }

    TString PrintToStroka(const TString& div);
};

//**************************************************************************************************************************************
