#include "tpddclientobj.h"
#include "limited_output.h"
#include "shtime.h"
#include <util/system/compat.h>
#include <util/stream/mem.h>
#include <util/stream/buffer.h>

//*************************************************************************************************************************************
//                                 TPDDStorage - ��������� ������ ���
//*************************************************************************************************************************************

TPDDStorageN::TPDDStorageN() {
}

TPDDStorageN::~TPDDStorageN() {
}

bool TPDDStorageN::GetPDDData(ui64 shingle, const TString& /*host*/, TPDDStructN& res_pdddata) {
    bool res = false;
    TPDDDataHashNIt it;

    if (shingle != 0) {
        it = data.find(shingle);
        if (it != data.end()) {
            res_pdddata = (*it).second;
            res_pdddata.m_est_data = true;
            res = true;
        }
    }

    return res;
}

void TPDDStorageN::AddPDDData(ui64 shingle, const TPDDStructN& pdddata) {
    TPDDDataHashNIt it;

    if (shingle != 0) {
        it = data.find(shingle);
        if (it != data.end())
            (*it).second = pdddata;
        else
            data[shingle] = pdddata;
    }
}

//*************************************************************************************************************************************
//                                                   TPDDClientItem
//*************************************************************************************************************************************

TPDDClientItemN::TPDDClientItemN() = default;

void TPDDClientItemN::Init(TPDDMonObj* monobj, const TString& url, ui32 ConnectTimeOutMSec, ui32 GetTimeOutMSec, const TString& ca) {
    m_monobj = monobj;
    SetHostData(url, ConnectTimeOutMSec, GetTimeOutMSec, ca);
}

void TPDDClientItemN::SetHostData(const TString& url, ui32 ConnectTimeOutMSec, ui32 GetTimeOutMSec, const TString& ca) {
    m_HostDataMutex.Acquire();

    m_url = url;

    curl.Setup(NCurl::TSSL().SetCACertFile(ca));

    m_ConnectTimeOut = TDuration::MilliSeconds(ConnectTimeOutMSec);
    m_GetTimeOut = TDuration::MilliSeconds(GetTimeOutMSec);

    m_HostDataMutex.Release();
}

TKPCWStrokaN TPDDClientItemN::GetHost(const TString& host) {
    TKPCWStrokaN res;
    TString http_s1 = "http://";
    TString http_s2 = "HTTP://";
    const char* p = nullptr;
    const char* ps = nullptr;

    p = strstr(host.c_str(), http_s1.c_str());
    if (p == nullptr) {
        p = strstr(host.c_str(), http_s2.c_str());
        if (p == nullptr)
            p = host.c_str();
        else
            p = p + http_s2.length();
    } else
        p = p + http_s1.length();
    if (p != nullptr) {
        ps = strstr(p, "/");
        if (ps != nullptr) {
            res.host = TString(p, ps - p);
            if ((ps + 1) != nullptr) {
                res.url = TString(ps + 1);
                res.action = res.url;
                if (!res.action.empty()) {
                    p = strchr(res.action.c_str(), '/');
                    if (p == nullptr)
                        p = strchr(res.action.c_str(), '\\');
                    if (p != nullptr)
                        res.action = TString(p + 1);
                }
            }
        } else {
            res.host = TString(p);
            res.url = "";
        }
    }

    return res;
}

void TPDDClientItemN::GetRequestToPassport(ui64 /*shingle*/, const TString& reqhost, TPrintBuffN& PBUFF, TPDDStructN& pdddata) {
    m_Mutex.Acquire();

    m_statdata.today.IncAllRequestCount();
    if (m_monobj != nullptr)
        m_monobj->Inc_all_request_count();

    m_HostDataMutex.Acquire();

    bool m_Result;
    ui32 BeginProcessTime = 0;
    ui16 m_HttpStatus = 0;
    TString request_url = "";
    TString full_request_url = "";
    TString txt = "";
    int err = 0;
    TString printshlist = "";
    TString responce = "";

    BeginProcessTime = CShingleTime::GetMs();

    rcv_buffer.Clear();
    request_url = GetRequest(reqhost);
    full_request_url = m_url + "?domain=" + CGIEscapeRet(reqhost);

    BeginProcessTime = CShingleTime::GetMs();

    TBufferOutput writer(rcv_buffer);

    {
        NCurl::TRequestContext requestContext;
        requestContext.SetHost(full_request_url);
        requestContext.SetRequestTimeout(m_GetTimeOut);
        requestContext.SetConnectTimeout(m_ConnectTimeOut);

        NCurl::TArtifacts artifacts(writer);

        if (auto error = curl.Setup(std::move(requestContext)).Perform(artifacts)) {
            m_Result = false;
            Cerr << "pdd error: " << error << Endl;
        } else {
            m_Result = true;
            m_HttpStatus = artifacts.code;
        }
    }

    BeginProcessTime = CShingleTime::GetMs() - BeginProcessTime;

    if (true == m_Result) {
        if (200 == m_HttpStatus) {
            if (m_monobj != nullptr)
                m_monobj->Inc_request_200_count();
            m_statdata.today.IncRequest200Count();
            responce = TString(rcv_buffer.Data());
            if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                PBUFF.in_printbuff += snprintf(PBUFF.printbuff.Data() + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PDDCLIENT: MESS! %u Request to server: OK (HttpStatus:200) - request='%s'", BeginProcessTime, full_request_url.c_str());

            pdddata.m_est_data = ParseRequest(responce, pdddata);
            if (pdddata.m_est_data) {
                if (m_monobj != nullptr)
                    m_monobj->Inc_rcv_data();
            }

        } else if ((400 <= m_HttpStatus) && (m_HttpStatus < 500)) {
            if (m_HttpStatus == 404) {
                if (m_monobj != nullptr)
                    m_monobj->Inc_request_404_count();
                m_statdata.today.IncRequest404Count();
            } else {
                if (m_monobj != nullptr)
                    m_monobj->Inc_request_400500_count();
                m_statdata.today.IncRequest400500Count();
            }
            if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                PBUFF.in_printbuff += snprintf(PBUFF.printbuff.Data() + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PDDCLIENT: ERR! %u Request to server: HttpStatus:%u - '%s'", BeginProcessTime, m_HttpStatus, full_request_url.c_str());
        } else {
            if (m_monobj != nullptr)
                m_monobj->Inc_request_other_count();
            m_statdata.today.IncRequestOtherCount();
            if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                PBUFF.in_printbuff += snprintf(PBUFF.printbuff.Data() + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PDDCLIENT: ERR! %u Request to server: HttpStatus:%u - '%s'", BeginProcessTime, m_HttpStatus, full_request_url.c_str());
        }
    } else {
        if (false == m_Result) {
            if (m_monobj != nullptr)
                m_monobj->Inc_request_error();
            m_statdata.today.IncRequestError();
            if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                PBUFF.in_printbuff += snprintf(PBUFF.printbuff.Data() + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PDDCLIENT: ERR! %u Request to server: request error (%d) - '%s'", BeginProcessTime, err, full_request_url.c_str());
        } else if (false == m_Result) {
            if (m_monobj != nullptr)
                m_monobj->Inc_request_timeout();
            m_statdata.today.IncRequestTimeout();
            if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                PBUFF.in_printbuff += snprintf(PBUFF.printbuff.Data() + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PDDCLIENT: ERR! %u Request to server: request timeout - '%s'", BeginProcessTime, full_request_url.c_str());
        } else if (false == m_Result) {
            if (m_monobj != nullptr)
                m_monobj->Inc_request_buffer_overflow();
            m_statdata.today.IncRequsetBufferOverflow();
            if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                PBUFF.in_printbuff += snprintf(PBUFF.printbuff.Data() + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "PDDCLIENT: ERR! %u Request to server: request buffer overflow - '%s'", BeginProcessTime, full_request_url.c_str());
        }
    }

    m_HostDataMutex.Release();

    m_Mutex.Release();
}

TString TPDDClientItemN::GetRequest(const TString& reqhost) {
    TString res = "";
    TString reqhost_t = "";

    if (!m_url.empty()) {
        res = m_url;
        if ((res[res.length() - 1] != '/') && (res[res.length() - 1] != '?'))
            res = res + "?";

        reqhost_t = reqhost;
        CGIEscape(reqhost_t);

        res = res + "domain=" + reqhost_t;
    }

    return res;
}

TString GetFielddataN(const char* pbegin, const char* pend, const TString& ident_begin, const TString& ident_end) {
    TString res = "";
    const char* pb_item = nullptr;
    const char* pe_item = nullptr;

    pb_item = strstr(pbegin, ident_begin.c_str());
    if (pb_item != nullptr) {
        pe_item = strstr(pb_item, ident_end.c_str());
        if (pe_item != nullptr) {
            if ((pe_item < pend) && ((pe_item - pb_item - ident_begin.length()) > 0))
                res = TString(pb_item + ident_begin.length(), pe_item - pb_item - ident_begin.length());
        }
    }

    return res;
}

bool TPDDClientItemN::ParseRequest(const TString& rspnc, TPDDStructN& pdddata) {
    bool res = false;
    const char* pb = nullptr;
    const char* pe = nullptr;
    TString pddmain_ident_b = "<pddinfo>";
    TString pddmain_ident_e = "</pddinfo>";
    TString data_s = "";
    long dvar = 0;

    pb = strstr(rspnc.c_str(), pddmain_ident_b.c_str());
    if (pb != nullptr) {
        pe = strstr(pb, pddmain_ident_e.c_str());
        if (pe != nullptr) {
            res = true;
            pdddata.m_est_data = true;
            pdddata.m_last_update = time(nullptr);

            //firsttime
            data_s = GetFielddataN(pb, pe, "<firsttime>", "</firsttime>");
            if (!data_s.empty()) {
                dvar = atol(data_s.c_str());
                pdddata.m_firsttime = dvar;
            }

            //mailboxcnt
            data_s = GetFielddataN(pb, pe, "<mailboxcnt>", "</mailboxcnt>");
            if (!data_s.empty()) {
                dvar = atol(data_s.c_str());
                if (dvar >= 0xFFFF)
                    pdddata.m_mailbox_count = 0xFFFF;
                else if (dvar < 0)
                    pdddata.m_mailbox_count = 0;
                else
                    pdddata.m_mailbox_count = dvar;
            }

            //admlogin
            data_s = GetFielddataN(pb, pe, "<admlogin>", "</admlogin>");
            if (!data_s.empty()) {
                pdddata.m_adm_login = Recode(CODES_UTF8, CODES_WIN, data_s);
            }

            //karma
            data_s = GetFielddataN(pb, pe, "<karma>", "</karma>");
            if (!data_s.empty()) {
                dvar = atol(data_s.c_str());
                if (dvar >= 0xFF)
                    pdddata.m_karma = 0xFF;
                else if (dvar < 0)
                    pdddata.m_karma = 0;
                else
                    pdddata.m_karma = dvar;
            }

            //ip
            data_s = GetFielddataN(pb, pe, "<ip>", "</ip>");
            if (!data_s.empty()) {
                pdddata.m_ip = TKIPv6(data_s.c_str());
            }

            //geo
            data_s = GetFielddataN(pb, pe, "<geo>", "</geo>");
            if (!data_s.empty()) {
                pdddata.m_geo = data_s;
            }
        }
    }

    return res;
}

TStatDataPCN TPDDClientItemN::GetStat() {
    return m_statdata;
}

TString TPDDClientItemN::GetExampleRequest() {
    TString res = "";
    TString reqhost = "fms.yandex.ru";

    res = m_url + "?domain=" + reqhost;

    return res;
}

void TPDDClientItemN::Midnight() {
    m_statdata.Midnight();
}

//*************************************************************************************************************************************
//                                                    TPDDClientQueue
//*************************************************************************************************************************************

TPDDClientQueueN::TPDDClientQueueN() {
    in_all = 0;
    lost_all = 0;
    out_all = 0;
    in_today = 0;
    lost_today = 0;
    out_today = 0;
    in_yesterday = 0;
    lost_yesterday = 0;
    out_yesterday = 0;
    m_stop_event = false;
    thread_count = 0;
    m_queue_size = DefaultQueueSize;
}

void TPDDClientQueueN::Init(ui32 capacityA, ui32 thread_countA) {
    thread_count = thread_countA;
    m_queue_size = capacityA;

    m_Sema = MakeHolder<TUnnamedSemaphore>(thread_count);
}

void TPDDClientQueueN::SendEvent() {
    if (m_Sema != nullptr)
        m_Sema->Release();
}

void TPDDClientQueueN::WaitEvent() {
    if (m_Sema != nullptr) {
        if (!m_stop_event)
            m_Sema->Acquire();
    }
}

void TPDDClientQueueN::Shutdown() {
    UnBlockAllEvent(thread_count);
}

void TPDDClientQueueN::UnBlockAllEvent(size_t thread_count) {
    m_stop_event = true;
    if (thread_count > 0) {
        for (size_t i = 0; i < thread_count; i++)
            SendEvent();
    } else
        SendEvent();
}

void TPDDClientQueueN::Add(ui64 shingle, const TString& host) {
    m_Mutex.Acquire();

    in_all++;
    in_today++;
    if (list.size() < m_queue_size) {
        list.emplace_back(MakeHolder<TPDDStructShortN>(shingle, host));
    } else {
        lost_all++;
        lost_today++;
    }

    m_Mutex.Release();

    SendEvent();
}

THolder<TPDDStructShortN> TPDDClientQueueN::Get() {
    THolder<TPDDStructShortN> res;
    TPDDClientQueueListNIt it;

    m_Mutex.Acquire();

    it = list.begin();
    if (it != list.end()) {
        res = std::move(*it);
        list.erase(it);
        out_all++;
        out_today++;
    }

    m_Mutex.Release();

    return res;
}

void TPDDClientQueueN::Midnight() {
    m_Mutex.Acquire();

    in_yesterday = in_today;
    lost_yesterday = lost_today;
    out_yesterday = out_today;

    in_today = 0;
    lost_today = 0;
    out_today = 0;

    m_Mutex.Release();
}

TString TPDDClientQueueN::GetStatS() {
    TString res = "";
    char buff[256];

    memset(buff, 0, sizeof(buff));
    snprintf(buff, sizeof(buff) - 1, "%" PRIu64 "(%" PRIu64 "), %" PRIu64 "(%" PRIu64 "), %" PRIu64 "(%" PRIu64 ")", in_today, in_yesterday, in_today - out_today - lost_today, in_yesterday - out_yesterday - lost_yesterday, lost_today, lost_yesterday);
    res = TString(buff);

    return res;
}

TQueueStatPCN TPDDClientQueueN::GetStat() {
    TQueueStatPCN res;

    res.today.m_incount = in_today;
    res.today.m_inqueue = in_today - out_today - lost_today;
    res.today.m_lost = lost_today;
    res.yesterday.m_incount = in_yesterday;
    res.yesterday.m_inqueue = in_yesterday - out_yesterday - lost_yesterday;
    res.yesterday.m_lost = lost_yesterday;

    return res;
}

//*************************************************************************************************************************************
//                                                     TPDDClientMain
//*************************************************************************************************************************************

#ifdef _win32_
void /*__stdcall*/ RqstThreadProc(void* par)
#else
void RqstThreadProc(void* par)
#endif
{
    TPDDClientMainN* ss = (TPDDClientMainN*)par;
    TPrintBuffN PBUFF;
    TPDDStructN pdddata;

    if (ss != nullptr) {
        int threadnumber = ss->IncrementNumberThread();

        if (ss->GetClientQueue(threadnumber) != nullptr) {
            while (!ss->QueueThreadShouldStop()) {
                if (ss != nullptr) {
                    if (ss->IsPause()) {
                        sleep(1); //�������� �� �������, �.�. ��������� ���-�� �������� � ���������� �������
                    } else {
                        THolder<TPDDStructShortN> data = ss->m_queue.Get();
                        if (data != nullptr) {
                            PBUFF.Clear();
                            if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                                PBUFF.in_printbuff += snprintf(PBUFF.printbuff.Data() + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "Q(%d) ", threadnumber);
                            ss->GetRequestToPassport(ss->GetClientQueue(threadnumber), data.Get(), PBUFF, pdddata);
                        } else {
                            ss->m_queue.WaitEvent();
                        }
                    }
                }
            }
        }

        ss->DecrementNumberThread();
    }
}

TPDDClientItemN* TPDDClientMainN::GetClientQueue(int threadnumber) {
    TPDDClientItemN* res = nullptr;

    if (threadnumber > 0)
        res = ClientPool[threadnumber - 1].Get();

    return res;
}

void TPDDClientMainN::GetRequestToPassport(TPDDClientItemN* client, TPDDStructShortN* data, TPrintBuffN& PBUFF, TPDDStructN& pdddata) {
    if (client != nullptr) {
        ui32 tick = 0;

        pdddata.m_host = data->m_host;

        tick = CShingleTime::GetMs();
        client->GetRequestToPassport(data->m_shingle, data->m_host, PBUFF, pdddata);
        tick = CShingleTime::GetMs() - tick;
        m_monobj.AddTick(tick);

        if (log != nullptr)
            log->WriteMessageAndData("%s", PBUFF.printbuff.Data());

        if (pdddata.m_last_update != 0) //������ ���� ��������
        {
            if (PDDStorage != nullptr)
                PDDStorage->AddPDDData(data->m_shingle, pdddata);
        }

        m_tMutex.Acquire();

        if (m_count_min < 0xFFFFFFFF)
            m_count_min++;

        if (m_count_hour < 0xFFFFFFFF)
            m_count_hour++;

        m_tMutex.Release();
    }
}

TPDDClientMainN::TPDDClientMainN() {
    for (size_t i = 0; i < MAX_THREAD_WORK; i++)
        m_QueueThread[i] = nullptr;
    for (size_t i = 0; i < MAX_THREAD_WORK; i++)
        ClientPool[i] = nullptr;
    use_threadcount = 0;
    run_scan_thread = false;
    m_StopQueueThread = false;
    m_thread_count = 1;
    PDDStorage = nullptr;
    use_mongo = false;
    m_lasttime_min = time(nullptr);
    m_count_min = 0;
    m_count_min_max = 0;
    m_lasttime_hour = time(nullptr);
    m_count_hour = 0;
    m_count_hour_max = 0;
    m_max_request_to_min = 0;
    m_max_request_to_hour = 0;
    m_queue_size = 0;
    m_udate_data_time = UPDATE_DATA_TIME_DEFAULT;
    m_directly = false;
    m_paused = 0;
    IniFile = nullptr;
    log = nullptr;
    m_exit = false;
    m_Sema = nullptr;
}

TPDDClientMainN::~TPDDClientMainN() {
    if (run_scan_thread) {
        StopQueueThread();
        m_queue.Shutdown();
    }
}

bool TPDDClientMainN::Init(TKConfig* IniFileA, TLogClass* logA) {
    bool res = false;
    TString url = "";
    ui32 ConnectTimeOutMSec = 0;
    ui32 GetTimeOutMSec = 0;

    IniFile = IniFileA;
    if (IniFile != nullptr) {
        m_enable = IniFile->ReadBool(PDDIniSection, "enable", true);
        m_thread_count = IniFile->ReadInteger(PDDIniSection, "thread_count", 1);
        url = IniFile->ReadStroka(PDDIniSection, "host", "");
        ConnectTimeOutMSec = IniFile->ReadInteger(PDDIniSection, "connecttimeout", 50);
        GetTimeOutMSec = IniFile->ReadInteger(PDDIniSection, "requesttimeout", 200);
        m_queue_size = IniFile->ReadInteger(PDDIniSection, "queue_size", 500);
        //use_mongo               = IniFile->ReadBool(PDDIniSection, "use_mongo", false);
        use_mongo = false;
        m_max_request_to_min = IniFile->ReadInteger(PDDIniSection, "max_request_to_min", 0);
        m_max_request_to_hour = IniFile->ReadInteger(PDDIniSection, "max_request_to_hour", 0);
        m_udate_data_time = IniFile->ReadInteger(PDDIniSection, "udate_data_time", UPDATE_DATA_TIME_DEFAULT);
        m_directly = IniFile->ReadBool(PDDIniSection, "directly", false);

        TString ca = IniFile->ReadStroka(PDDIniSection, "ca", "");

        if (m_enable) {
            if (use_mongo) {
                //PDDStorage = new TPDDMongoStorage();
            } else {
                PDDStorage = MakeHolder<TPDDStorageN>();
            }
            if (PDDStorage != nullptr)
                PDDStorage->Init(IniFileA);

            log = logA;

            if (m_thread_count < 1)
                m_thread_count = 1;
            if (m_thread_count >= MAX_THREAD_WORK)
                m_thread_count = MAX_THREAD_WORK;
            m_queue.Init(m_queue_size, m_thread_count);
            for (size_t i = 0; i < m_thread_count; i++) {
                ClientPool[i] = MakeHolder<TPDDClientItemN>();
                if (ClientPool[i] != nullptr)
                    ClientPool[i]->Init(&m_monobj, url, ConnectTimeOutMSec, GetTimeOutMSec, ca);
            }

            if (m_directly) //����� ������� ������ (������ ������ � ����, ���� ������ ��� � ����)
            {
                if (m_Sema == nullptr)
                    m_Sema = MakeHolder<TUnnamedSemaphore>(m_thread_count);

                for (size_t i = 0; i < m_thread_count; i++) {
                    if (ClientPool[i] != nullptr) {
                        m_MutexAccCl.Acquire();

                        m_AccessibleList.push_back(ClientPool[i].Get());

                        m_MutexAccCl.Release();
                    }
                }

            } else //����� ������ ����� ������� (���� ������ ��� � ���� ��� ��������, ������ � ������� �� ���������� ����)
            {
                StartQueueThread();
            }
        }
        res = true;
    }

    return res;
}

void TPDDClientMainN::StartQueueThread() {
    m_QueueMutex.Acquire();

    m_StopQueueThread = false;

    for (size_t i = 0; i < m_thread_count; i++) {
        m_QueueThread[i] = MakeHolder<TThread>((TThread::TThreadProc)&RqstThreadProc, this);
        m_QueueThread[i]->Start();
    }
    run_scan_thread = true;

    m_QueueMutex.Release();
}

int TPDDClientMainN::IncrementNumberThread() {
    int res = 0;

    m_QueueMutex.Acquire();

    use_threadcount++;
    res = use_threadcount;

    m_QueueMutex.Release();

    return res;
}

void TPDDClientMainN::DecrementNumberThread() {
    m_QueueMutex.Acquire();

    if (use_threadcount > 0)
        use_threadcount--;

    m_QueueMutex.Release();
}

void TPDDClientMainN::StopQueueThread() {
    m_QueueMutex.Acquire();
    m_StopQueueThread = true;
    m_QueueMutex.Release();
}

bool TPDDClientMainN::GetPDDInfoQueue(ui64 shingle, const TString& host, TPDDStructN& pdddata) {
    bool res = false;
    bool updata_record = true;
    time_t currenttime = time(nullptr);
    ui32 elapsedtime = 0;

    pdddata = {};
    if (PDDStorage != nullptr) {
        res = PDDStorage->GetPDDData(shingle, host, pdddata);
        if (res) {
            pdddata.m_rqsttype_data = RFT_CACHE;
            m_monobj.Inc_rcv_data_from_cache();
            elapsedtime = currenttime - pdddata.m_last_update;
            if (elapsedtime < m_udate_data_time)
                updata_record = false;
        }
    }
    if (updata_record) {
        m_queue.Add(shingle, host);
        pdddata.m_rqsttype_data = RFT_QUEUE;
    }

    return res;
}

bool TPDDClientMainN::GetPDDInfoDirectly(ui64 shingle, const TString& host, TPDDStructN& pdddata) {
    bool res = false;
    bool update_record = true;
    time_t currenttime = time(nullptr);
    ui32 elapsedtime = 0;
    TPrintBuffN PBUFF;
    TPDDClientItemN* client = nullptr;

    pdddata = {};
    if (PDDStorage != nullptr) {
        res = PDDStorage->GetPDDData(shingle, host, pdddata);
        if (res) {
            pdddata.m_rqsttype_data = RFT_CACHE;
            m_monobj.Inc_rcv_data_from_cache();
            elapsedtime = currenttime - pdddata.m_last_update;
            if (elapsedtime < m_udate_data_time)
                update_record = false;
        }
    }
    if (update_record) {
        TPDDStructShortN data = TPDDStructShortN(shingle, host);
        int accessible_clients = 0;

        pdddata.m_rqsttype_data = RFT_NONE;
        client = GetClientDirectly(accessible_clients);
        if (client != nullptr) {
            PBUFF.Clear();
            if ((PBUFF.printbuffsize - PBUFF.in_printbuff - 1) > 0)
                PBUFF.in_printbuff += snprintf(PBUFF.printbuff.Data() + PBUFF.in_printbuff, PBUFF.printbuffsize - PBUFF.in_printbuff - 1, "D(%d) ", accessible_clients);
            GetRequestToPassport(client, &data, PBUFF, pdddata);
            pdddata.m_rqsttype_data = RFT_DIRECTLY;

            ReturnClientDirectly(client);
        }
    }
    if (pdddata.m_est_data)
        res = true;

    return res;
}

bool TPDDClientMainN::GetPDDInfo(ui64 shingle, const TString& host, TPDDStructN& pdddata) {
    bool res = false;

    if (m_directly)
        res = GetPDDInfoDirectly(shingle, host, pdddata);
    else
        res = GetPDDInfoQueue(shingle, host, pdddata);

    return res;
}

bool TPDDClientMainN::IsPause() {
    bool res = false;
    time_t currenttime = time(nullptr);
    tm tlast, tcurr;

    //��������� �������� ������
    //if (m_max_request_to_min > 0)
    if (true) {
        if ((localtime_r(&currenttime, &tcurr) != nullptr) && (localtime_r(&m_lasttime_min, &tlast) != nullptr)) {
            m_tMutex.Acquire();

            if (tcurr.tm_min != tlast.tm_min) {
                if (m_count_min > m_count_min_max)
                    m_count_min_max = m_count_min;
                if (log != nullptr)
                    log->WriteMessageAndData("Request count by last minute: %u (max: %u)", m_count_min, m_count_min_max);
                m_count_min = 0;
                m_lasttime_min = currenttime;
            }

            m_tMutex.Release();
        }
        if ((m_max_request_to_min > 0) && (m_count_min > m_max_request_to_min))
            res = true;
    }

    //��������� ������� ������
    //if ( (!res) && (m_max_request_to_hour > 0) )
    if (true) {
        if ((localtime_r(&currenttime, &tcurr) != nullptr) && (localtime_r(&m_lasttime_hour, &tlast) != nullptr)) {
            m_tMutex.Acquire();

            if (tcurr.tm_hour != tlast.tm_hour) {
                if (m_count_hour > m_count_hour_max)
                    m_count_hour_max = m_count_hour;
                if (log != nullptr)
                    log->WriteMessageAndData("Request count by last hour: %u (max: %u)", m_count_hour, m_count_hour_max);
                m_count_hour = 0;
                m_lasttime_hour = currenttime;
            }

            m_tMutex.Release();
        }
        if ((m_max_request_to_hour > 0) && (m_count_hour > m_max_request_to_hour))
            res = true;
    }

    TAtomic current_state = AtomicAdd(m_paused, 0);
    TAtomic new_state = res ? 1 : 0;

    if (current_state ^ new_state) {
        if (log != nullptr)
            log->WriteMessageAndData("Queries to PDD %s. Count min: %d (max: %d). Count hour: %d (max: %d)",
                                     (res ? "paused" : "resumed"), m_count_min, m_max_request_to_min, m_count_hour, m_max_request_to_hour);
    }

    AtomicSwap(&m_paused, new_state);
    return res;
}

TSummaryStatPCN TPDDClientMainN::GetStat() {
    TSummaryStatPCN res;

    res.enable = m_enable;
    res.enable_threads = run_scan_thread;
    res.threads = m_thread_count;
    res.queue_size = m_queue_size;
    if (use_mongo)
        res.storage_type = "mongo";
    else
        res.storage_type = "hash";
    res.count_min = m_count_min;
    res.count_min_max = m_count_min_max;
    res.count_hour = m_count_hour;
    res.count_hour_max = m_count_hour_max;
    if (m_thread_count > 0)
        res.example_request = ClientPool[0]->GetExampleRequest();

    res.host_update_period = m_udate_data_time;

    for (size_t i = 0; i < m_thread_count; i++) {
        if (ClientPool[i] != nullptr)
            res.client_stat += ClientPool[i]->GetStat();
    }
    res.queue_stat = m_queue.GetStat();
    res.directly = m_directly;
    if (m_directly) {
        m_MutexAccCl.Acquire();
        res.directly_accessible_clients = m_AccessibleList.size();
        m_MutexAccCl.Release();
    }

    return res;
}

void TPDDClientMainN::Midnight() {
    for (size_t i = 0; i < m_thread_count; i++) {
        if (ClientPool[i] != nullptr)
            ClientPool[i]->Midnight();
    }
    m_queue.Midnight();

    m_tMutex.Acquire();
    m_count_min = 0;
    m_count_min_max = 0;
    m_count_hour = 0;
    m_count_hour_max = 0;
    m_tMutex.Release();
}

void TPDDClientMainN::Shutdown() {
    m_queue.Shutdown();
    SetExit();
}

bool TPDDClientMainN::ReloadProperties() {
    bool res = false;
    TKConfig config_object;
    TString filename = "";
    TString host = "";
    ui32 ConnectTimeOutMSec = 0;
    ui32 GetTimeOutMSec = 0;

    if (IniFile != nullptr)
        filename = IniFile->ConfigFilename();

    if (!filename.empty()) {
        config_object.Load(filename);

        host = config_object.ReadStroka(PDDIniSection, "host", "");
        ConnectTimeOutMSec = config_object.ReadInteger(PDDIniSection, "connecttimeout", 50);
        GetTimeOutMSec = config_object.ReadInteger(PDDIniSection, "requesttimeout", 200);
        TString ca = config_object.ReadStroka(PDDIniSection, "ca", "");

        for (size_t i = 0; i < m_thread_count; i++) {
            if (ClientPool[i] != nullptr)
                ClientPool[i]->SetHostData(host, ConnectTimeOutMSec, GetTimeOutMSec, ca);
        }

        res = true;
    }

    return res;
}

TString TPDDClientMainN::GetMonData() {
    TString res = "";

    //<PDD:rcv_from_host,no_hostport/all_rqst/rcv_data,ce/ct/200/404/400500/other/re/rt/bo,00_05/05_50/50_100/100_190/more_190>
    if (m_enable) {
        res = "<PDD:" + m_monobj.GetMonData() + ">";

    } else {
        res = "<PDD:->";
    }

    return res;
}

void TPDDClientMainN::ReturnClientDirectly(TPDDClientItemN* elem) {
    m_MutexAccCl.Acquire();

    m_AccessibleList.push_back(elem);

    m_MutexAccCl.Release();

    if (m_Sema != nullptr)
        m_Sema->Release();
}

TPDDClientItemN* TPDDClientMainN::GetClientDirectly(int& accessible_client) {
    TPDDClientItemN* res = nullptr;
    TPDDClientItemNListIt it;
    ui32 tick_time = 0;

    tick_time = CShingleTime::GetMs();

    while (true) {
        if (m_exit)
            break;

        if (m_Sema != nullptr)
            m_Sema->Acquire();

        if (m_exit)
            break;

        m_MutexAccCl.Acquire();

        it = m_AccessibleList.begin();
        if (it != m_AccessibleList.end()) {
            res = (*it);
            m_AccessibleList.erase(it);

            accessible_client = m_AccessibleList.size();
            m_MutexAccCl.Release();
            break;
        }

        accessible_client = m_AccessibleList.size();
        m_MutexAccCl.Release();

        if (m_Sema != nullptr)
            m_Sema->Release();
    }

    return res;
}

void TPDDClientMainN::SetExit() {
    m_MutexExit.Acquire();

    m_exit = true;

    m_MutexExit.Release();

    if ((m_Sema != nullptr) && (m_thread_count > 0)) {
        for (size_t i = 0; i < m_thread_count; i++)
            m_Sema->Release();
    }
}

//*************************************************************************************************************************************
