#pragma once

#ifndef tpddclientobj_H
#define tpddclientobj_H

#include <list>
#include <sys/stat.h>
#include "kfunc.h"
#include "util/generic/hash.h"
#include "util/generic/string.h"
#include "util/system/mutex.h"
#include "library/cpp/deprecated/atomic/atomic.h"
#include "util/string/util.h"
#include "library/cpp/charset/recyr.hh"
#include "util/datetime/systime.h"
#include <mail/so/libs/curl/curl.h>
#include <util/system/thread.h>
#include "unnamedsem.h"
#include "tkipv6.h"
#include "tkconfig.h"
#include "tlogclass.h"
#include "ttrafficcontrol.h"
#include <library/cpp/string_utils/quote/quote.h>

#define PDDIniSection "pddstorage"

//*************************************************************************************************************************************
//                                           TPDDMonObj
//*************************************************************************************************************************************

class TPDDMonObj {
private:
    TDiffCounter m_all_request_count;       //����� �������� � ������� (������ � ������� �� �������)
    TDiffCounter m_rcv_data;                //�������� ������ � ��� (������ � ������� �� �������)
    TDiffCounter m_rcv_data_from_cache;     //�������� ������ � ��� �� ����
    TDiffCounter m_connect_error;           //������ �������� (������ � ������� �� �������)
    TDiffCounter m_connect_timeout;         //������� �������� (������ � ������� �� �������)
    TDiffCounter m_request_200_count;       //200 ��� (������ � ������� �� �������)
    TDiffCounter m_request_404_count;       //404 ��� (������ � ������� �� �������)
    TDiffCounter m_request_400500_count;    //4�� ���� (< 500) (������ � ������� �� �������)
    TDiffCounter m_request_other_count;     //������ ���� (������ � ������� �� �������)
    TDiffCounter m_request_error;           //������ �������� (������ � ������� �� �������)
    TDiffCounter m_request_timeout;         //������� �������� (������ � ������� �� �������)
    TDiffCounter m_request_buffer_overflow; //������ ������������ ������ (������ � ������� �� �������)
    TDiffCounter m_no_host_or_port;         //�� ����� ���� ��� ���� (������ � ������� �� �������)

    TDiffCounter m_00_05;    //���-�� �������� � �������� ���������� 0..4 ��
    TDiffCounter m_05_50;    //���-�� �������� � �������� ���������� 5..49 ��
    TDiffCounter m_50_100;   //���-�� �������� � �������� ���������� 50..99 ��
    TDiffCounter m_100_190;  //���-�� �������� � �������� ���������� 100..189 ��
    TDiffCounter m_more_190; //���-�� �������� � �������� ���������� ������ ��� ����� 190 ��

public:
    TPDDMonObj(){};
    ~TPDDMonObj(){};

    void Inc_all_request_count() {
        m_all_request_count.Increment();
    }
    void Inc_rcv_data() {
        m_rcv_data.Increment();
    }
    void Inc_rcv_data_from_cache() {
        m_rcv_data_from_cache.Increment();
    }
    void Inc_connect_error() {
        m_connect_error.Increment();
    }
    void Inc_connect_timeout() {
        m_connect_timeout.Increment();
    }
    void Inc_request_200_count() {
        m_request_200_count.Increment();
    }
    void Inc_request_404_count() {
        m_request_404_count.Increment();
    }
    void Inc_request_400500_count() {
        m_request_400500_count.Increment();
    }
    void Inc_request_other_count() {
        m_request_other_count.Increment();
    }
    void Inc_request_error() {
        m_request_error.Increment();
    }
    void Inc_request_timeout() {
        m_request_timeout.Increment();
    }
    void Inc_request_buffer_overflow() {
        m_request_buffer_overflow.Increment();
    }
    void Inc_no_host_or_port() {
        m_no_host_or_port.Increment();
    }

    void AddTick(ui32 tick) {
        if (tick < 5)
            m_00_05.Increment();
        else if ((tick >= 5) && (tick < 50))
            m_05_50.Increment();
        else if ((tick >= 50) && (tick < 100))
            m_50_100.Increment();
        else if ((tick >= 100) && (tick < 190))
            m_100_190.Increment();
        else
            m_more_190.Increment();
    }

    TString GetMonData() {
        //rcv_from_host,no_hostport/all_rqst/rcv_data,ce/ct/200/404/400500/other/re/rt/bo,00_05/05_50/50_100/100_190/more_190
        TString res = "";

        res = res + IntToStroka(m_rcv_data_from_cache.GetDiff()) + ",";
        res = res + IntToStroka(m_no_host_or_port.GetDiff()) + "/" + IntToStroka(m_all_request_count.GetDiff()) + "/" + IntToStroka(m_rcv_data.GetDiff()) + ",";
        res = res + IntToStroka(m_connect_error.GetDiff()) + "/" + IntToStroka(m_connect_timeout.GetDiff()) + "/" + IntToStroka(m_request_200_count.GetDiff()) + "/" + IntToStroka(m_request_404_count.GetDiff()) + "/" + IntToStroka(m_request_400500_count.GetDiff()) + "/" + IntToStroka(m_request_other_count.GetDiff()) + "/" + IntToStroka(m_request_error.GetDiff()) + "/" + IntToStroka(m_request_timeout.GetDiff()) + "/" + IntToStroka(m_request_buffer_overflow.GetDiff()) + ",";
        res = res + IntToStroka(m_00_05.GetDiff()) + "/" + IntToStroka(m_05_50.GetDiff()) + "/" + IntToStroka(m_50_100.GetDiff()) + "/" + IntToStroka(m_100_190.GetDiff()) + "/" + IntToStroka(m_more_190.GetDiff());

        return res;
    }
};

//*************************************************************************************************************************************
//                                 TPDDStorage - ��������� ������ ���
//*************************************************************************************************************************************

enum TRqstFindDataType { RFT_NONE,
                         RFT_CACHE,
                         RFT_QUEUE,
                         RFT_DIRECTLY };

struct TPDDStructN {
    bool m_est_data{};                   //true - ���� ������
    TRqstFindDataType m_rqsttype_data = RFT_NONE; //���, ��� �������� ������
    TString m_host;                    //��� ����� � ���� �����
    ui32 m_last_update{};                //�����, ����� ������ ���� �������� �� ��������
    ui32 m_firsttime{};                  //���� ����������� ������ � ���
    ui16 m_mailbox_count{};              //����� ������ � ������ (�� ����, ��������� +- ��������� ����)
    TString m_adm_login;               //����� (uid) �������������� ������
    ui8 m_karma{};                       //����� ������ � ������������� ����� �� 0 �� 100, �������� � ������� ���������� ��� �����������, ��������� ������� ��������� �������� ������� �������.
    TKIPv6 m_ip;                       //IP-�����, � �������� ��� ����������� ������ �� ����������� �����
    TString m_geo;                     //������� (�� ����� ������ ������)

    TPDDStructN() = default;

    TPDDStructN(bool& estdata, TRqstFindDataType& rqsttype_data, const TString& host, ui32 last_update, ui32 firsttime, ui16 mailbox_count, const TString& adm_login, ui8 karma, TKIPv6 ip, const TString& geo) {
        m_est_data = estdata;
        m_rqsttype_data = rqsttype_data;
        m_host = host;
        m_last_update = last_update;
        m_firsttime = firsttime;
        m_mailbox_count = mailbox_count;
        m_adm_login = adm_login;
        m_karma = karma;
        m_ip = ip;
        m_geo = geo;
    }

    TString toLog() {
        TString res = "";

        switch (m_rqsttype_data) {
            case RFT_NONE:
                res = res + "N, ";
                break;
            case RFT_CACHE:
                res = res + "L, ";
                break;
            case RFT_QUEUE:
                res = res + "Q, ";
                break;
            case RFT_DIRECTLY:
                res = res + "D, ";
                break;
        };
        res = res + "est_data=" + BoolToStroka2(m_est_data) + ", ";
        res = res + "host='" + m_host + "', ";
        res = res + "lu=" + IntToStroka(m_last_update) + ", ";
        res = res + "ft=" + IntToStroka(m_firsttime) + ", ";
        res = res + "mbc=" + IntToStroka(m_mailbox_count) + ", ";
        res = res + "admlgn='" + m_adm_login + "', ";
        res = res + "karma=" + IntToStroka(m_karma) + ", ";
        res = res + "ip=" + m_ip.toStroka() + ", ";
        res = res + "geo='" + m_geo + "'";

        return res;
    }
};

class TPDDStorageBaseN {
private:
public:
    TPDDStorageBaseN(){};
    virtual ~TPDDStorageBaseN(){};

    virtual bool Init(TKConfig*) {
        return true;
    };
    virtual bool GetPDDData(ui64 shingle, const TString& host, TPDDStructN& res_pdddata) = 0;
    virtual void AddPDDData(ui64 shingle, const TPDDStructN& pdddata) = 0;
};

typedef THashMap<ui64, TPDDStructN> TPDDDataHashN;
typedef TPDDDataHashN::iterator TPDDDataHashNIt;

class TPDDStorageN: public TPDDStorageBaseN {
private:
    TPDDDataHashN data;

public:
    TPDDStorageN();
    ~TPDDStorageN();

    bool GetPDDData(ui64 shingle, const TString& host, TPDDStructN& res_pdddata);
    void AddPDDData(ui64 shingle, const TPDDStructN& pdddata);
};

//*************************************************************************************************************************************
//                           TPDDClientItem - ��� ������, ������� ������ ������ � �������
//*************************************************************************************************************************************

struct TPrintBuffN {
    int printbuffsize{};
    TBuffer printbuff;
    int in_printbuff{};

    TPrintBuffN() : printbuffsize(65000), printbuff(printbuffsize) {
    }

    void Clear() {
        printbuff.Resize(printbuffsize);
        printbuff.Fill(0, printbuffsize);
        in_printbuff = 0;
    }
};

struct TKPCWStrokaN {
    TString host;
    TString url;
    TString action;

    TKPCWStrokaN() {
        host = "";
        url = "";
        action = "";
    }
};

struct TStatDataPCItemN {
    ui32 all_request_count;
    ui32 connect_error;
    ui32 connect_timeout;
    ui32 request_200_count;
    ui32 request_404_count;
    ui32 request_400500_count;
    ui32 request_other_count;
    ui32 request_error;
    ui32 request_timeout;
    ui32 request_buffer_overflow;

    TStatDataPCItemN() {
        Clear();
    }

    void IncAllRequestCount() {
        all_request_count = IncMax32(all_request_count, 1);
    }
    void IncConnectError() {
        connect_error = IncMax32(connect_error, 1);
    }
    void IncConnectTimeout() {
        connect_timeout = IncMax32(connect_timeout, 1);
    }
    void IncRequest200Count() {
        request_200_count = IncMax32(request_200_count, 1);
    }
    void IncRequest404Count() {
        request_404_count = IncMax32(request_404_count, 1);
    }
    void IncRequest400500Count() {
        request_400500_count = IncMax32(request_400500_count, 1);
    }
    void IncRequestOtherCount() {
        request_other_count = IncMax32(request_other_count, 1);
    }
    void IncRequestError() {
        request_error = IncMax32(request_error, 1);
    }
    void IncRequestTimeout() {
        request_timeout = IncMax32(request_timeout, 1);
    }
    void IncRequsetBufferOverflow() {
        request_buffer_overflow = IncMax32(request_buffer_overflow, 1);
    }

    void Clear() {
        all_request_count = 0;
        connect_error = 0;
        connect_timeout = 0;
        request_200_count = 0;
        request_404_count = 0;
        request_400500_count = 0;
        request_other_count = 0;
        request_error = 0;
        request_timeout = 0;
        request_buffer_overflow = 0;
    }

    TStatDataPCItemN& operator+=(const TStatDataPCItemN& obj) {
        this->all_request_count = IncMax32(this->all_request_count, obj.all_request_count);
        this->connect_error = IncMax32(this->connect_error, obj.connect_error);
        this->connect_timeout = IncMax32(this->connect_timeout, obj.connect_timeout);
        this->request_200_count = IncMax32(this->request_200_count, obj.request_200_count);
        this->request_404_count = IncMax32(this->request_404_count, obj.request_404_count);
        this->request_400500_count = IncMax32(this->request_400500_count, obj.request_400500_count);
        this->request_other_count = IncMax32(this->request_other_count, obj.request_other_count);
        this->request_error = IncMax32(this->request_error, obj.request_error);
        this->request_timeout = IncMax32(this->request_timeout, obj.request_timeout);
        this->request_buffer_overflow = IncMax32(this->request_buffer_overflow, obj.request_buffer_overflow);

        return *this;
    }

    TStatDataPCItemN& operator-=(const TStatDataPCItemN& obj) {
        this->all_request_count = Minus32(this->all_request_count, obj.all_request_count);
        this->connect_error = Minus32(this->connect_error, obj.connect_error);
        this->connect_timeout = Minus32(this->connect_timeout, obj.connect_timeout);
        this->request_200_count = Minus32(this->request_200_count, obj.request_200_count);
        this->request_404_count = Minus32(this->request_404_count, obj.request_404_count);
        this->request_400500_count = Minus32(this->request_400500_count, obj.request_400500_count);
        this->request_other_count = Minus32(this->request_other_count, obj.request_other_count);
        this->request_error = Minus32(this->request_error, obj.request_error);
        this->request_timeout = Minus32(this->request_timeout, obj.request_timeout);
        this->request_buffer_overflow = Minus32(this->request_buffer_overflow, obj.request_buffer_overflow);

        return *this;
    }
};

struct TStatDataPCN {
    TStatDataPCItemN today;
    TStatDataPCItemN yesterday;

    TStatDataPCN() {
    }

    void Midnight() {
        yesterday = today;
        today.Clear();
    }
    TStatDataPCN& operator+=(const TStatDataPCN& obj) {
        this->today += obj.today;
        this->yesterday += obj.yesterday;

        return *this;
    }

    TStatDataPCN& operator-=(const TStatDataPCN& obj) {
        this->today -= obj.today;
        this->yesterday -= obj.yesterday;

        return *this;
    }
};

class TPDDClientItemN {
private:
    NCurl::TCurl curl;
    TBuffer rcv_buffer;
    TMutex m_HostDataMutex;
    TString m_url;
    TDuration m_ConnectTimeOut = TDuration::MilliSeconds(100), m_GetTimeOut = TDuration::MilliSeconds(200);
    TStatDataPCN m_statdata;
    TMutex m_Mutex;
    TPDDMonObj* m_monobj{};

    TKPCWStrokaN GetHost(const TString& host);
    TString GetRequest(const TString& reqhost);
    bool ParseRequest(const TString& rspnc, TPDDStructN& pdddata);

public:
    TPDDClientItemN();

    void Init(TPDDMonObj* monobj, const TString& url, ui32 ConnectTimeOutMSec, ui32 GetTimeOutMSec, const TString& ca);
    void SetHostData(const TString& url, ui32 ConnectTimeOutMSec, ui32 GetTimeOutMSec, const TString& caPath = {});
    void GetRequestToPassport(ui64 shingle, const TString& reqhost, TPrintBuffN& PBUFF, TPDDStructN& pdddata);
    TStatDataPCN GetStat();
    TString GetExampleRequest();
    void Midnight();
};

typedef std::list<TPDDClientItemN*> TPDDClientItemNList;
typedef TPDDClientItemNList::iterator TPDDClientItemNListIt;

//*************************************************************************************************************************************
//                                    TPDDClientQueue - ������� ��� ����������� ��������
//*************************************************************************************************************************************

struct TPDDStructShortN {
    ui64 m_shingle;
    TString m_host;

    TPDDStructShortN() {
        Clear();
    }

    TPDDStructShortN(ui64 shingle, const TString& host) {
        m_shingle = shingle;
        m_host = host;
    }

    void Clear() {
        m_shingle = 0;
        m_host = "";
    }
};

typedef std::list<THolder<TPDDStructShortN>> TPDDClientQueueListN;
typedef TPDDClientQueueListN::iterator TPDDClientQueueListNIt;

struct TQueueStatItemPCN {
    ui64 m_incount;
    ui64 m_inqueue;
    ui64 m_lost;

    TQueueStatItemPCN() {
        Clear();
    }

    void Clear() {
        m_incount = 0;
        m_inqueue = 0;
        m_lost = 0;
    }
};

struct TQueueStatPCN {
    TQueueStatItemPCN today;
    TQueueStatItemPCN yesterday;

    TQueueStatPCN() {
        Clear();
    }

    void Clear() {
        today.Clear();
        yesterday.Clear();
    }
};

class TPDDClientQueueN {
private:
    static const ui32 DefaultQueueSize = 500;
    ui32 m_queue_size;
    TPDDClientQueueListN list;
    THolder<TUnnamedSemaphore> m_Sema;
    ui32 thread_count;
    bool m_stop_event;
    TMutex m_Mutex;
    ui64 in_all;
    ui64 lost_all;
    ui64 out_all;
    ui64 in_today;
    ui64 lost_today;
    ui64 out_today;
    ui64 in_yesterday;
    ui64 lost_yesterday;
    ui64 out_yesterday;

    void SendEvent();
    void UnBlockAllEvent(size_t thread_count);

public:
    TPDDClientQueueN();

    void Init(ui32 capacityA, ui32 thread_countA);
    void Add(ui64 shingle, const TString& host);
    THolder<TPDDStructShortN> Get();
    void Midnight();
    TString GetStatS();
    TQueueStatPCN GetStat();
    void Shutdown();
    void WaitEvent();
};

//*************************************************************************************************************************************
//                                           TPDDClientMain  -�������� �����
//*************************************************************************************************************************************

struct TSummaryStatPCN {
    ui16 threads;                     //����� ������, ������������ �������
    bool enable;                      //������������ �������� PDD
    bool enable_threads;              //����� ��������
    ui32 queue_size;                  //����.������ �������
    TString storage_type;             //��� ��������� (hash, mongo)
    ui32 count_min;                   //������� �������� � ������� ������
    ui32 count_min_max;               //������� �������� � ������ (max � ������ �� �����)
    ui32 count_hour;                  //������� �������� � ������� ���
    ui32 count_hour_max;              //������� �������� � ��� (max � ��� �� �����)
    TString example_request;          //������ ������� � �������
    ui32 host_update_period;          //����� ���������� ���������� �� �����
    bool directly;                    //true - ������ ������� ��������, false - ����� �������
    ui32 directly_accessible_clients; //����� ��������� �������� � ������ directly
    TStatDataPCN client_stat;         //���������� ��������
    TQueueStatPCN queue_stat;         //���������� �������

    TSummaryStatPCN() {
        Clear();
    }

    void Clear() {
        threads = 0;
        enable = false;
        enable_threads = false;
        queue_size = 0;
        storage_type = "";
        count_min = 0;
        count_min_max = 0;
        count_hour = 0;
        count_hour_max = 0;
        example_request = "";
        host_update_period = 0;
        directly = false;
        directly_accessible_clients = 0;
        queue_stat.Clear();
    }
};

class TPDDClientMainN {
private:
    static const ui32 MAX_THREAD_WORK = 16;
    static const ui32 UPDATE_DATA_TIME_DEFAULT = 600; //����� (���) ���������� ������ �� �������� (���� �������, ������ ���������� � ��������)
private:
    THolder<TThread> m_QueueThread[MAX_THREAD_WORK];
    TMutex m_QueueMutex;
    bool m_StopQueueThread;
    bool run_scan_thread;
    ui32 m_thread_count;
    TLogClass* log;
    THolder<TPDDClientItemN> ClientPool[MAX_THREAD_WORK];
    THolder<TPDDStorageBaseN> PDDStorage;
    TPDDClientItemNList m_AccessibleList;
    bool use_mongo;
    TMutex m_tMutex;
    time_t m_lasttime_min;
    ui32 m_count_min;
    ui32 m_count_min_max;
    time_t m_lasttime_hour;
    ui32 m_count_hour;
    ui32 m_count_hour_max;
    ui32 m_max_request_to_min;
    ui32 m_max_request_to_hour;
    bool m_enable;
    ui32 m_queue_size;
    ui32 m_udate_data_time;
    bool m_directly;
    TAtomic m_paused;
    TKConfig* IniFile;
    TPDDMonObj m_monobj;
    bool m_exit;
    THolder<TUnnamedSemaphore> m_Sema;
    TMutex m_MutexExit;
    TMutex m_MutexAccCl;

    int use_threadcount;
    void StartQueueThread();
    void StopQueueThread();

    bool GetPDDInfoQueue(ui64 shingle, const TString& host, TPDDStructN& pdddata);
    bool GetPDDInfoDirectly(ui64 shingle, const TString& host, TPDDStructN& pdddata);

public:
    TPDDClientQueueN m_queue;
    int IncrementNumberThread();
    void DecrementNumberThread();
    bool QueueThreadShouldStop() {
        return m_StopQueueThread;
    }
    void GetRequestToPassport(TPDDClientItemN* client, TPDDStructShortN* data, TPrintBuffN& PBUFF, TPDDStructN& pdddata);
    TPDDClientItemN* GetClientQueue(int threadnumber);
    bool IsPause();

    void ReturnClientDirectly(TPDDClientItemN* elem);
    TPDDClientItemN* GetClientDirectly(int& accessible_client);
    void SetExit();

public:
    TPDDClientMainN();
    ~TPDDClientMainN();

    bool Init(TKConfig* IniFileA, TLogClass* logA);
    bool GetPDDInfo(ui64 shingle, const TString& host, TPDDStructN& pdddata);
    TSummaryStatPCN GetStat();
    void Midnight();
    void Shutdown();
    bool ReloadProperties();

    TString GetMonData();
    bool GetEnable() {
        return m_enable;
    }
};

//*************************************************************************************************************************************

#endif
