#include "tphoneparser.h"

//***************************************************************************************
//                      TPhoneParser - ����� ��� ������ � ����������
//***************************************************************************************

namespace common {
    TPhoneParser::TPhoneParser() {
        InitPrefix();
        InitTable();
    }

    TPhoneParser::~TPhoneParser() {
    }

    bool TPhoneParser::InitPrefix() {
        bool res = true;

        prefixlist.push_back(TPrefix("�", 0));
        prefixlist.push_back(TPrefix("�-�", 0));
        prefixlist.push_back(TPrefix("���-�", 0));
        prefixlist.push_back(TPrefix("���", 0));
        prefixlist.push_back(TPrefix("�����", 0));
        prefixlist.push_back(TPrefix("�������", 0));
        prefixlist.push_back(TPrefix("��������", 0));
        prefixlist.push_back(TPrefix("��������", 0));
        prefixlist.push_back(TPrefix("��������", 0));
        prefixlist.push_back(TPrefix("���/����", 0));
        prefixlist.push_back(TPrefix("tel", 0));
        prefixlist.push_back(TPrefix("phone", 0));
        prefixlist.push_back(TPrefix("telephone", 0));
        prefixlist.push_back(TPrefix("mob", 0));
        prefixlist.push_back(TPrefix("mobile", 0));
        prefixlist.push_back(TPrefix("���", 0));
        prefixlist.push_back(TPrefix("���", 0));
        prefixlist.push_back(TPrefix("���", 0));
        prefixlist.push_back(TPrefix("�������", 0));
        prefixlist.push_back(TPrefix("+7", 1));
        prefixlist.push_back(TPrefix("8", 1));
        prefixlist.push_back(TPrefix("+38", 1));

        if (prefixlist.size() > MAX_PREFIX_COUNT)
            res = false;

        return res;
    }

    void TPhoneParser::InitTable() {
        memset(SymbTable, 0, sizeof(SymbTable));

        SymbTable[(int)'0'] = (SymbTable[(int)'0'] & 0xFE) + 0x01;
        SymbTable[(int)'1'] = (SymbTable[(int)'1'] & 0xFE) + 0x01;
        SymbTable[(int)'2'] = (SymbTable[(int)'2'] & 0xFE) + 0x01;
        SymbTable[(int)'3'] = (SymbTable[(int)'3'] & 0xFE) + 0x01;
        SymbTable[(int)'4'] = (SymbTable[(int)'4'] & 0xFE) + 0x01;
        SymbTable[(int)'5'] = (SymbTable[(int)'5'] & 0xFE) + 0x01;
        SymbTable[(int)'6'] = (SymbTable[(int)'6'] & 0xFE) + 0x01;
        SymbTable[(int)'7'] = (SymbTable[(int)'7'] & 0xFE) + 0x01;
        SymbTable[(int)'8'] = (SymbTable[(int)'8'] & 0xFE) + 0x01;
        SymbTable[(int)'9'] = (SymbTable[(int)'9'] & 0xFE) + 0x01;

        SymbTable[(int)' '] = (SymbTable[(int)' '] & 0xFD) + 0x02;
        SymbTable[(int)':'] = (SymbTable[(int)':'] & 0xFD) + 0x02;
        SymbTable[(int)'.'] = (SymbTable[(int)'.'] & 0xFD) + 0x02;

        SymbTable[(int)' '] = (SymbTable[(int)' '] & 0xFB) + 0x04;
        SymbTable[(int)'+'] = (SymbTable[(int)'+'] & 0xFB) + 0x04;
        SymbTable[(int)'-'] = (SymbTable[(int)'-'] & 0xFB) + 0x04;
        SymbTable[(int)'('] = (SymbTable[(int)'('] & 0xFB) + 0x04;
        SymbTable[(int)')'] = (SymbTable[(int)')'] & 0xFB) + 0x04;

        SymbTable[(int)'0'] = (SymbTable[(int)'0'] & 0xF7) + 0x08;
        SymbTable[(int)'1'] = (SymbTable[(int)'1'] & 0xF7) + 0x08;
        SymbTable[(int)'2'] = (SymbTable[(int)'2'] & 0xF7) + 0x08;
        SymbTable[(int)'3'] = (SymbTable[(int)'3'] & 0xF7) + 0x08;
        SymbTable[(int)'4'] = (SymbTable[(int)'4'] & 0xF7) + 0x08;
        SymbTable[(int)'5'] = (SymbTable[(int)'5'] & 0xF7) + 0x08;
        SymbTable[(int)'6'] = (SymbTable[(int)'6'] & 0xF7) + 0x08;
        SymbTable[(int)'7'] = (SymbTable[(int)'7'] & 0xF7) + 0x08;
        SymbTable[(int)'8'] = (SymbTable[(int)'8'] & 0xF7) + 0x08;
        SymbTable[(int)'9'] = (SymbTable[(int)'9'] & 0xF7) + 0x08;
        SymbTable[(int)'+'] = (SymbTable[(int)'+'] & 0xF7) + 0x08;
        //SymbTable['('] = (SymbTable['('] & 0xF7) + 0x08;
        //SymbTable[')'] = (SymbTable[')'] & 0xF7) + 0x08;

        for (int i = 'a'; i < 'z'; i++)
            SymbTable[i] = (SymbTable[i] & 0xEF) + 0x10;
        for (int i = 'A'; i < 'Z'; i++)
            SymbTable[i] = (SymbTable[i] & 0xEF) + 0x10;
        for (ui32 i = 192; i <= 255; ++i)
            SymbTable[i] = (SymbTable[i] & 0xEF) + 0x10;
    }

    bool TPhoneParser::IsDigits(char symb) {
        bool res = false;
        unsigned char uc = 0;
        ui8 value = 0;

        memcpy(&uc, &symb, sizeof(symb));
        value = SymbTable[uc];
        if ((value & 0x01) > 0)
            res = true;

        return res;
    }

    bool TPhoneParser::IsCharacter(char symb) {
        bool res = false;
        unsigned char uc = 0;
        ui8 value = 0;

        memcpy(&uc, &symb, sizeof(symb));
        value = SymbTable[uc];
        if ((value & 0x02) > 0)
            res = true;

        return res;
    }

    bool TPhoneParser::IsCharacterBody(char symb) {
        bool res = false;
        unsigned char uc = 0;
        ui8 value = 0;

        memcpy(&uc, &symb, sizeof(symb));
        value = SymbTable[uc];
        if ((value & 0x04) > 0)
            res = true;

        return res;
    }

    bool TPhoneParser::IsPhoneSymbol(char symb) {
        bool res = false;
        unsigned char uc = 0;
        ui8 value = 0;

        memcpy(&uc, &symb, sizeof(symb));
        value = SymbTable[uc];
        if ((value & 0x08) > 0)
            res = true;

        return res;
    }

    bool TPhoneParser::IsSymbolSymbol(char symb) {
        bool res = false;
        unsigned char uc = 0;
        ui8 value = 0;

        memcpy(&uc, &symb, sizeof(symb));
        value = SymbTable[uc];
        if ((value & 0x10) > 0)
            res = true;

        return res;
    }

    void TPhoneParser::CheckSymbol(char symb, ui16& digits_count, ui16& character_count, ui16& characterbody_count, ui16& othersymb_count) {
        unsigned char uc = 0;
        ui8 value = 0;
        bool flag = true;

        memcpy(&uc, &symb, sizeof(symb));
        value = SymbTable[uc];
        if ((value & 0x01) > 0) {
            if (digits_count < 0xFFFF)
                digits_count++;
            flag = false;
        }
        if (((value & 0x02) > 0) && (digits_count == 0)) {
            if (character_count < 0xFFFF)
                character_count++;
            flag = false;
        }
        if (((value & 0x04) > 0)) {
            if (characterbody_count < 0xFFFF)
                characterbody_count++;
            flag = false;
        }
        if (flag) {
            if (othersymb_count < 0xFFFF)
                othersymb_count++;
        }
    }

    TString TPhoneParser::GetStripPhoneNumber(const char* p, ui32 len, const TString& /*signature*/) {
        //return TString(p, len);

        TString res = "";
        char symb = 0;

        for (size_t i = 0; i < len; i++) {
            if ((p + i) != nullptr) {
                symb = *(p + i);
                if (IsPhoneSymbol(symb))
                    res = res + symb;
            }
        }

        /*if (!res.empty())
   {
      if (res[0] == ')')
         res = res.substr(1, res.length() -1);
      else if (res[res.length() - 1] == '(')
         res = res.substr(0, res.length() - 1);
   }*/

        return res;
    }

    ui32 TPhoneParser::GetAllPhones(const char* str, ui32 len, TPhoneList& plist) {
        TString source_str = "";
        TPrefixListIt it;
        char symb = 0;
        ui16 digits_count = 0;
        ui16 character_count = 0;
        ui16 characterbody_count = 0;
        ui16 othersymb_count = 0;
        ui32 symb_count = 0;
        TString phone = "";
        bool phoneexists = false;
        int digits_count_v = 0;
        size_t j = 0;
        int osc = -1;
        int zsc = -1;
        char pred_prefix_symb = 0;
        bool pred_prefix_nosymb = false;
        int min_digits_count = 0;
        int max_digits_count = 0;

        source_str = DecodeFromHTML(TString(str, len));
        to_lower_k(source_str);

        plist.clear();

        if (!source_str.empty()) {
            for (size_t i = 0; i < source_str.length(); i++) {
                if ((source_str.c_str() + i) != nullptr) {
                    symb = *(source_str.c_str() + i);

                    phoneexists = false;

                    //����������� �����
                    it = prefixlist.begin();
                    while (it != prefixlist.end()) {
                        TString sss = (*it).prefix;
                        if (((*it).prefix.length() <= (i + 1)) && ((*it).lastsymb == symb)) {
                            //���������� ���������
                            if (!memcmp((*it).prefix.c_str(), source_str.c_str() + i + 1 - (*it).prefix.length(), (*it).prefix.length())) {
                                //����������, ���� �� ������ ����� ��������� ��� �� ������
                                pred_prefix_nosymb = true;
                                pred_prefix_nosymb = false;
                                if ((*it).prefix.length() == (i + 1))
                                    pred_prefix_nosymb = true;
                                else {
                                    if ((symb + i - (*it).prefix.length()) != 0) {
                                        pred_prefix_symb = *(source_str.c_str() + i - (*it).prefix.length());
                                        pred_prefix_nosymb = !IsSymbolSymbol(pred_prefix_symb);
                                    }
                                }
                                //���� ��� �� ������ - ������� �������� �������
                                if (pred_prefix_nosymb) {
                                    j = i + 1;
                                    digits_count = 0;
                                    character_count = 0;
                                    characterbody_count = 0;
                                    othersymb_count = 0;
                                    while (j <= source_str.length()) {
                                        if ((source_str.c_str() + j) != nullptr) {
                                            symb = *(source_str.c_str() + j);
                                            CheckSymbol(symb, digits_count, character_count, characterbody_count, othersymb_count);
                                            if ((othersymb_count > 0) || (j == source_str.length())) {
                                                if ((*it).type == 0) {
                                                    min_digits_count = 5;
                                                    max_digits_count = 12;
                                                } else {
                                                    min_digits_count = 10;
                                                    max_digits_count = 12;
                                                }
                                                if ((character_count >= 0) && (digits_count >= min_digits_count) && (digits_count <= max_digits_count)) {
                                                    symb_count = j - i - 1 + (*it).prefix.length();
                                                    if (symb_count > 0) {
                                                        TString sign = (*it).prefix;
                                                        phone = GetStripPhoneNumber(source_str.c_str() + i + 1 - (*it).prefix.length(), symb_count, "");
                                                        plist.push_back(phone);
                                                    }
                                                    i = i + 1 - (*it).prefix.length() + symb_count;

                                                    phoneexists = true;
                                                    break;
                                                } else
                                                    break;
                                            } else
                                                j++;
                                        }
                                    }
                                    if (phoneexists)
                                        break;
                                }
                            }
                        }
                        ++it;
                    }
                    if (phoneexists) {
                        digits_count_v = 0;
                        osc = -1;
                        zsc = -1;
                        continue;
                    }

                    //����� �������� ���� (XXX)XXXXXXX
                    if (symb == '(')
                        osc = i;
                    else if (symb == ')')
                        zsc = i;
                    else if ((osc >= 0) && IsDigits(symb))
                        digits_count_v++;
                    else {
                        digits_count_v = 0;
                        osc = -1;
                        zsc = -1;
                    }

                    if ((osc >= 0) && (zsc >= 0) && (digits_count_v >= 3) && (digits_count_v <= 5)) {
                        j = osc + 2 + digits_count_v;
                        digits_count = 0;
                        character_count = 0;
                        characterbody_count = 0;
                        othersymb_count = 0;
                        while (j <= source_str.length()) {
                            if ((source_str.c_str() + j) != nullptr) {
                                symb = *(source_str.c_str() + j);
                                CheckSymbol(symb, digits_count, character_count, characterbody_count, othersymb_count);
                                if ((othersymb_count > 0) || (j == source_str.length())) {
                                    if ((character_count >= 0) && (digits_count >= 7) && (digits_count <= 9)) {
                                        symb_count = j - osc;
                                        if (symb_count > 0) {
                                            phone = GetStripPhoneNumber(source_str.c_str() + osc, symb_count, "");
                                            plist.push_back(phone);
                                        }
                                        i = osc + symb_count;

                                        digits_count_v = 0;
                                        osc = -1;
                                        zsc = -1;
                                        break;
                                    } else {
                                        digits_count_v = 0;
                                        osc = -1;
                                        zsc = -1;
                                        break;
                                    }
                                } else
                                    j++;
                            } else {
                                digits_count_v = 0;
                                osc = -1;
                                zsc = -1;
                                break;
                            }
                        }
                    } else if ((osc >= 0) && (digits_count_v > 5)) {
                        digits_count_v = 0;
                        osc = -1;
                        zsc = -1;
                    }
                }
            }
        }

        return plist.size();
    }
}
//***************************************************************************************
