#pragma once

#ifndef tphoneparser_H
#define tphoneparser_H

//#ifdef VERSION_TAG
#include "util/generic/string.h"

//#else
//#  include "util/stroka.h"
//#  include "util/codepage.h"
//#endif
#include "kfunc.h"
#include <list>

//***************************************************************************************
//                      TPhoneParser - ����� ��� ������ � ����������
//***************************************************************************************
namespace common {
    class TPhoneParser {
    public:
        static const int MAX_PREFIX_COUNT = 32;

        typedef std::list<TString> TPhoneList;
        typedef TPhoneList::iterator TPhoneListIt;

        struct TPrefix {
            TString prefix;
            ui8 type; //0 - ����������, 1 - ��������
            char lastsymb;

            TPrefix() {
                prefix = "";
                type = 0;
                lastsymb = 0;
            }

            TPrefix(const TString& prefixA, const ui8& typeA) {
                prefix = prefixA;
                type = typeA;
                if (!prefix.empty())
                    lastsymb = prefix[prefix.length() - 1];
                else
                    lastsymb = 0;
            }
        };

        typedef std::list<TPrefix> TPrefixList;
        typedef TPrefixList::iterator TPrefixListIt;

        struct TPointers {
            const char* p;
            ui8 len;
            ui8 type;
            TString signature;

            TPointers() {
                p = nullptr;
                len = 0;
                type = 0;
                signature = "";
            }

            TPointers(const char* pA, const ui8& lenA, const ui8& typeA, const TString& signatureA) {
                p = pA;
                len = lenA;
                type = typeA;
                signature = signatureA;
            }

            bool operator<(const TPointers& value) const {
                return (p < value.p);
            }
        };

        typedef std::list<TPointers> TPointList;
        typedef TPointList::iterator TPointListIt;

    private:
        TPrefixList prefixlist;
        ui8 SymbTable[256];

        bool InitPrefix();
        void InitTable();
        bool IsDigits(char symb);
        bool IsCharacter(char symb);
        bool IsCharacterBody(char symb);
        bool IsPhoneSymbol(char symb);
        bool IsSymbolSymbol(char symb);
        void CheckSymbol(char symb, ui16& digits_count, ui16& character_count, ui16& characterbody_count, ui16& othersymb_count);
        TString GetStripPhoneNumber(const char* p, ui32 len, const TString& signature);

    public:
        TPhoneParser();
        ~TPhoneParser();

        ui32 GetAllPhones(const char* str, ui32 len, TPhoneList& plist);
    };

    //***************************************************************************************
}

#endif
