#include "tprocidentclass.h"
#include <util/system/hostname.h>
#include <library/cpp/digest/old_crc/crc.h>
#include <library/cpp/charset/codepage.h>

//****************************************************************************************
//                                  TProcIdentClass
//****************************************************************************************

TProcIdentClass::TProcIdentClass() {
    int startcode = 0;
    char buff[16];

    memset(buff, 0, sizeof(buff));
    starttime = time(nullptr);
    startcode = starttime % 0xFFFF;
    snprintf(buff, sizeof(buff) - 1, "%04x", startcode);
    timecode = TString(buff);

    last_sec = 0;
    number = 0;
    hostname = "";
    hostcode = "";

    pid = 0;
    pidcode = "";
}

void TProcIdentClass::Init() {
    last_sec = 0;
    number = 0;
    hostname = HostName();
    ui16 crcval = crc16(hostname.c_str(), hostname.size());

    char buf[10];
    sprintf(buf, "%04x", static_cast<int>(crcval));
    hostcode = buf;

    pid = getpid();
    sprintf(buf, "%04x", pid);
    pidcode = buf;
}

TProcIdentClass::~TProcIdentClass() {
}

ui64 TProcIdentClass::GetNumber() {
    ui64 res = 0;
    time_t t = time(nullptr);

    m_Mutex.Acquire();

    if (t == last_sec) {
        number++;
        res = (ui64)last_sec * (ui64)100000 + (ui64)number;
    } else {
        res = (ui64)t * (ui64)100000;
        last_sec = t;
        number = 0;
    }

    m_Mutex.Release();

    return res;
}

TString TProcIdentClass::GetNumberS(bool second) {
    TString res = "";

    if (second)
        res = "##" + hostcode + "-" + UI64ToStroka(GetNumber()) + "S";
    else
        res = "##" + hostcode + "-" + UI64ToStroka(GetNumber()) + "F";

    return res;
}

TString TProcIdentClass::GetHostName() const {
    return hostname;
}

TString TProcIdentClass::GetHostCode() const {
    return hostcode;
}

TString TProcIdentClass::GetTimeCode() const {
    return timecode;
}

TString TProcIdentClass::GetSummCode() const {
    TString res = "";

    res = hostcode + "-" + pidcode + "-" + timecode;
    ToUpper(res.begin(), res.size());

    return res;
}

TString TProcIdentClass::GetSummCodeDetail() const {
    TString res = "";

    res = GetSummCode() + ", SRVR='" + hostname + "', PID='" + IntToStroka(pid) + "', TIME='" + UI32ToStroka(starttime) + "'";

    return res;
}

//*****************************************************************************************
