#pragma once

#ifndef tprocidentclass_H
#define tprocidentclass_H

#include "util/generic/string.h"
#include "util/system/mutex.h"
#include "kfunc.h"

//****************************************************************************************
//                                  TProcIdentClass
//****************************************************************************************

class TProcIdentClass {
private:
    time_t last_sec;
    ui32 starttime;
    ui32 number;
    TString hostname;
    TString hostcode;
    TString timecode;
    TMutex m_Mutex;
    int pid;
    TString pidcode;

public:
    TProcIdentClass();
    ~TProcIdentClass();

    void Init();
    ui64 GetNumber();                //������� ����� ����������� �������
    TString GetNumberS(bool second); //������� ����� ����������� ������� (second=true ��������� 'S' � �����, second=false ��������� � ����� 'F')
    TString GetHostName() const;     //���������� ��� �����
    TString GetHostCode() const;     //���������� HEX ��� �� ����� �����
    TString GetTimeCode() const;     //���������� ��������� ����� �������� ����� ������

    TString GetSummCode() const;       //���������� ���������� ������: ���_�����-���-���������_�����
    TString GetSummCodeDetail() const; //���������� ����������� summcode
};

//*****************************************************************************************

#endif
