#pragma once

//#ifndef trblhostclass_H
//#define trblhostclass_H

//#ifdef SO_SERV_VERS

#include "util/generic/hash.h"
#include "util/generic/string.h"
#include "util/system/mutex.h"
#include "util/string/util.h"
#include <library/cpp/cgiparam/cgiparam.h>
#include "kfunc.h"
#include "tlogclass.h"
#include "tudnsclass.h"
#include "tkipv6.h"
#include "tkconfig.h"
#include <list>
#include <vector>
#include "ttrafficcontrol.h"

//*************************************************************************************************************************************
//                                                          TUdnsObjItem
//*************************************************************************************************************************************

struct TSootvItem {
    TString m_key;
    TString m_value;

    TSootvItem() {
        Clear();
    }

    TSootvItem(const TString& key, const TString& value) {
        m_key = key;
        m_value = value;
    }

    void Clear() {
        m_key = "";
        m_value = "";
    }
};

typedef std::list<TSootvItem> TSootvItemList;
typedef TSootvItemList::iterator TSootvItemListIt;

enum TUdnsObjItemType { UDNS_UNKNOWN,
                        UDNS_RESOLV,
                        UDNS_GEO,
                        UDNS_RBLHOST,
                        UDNS_OTHER };

TString TUdnsObjItemTypeToStroka(TUdnsObjItemType type);

class TUdnsObjItem {
private:
    bool init_ok;
    THolder<TUdnsClass> udns_obj;
    TLogClass* log;
    TUdnsPropData udns_prop;
    TString name;
    TUdnsObjItemType type;
    TSootvItemList sootvlist;

    TDiffCounter m_00_05;    //���-�� �������� � �������� ���������� 0..4 ��
    TDiffCounter m_05_50;    //���-�� �������� � �������� ���������� 5..49 ��
    TDiffCounter m_50_100;   //���-�� �������� � �������� ���������� 50..99 ��
    TDiffCounter m_100_190;  //���-�� �������� � �������� ���������� 100..189 ��
    TDiffCounter m_more_190; //���-�� �������� � �������� ���������� ������ ��� ����� 190 ��

    TDiffCounter m_ok;
    TDiffCounter m_failed;
    TDiffCounter m_error;
    TDiffCounter m_ip_error;

    bool InitData(const TString& nameA, const TString& host, ui16 port, ui32 timeout, TLogClass* log);
    bool GetData(const TString& Numbrequest, TKIPv6& ip, TMultiStringList& resvalues);

public:
    TUdnsObjItem(const TString& nameA, TLogClass* logA, TUdnsPropData& udns_propA, TUdnsObjItemType typeA, const TSootvItemList& sootvlistA);

    TString Name() {
        return name;
    }
    TUdnsObjItemType Type() {
        return type;
    }
    TUdnsPropData GetProp() {
        return udns_prop;
    }
    TString GetInitStatus();

    bool Resolv(const TString& NumbRequest, TKIPv6& ip, TMultiStringList& resvalues);
    TSummDataUdns GetSummData(const TString& NumbRequest, TKIPv6& ip);

    void AddTick(ui32 tick) {
        if (tick < 5)
            m_00_05.Increment();
        else if ((tick >= 5) && (tick < 50))
            m_05_50.Increment();
        else if ((tick >= 50) && (tick < 100))
            m_50_100.Increment();
        else if ((tick >= 100) && (tick < 190))
            m_100_190.Increment();
        else
            m_more_190.Increment();
    }

    TString GetMonData() {
        TString res = "";

        //<UDNS=*:ok/failed/error/ip_error,00_05/05_50/50_100/100_190/more_190>
        res = res + "<UDNS=" + name + ":";
        res = res + IntToStroka(m_ok.GetDiff()) + "/" + IntToStroka(m_failed.GetDiff()) + "/" + IntToStroka(m_error.GetDiff()) + "/" + IntToStroka(m_ip_error.GetDiff()) + ",";
        res = res + IntToStroka(m_00_05.GetDiff()) + "/" + IntToStroka(m_05_50.GetDiff()) + "/" + IntToStroka(m_50_100.GetDiff()) + "/" + IntToStroka(m_100_190.GetDiff()) + "/" + IntToStroka(m_more_190.GetDiff());
        res = res + ">";

        return res;
    }
};

typedef std::list<TUdnsObjItem> TUdnsObjItemList;
typedef TUdnsObjItemList::iterator TUdnsObjItemListIt;

//*************************************************************************************************************************************
//                                                          TRBLHostClass
//*************************************************************************************************************************************

struct TRBLHostStat {
    TSummDataUdnsList stat_list;

    TRBLHostStat() {
        stat_list.clear();
    }
};

class TRBLHostClass {
public:
    typedef TMultiStringList TRBLWorkRuleList;
    typedef TRBLWorkRuleList::iterator TRBLWorkRuleListIt;

private:
    TLogClass* Log;
    TString m_rblconf_filename;
    TUdnsPropData m_rblconf_prop;
    TUdnsPropData m_resolv_prop;
    TUdnsPropData m_geo_prop;
    TUdnsObjItemList element_list;

    TUdnsObjItemListIt m_resolv_it;
    TUdnsObjItemListIt m_geo_it;

    bool ParseRBLHostFile(const TString& filename, TUdnsObjItemList& elemlist, TLogClass* logA, TUdnsPropData& prop_base);

public:
    TRBLHostClass();

    bool InitByConfig(TKConfig* configobj, TLogClass* LogA);

    //������������� / ��������������� �� ����� ������
    bool Init(TLogClass* LogA,
              bool resolv_enable, const TString& resolv_host, int resolv_port, int resolv_timeout, const TString& resolv_zone,
              bool geo_enable, const TString& geo_host, int geo_port, int geo_timeout, const TString& geo_zone,
              bool rblconf_enable, const TString& rblconf_host, int rblconf_port, int rblconf_timeout, const TString& rblconf_filename);

    //������ ������� ������������� ��� ������ � ���
    void GetInitStatus(TMultiStringList& status_list);

    //�������� ip �� ���� ����� (������ ��������� + ��������� ����)
    void GetAllStat(const TString& NumbRequest, TKIPv6 ip, TSummDataUdnsList& stat_list);

    //������
    bool ResolvEnable();
    TShortDataUdns GetResolvData(const TString& NumbRequest, TKIPv6 ip);
    bool GetResolvData(const TString& NumbRequest, TKIPv6 ip, TString& resvalue);

    //���
    bool GeoEnable();
    TShortDataUdns GetGeoData(const TString& NumbRequest, TKIPv6 ip);
    bool GetGeoData(const TString& NumbRequest, TKIPv6 ip, TString& resvalue);

    //rblhost
    void GetRBLHosts(const TString& NumbRequest, TKIPv6 ip, TShortDataUdnsList& reslist);
    void GetWorkRules(const TString& NumbRequest, TKIPv6 ip, TRBLWorkRuleList& rulelist);

    TString GetMonData();
};

//*************************************************************************************************************************************

//#endif
//#endif
