#pragma once

#include <util/generic/string.h>
#include "tpoolhttpclients.h"

#define EXPORT_BAN                     0x00000001           // was ban
#define EXPORT_BAN_WOW                 0x00000002           // was ban manual
#define EXPORT_WHITE                   0x00000004           // white list
#define EXPORT_RBL4                    0x00000008           // rbl4
#define IS_EXPORT_BAN(flag)            ((flag) & EXPORT_BAN)
#define IS_EXPORT_BAN_WOW(flag)        ((flag) & EXPORT_BAN_WOW)
#define IS_EXPORT_WHITE(flag)          ((flag) & EXPORT_WHITE)
#define IS_EXPORT_RBL4(flag)           ((flag) & EXPORT_RBL4)
#define SET_EXPORT_BAN(flag)           { (flag) |= EXPORT_BAN;     }
#define SET_EXPORT_BAN_WOW(flag)       { (flag) |= EXPORT_BAN_WOW; }
#define SET_EXPORT_WHITE(flag)         { (flag) |= EXPORT_WHITE;   }
#define SET_EXPORT_RBL4(flag)          { (flag) |= EXPORT_RBL4;    }

//****************************************************************************************************************************************
//                                                    TSPSTDataRes
//****************************************************************************************************************************************

struct TSPSTDataRes
{
   bool                    m_exists_data;
   poolhttpcl::TReqError   m_err;
   ui32                    m_err_code;
   TString                  m_ip;
   ui32                    m_today_ham;
   ui32                    m_today_spam;
   ui32                    m_today_malic;
   ui32                    m_today_flag;
   bool                    m_today_autoban;
   bool                    m_today_manualban;
   bool                    m_today_white;
   bool                    m_today_rbl;
   ui8                     m_today_spam_percent;
   ui32                    m_yesterday_ham;
   ui32                    m_yesterday_spam;
   ui32                    m_yesterday_malic;
   ui32                    m_yesterday_flag;
   bool                    m_yesterday_autoban;
   bool                    m_yesterday_manualban;
   bool                    m_yesterday_white;
   bool                    m_yesterday_rbl;
   ui8                     m_yesterday_spam_percent;
   ui32                    m_history_reject;
   ui32                    m_history_noreject;
   ui32                    m_history_ham;
   ui32                    m_history_spam;
   ui8                     m_history_spam_percent;
   TString                  m_geodata;
   TString                  m_host;

   TSPSTDataRes()
   {
      Clear();
   }

   void Clear()
   {
      m_exists_data          = false;
      m_err                  = poolhttpcl::KNONEERROR;
      m_err_code             = 0;
      m_ip                   = "";
      m_today_ham            = 0;
      m_today_spam           = 0;
      m_today_malic          = 0;
      m_today_flag           = 0;
      m_today_autoban        = false;
      m_today_manualban      = false;
      m_today_white          = false;
      m_today_rbl            = false;
      m_today_spam_percent   = 0;
      m_yesterday_ham        = 0;
      m_yesterday_spam       = 0;
      m_yesterday_malic      = 0;
      m_yesterday_flag       = 0;
      m_yesterday_autoban    = false;
      m_yesterday_manualban  = false;
      m_yesterday_white      = false;
      m_yesterday_rbl        = false;
      m_yesterday_spam_percent = 0;
      m_history_reject       = 0;
      m_history_noreject     = 0;
      m_history_ham          = 0;
      m_history_spam         = 0;
      m_history_spam_percent = 0;
      m_geodata              = "";
      m_host                 = "";
   }

   TString ToText()
   {
      TString res = poolhttpcl::TReqErrorToTString(m_err) + ", ";
      if (m_exists_data)
      {
         res = res + "t(ban=" + BoolToStroka2(m_today_autoban) + " mban=" + BoolToStroka2(m_today_manualban) + " h=" + IntToStroka(m_today_ham) + " s=" + IntToStroka(m_today_spam) + " m=" + IntToStroka(m_today_malic) + ") ";
         res = res + "y(ban=" + BoolToStroka2(m_yesterday_autoban) + " mban=" + BoolToStroka2(m_yesterday_manualban) + " h=" + IntToStroka(m_yesterday_ham) + " s=" + IntToStroka(m_yesterday_spam) + " m=" + IntToStroka(m_yesterday_malic) + ") ";
         res = res + "h(rej=" + IntToStroka(m_history_reject) + " norej=" + IntToStroka(m_history_noreject) + " h=" + IntToStroka(m_history_ham) + " s=" + IntToStroka(m_history_spam) + ") ";
         res = res + "geo='" + m_geodata + "' ";
         res = res + "host='" + m_host + "' ";
      } else
         res = res + "-";

      return TString{Trim(res)};
   }

   ui8 TodayPercentSpam()
   {
      ui32 res = 0;

      if ((m_today_ham + m_today_spam) > 0)
         res = m_today_spam * (ui32)100 / (m_today_ham + m_today_spam);

      return (res & 0xFF);
   }

   ui8 YesterdayPercentSpam()
   {
      ui32 res = 0;

      if ((m_yesterday_ham + m_yesterday_spam) > 0)
         res = m_yesterday_spam * (ui32)100 / (m_yesterday_ham + m_yesterday_spam);

      return (res & 0xFF);
   }

   ui8 HistoryPercentSpam()
   {
      ui32 res = 0;

      if ((m_history_ham + m_history_spam) > 0)
         res = m_history_spam * (ui32)100 / (m_history_ham + m_history_spam);

      return (res & 0xFF);
   }

};

//****************************************************************************************************************************************
//                                                    TSPSTData
//****************************************************************************************************************************************

class TSPSTData: public poolhttpcl::THttpBase
{
private:

public:
         TSPSTData();
         ~TSPSTData();

         TSPSTDataRes  ParseResponce(const TString &text);
         TSPSTDataRes  ReturnData();
};

//****************************************************************************************************************************************


