#include "ttraccert_stat.h"
#include "color_scheme.h"

//*******************************************************************************************************************************************
//                                                       TTraccertStat
//*******************************************************************************************************************************************

namespace trcstat {

    TTraccertStat::TTraccertStat() = default;

    void TTraccertStat::Init() {
        diap_vect.push_back(TDiapEl("0", 0, 0));
        diap_vect.push_back(TDiapEl("1-4", 1, 4));
        diap_vect.push_back(TDiapEl("5-9", 5, 9));
        diap_vect.push_back(TDiapEl("10-19", 10, 19));
        diap_vect.push_back(TDiapEl("20-49", 20, 49));
        diap_vect.push_back(TDiapEl("50-69", 50, 69));
        diap_vect.push_back(TDiapEl("70-99", 70, 99));
        diap_vect.push_back(TDiapEl("100-149", 100, 149));
        diap_vect.push_back(TDiapEl("150-189", 150, 189));
        diap_vect.push_back(TDiapEl("190-199", 190, 199));
        diap_vect.push_back(TDiapEl("200-499", 200, 499));
        diap_vect.push_back(TDiapEl("more500", 500, 1000000));
    }

    void TTraccertStat::AddTick(const TString& ident, ui32 tick) {
        TTraccertStatItemHashIt it;

        if (!ident.empty()) {
            m_Mutex.Acquire();

            if (srvc_hash_today) {
                it = srvc_hash_today.find(ident);
                if (it != srvc_hash_today.end()) {
                    (*it).second.Increment(tick, diap_vect);

                } else {
                    (srvc_hash_today)[ident] = TTraccertStatItem(ident, tick, diap_vect);
                }
            }

            m_Mutex.Release();
        }
    }

    void TTraccertStat::Midnight() {
        m_Mutex.Acquire();
        srvc_hash_today = {};
        m_Mutex.Release();
    }

    TString TTraccertStat::GetWebData() {
        TString res = "";
        ui32 col_width = 0;
        TTraccertStatItemVector data_vect;
        TTraccertStatItemVectorIt it;
        TTraccertStatItemHashIt hit;

        if (diap_vect.size() > 0)
            col_width = (100 - 20) / (diap_vect.size() + 1);

        res += "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=" + TString(color_table_default) + ">\n";

        res += "<tr bgcolor=" + TString(color_table_shap) + " align='center'>";
        res += "<td width='20%'>&nbsp;</td>";
        if (diap_vect.size() > 0) {
            res += "<td width='" + IntToStroka(col_width) + "%'><b>ALL</b></td>";
            for (size_t i = 0; i < diap_vect.size(); i++)
                res += "<td width='" + IntToStroka(col_width) + "%'><b>" + diap_vect[i].m_label + "</b></td>";
        }
        res += "</tr>";

        m_Mutex.Acquire();
        if (srvc_hash_today) {
            hit = srvc_hash_today.begin();
            while (hit != srvc_hash_today.end()) {
                data_vect.push_back((*hit).second);

                ++hit;
            }
        }
        m_Mutex.Release();

        std::sort(data_vect.begin(), data_vect.end());

        it = data_vect.begin();
        while (it != data_vect.end()) {
            res += "<tr align='right'>";
            res += "<td align='left'>" + (*it).m_srvc_label + "</td>";
            if (diap_vect.size() > 0) {
                ui32 all_cnt = 0;
                for (size_t i = 0; i < diap_vect.size(); i++) {
                    if (i < TTraccertStatItem::DEFAUL_CNT_COUNT)
                        all_cnt = IncMax32(all_cnt, (*it).m_count[i]);
                }
                res += "<td>" + IntToStroka(all_cnt) + "</td>";

                for (size_t i = 0; i < diap_vect.size(); i++) {
                    if (i < TTraccertStatItem::DEFAUL_CNT_COUNT) {
                        if ((*it).m_count[i] > 0)
                            res += "<td>" + IntToStroka((*it).m_count[i]) + "</td>";
                        else
                            res += "<td>-</td>";
                    }
                }
            }
            res += "</tr>";

            ++it;
        }

        res += "</table>\n";

        return res;
    }

    //*******************************************************************************************************************************************

} // namespace trcstat
