#include "ttrafficcontrol.h"
#include "shtime.h"

//*****************************************************************************************************************************************
//                                                    TCalcRulesCSStat
//*****************************************************************************************************************************************

TCalcRulesCSStat::TCalcRulesCSStat() {
}

TCalcRulesCSStat::~TCalcRulesCSStat() {
}

void TCalcRulesCSStat::AddFilterCall(const TString& rules_cs) {
    THashMap<TString, ui32>::iterator it;

    m_Mutex.Acquire();

    it = m_data.find(rules_cs);
    if (it != m_data.end())
        (*it).second++;
    else
        m_data[rules_cs] = 1;

    m_Mutex.Release();
}

TString TCalcRulesCSStat::GetUniqRulesCount() {
    TString res = "";
    int uniq_part_count = 0;
    int all_call_count = 0;
    THashMap<TString, ui32>::iterator it;

    m_Mutex.Acquire();

    uniq_part_count = m_data.size();
    it = m_data.begin();
    while (it != m_data.end()) {
        all_call_count = all_call_count + (*it).second;
        ++it;
    }
    m_data.clear();

    m_Mutex.Release();

    res = IntToStroka(uniq_part_count) + "/" + IntToStroka(all_call_count);

    return res;
}

//********************************************************************************************************************************
//                                                    TDelayByPart
//********************************************************************************************************************************

TDelayByPart::TDelayByPart() {
    data_today.Clear();
    data_yesterday.Clear();
}

TDelayByPart::~TDelayByPart() {
}

void TDelayByPart::Increment(ui32 delay) {
    m_Mutex.Acquire();

    if (delay < 10)
        data_today.m_0_10 = IncMax32(data_today.m_0_10, 1);
    else if (delay < 20)
        data_today.m_10_20 = IncMax32(data_today.m_10_20, 1);
    else if (delay < 30)
        data_today.m_20_30 = IncMax32(data_today.m_20_30, 1);
    else if (delay < 40)
        data_today.m_30_40 = IncMax32(data_today.m_30_40, 1);
    else if (delay < 50)
        data_today.m_40_50 = IncMax32(data_today.m_40_50, 1);
    else if (delay < 100)
        data_today.m_50_100 = IncMax32(data_today.m_50_100, 1);
    else if (delay < 195)
        data_today.m_100_200 = IncMax32(data_today.m_100_200, 1);
    else if (delay < 500)
        data_today.m_200_500 = IncMax32(data_today.m_200_500, 1);
    else
        data_today.m_more500 = IncMax32(data_today.m_more500, 1);

    m_Mutex.Release();
}

TDelayByPartStat TDelayByPart::GetDiff() {
    TDelayByPartStat res;

    m_Mutex.Acquire();

    res = data_today;
    data_today.Clear();

    m_Mutex.Release();

    return res;
}

TDelayByPartStat TDelayByPart::GetToday() {
    return data_today;
}

TDelayByPartStat TDelayByPart::GetYesterday() {
    return data_yesterday;
}

void TDelayByPart::Midnight() {
    m_Mutex.Acquire();

    data_yesterday = data_today;
    data_today.Clear();

    m_Mutex.Release();
}

//********************************************************************************************************************************
//                                                       TDiffCounter
//********************************************************************************************************************************

TDiffCounter::TDiffCounter() {
    last_value = 0;
}

TDiffCounter::~TDiffCounter() {
}

void TDiffCounter::Increment() {
    curr_value.Increment();
}

void TDiffCounter::IncrementM(ui32 count) {
    curr_value.Add(count);
}

ui32 TDiffCounter::GetDiff() {
    ui32 res = 0;
    i64 current_value = 0;

    current_value = curr_value.Value();
    if (current_value > 0) {
        if (current_value < last_value) {
            m_Mutex.Acquire();

            last_value = 0;

            m_Mutex.Release();
        }
        if (current_value > last_value) {
            m_Mutex.Acquire();

            res = current_value - last_value;
            last_value = current_value;

            m_Mutex.Release();
        }
    }

    return res;
}

//************************************************************************************************************************************
//                                                 TTrafficCounter
//************************************************************************************************************************************

TTrafficCounter::TTrafficCounter() {
    today_request.Swap(0);
    last_request_count = 0;
    yesterday_request = 0;
    last_calc_cps = time(nullptr);
    m_cps = 0;
}

TTrafficCounter::~TTrafficCounter() {
}

void TTrafficCounter::AddRequest() {
    today_request.Increment();
}

void TTrafficCounter::Midnight() {
    m_Mutex.Acquire();

    yesterday_request = today_request.Value();
    today_request.Swap(0);
    last_request_count = 0;

    m_Mutex.Release();
}

void TTrafficCounter::CalcCPS() {
    ui32 currenttime = time(nullptr);
    ui64 diff = 0;
    ui32 difftime = 0;
    ui64 newvalue = 0;
    float cps = 0;

    difftime = currenttime - last_calc_cps;
    if (difftime > PERIOD_CALC_CPS_SEC) {
        newvalue = today_request.Value();
        if (newvalue >= last_request_count)
            diff = newvalue - last_request_count;
        else
            diff = newvalue;
        cps = diff / difftime;

        m_Mutex.Acquire();

        last_calc_cps = currenttime;
        last_request_count = newvalue;
        m_cps = cps;

        m_Mutex.Release();
    }
}

TTrafficCtrlStat TTrafficCounter::GetStat() {
    TTrafficCtrlStat res;

    res.cps_stat = FloatToStr(m_cps);
    res.today_request = today_request.Value();
    res.today_lost = 0;
    res.yesterday_request = yesterday_request;
    res.yesterday_lost = 0;

    return res;
}

ui64 TTrafficCounter::GetTodayRequest() {
    return today_request.Value();
}

ui64 TTrafficCounter::GetYesterdayRequest() {
    return yesterday_request;
}

float TTrafficCounter::GetCPS() {
    return m_cps;
}

//************************************************************************************************************************************
//                                                 TTrafficControl
//************************************************************************************************************************************

TTrafficControl::TTrafficControl() {
 SrvcDisabled = false;
    koef.Swap(1);
    inc.Swap(0);
    teilinc.Swap(0);
    teilinc_last = 0;
    inc_last = 0;
    last_cps = 0;
    in_last_cps = 0;
    max_cps = 0;
    in_max_cps = 0;
    tick = 0;
    timelast = 0;
    treshold_min = 0;
    treshold_max = 0;

    up_counter = 0;
    down_counter = 0;
    middle_counter = 0;
    enable = false;

    yesterday_request = 0;
    lost_yesterday_request = 0;
    uservalue1_yesterday_request = 0;

    last_sec = 0;
    number = 0;
}

TTrafficControl::~TTrafficControl() {
}

void TTrafficControl::Init(ui32 tresholdMinA, ui32 tresholdMaxA, bool EnableA, bool SrvcDisabledA) {
 SrvcDisabled = SrvcDisabledA;
    if (tresholdMaxA >= tresholdMinA) {
        treshold_min = tresholdMinA;
        treshold_max = tresholdMaxA;
    } else {
        treshold_min = tresholdMaxA;
        treshold_max = tresholdMinA;
    }
    timelast = CShingleTime::GetMs();
    enable = EnableA;
}

bool TTrafficControl::Skeep() {
    bool res = true;

 if (SrvcDisabled)
 {
  res = true;
 }
 else
 {
  if (enable) {
   i64 value = 0;
   i64 wkoef = 0;

   value = inc.Increment();
   wkoef = koef.Value();

   if (wkoef != 0)
    res = (value % wkoef) ? false : true;
   if (res)
    teilinc.Increment();

  }
  else {
   inc.Increment();
   teilinc.Increment();

   res = true;
  }
 }

    AllRequest.Increment();
    if (!res)
        LostAllRequest.Increment();

    diffallcounter.Increment();
    if (!res)
        difflostcounter.Increment();

    return !res;
}

void TTrafficControl::CalcCPS() {
    if (!AGGRESSIVE_STRATEGY)
        CalcCPSOld();
    else
        CalcCPSNew();
}

void TTrafficControl::CalcCPSOld() {
    if (true /*enable*/) {
        ui32 timetick = CShingleTime::GetMs();
        ui32 timediff = timetick - timelast;
        if (timediff > TIMEPERIODMSEC) {
            i64 value = 0;
            i64 udiff = 0;

            m_Mutex.Acquire();

            //calc cps out
            value = teilinc.Value();
            if (value >= teilinc_last)
                udiff = value - teilinc_last;
            teilinc_last = value;

            last_cps = (float)udiff / (float)timediff * (float)1000;
            if (last_cps > max_cps)
                max_cps = last_cps;

            //calc cps in
            value = inc.Value();
            if (value >= inc_last)
                udiff = value - inc_last;
            inc_last = value;

            in_last_cps = (float)udiff / (float)timediff * (float)1000;
            if (in_last_cps > in_max_cps)
                in_max_cps = in_last_cps;

            //do
            if (last_cps > treshold_max) {
                up_counter++;
                if (up_counter >= 2) {
                    down_counter = 0;
                    middle_counter = 0;
                }
            } else if (last_cps < treshold_min) {
                down_counter++;
                if (down_counter >= 2) {
                    up_counter = 0;
                    middle_counter = 0;
                }
            } else {
                middle_counter++;
                if (middle_counter >= 2) {
                    down_counter = 0;
                    up_counter = 0;
                }
            }
            if (up_counter >= 5) {
                i64 tkoefval = 0;

                tkoefval = koef.Value();
                if (tkoefval < 100) {
                    koef.Increment();
                } else {
                    koef.Swap(100);
                }

                up_counter = 0;
                down_counter = 0;
            } else if (down_counter >= 5) {
                i64 tkoefval = 0;

                tkoefval = koef.Value();
                if (tkoefval > 1) {
                    koef.Decrement();
                } else {
                    koef.Swap(1);
                }

                up_counter = 0;
                down_counter = 0;
            }

            timelast = timetick;

            m_Mutex.Release();
        }
    }
}

void TTrafficControl::CalcCPSNew() {
    if (true /*enable*/) {
        ui32 timetick = CShingleTime::GetMs();
        ui32 timediff = timetick - timelast;
        if (timediff > TIMEPERIODMSEC) {
            i64 value = 0;
            i64 udiff = 0;
            i64 t_koef = 0;
            i64 t_val_koef = 0;
            float t_lastcps = 0;

            m_Mutex.Acquire();

            //calc cps out
            value = teilinc.Value();
            if (value >= teilinc_last)
                udiff = value - teilinc_last;
            teilinc_last = value;

            last_cps = (float)udiff / (float)timediff * (float)1000;
            if (last_cps > max_cps)
                max_cps = last_cps;

            //calc cps in
            value = inc.Value();
            if (value >= inc_last)
                udiff = value - inc_last;
            inc_last = value;

            in_last_cps = (float)udiff / (float)timediff * (float)1000;
            if (in_last_cps > in_max_cps)
                in_max_cps = in_last_cps;

            //do
            if (last_cps > treshold_max) {
                up_counter++;
                if (up_counter >= 2) {
                    down_counter = 0;
                    middle_counter = 0;
                }
            } else if (last_cps < treshold_min) {
                down_counter++;
                if (down_counter >= 2) {
                    up_counter = 0;
                    middle_counter = 0;
                }
            } else {
                middle_counter++;
                if (middle_counter >= 2) {
                    down_counter = 0;
                    up_counter = 0;
                }
            }
            if (up_counter >= 5) {
                t_val_koef = 5;
                for (int z = 1; z <= t_val_koef; z++) {
                    t_koef = koef.Value() + z;
                    t_lastcps = in_last_cps / (float)t_koef;
                    if (t_lastcps < treshold_max) {
                        t_val_koef = z;
                        break;
                    }
                }

                //t_lastcps = in_last_cps / (float)(koef + t_val_koef);
                //printf("UP: koef=%d, diff=%d, lastcps=%2.2f, rcps=%2.2f\n", koef, t_val_koef, in_last_cps, t_lastcps);

                //��������� �� �������� ��������� � �������� 1...100 � ����������� � ������������
                i64 tkoefval = 0;

                tkoefval = koef.Value();
                tkoefval = IncMax64_i(tkoefval, t_val_koef);
                if (tkoefval < 1) {
                    koef.Swap(1);
                } else if (tkoefval > 100) {
                    koef.Swap(100);
                } else
                    koef.Add(t_val_koef);

                up_counter = 0;
                down_counter = 0;

            } else if (down_counter >= 5) {
                t_val_koef = 5;
                for (int z = 1; z <= t_val_koef; z++) {
                    if (koef.Value() > z) {
                        t_koef = koef.Value() - z;
                        t_lastcps = in_last_cps * (float)t_koef;
                        if (t_lastcps > treshold_min) {
                            t_val_koef = z;
                            break;
                        }
                    } else {
                        t_val_koef = 1;
                        break;
                    }
                }
                t_val_koef = -1 * t_val_koef;

                //t_lastcps = in_last_cps / (float)(koef + t_val_koef);
                //printf("DOWN: koef=%d, diff=%d, lastcps=%2.2f, rcps=%2.2f\n", koef, t_val_koef, in_last_cps, t_lastcps);

                //��������� �� �������� ��������� � �������� 1...100 � ����������� � ������������
                i64 tkoefval = 0;

                tkoefval = koef.Value();
                tkoefval = IncMax64_i(tkoefval, t_val_koef);
                if (tkoefval < 1) {
                    koef.Swap(1);
                } else if (tkoefval > 100) {
                    koef.Swap(100);
                } else
                    koef.Add(t_val_koef);

                up_counter = 0;
                down_counter = 0;
            }

            timelast = timetick;

            m_Mutex.Release();
        }
    }
}

TString TTrafficControl::GetStatist() {
    TString res = "";
    char buff[1024];

 if (SrvcDisabled)
 {
  res = "service disabled";
 }
 else
 {
  if (enable) {
   i64 wkoefi = 0;
   ui32 wkoef = 0;

   wkoefi = koef.Value();
   wkoef = wkoefi & 0xFFFFFFFF;
   memset(buff, 0, sizeof(buff));
   snprintf(buff, sizeof(buff) - 1, "IN_MPS=%5.2f (IN_MPSmax=%5.2f), RCV_MPS=%5.2f (RCV_MPSmax=%5.2f), Koef=%u (THmin=%u, THmax=%u)", in_last_cps, in_max_cps, last_cps, max_cps, wkoef, treshold_min, treshold_max);
   res.assign(buff);
  }
  else {
   memset(buff, 0, sizeof(buff));
   snprintf(buff, sizeof(buff) - 1, "IN_MPS=%5.2f (IN_MPSmax=%5.2f), RCV_MPS=%5.2f (RCV_MPSmax=%5.2f)", in_last_cps, in_max_cps, last_cps, max_cps);
   res.assign(buff);
  }
 }

    return res;
}

TString TTrafficControl::GetStatistMin() {
    TString res = "";
    char buff[1024];

 if (SrvcDisabled)
 {
  res = "service disabled";
 }
 else
 {
  memset(buff, 0, sizeof(buff));
  snprintf(buff, sizeof(buff) - 1, "%5.2f", in_last_cps);
  res.assign(buff);
 }

    return res;
}

TString TTrafficControl::GetStatistMin2() {
    TString res = "";
    char buff[1024];

 if (SrvcDisabled)
 {
  res = "service disabled";
 }
 else
 {
  memset(buff, 0, sizeof(buff));
  snprintf(buff, sizeof(buff) - 1, "%5.2f (%5.2f), rcvcount(today/yesterday): %" PRIu64 " / %" PRIu64, in_last_cps, in_max_cps, GetTodayRequest(), GetYesterdayRequest());
  res.assign(buff);

 }

    return res;
}

TString TTrafficControl::GetStatistLog()
{
 TString res = "";

 if (SrvcDisabled)
 {
  res = "service disabled";
 }
 else
 {
  if (enable)
  {
   ui32   wkoef = 0;
   char   buff[1024];

   wkoef = static_cast<ui32>(koef.Value());
//   wkoef = atomic_add(koef, 0);
   memset(buff, 0, sizeof(buff));
   snprintf(buff, sizeof(buff) - 1, "IN=%5.2f,RCV=%5.2f,K=%u(%u:%u)", in_last_cps, last_cps, wkoef, treshold_min, treshold_max);
   res.assign(buff);
  }
  else
  {
   res = "control disabled";
  }
 }

 return res;
}
ui32 TTrafficControl::GetKoef() {
    ui32 res = 1;
    i64 wkoef = 0;

    wkoef = koef.Value();
    res = wkoef & 0xFFFFFFFF;

    return res;
}

float TTrafficControl::GetInMPS() {
    return in_last_cps;
}

float TTrafficControl::GetRcvMPS() {
    return last_cps;
}

ui32 TTrafficControl::GetMinTreshold() {
    return treshold_min;
}

ui32 TTrafficControl::GetMaxTreshold() {
    return treshold_max;
}

void TTrafficControl::EnableSkeepRegime(bool enableA) {
    m_Mutex.Acquire();

    enable = enableA;

    koef.Swap(1);

    m_Mutex.Release();
}

bool TTrafficControl::GetSkeepRegime() {
    return enable;
}

void TTrafficControl::IncrementUserValue1Request() {
    UserValue1Request.Increment();
}

void TTrafficControl::Midnight() {
    m_MutexMailStat.Acquire();

    yesterday_request = AllRequest.Value();
    lost_yesterday_request = LostAllRequest.Value();
    uservalue1_yesterday_request = UserValue1Request.Value();

    AllRequest.Clear();
    LostAllRequest.Clear();
    UserValue1Request.Clear();

    m_MutexMailStat.Release();

    m_Mutex.Acquire();

    inc.Swap(0);
    teilinc.Swap(0);
    teilinc_last = 0;
    inc_last = 0;

    m_Mutex.Release();
}

ui64 TTrafficControl::GetTodayRequest() {
    return AllRequest.Value();
}

ui64 TTrafficControl::GetTodayLostRequest() {
    return LostAllRequest.Value();
}

ui64 TTrafficControl::GetTodayUserValue1Request() {
    return UserValue1Request.Value();
}

ui64 TTrafficControl::GetYesterdayRequest() {
    return yesterday_request;
}

ui64 TTrafficControl::GetYesterdayLostRequest() {
    return lost_yesterday_request;
}

ui64 TTrafficControl::GetYesterdayUserValue1Request() {
    return uservalue1_yesterday_request;
}

TString TTrafficControl::GetMailStatist() {
    TString res = "";
    char buff[512];

    memset(buff, 0, sizeof(buff));
    snprintf(buff, sizeof(buff) - 1, "lost=%" PRIu64 " / all=%" PRIu64, GetTodayLostRequest(), GetTodayRequest());
    res = TString(buff);

    return res;
}

ui64 TTrafficControl::GetNumber() {
    ui64 res = 0;
    time_t t = time(nullptr);

    m_MutexNumb.Acquire();

    if (t == last_sec) {
        number++;
        res = (ui64)last_sec * (ui64)100000 + (ui64)number;
    } else {
        res = (ui64)t * (ui64)100000;
        last_sec = t;
        number = 0;
    }

    m_MutexNumb.Release();

    return res;
}

ui64 TTrafficControl::GetNumberProxy() {
    ui64 res = 0;
    //   ui64     tres = 0;
    time_t t = time(nullptr);

    m_MutexNumb.Acquire();

    if (t == last_sec) {
        number++;
        res = (ui64)last_sec * (ui64)100000 + (ui64)number;
    } else {
        res = (ui64)t * (ui64)100000;
        last_sec = t;
        number = 0;
    }

    res = (ui64)1000000 * (ui64)1000000 * (ui64)10000000 + res;

    m_MutexNumb.Release();

    return res;
}

/*ui32 TTrafficControl::atomic_add(ui32 &base, ui32 addv)
{
   ui32 res    = 0;
   ui32 vart   = 0;
   ui32 varmax = -1;

   m_atomic_mutex.Acquire();

   if (addv == 0)
      res = base;
   else
   {
      vart = varmax - base;
      if (addv <= vart)
         base = base + addv;
      else
         base = varmax;
      res = base;
   }

   m_atomic_mutex.Release();

   return res;
}*/

TString TTrafficControl::GetStatistCounter() {
    TString res = "";
    char buff[256];

    memset(buff, 0, sizeof(buff));
    snprintf(buff, sizeof(buff) - 1, "%5.2f, %" PRIu64 " / %" PRIu64, GetInMPS(), GetTodayRequest(), GetYesterdayRequest());
    res = TString(buff);

    return res;
}

TTrafficCtrlStat TTrafficControl::GetConsoleStat() {
    TTrafficCtrlStat res;

    res.cps_stat = GetStatist();
    res.today_request = GetTodayRequest();
    res.today_lost = GetTodayLostRequest();
    res.yesterday_request = GetYesterdayRequest();
    res.yesterday_lost = GetYesterdayLostRequest();

    return res;
}

void TTrafficControl::IncHamCount() {
    hamcount.Increment();
}

void TTrafficControl::IncSpamCount() {
    spamcount.Increment();
}

void TTrafficControl::IncMalicCount() {
    maliccount.Increment();
}

void TTrafficControl::IncBanCount() {
    bancount.Increment();
}

i64 TTrafficControl::GetHamCount() {
    i64 res = 0;

    res = hamcount.Value();
    hamcount.Swap(0);

    return res;
}

i64 TTrafficControl::GetSpamCount() {
    i64 res = 0;

    res = spamcount.Value();
    spamcount.Swap(0);

    return res;
}

i64 TTrafficControl::GetMalicCount() {
    i64 res = 0;

    res = maliccount.Value();
    maliccount.Swap(0);

    return res;
}

i64 TTrafficControl::GetBanCount() {
    i64 res = 0;

    res = bancount.Value();
    bancount.Swap(0);

    return res;
}

TString TTrafficControl::GetStatistikToLog() {
    TString res = "";
    i64 ham_count = 0;
    i64 spam_count = 0;
    i64 malic_count = 0;
    i64 ban_count = 0;
    i64 in_count = 0;
    i64 lost_count = 0;
    i64 in_count_a = 0;
    i64 lost_count_a = 0;
    i64 in_count_diff = 0;
    i64 lost_count_diff = 0;

    ham_count = GetHamCount();
    spam_count = GetSpamCount();
    malic_count = GetMalicCount();
    ban_count = GetBanCount();
    in_count = GetTodayRequest();
    lost_count = GetTodayLostRequest();
    in_count_a = in_count_last.Value();
    lost_count_a = lost_count_last.Value();

    if (in_count > in_count_a)
        in_count_diff = in_count - in_count_a;
    if (lost_count > lost_count_a)
        lost_count_diff = lost_count - lost_count_a;
    in_count_last.Swap(in_count);
    lost_count_last.Swap(lost_count);

    res = res + "rcv=" + FloatToStr(GetRcvMPS()) + " (in=" + FloatToStr(GetInMPS()) + "/" + IntToStroka2(GetKoef()) + "), ";
    res = res + "mall=" + IntToStroka(in_count_diff) + ", ";
    res = res + "mlost=" + IntToStroka(lost_count_diff) + ", ";
    res = res + "ham=" + IntToStroka(ham_count) + ", ";
    res = res + "spm=" + IntToStroka(spam_count) + ", ";
    res = res + "mlc=" + IntToStroka(malic_count) + ", ";
    res = res + "ban=" + IntToStroka(ban_count) + ", ";

    return res;
}

TString TTrafficControl::GetStatistikToLog2() {
    TString res = "";
    i64 ham_count = 0;
    i64 spam_count = 0;
    i64 malic_count = 0;
    i64 ban_count = 0;
    i64 in_count = 0;
    i64 lost_count = 0;
    i64 in_count_a = 0;
    i64 lost_count_a = 0;
    i64 in_count_diff = 0;
    i64 lost_count_diff = 0;

    ham_count = GetHamCount();
    spam_count = GetSpamCount();
    malic_count = GetMalicCount();
    ban_count = GetBanCount();
    in_count = GetTodayRequest();
    lost_count = GetTodayLostRequest();
    in_count_a = in_count_last.Value();
    lost_count_a = lost_count_last.Value();

    if (in_count > in_count_a)
        in_count_diff = in_count - in_count_a;
    if (lost_count > lost_count_a)
        lost_count_diff = lost_count - lost_count_a;
    in_count_last.Swap(in_count);
    lost_count_last.Swap(lost_count);

    res = res + "rcv=" + FloatToStr(GetRcvMPS()) + " (in=" + FloatToStr(GetInMPS()) + "/" + IntToStroka2(GetKoef()) + "), ";
    res = res + "mall=" + IntToStroka(in_count_diff) + ", ";
    res = res + "mlost=" + IntToStroka(lost_count_diff) + ", ";
    res = res + "badrqst=" + IntToStroka(ham_count) + ", ";
    res = res + "ban=" + IntToStroka(ban_count) + ", ";

    return res;
}

//************************************************************************************************************************************
