#pragma once

#include "util/system/mutex.h"
#include "tkcounterclass.h"
#include "library/cpp/deprecated/atomic/atomic.h"
#include "kfunc.h"

//*****************************************************************************************************************************************
//                                                    TCalcRulesCSStat
//*****************************************************************************************************************************************

class TCalcRulesCSStat {
private:
    THashMap<TString, ui32> m_data;
    TMutex m_Mutex;

public:
    TCalcRulesCSStat();
    ~TCalcRulesCSStat();

    void AddFilterCall(const TString& rules_cs);
    TString GetUniqRulesCount();
};

//********************************************************************************************************************************
//                                                       TDiffCounter
//********************************************************************************************************************************

class TDiffCounter {
private:
    TKAtomic curr_value;
    i64 last_value;
    TMutex m_Mutex;

public:
    TDiffCounter();
    ~TDiffCounter();

    void Increment();
    void IncrementM(ui32 count);
    ui32 GetDiff();
};

//********************************************************************************************************************************
//                                                    TDelayByPart
//********************************************************************************************************************************

struct TDelayByPartStat {
    ui32 m_0_10;    //0 - 10 ms
    ui32 m_10_20;   //10 - 20 ms
    ui32 m_20_30;   //20 - 30 ms
    ui32 m_30_40;   //30 - 40 ms
    ui32 m_40_50;   //40 - 50 ms
    ui32 m_50_100;  //50 - 100 ms
    ui32 m_100_200; //100 - 195 ms
    ui32 m_200_500; //195 - 500 ms
    ui32 m_more500; //more 500 ms

    TDelayByPartStat() {
        Clear();
    }

    void Clear() {
        m_0_10 = 0;
        m_10_20 = 0;
        m_20_30 = 0;
        m_30_40 = 0;
        m_40_50 = 0;
        m_50_100 = 0;
        m_100_200 = 0;
        m_200_500 = 0;
        m_more500 = 0;
    }

    TString toLog() {
        TString res = "";
        char buff[256];

        memset(buff, 0, sizeof(buff));
        snprintf(buff, sizeof(buff), "%u-%u-%u-%u-%u-%u-%u-%u-%u", m_0_10, m_10_20, m_20_30, m_30_40, m_40_50, m_50_100, m_100_200, m_200_500, m_more500);
        res = TString(buff);

        return res;
    }
};

class TDelayByPart {
private:
    TDelayByPartStat data_today;
    TDelayByPartStat data_yesterday;
    TMutex m_Mutex;

public:
    TDelayByPart();
    ~TDelayByPart();

    void Increment(ui32 delay);
    TDelayByPartStat GetDiff();
    TDelayByPartStat GetToday();
    TDelayByPartStat GetYesterday();
    void Midnight();
};

//********************************************************************************************************************************
//                                                    TTrafficCtrlStat
//********************************************************************************************************************************

struct TTrafficCtrlStat {
    TString cps_stat;
    ui64 today_request;
    ui64 today_lost;
    ui64 yesterday_request;
    ui64 yesterday_lost;

    TTrafficCtrlStat() {
        Clear();
    }

    void Clear() {
        cps_stat = "";
        today_request = 0;
        today_lost = 0;
        yesterday_request = 0;
        yesterday_lost = 0;
    }
};

//************************************************************************************************************************************
//                                                 TTrafficCounter
//************************************************************************************************************************************

class TTrafficCounter {
private:
    static const int PERIOD_CALC_CPS_SEC = 20;

private:
    TKAtomic today_request;
    ui32 last_request_count;
    ui64 yesterday_request;
    time_t last_calc_cps;
    TMutex m_Mutex;
    float m_cps;

public:
    TTrafficCounter();
    ~TTrafficCounter();

    void AddRequest();
    void Midnight();
    void CalcCPS();
    TTrafficCtrlStat GetStat();
    ui64 GetTodayRequest();
    ui64 GetYesterdayRequest();
    float GetCPS();
};

//************************************************************************************************************************************
//                                                 TTrafficControl
//************************************************************************************************************************************

class TTrafficControl {
private:
    static const ui32 TIMEPERIODMSEC = 6000;
    static const bool AGGRESSIVE_STRATEGY = true;

 bool     SrvcDisabled;
    TKAtomic koef;    //����������� �������
    TKAtomic inc;     //��������������� ������������� ������� (�� ���� �������� ��������)
    TKAtomic teilinc; //��������������� ������������� ������� (������ �� �������� �������� � �������� "�������")
    i64 teilinc_last;
    i64 inc_last;
    float last_cps;
    float in_last_cps;
    float max_cps;
    float in_max_cps;
    ui32 tick;
    TMutex m_Mutex;
    ui32 timelast;
    ui32 treshold_min;
    ui32 treshold_max;
    bool enable;
    time_t last_sec;
    ui32 number;
    TMutex m_MutexNumb;
    TMutex m_atomic_mutex;

    ui32 up_counter;
    ui32 down_counter;
    ui32 middle_counter;

    TMutex m_MutexMailStat;
    TKCounterclass AllRequest;
    TKCounterclass LostAllRequest;
    TKCounterclass UserValue1Request;
    ui64 yesterday_request;
    ui64 lost_yesterday_request;
    ui64 uservalue1_yesterday_request;

    void CalcCPSOld();
    void CalcCPSNew();

    TKAtomic hamcount;
    TKAtomic spamcount;
    TKAtomic maliccount;
    TKAtomic bancount;
    TKAtomic in_count_last;
    TKAtomic lost_count_last;

    TDiffCounter diffallcounter;
    TDiffCounter difflostcounter;

public:
    TTrafficControl();
    ~TTrafficControl();

    void Init(ui32 tresholdMinA, ui32 tresholdMaxA, bool EnableA, bool SrvcDisabledA = false);

    bool Skeep();
    void CalcCPS();
    TString GetStatist();
    TString GetStatistMin();
    TString GetStatistMin2();
    TString GetStatistLog();
    void EnableSkeepRegime(bool enableA);
    bool GetSkeepRegime();
    ui32 GetKoef();
    float GetInMPS();
    float GetRcvMPS();
    ui32 GetMinTreshold();
    ui32 GetMaxTreshold();

    void IncrementUserValue1Request();
    void Midnight();
    ui64 GetTodayRequest();
    ui64 GetTodayLostRequest();
    ui64 GetTodayUserValue1Request();
    ui64 GetYesterdayRequest();
    ui64 GetYesterdayLostRequest();
    ui64 GetYesterdayUserValue1Request();
    TString GetMailStatist();

    ui64 GetNumber();
    ui64 GetNumberProxy();

    TString GetStatistCounter();
    TTrafficCtrlStat GetConsoleStat();

    void IncHamCount();
    void IncSpamCount();
    void IncMalicCount();
    void IncBanCount();
    i64 GetHamCount();
    i64 GetSpamCount();
    i64 GetMalicCount();
    i64 GetBanCount();
    TString GetStatistikToLog();
    TString GetStatistikToLog2();

    ui32 GetDiffAllRequest() {
        return diffallcounter.GetDiff();
    }
    ui32 GetDiffLostRequest() {
        return difflostcounter.GetDiff();
    }
};
