#pragma once

#ifdef _MSC_VER
#include "util/network/socket.h"
#endif

#include <util/system/mutex.h>

#include <contrib/deprecated/udns/udns.h>

#include <errno.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

#include "ipv6.h"
#include "tlogclass.h"

typedef TVector<TString> TMultiStringList;
typedef TMultiStringList::iterator TMultiStringListIt;

struct TUdnsPropData {
    bool m_enable;
    TString m_host;
    int m_port;
    int m_timeout;
    TString m_zone;

    TUdnsPropData() {
        Clear();
    }

    void Clear() {
        m_enable = false;
        m_host = "";
        m_port = 0;
        m_timeout = 0;
        m_zone = "";
    }
};

struct TShortDataUdns {
    TString m_name;
    bool m_ok;
    TMultiStringList m_res;
    ui32 m_tick;

    TShortDataUdns() {
        Clear();
    }

    void Clear() {
        m_name = "";
        m_ok = false;
        m_res.clear();
        m_tick = 0;
    }

    TString ToResultS() {
        TString res = "";
        TMultiStringListIt it;

        it = m_res.begin();
        while (it != m_res.end()) {
            if (!res.empty())
                res = res + ", " + (*it);
            else
                res = res + (*it);

            ++it;
        }

        return res;
    }
};

typedef TVector<TShortDataUdns> TShortDataUdnsList;
typedef TShortDataUdnsList::iterator TShortDataUdnsListIt;

struct TSummDataUdns {
    TUdnsPropData m_prop;
    TShortDataUdns m_data;

    TSummDataUdns() {
        Clear();
    }

    void Clear() {
        m_prop.Clear();
        m_data.Clear();
    }
};

typedef TVector<TSummDataUdns> TSummDataUdnsList;
typedef TSummDataUdnsList::iterator TSummDataUdnsListIt;

struct TUdnsClassInit {
    TUdnsClassInit() { dns_init(nullptr, 0); }
};

class TUdnsClass: public NNonCopyable::TMoveOnly {
public:
    TUdnsClass(const TString& sLbl, TBaseLogClass* logA, ui32 dns_timeoutA)
        : bReady(false)
        , context(nullptr)
    {
        static const TUdnsClassInit init;

        is_spk = true;
        log = logA;
        dns_timeout = dns_timeoutA;
        context = dns_new(nullptr);
        errcode = DNS_E_NOERROR;
        SetLabel(sLbl);
    }

    TUdnsClass(const TString& sLbl = nullptr)
        : bReady(false)
        , errcode(DNS_E_NOERROR)
    {
        static const TUdnsClassInit init;

        is_spk = false;
        log         = NULL;
        dns_timeout = 50;
        context = dns_new(nullptr);
        SetLabel(sLbl);
    }

    ~TUdnsClass() {
        if (context) {
            dns_close(context);
            dns_free(context);
        }
        vResults.clear();
    }

    bool Open(const TString& sSrv = nullptr);
    bool Open(int port, const TString& sSrv = nullptr);

    void SetLabel(const TString& sLbl) {
        if (sLbl.length() > 0)
            sLabel = sLbl;
    }

    bool ResolveHost(const TString& NumbRequest, const char* sHost, TVector<TString>* addrs = nullptr);
    bool ResolveDNSBL(const TString& NumbRequest, const TIpAddr& host, const char* zone, TString& resvalue);
    bool ResolveAddr(const TString& NumbRequest, const TIpAddr& host, TString& resvalue);

    bool ResolveAddr(const TIpAddr& host);

    const char* GetStr() {
        return sStr.c_str();
    }

    bool IsReady() {
        return bReady;
    }

    int Error() {
        return errcode;
    }

    TString GetResult(int i) {
        if (vResults.empty())
            return "";
        return vResults[i];
    }

private:
    volatile bool bReady;
    dns_ctx* context;
    char timeoutstr[16];
    int errcode;
    TString sStr;
    TVector<TString> vResults;
    TMutex udnsMutex;
    TString sLabel;

    bool           is_spk;
    TBaseLogClass* log;
    ui32           dns_timeout;
};


dns_rr_ptr* dns_resolve_ptr(struct dns_ctx* ctx, const TIpAddr& addr);
dns_rr_ptr* dns_resolve_ptr(struct dns_ctx* ctx, const struct in_addr* addr);
dns_rr_ptr* dns_resolve_ptr(struct dns_ctx* ctx, const struct in6_addr* addr);

dns_rr_a4* dns_resolve_dnsbl(struct dns_ctx* ctx, const TIpAddr& addr, const char* dnsbl);
dns_rr_a4* dns_resolve_dnsbl(struct dns_ctx* ctx, const struct in_addr* addr, const char* dnsbl);
dns_rr_a4* dns_resolve_dnsbl(struct dns_ctx* ctx, const struct in6_addr* addr, const char* dnsbl);

dns_rr_txt* dns_resolve_dnsbl_txt(struct dns_ctx* ctx, const TIpAddr& addr, const char* dnsbl);
dns_rr_txt* dns_resolve_dnsbl_txt(struct dns_ctx* ctx, const struct in_addr* addr, const char* dnsbl);
dns_rr_txt* dns_resolve_dnsbl_txt(struct dns_ctx* ctx, const struct in6_addr* addr, const char* dnsbl);
