#pragma once

#include <util/generic/string.h>
#include <util/stream/output.h>

class TUid : public TString {
public:
    const TString& AsString() const noexcept {
        return static_cast<const TString&>(*this);
    }
};

class TLogin : public TString {
public:
    using TString::TString;
    const TString& AsString() const noexcept {
        return static_cast<const TString&>(*this);
    }
};

Y_DECLARE_OUT_SPEC(inline, TLogin, s, v) {
    s.Write(v.data(), v.size());
}

Y_DECLARE_OUT_SPEC(inline, TUid, s, v) {
    s.Write(v.data(), v.size());
}

template<> class THash<TLogin> {
    const THash<TString> hash{};
public:
    size_t operator()(const TLogin& login) const {
        return hash(login);
    }
};
