#pragma once

#ifndef _UNNAMEDSEM_
#define _UNNAMEDSEM_

#include <util/generic/ptr.h>
#include <util/system/defaults.h>
#include <util/datetime/base.h>

class TUnnamedSemaphore {
public:
    TUnnamedSemaphore &operator=(TUnnamedSemaphore&&) noexcept;
    TUnnamedSemaphore(TUnnamedSemaphore&&) noexcept;
    TUnnamedSemaphore(ui32 maxFreeCount);
    ~TUnnamedSemaphore();

    //Increase the semaphore counter.
    //Returns 'true' if the semaphore counter increased
    bool Release();

    //Keep a thread held while the semaphore counter is equal 0.
    bool Acquire();

    //Keep a thread held while the semaphore counter is equal 0 or until 'until'.
    bool TimedAcquire(const TInstant& until);

    //Keep a thread held while the semaphore counter is equal 0 or timeout is exceed.
    bool TimedAcquire(const TDuration& timeout);

    //Try to enter the semaphore gate. A non-blocking variant of Acquire.
    //Returns 'true' if the semaphore counter decreased
    bool TryAcquire();

private:
    class TImpl;
    THolder<TImpl> Impl_;
};

#endif
