#include <library/cpp/testing/unittest/registar.h>

#include "algorithm.h"
#include <util/generic/vector.h>
#include <util/generic/deque.h>
#include <util/generic/list.h>

Y_UNIT_TEST_SUITE(Algorithm) {
    Y_UNIT_TEST(ForEachContainer) {
        const TVector<size_t> v1 = { 1, 3, 5, 7, 11 };
        const TDeque<double> v2 = { 2, 4, 6, 8, 10 };
        const TList<bool> v3 = { false, true, false, true, false };

        size_t value = 0;
        simultaneous_for_each_container_with_check([&value](const auto& v) {
            value += v;
        }, v1);
        UNIT_ASSERT_EQUAL(value, 27);

        double sum = 0;
        simultaneous_for_each_container_with_check([&sum](const auto& l, const auto& m, const auto& r) {
            sum += l + m + (r? 1: 0);
        }, v1, v2, v3);

        UNIT_ASSERT_EQUAL(sum, 59.0);
    }
}

Y_UNIT_TEST_SUITE(SetDifferenceInPlace) {
    Y_UNIT_TEST(NotRemove) {
        TVector<size_t> left = { 1, 3, 5, 7, 11, 13, 17, 19, 23 };
        const TVector<size_t> right = { 2, 4, 6, 8, 10 };

        auto copy = left;
        auto it = set_difference_in_place(left.begin(), left.end(), right.begin(), right.end());
        UNIT_ASSERT_EQUAL(it, left.end());
        UNIT_ASSERT_EQUAL(left, copy);
    }

    Y_UNIT_TEST(Remove) {
        TVector<size_t> left = { 1, 3, 5, 7, 11, 13, 17, 19, 23 };
        const TVector<size_t> right = { 2, 3, 4, 6, 7, 8, 23 };
        const TVector<size_t> result = { 1, 5, 11, 13, 17, 19 };

        set_difference_in_place_container(left, right);
        UNIT_ASSERT_EQUAL(left, result);
    }
}
