#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/env.h>
#include <util/memory/blob.h>
#include <mail/so/spamstop/tools/so-common/so_answer.h>

static TBlob GetFile(const TString &file) {
    return TBlob::FromFile(JoinFsPaths(ArcadiaSourceRoot(), "./mail/so/spamstop/tools/so-common/ut/resources/", file));
}

Y_UNIT_TEST_SUITE(SoAnswer) {
    Y_UNIT_TEST(Made) {
        TCheckedMessage answer1(TSpClass::HAM,
                               TDeque<TUid>{"456", "234"},
                               TDeque<TSuid>{"123", "345"});
        {
            answer1.Report.Hits = 42;
            answer1.ShouldLogForKaspersky = true;

            answer1.SuidsWithPf = {"345", "12"};

            answer1.UidsActivities = {
                {TUid("234"), 2},
                {TUid("23"),  3},
                {TUid("456"), 4},
            };
            answer1.UidsWithPf = {"456", "23"};

            answer1.DenyGreyListing = false;

            answer1.SoClass = {"class1", "class2"};

            answer1.ForeignZone = "RU";

            answer1.MXCode = "BLA";

            answer1.UidsResolutions = {
                    {TUid("456"), TSpClass::SPAM},
                    {TUid("23"), TSpClass::HAM},
            };

            answer1.Reject = 2;
            answer1.RejectStr = "reject str";
        }

        {
            const auto expected = GetFile("answer1.txt");
            const TString madden = TStringBuilder{} << answer1.AsLegacy(true);
            UNIT_ASSERT_VALUES_EQUAL(expected.AsCharPtr(), madden);
        }
        TCheckedMessage answer2(TSpClass::SPAM,
                                TDeque<TUid>{"1"},
                                TDeque<TSuid>{"2"});
        {
            answer2.Report.Hits = 12;
            answer2.ShouldLogForKaspersky = false;

            answer2.SuidsWithPf = {"2"};

            answer2.UidsActivities = {
                    {TUid("1"), 3},
            };
            answer2.UidsWithPf = {"1"};

            answer2.DenyGreyListing = true;

            answer2.SoClass = {"class3", "class4"};

            answer2.ForeignZone = "EN";

            answer2.MXCode = "WHI";

            answer2.UidsResolutions = {};

            answer2.Reject = 3;
            answer2.RejectStr = "another reject str";
        }

        answer1.CombineWith(std::move(answer2));

        {
            const auto expected = GetFile("answer3.txt");
            const TString madden = TStringBuilder{} << answer1.AsLegacy(false);
            UNIT_ASSERT_VALUES_EQUAL(expected.AsCharPtr(), madden);
        }
    }

    Y_UNIT_TEST(PfOverride) {
        TCheckedMessage answer1(TSpClass::HAM,
                               TDeque<TUid>{"456", "234"},
                               TDeque<TSuid>{"123", "345"});
        answer1.UidsWithPf = {"456", "234"};

        // No PFs, this answer resolution will be selected
        TCheckedMessage answer2(TSpClass::SPAM,
                               TDeque<TUid>{"789"},
                               TDeque<TSuid>{"777"});
        answer1.CombineWith(std::move(answer2));

        UNIT_ASSERT_VALUES_EQUAL(TSpClass::SPAM, answer1.spClass);
    }

    Y_UNIT_TEST(PfNoOverride) {
        TCheckedMessage answer1(TSpClass::HAM,
                               TDeque<TUid>{"456", "234"},
                               TDeque<TSuid>{"123", "345"});

        // Has PFs, this answer resolution won't be selected
        TCheckedMessage answer2(TSpClass::SPAM,
                               TDeque<TUid>{"789"},
                               TDeque<TSuid>{"777"});
        answer2.UidsWithPf = {"789"};
        answer1.CombineWith(std::move(answer2));

        UNIT_ASSERT_VALUES_EQUAL(TSpClass::HAM, answer1.spClass);
    }
}