#include <library/cpp/testing/unittest/registar.h>
#include "ares.h"

Y_UNIT_TEST_SUITE(Ares) {
    Y_UNIT_TEST(Main) {
        NAres::TPool pool(TPoolParams(5, TDuration::MilliSeconds(100)));
        NAres::TPoolTraits traits;

        auto result = pool.get(traits)->Resolve("ya.ru");
        UNIT_ASSERT_EQUAL(result.empty(), false);
    }

    Y_UNIT_TEST(Coroutine) {
        NAres::TAres ares;
        TVector<TString> result;
        TContExecutor contExecutor(320000);

        auto functor = [&ares, &result](TCont* cont) {return result = ares.Resolve("ya.ru", TInstant::Max(), cont); };
        contExecutor.Create(functor, "resolve");
        contExecutor.Execute();

        UNIT_ASSERT_EQUAL(result.empty(), false);
    }
}
