//
// Created by luckybug on 14.06.18.
//

#include <library/cpp/testing/unittest/registar.h>
#include <util/stream/file.h>
#include <library/cpp/resource/resource.h>
#include "ArjReader.h"

Y_UNIT_TEST_SUITE(ArjReader) {
    Y_UNIT_TEST(TestGetFilenames) {
        const auto & goodData = NResource::Find("/good_arj");

        NArj::TTraitsList traitsList;
        UNIT_ASSERT(NArj::ReadTraits(goodData.cbegin(), goodData.size(), traitsList));

        UNIT_ASSERT_EQUAL_C(traitsList.size(), 2, traitsList.size());
        UNIT_ASSERT_EQUAL_C(traitsList[0].filename, "rjReader.cpp", traitsList[0].filename);
        UNIT_ASSERT_EQUAL_C(traitsList[1].filename, "rjReader.h", traitsList[1].filename);
    }
    Y_UNIT_TEST(TestWrongFormat) {
        const auto & badData = NResource::Find("/bad_arj");

        NArj::TTraitsList traitsList;
        UNIT_ASSERT(!NArj::ReadTraits(badData.cbegin(), badData.size(), traitsList));

        UNIT_ASSERT(traitsList.empty());
    }
}

