#include <library/cpp/testing/unittest/registar.h>

#include <mail/so/spamstop/tools/so-common/exp_boxes.h>

Y_UNIT_TEST_SUITE(ExpBoxes) {
    Y_UNIT_TEST(Parse) {
        const TExpBoxes expBoxes("261663,0,45;188839,0,-1");

        UNIT_ASSERT_VALUES_EQUAL("261663,0,45;188839,0,-1", expBoxes.RawExpBoxes);

        UNIT_ASSERT_VALUES_EQUAL(2, expBoxes.Experiments.size());

        UNIT_ASSERT_VALUES_EQUAL(261663, expBoxes.Experiments[0].ExperimentId);
        UNIT_ASSERT_VALUES_EQUAL(45, expBoxes.Experiments[0].Bucket);

        UNIT_ASSERT_VALUES_EQUAL(188839, expBoxes.Experiments[1].ExperimentId);
        UNIT_ASSERT_VALUES_EQUAL(-1, expBoxes.Experiments[1].Bucket);
    }
}
