/*
 * kfunc_ut.cpp
 *
 *  Created on: 4 авг. 2017 г.
 *      Author: luckybug
 */

#include <library/cpp/testing/unittest/registar.h>

#include "kfunc.h"

template <typename T>
void testSafeInc() {
    T a = 5;

    Inc(a);
    UNIT_ASSERT_EQUAL(a, 6);

    Inc(a, T(156));
    UNIT_ASSERT_EQUAL(a, 162);

    Dec(a, T(10));
    UNIT_ASSERT_EQUAL_C(a, 152, a);

    a = std::numeric_limits<T>::max() - 100;

    Inc(a);
    UNIT_ASSERT_EQUAL(a, std::numeric_limits<T>::max() - 99);

    Inc(a, T(156));
    UNIT_ASSERT_EQUAL(a, std::numeric_limits<T>::max());

    Dec(a, T(10));
    UNIT_ASSERT_EQUAL_C(a, std::numeric_limits<T>::max() - 10, a);

    a = std::numeric_limits<T>::min() + 100;

    Inc(a);
    UNIT_ASSERT_EQUAL(a, std::numeric_limits<T>::min() + 101);

    Dec(a, T(156));
    UNIT_ASSERT_EQUAL(a, std::numeric_limits<T>::min());

    Inc(a, T(10));
    UNIT_ASSERT_EQUAL_C(a, std::numeric_limits<T>::min() + 10, a);
}

Y_UNIT_TEST_SUITE(KFUNC) {
    Y_UNIT_TEST(TestSafeIncDec) {
        testSafeInc<ui8>();
        testSafeInc<ui16>();
        testSafeInc<ui32>();
        testSafeInc<ui64>();
    }


    Y_UNIT_TEST(TestTrim) {
        UNIT_ASSERT_EQUAL(Trim(""), "");
        UNIT_ASSERT_EQUAL_C(Trim("test test\t\r"), "test test", Trim("test test"));
        UNIT_ASSERT_EQUAL(Trim("   test  test              "), "test  test");
        UNIT_ASSERT_EQUAL(Trim(" test test "), "test test");
        UNIT_ASSERT_EQUAL(Trim(" "), "");
        UNIT_ASSERT_EQUAL(Trim("                  "), "");
    }
}
