//
// Created by luckybug on 14.06.18.
//

#include "local_cache_template.h"
#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/vector.h>
#include <util/generic/buffer.h>
#include <util/stream/buffer.h>

Y_UNIT_TEST_SUITE(LocalCacheTemplate) {
    using TCache = NCache::TCacheBase<size_t, TString>;


    Y_UNIT_TEST(TestGetSet) {
        TCache cache;

        cache.Add(42, "test");

        UNIT_ASSERT_EQUAL(cache.Exist(42), true);
        UNIT_ASSERT_EQUAL(cache.Exist(43), false);
        UNIT_ASSERT_EQUAL(cache.Size(), 1);

        cache.Add(43, "test1");

        UNIT_ASSERT_EQUAL(cache.Exist(42), true);
        UNIT_ASSERT_EQUAL(cache.Exist(43), true);
        UNIT_ASSERT_EQUAL(cache.Size(), 2);

        TString val;

        cache.Get(42, val);
        UNIT_ASSERT_EQUAL(val, "test");

        cache.Get(43, val);
        UNIT_ASSERT_EQUAL(val, "test1");

        cache.Remove(43);

        UNIT_ASSERT_EQUAL(cache.Exist(42), true);
        UNIT_ASSERT_EQUAL(cache.Exist(43), false);
        UNIT_ASSERT_EQUAL(cache.Size(), 1);

    }

    Y_UNIT_TEST(TestSteps) {
        TCache cache;

        cache.Add(42, "test");
        UNIT_ASSERT_EQUAL(cache.Exist(42), true);
        UNIT_ASSERT_EQUAL(cache.Exist(43), false);
        UNIT_ASSERT_EQUAL(cache.Size(), 1);

        cache.Cleanup();
        cache.Add(43, "test1");
        UNIT_ASSERT_EQUAL(cache.Exist(42), true);
        UNIT_ASSERT_EQUAL(cache.Exist(43), true);
        UNIT_ASSERT_EQUAL(cache.Size(), 2);

        cache.Cleanup();
        UNIT_ASSERT_EQUAL(cache.Exist(42), false);
        UNIT_ASSERT_EQUAL(cache.Exist(43), true);
        UNIT_ASSERT_EQUAL(cache.Size(), 1);

        cache.Cleanup();
        UNIT_ASSERT_EQUAL(cache.Exist(42), false);
        UNIT_ASSERT_EQUAL(cache.Exist(43), false);
        UNIT_ASSERT_EQUAL(cache.Size(), 0);
    }

    Y_UNIT_TEST(TestSaveLoad) {
        TCache cache;
        cache.Add(42, "test");

        TBuffer buffer;
        {
            TBufferOutput output(buffer);
            ::Save(&output, cache);
        }

        TCache load;
        {
            TBufferInput input(buffer);
            ::Load(&input, load);
        }

        UNIT_ASSERT_EQUAL(cache, load);
        load.Cleanup();

        UNIT_ASSERT_UNEQUAL(cache, load);
    }

    Y_UNIT_TEST(TestExpired) {
        TCache cache(NCache::TConfig().SetDuration(TDuration::MilliSeconds(200)));
        cache.Add(42, "test");

        Sleep(TDuration::MilliSeconds(50));
        UNIT_ASSERT_EQUAL(cache.Expired(), false);
        cache.EventTick();
        UNIT_ASSERT_EQUAL(cache.Exist(42), true);


        Sleep(TDuration::MilliSeconds(100));
        UNIT_ASSERT_EQUAL(cache.Expired(), true);
        cache.EventTick();
        UNIT_ASSERT_EQUAL(cache.Exist(42), true);


        Sleep(TDuration::MilliSeconds(300));
        UNIT_ASSERT_EQUAL(cache.Expired(), true);
        cache.EventTick();
        UNIT_ASSERT_EQUAL(cache.Exist(42), false);
    }
}

