#include <library/cpp/testing/unittest/registar.h>
#include <mail/so/spamstop/tools/so-common/multicounter.h>
#include <util/string/join.h>

Y_UNIT_TEST_SUITE(TestMultiCounter) {

    Y_UNIT_TEST(Main) {
        TMultiCounter multiCounter(TVector<size_t>{1, 2, 0, 4});

        TVector<size_t> expected;
        expected = TVector<size_t>{0,0,0,0};
        UNIT_ASSERT_VALUES_EQUAL(expected, multiCounter.GetCounters());

        UNIT_ASSERT(multiCounter.Next());
        expected = TVector<size_t>{0,1,0,0};
        UNIT_ASSERT_VALUES_EQUAL(expected, multiCounter.GetCounters());

        UNIT_ASSERT(multiCounter.Next());
        expected = TVector<size_t>{0,0,0,1};
        UNIT_ASSERT_VALUES_EQUAL(expected, multiCounter.GetCounters());

        UNIT_ASSERT(multiCounter.Next());
        expected = TVector<size_t>{0,1,0,1};
        UNIT_ASSERT_VALUES_EQUAL(expected, multiCounter.GetCounters());

        UNIT_ASSERT(multiCounter.Next());
        expected = TVector<size_t>{0,0,0,2};
        UNIT_ASSERT_VALUES_EQUAL(expected, multiCounter.GetCounters());

        UNIT_ASSERT(multiCounter.Next());
        expected = TVector<size_t>{0,1,0,2};
        UNIT_ASSERT_VALUES_EQUAL(expected, multiCounter.GetCounters());

        UNIT_ASSERT(multiCounter.Next());
        expected = TVector<size_t>{0,0,0,3};
        UNIT_ASSERT_VALUES_EQUAL(expected, multiCounter.GetCounters());

        UNIT_ASSERT(multiCounter.Next());
        expected = TVector<size_t>{0,1,0,3};
        UNIT_ASSERT_VALUES_EQUAL(expected, multiCounter.GetCounters());

        UNIT_ASSERT(!multiCounter.Next());
    }
    Y_UNIT_TEST(ZeroSize) {
        TMultiCounter multiCounter(TVector<size_t>{});

        TVector<size_t> expected;
        UNIT_ASSERT_VALUES_EQUAL(expected, multiCounter.GetCounters());
        UNIT_ASSERT(!multiCounter.Next());
        UNIT_ASSERT_VALUES_EQUAL(expected, multiCounter.GetCounters());
    }

    Y_UNIT_TEST(SingleSize) {
        TMultiCounter multiCounter(TVector<size_t>{1, 1});

        TVector<size_t> expected{0, 0};
        UNIT_ASSERT_VALUES_EQUAL(expected, multiCounter.GetCounters());
        UNIT_ASSERT(!multiCounter.Next());
        UNIT_ASSERT_VALUES_EQUAL(expected, multiCounter.GetCounters());
    }
}
