#include <library/cpp/testing/unittest/registar.h>
#include <util/charset/wide.h>

#include "parsers.h"


Y_UNIT_TEST_SUITE(TSOParsersTest) {

    Y_UNIT_TEST(SelfSentDetection) {
        TString sMfrm1("turagal@yandex.ru id=901787877 country=ru karma=0 karma_status=0 uid=365721478 borndate=1456314808");
        TString sRcpt1("anton.volkov@investgt.com id=1130000031987637 uid=1130000014784036 country=ru");

        TString sMfrm2("testmailssco@masterdm.ru id=1130000030527587 country=ru karma=0 karma_status=0 uid=1130000013327728 borndate=1410345237");
        TString sRcpt2("testmailssco@masterdm.ru id=1130000030527587 uid=1130000013327728 country=ru");

        TString sMfrm3("report@weblinkservice.ru id=1130000037487138 country=ru karma=0 karma_status=0 uid=1130000020283487 borndate=1455744152");
        TString sRcpt3("k.minakova@weblinkservice.ru id=1130000037245727 uid=1130000020042057 country=ru");

        TString sMfrm4("alerter@4geo.ru id=1130000039795394 country=ru karma=0 karma_status=0 uid=1130000022592128 borndate=1481871109");
        TString sRcpt4("supportas@4geo.ru id=1130000030135794 uid=1130000012935818 country=ru;marketing@4geo.ru id=1130000008998015 uid=1130000003264785 country=ru");

        bool bSelfSent = false;
        bool bSameDomain = false;

        CheckForSelfSentMessage(sMfrm1, sRcpt1, &bSelfSent, &bSameDomain);
        UNIT_ASSERT_EQUAL(bSelfSent, false);
        UNIT_ASSERT_EQUAL(bSameDomain, false);

        CheckForSelfSentMessage(sMfrm2, sRcpt2, &bSelfSent, &bSameDomain);
        UNIT_ASSERT_EQUAL(bSelfSent, true);
        UNIT_ASSERT_EQUAL(bSameDomain, true);

        CheckForSelfSentMessage(sMfrm3, sRcpt3, &bSelfSent, &bSameDomain);
        UNIT_ASSERT_EQUAL(bSelfSent, false);
        UNIT_ASSERT_EQUAL(bSameDomain, true);

        CheckForSelfSentMessage(sMfrm4, sRcpt4, &bSelfSent, &bSameDomain);
        UNIT_ASSERT_EQUAL(bSelfSent, false);
        UNIT_ASSERT_EQUAL(bSameDomain, true);
    }

    Y_UNIT_TEST(TextSplitter) {
        TVector<TTextSplitter::TSplitResult> splitResults;

        const char text[] = "justword  wordwith1num \n    1wordwith2nums wordwithкириллица. wordw-ith+notalnum";

        for (TTextSplitter it(text, strlen(text), 200); it.FindNextWord();) {
            const TTextSplitter::TSplitResult& splitResult = it.Get();
            splitResults.push_back(splitResult);
        }

        UNIT_ASSERT_EQUAL(splitResults.size(), 7);

        UNIT_ASSERT_EQUAL(splitResults[0].word, u"justword");
        UNIT_ASSERT_EQUAL(splitResults[0].has_cyrillic, false);
        UNIT_ASSERT_EQUAL(splitResults[0].has_latin, true);
        UNIT_ASSERT_EQUAL(splitResults[0].has_digit, false);
        UNIT_ASSERT_EQUAL(splitResults[0].has_2_or_more_digits, false);

        UNIT_ASSERT_EQUAL(splitResults[1].word, u"wordwith1num");
        UNIT_ASSERT_EQUAL(splitResults[1].has_cyrillic, false);
        UNIT_ASSERT_EQUAL(splitResults[1].has_latin, true);
        UNIT_ASSERT_EQUAL(splitResults[1].has_digit, true);
        UNIT_ASSERT_EQUAL(splitResults[1].has_2_or_more_digits, false);

        UNIT_ASSERT_EQUAL(splitResults[2].word, u"1wordwith2nums");
        UNIT_ASSERT_EQUAL(splitResults[2].has_cyrillic, false);
        UNIT_ASSERT_EQUAL(splitResults[2].has_latin, true);
        UNIT_ASSERT_EQUAL(splitResults[2].has_digit, true);
        UNIT_ASSERT_EQUAL(splitResults[2].has_2_or_more_digits, true);

        UNIT_ASSERT_EQUAL(splitResults[3].word, u"wordwithкириллица");
        UNIT_ASSERT_EQUAL(splitResults[3].has_cyrillic, true);
        UNIT_ASSERT_EQUAL(splitResults[3].has_latin, true);
        UNIT_ASSERT_EQUAL(splitResults[3].has_digit, false);
        UNIT_ASSERT_EQUAL(splitResults[3].has_2_or_more_digits, false);

        UNIT_ASSERT_EQUAL(splitResults[4].word, u"wordw");
        UNIT_ASSERT_EQUAL(splitResults[4].has_cyrillic, false);
        UNIT_ASSERT_EQUAL(splitResults[4].has_latin, true);
        UNIT_ASSERT_EQUAL(splitResults[4].has_digit, false);
        UNIT_ASSERT_EQUAL(splitResults[4].has_2_or_more_digits, false);

        UNIT_ASSERT_EQUAL(splitResults[5].word, u"ith");
        UNIT_ASSERT_EQUAL(splitResults[5].has_cyrillic, false);
        UNIT_ASSERT_EQUAL(splitResults[5].has_latin, true);
        UNIT_ASSERT_EQUAL(splitResults[5].has_digit, false);
        UNIT_ASSERT_EQUAL(splitResults[5].has_2_or_more_digits, false);

        UNIT_ASSERT_EQUAL(splitResults[6].word, u"notalnum");
        UNIT_ASSERT_EQUAL(splitResults[6].has_cyrillic, false);
        UNIT_ASSERT_EQUAL(splitResults[6].has_latin, true);
        UNIT_ASSERT_EQUAL(splitResults[6].has_digit, false);
        UNIT_ASSERT_EQUAL(splitResults[6].has_2_or_more_digits, false);
    }
    Y_UNIT_TEST(Parseout) {
        const TStringBuf src = "asd=wer  asd &wefg=38 agar a{}";
        UNIT_ASSERT_EQUAL(Parseout(src, "&asd=", " "), "wer");
        UNIT_ASSERT_EQUAL(Parseout(src, "asd=", " "), "wer");
        UNIT_ASSERT_EQUAL(Parseout(src, "wefg=", " "), "38");
        UNIT_ASSERT_EQUAL(Parseout(src, "&wefg=", " "), "38");
        UNIT_ASSERT_EQUAL(Parseout(src, "agar", "{"), " a");
        UNIT_ASSERT_EQUAL(Parseout(src, "not exists", "{"), "");
    }
    Y_UNIT_TEST(From) {
        {
            const TFrom f("Lomanov Vasiliy <luckybug@yandex-team.ru>");
            UNIT_ASSERT_VALUES_EQUAL(f.GetAddr(), "luckybug@yandex-team.ru");
            UNIT_ASSERT_VALUES_EQUAL(f.GetName(), "Lomanov Vasiliy");
        }
        {
            const TFrom f(" luckybug+tag@yandex-team.ru>");
            UNIT_ASSERT_VALUES_EQUAL(f.GetAddr(), "luckybug@yandex-team.ru");
            UNIT_ASSERT_VALUES_EQUAL(f.GetName(), "");
        }
    }
    Y_UNIT_TEST(FixAddressTest) {
        UNIT_ASSERT_VALUES_EQUAL("kresdein@yandex.com", FixAddress("kresdei @n+42@yandex.com"));
    }
};

