//
// Created by luckybug on 14.06.18.
//

#include "local_cache_template.h"
#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/vector.h>
#include <util/generic/buffer.h>
#include <util/stream/buffer.h>

Y_UNIT_TEST_SUITE(ShardedItems) {
    Y_UNIT_TEST(TestGetSet) {
        TShardedItems<size_t> shardedItems(123);

        UNIT_ASSERT_EQUAL_C(shardedItems.Size(), 123, shardedItems.Size() << " vs 123");

        for(size_t i = 0; i < shardedItems.Size(); i++)
            shardedItems.getShard(i) = i*i;

        for(size_t i = 0; i < 1000000; i++) {
            const auto q = i % 123;
            UNIT_ASSERT_EQUAL_C(shardedItems.getShard(i), q*q, i << " vs " << q*q);
        }
    }
    Y_UNIT_TEST(TestSaveLoad) {
        TShardedItems<size_t> shardedItems(123);
        for(size_t i = 0; i < shardedItems.Size(); i++)
            shardedItems.getShard(i) = i*i;

        TBuffer buffer;
        {
            TBufferOutput output(buffer);
            ::Save(&output, shardedItems);
        }

        TShardedItems<size_t> load;
        {
            TBufferInput input(buffer);
            ::Load(&input, load);
        }
        UNIT_ASSERT_EQUAL(shardedItems, load);
    }
}

