/*
 * sobase64_ut.cpp
 *
 *  Created on: 20 сент. 2016 г.
 *      Author: luckybug
 */

#include <library/cpp/testing/unittest/registar.h>

#include "sobase64.h"
#include <util/generic/buffer.h>
#include <util/stream/buffer.h>

#include <cstdlib>
#include <ctime>
#include <util/ysaveload.h>

/*
 * just copy-paste it for good start point
 */

Y_UNIT_TEST_SUITE(TestSoBase64) {
    Y_UNIT_TEST(TestCompress) {
        TString src("some text");

        TVector<ui8> compressed;
        TString decompressed, err;
        {
            UNIT_ASSERT_EQUAL(LzoCompress(src.c_str(), src.size(), compressed, err), true);
        }

        {
            UNIT_ASSERT_EQUAL_C(LzoUncompress(compressed.data(), compressed.size(), decompressed, err), true, err << ' ' << compressed.size() << ' ' << Endl);
        }

        UNIT_ASSERT_EQUAL_C(src, decompressed, src << " vs " << decompressed);
    }

    Y_UNIT_TEST(TestCompressAndBase64) {
        TString src("some text");

        TString compressed, decompressed, err;
        bool sizeWarning = false;
        {
            UNIT_ASSERT_EQUAL(CompressAndBase64(src.c_str(), src.size(), compressed, err), true);
        }

        {
            UNIT_ASSERT_EQUAL(Unbase64AndUncompress(compressed.c_str(), compressed.size(), sizeWarning, decompressed, err), true);
            UNIT_ASSERT_EQUAL(sizeWarning, false);
        }

        UNIT_ASSERT_EQUAL_C(src, decompressed, src << " vs " << decompressed);
    }
}
