#include <library/cpp/testing/unittest/registar.h>
#include "sputil.h"


Y_UNIT_TEST_SUITE(Sputil) {

    Y_UNIT_TEST(RemoveForbiddenCharsTest) {
        {
            const TString s = "test";
            TStringStream res;

            res << TRemoveForbiddenChars(s);

            UNIT_ASSERT_EQUAL_C(s, res.Str(), res.Str() << " vs " << s);
        }
        {
            const TString s = "-t()((()(est---()()(()";
            TStringStream res;

            res << TRemoveForbiddenChars(s);

            UNIT_ASSERT_EQUAL("test", res.Str());
        }
        {
            const TString s;
            TStringStream res;

            res << TRemoveForbiddenChars(s);

            UNIT_ASSERT(res.empty());
        }
    }
}
