#include <library/cpp/testing/unittest/registar.h>
#include "stats_consumer.h"

Y_UNIT_TEST_SUITE(StatsConsumer) {
    Y_UNIT_TEST(Main) {
        TStatsConsumer consumer;
        {
            TStatsConsumerLock one(consumer, "one");
            with_lock(one) {
                TStatsConsumerLock two(consumer, "two");
                with_lock(two) {}
            }
        }

        const auto now = Now();

        consumer.JustCleanUp(now - TDuration::Seconds(5));
        auto data = consumer.GetLastsAndCleanUp(now - TDuration::Seconds(5));

        UNIT_ASSERT_EQUAL(data.size(), 2);
        UNIT_ASSERT_EQUAL(data[0].name, "two");
        UNIT_ASSERT_EQUAL(data[1].name, "one");
    }
}

