LIBRARY(so-common)

OWNER(g:so)

SRCS(
    shtime.cpp
    ares.cpp
    tag_sets.cpp
    phone_parser.cpp
    urlparser.cpp
    tkinifile.cpp
    tkconfig.cpp
    tlogclass.cpp
    tkipv6.cpp
    tkipv6classes.cpp
    unnamedsem.cpp
    anyvalue.cpp
    tnetipv6.cpp
    tprocidentclass.cpp
    tudnsclass.cpp
    get_zone_time.cpp
    trblhostclass.cpp
    tpddclientobj.cpp
    parsers.cpp
    prof.cpp
    tstoragerequeststat.cpp
    AnyValue_v2.cpp
    ArjReader.cpp
    ipv6.cpp
    kfunc.cpp
    tkcounterclass.cpp
    ttrafficcontrol.cpp
    sobase64.cpp
    sputil.cpp
    so_log.cpp
    thashipv6.cpp
    tbasestoragetypes.cpp
    tparsedlvlog_data.cpp
    tpoolhttpclients.cpp
    tresolvcache.cpp
    tspamstatclient.cpp
    ttraccert_stat.cpp
    algorithm.h
    tlogsgroupbase.cpp
    stats_consumer.cpp
    safe_recode.cpp
    receipt.cpp
    shconn.cpp
    multicounter.cpp
    so_answer.cpp
    exp_boxes.cpp
)

IF (WIN32)
    SRCS(
        find_files.cpp
    )
ENDIF(WIN32)

IF (NOT CORP_SO)
    SRCS(
        tphoneparser.cpp
    )
ENDIF(NOT CORP_SO)

PEERDIR(
    contrib/deprecated/udns
    contrib/libs/c-ares
    contrib/libs/fcgi
    contrib/libs/lzo2
    contrib/libs/re2
    library/cpp/cgiparam
    library/cpp/charset
    library/cpp/coroutine/engine
    library/cpp/json
    library/cpp/langs
    library/cpp/logger
    library/cpp/string_utils/base64
    library/cpp/string_utils/quote
    library/cpp/threading/queue
    library/cpp/config
    mail/so/libs/curl
    mail/so/libs/scheduler
    mail/so/libs/pool
    mail/so/libs/tld
    mail/so/libs/primitives
    mail/so/libs/syslog
    mail/so/api
    library/cpp/protobuf/json
    library/cpp/uri
    library/cpp/deprecated/atomic
)

SET_APPEND(
    CFLAGS
    -DENV_UNIX
    -D_REENTRANT
    -D_7ZIP_LARGE_PAGES
    -DUNICODE
    -D_UNICODE
    -D_FILE_OFFSET_BITS=64
    -D_LARGEFILE_SOURCE
    -DENV_HAVE_LSTAT
    -DVERSION_TAG
)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(AnyValue_v2.h)

GENERATE_ENUM_SERIALIZATION_WITH_HEADER(so_class.h)

END()
