#pragma once

#include "hist.h"
#include <library/cpp/json/json_writer.h>
#include <util/string/builder.h>

using TNamedTimeHist = THashMap<TString, THist<TDuration>>;

inline void ToJson(const TNamedTimeHist& hist, NJsonWriter::TBuf& jsonWriter) {
    for(const auto& [name, hist]: hist) {
        TDuration lastLevel{};

        jsonWriter.BeginList();
        jsonWriter.WriteString(TStringBuilder{} << name << "_ahhh");

        jsonWriter.BeginList();
        for(const auto& bin: hist.GetBins()) {
            jsonWriter.BeginList();
            jsonWriter.WriteULongLong(lastLevel.MilliSeconds());
            jsonWriter.WriteULongLong(bin.count);
            jsonWriter.EndList();

            lastLevel = bin.val;
        }
        {
            jsonWriter.BeginList();
            jsonWriter.WriteULongLong(lastLevel.MilliSeconds());
            jsonWriter.WriteULongLong(hist.GetMore());
            jsonWriter.EndList();
        }
        jsonWriter.EndList();
        jsonWriter.EndList();
    }

    for(const auto& [name, hist]: hist) {
        for(const auto bin: hist.GetBins()) {
            if(bin.count == 0)
                continue;
            jsonWriter.BeginList();
            jsonWriter.WriteString(TStringBuilder{} << name << '_' << bin.val.MilliSeconds() << "_ammm");
            jsonWriter.WriteULongLong(bin.count);
            jsonWriter.EndList();
        }

        if(hist.GetMore() != 0) {
            jsonWriter.BeginList();
            jsonWriter.WriteString(TStringBuilder{} << name << "_more_ammm");
            jsonWriter.WriteULongLong(hist.GetMore());
            jsonWriter.EndList();
        }

        if(hist.GetTotal() != 0) {
            jsonWriter.BeginList();
            jsonWriter.WriteString(TStringBuilder{} << name << "_total_ammm");
            jsonWriter.WriteULongLong(hist.GetTotal());
            jsonWriter.EndList();
        }


    }
}



