#include "baniplist.h"
#include "tstatipobject.h"

#ifndef _win_
#include <unistd.h>
#include <sys/syscall.h>
#endif

//**************************************************************************************
//                                  TBanQueue
//**************************************************************************************

TBanQueue::TBanQueue(TLogsGroup *LogsGroupA, const TString &ident)
{
   m_today_in_count       = 0;
   m_today_out_count      = 0;
   m_today_lost_count     = 0;
   m_yesterday_in_count   = 0;
   m_yesterday_out_count  = 0;
   m_yesterday_lost_count = 0;
   LogsGroup              = LogsGroupA;
   m_ident                = ident;
   m_cps                  = 0;
   m_request              = 0;
   m_last_calc_cps        = time(NULL);
}

TBanQueue::~TBanQueue()
{
   TBanQueueListIt   it;

   it = blist.begin();
   while (it != blist.end())
   {
      if ((*it) != NULL)
      {
         delete (*it);
         (*it) = NULL;
      }

      ++it;
   }
   blist.clear();

}

void TBanQueue::Lock()
{
   m_Mutex.Acquire();
}

void TBanQueue::UnLock()
{
   m_Mutex.Release();
}

void TBanQueue::CalcCPS()
{
   time_t currenttime = time(NULL);
   if ((currenttime - m_last_calc_cps) >= 10)
   {
      m_cps = (float)m_request / (float)(currenttime - m_last_calc_cps);
      m_last_calc_cps = currenttime;
      m_request = 0;
   } else
   {
      m_request = (m_request < 0xFFFFFFFF) ? (m_request + 1) : 0xFFFFFFFF;
   }
}

void TBanQueue::ReCalcCPS()
{
   time_t currenttime = time(NULL);
   if ((currenttime - m_last_calc_cps) >= 10)
   {
      m_cps = (float)m_request / (float)(currenttime - m_last_calc_cps);
      m_last_calc_cps = currenttime;
      m_request = 0;
   }
}

void TBanQueue::Add(TQueueRecord *value)
{
   if (value != NULL)
   {
      bool   lost        = false;

      Lock();

      CalcCPS();

      m_today_in_count = (m_today_in_count < 0xFFFFFFFFFFFFFFFF) ? (m_today_in_count + 1) : 0xFFFFFFFFFFFFFFFF;

      if (blist.size() < MAX_ELEMENT_COUNT)
         blist.push_back(value);
      else
      {
         lost = true;
         m_today_lost_count = (m_today_lost_count < 0xFFFFFFFFFFFFFFFF) ? (m_today_lost_count + 1) : 0xFFFFFFFFFFFFFFFF;
      }

      UnLock();

      if ( (lost) && (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
      {
         LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Cant's add ip (%s) to queue, queue is full.", m_ident.c_str(), value->ip.toStroka().c_str());
      }
   }
}

TQueueRecord *TBanQueue::Get()
{
   TQueueRecord      *res = NULL;
   TBanQueueListIt   it;

   Lock();

   it = blist.begin();
   if (it != blist.end())
   {
      res = (*it);
      blist.erase(it);
      m_today_out_count = (m_today_out_count < 0xFFFFFFFFFFFFFFFF) ? (m_today_out_count + 1) : 0xFFFFFFFFFFFFFFFF;
   } else
   {
      ReCalcCPS();
   }

   UnLock();

   return res;
}

void TBanQueue::Midnight()
{
   Lock();

   m_yesterday_in_count   = m_today_in_count;
   m_yesterday_out_count  = m_today_out_count;
   m_yesterday_lost_count = m_today_lost_count;
   m_today_in_count       = 0;
   m_today_out_count      = 0;
   m_today_lost_count     = 0;

   UnLock();
}

TBanQueueStat TBanQueue::GetStat()
{
   TBanQueueStat res;

   res.m_today_count          = blist.size();
   res.m_today_in_count       = m_today_in_count;
   res.m_today_out_count      = m_today_out_count;
   res.m_today_lost_count     = m_today_lost_count;
   res.m_yesterday_in_count   = m_yesterday_in_count;
   res.m_yesterday_out_count  = m_yesterday_out_count;
   res.m_yesterday_lost_count = m_yesterday_lost_count;
   res.m_cps                  = m_cps;

   return res;
}

//**************************************************************************************
//                                  TSaveBan
//**************************************************************************************

TSaveBanNew::TSaveBanNew(TString m_identA, TString bantextfileA, TString banindexfileA, bool CloseFileA, TLogsGroup *LogsGroupA, TString &bandaylistfileA, TString &bandaylistfile_dA)
{
   m_ident                  = m_identA;
   bantextfile              = bantextfileA;
   banindexfile             = banindexfileA;
   bandaylistfile           = bandaylistfileA;
   bandaylistfile_d         = bandaylistfile_dA;
   hindex                   = NULL;
   htext                    = NULL;
   hdaylist                 = NULL;
   hdaylist_d               = NULL;
   CloseFile                = CloseFileA;
   LogsGroup                = LogsGroupA;
   m_lostlockrecord_idx     = 0;
   m_lostlockrecord_txt     = 0;
   m_lostlockrecord_daylist = 0;
   m_lostlockrecord_daylistd = 0;
   m_lock                   = false;
   writeerror.Clear();
   writeerror_out.Clear();
   writeerror.last_calc_error_info = time(NULL);
}

TSaveBanNew::~TSaveBanNew()
{
   DELETE_FP(hindex);
   DELETE_FP(htext);
   DELETE_FP(hdaylist);
   DELETE_FP(hdaylist_d);
}

void TSaveBanNew::Lock()
{
   m_Mutex.Acquire();
}

void TSaveBanNew::UnLock()
{
   m_Mutex.Release();
}

int TSaveBanNew::WriteIdxA(void *buf, size_t size, size_t count)
{
   int res = 0;

   WriteLastWriteMoment();
   if ((hindex == NULL) && (!banindexfile.empty()))
         hindex = fopen(banindexfile.c_str(), "a+b");
   if (hindex != NULL)
   {
      res = fwrite(buf, size, count, hindex);
      if (res != count)
      {
         WriteErrorIdx();
         if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not save %s", m_ident.c_str(), banindexfile.c_str());
      } else
      {
         fflush(hindex);
      }

   } else
   {
      WriteErrorIdx();

      if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
         LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not save %s", m_ident.c_str(), banindexfile.c_str());
   }

   if ( (CloseFile) && (hindex != NULL) )
   {
      fclose(hindex);
      hindex = NULL;
   }

   return res;
}

int TSaveBanNew::WriteTxtA(void *buf, size_t size, size_t count)
{
   int res = 0;

   WriteLastWriteMoment();
   if ((htext == NULL) && (!bantextfile.empty()))
      htext = fopen(bantextfile.c_str(), "a+b");
   if (htext != NULL)
   {
      res = fwrite(buf, size, count, htext);
      if (res != count)
      {
         WriteErrorTxt();
         if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not save %s", m_ident.c_str(), bantextfile.c_str());
      } else
      {
         fflush(htext);
      }

   } else
   {
      WriteErrorTxt();
      if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
         LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not save %s", m_ident.c_str(), bantextfile.c_str());
   }

   if ( (CloseFile) && (htext != NULL) )
   {
      fclose(htext);
      htext = NULL;
   }

   return res;
}

int TSaveBanNew::WriteDayListA(const void *buf, size_t size, size_t count)
{
   int res = 0;

   WriteLastWriteMoment();
   if ((hdaylist == NULL) && (!bandaylistfile.empty()))
      hdaylist = fopen(bandaylistfile.c_str(), "a+b");
   if (hdaylist != NULL)
   {
      res = fwrite(buf, size, count, hdaylist);
      if (res != count)
      {
         WriteErrorTxt();
         if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not save %s", m_ident.c_str(), bandaylistfile.c_str());
      } else
      {
         fflush(hdaylist);
      }

   } else
   {
      WriteErrorTxt();
      if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
         LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not save %s", m_ident.c_str(), bandaylistfile.c_str());
   }

   if ( (CloseFile) && (hdaylist != NULL) )
   {
      fclose(hdaylist);
      hdaylist = NULL;
   }

   return res;
}

int TSaveBanNew::WriteDayListDA(const void *buf, size_t size, size_t count)
{
   int    res = 0;
   TString newfilename = "";

   newfilename = bandaylistfile_d;
   WriteLastWriteMoment();
   if ((hdaylist_d == NULL) && (!newfilename.empty()))
      hdaylist_d = fopen(newfilename.c_str(), "a+b");
   if (hdaylist_d != NULL)
   {
      res = fwrite(buf, size, count, hdaylist_d);
      if (res != count)
      {
         WriteErrorTxt();
         if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not save %s", m_ident.c_str(), newfilename.c_str());
      } else
      {
         fflush(hdaylist_d);
      }

   } else
   {
      WriteErrorTxt();
      if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
         LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not save %s", m_ident.c_str(), newfilename.c_str());
   }

   if ( (CloseFile) && (hdaylist_d != NULL) )
   {
      fclose(hdaylist_d);
      hdaylist_d = NULL;
   }

   return res;
}

int TSaveBanNew::WriteTxt(const TString &ips)
{
   int res = 0;

   Lock();

   if (m_lock) //lock basa
   {
      if (locklist.size() < MAX_SIZE_LOCK_LIST)
      {
         locklist.push_back(TDataForWrite(KTXT, (void *)ips.c_str(), ips.length(), 1));

      } else
      {
         if (m_lostlockrecord_txt < 0xFFFFFFFF)
            m_lostlockrecord_txt++;
      }

   } else
   {
      res = WriteTxtA((void *)ips.c_str(), ips.length(), 1);
   }

   UnLock();

   return res;
}

int TSaveBanNew::WriteIdx(TBanIpBasic *value)
{
   int res = 0;

   Lock();

   if (m_lock) //lock basa
   {
      if (locklist.size() < MAX_SIZE_LOCK_LIST)
      {
         locklist.push_back(TDataForWrite(KIDX, (void *)value, sizeof(TBanIpBasic), 1));
      } else
      {
         if (m_lostlockrecord_idx < 0xFFFFFFFF)
            m_lostlockrecord_idx++;
      }

   } else
   {
      res = WriteIdxA((void *)value, sizeof(TBanIpBasic), 1);
   }

   UnLock();
   return res;
}

int TSaveBanNew::WriteDayList(const TString &ips)
{
   int res = 0;

   Lock();

   if (m_lock) //lock basa
   {
      if (locklist.size() < MAX_SIZE_LOCK_LIST)
      {
         locklist.push_back(TDataForWrite(KDAYLIST, (void *)ips.c_str(), ips.length(), 1));
      } else
      {
         if (m_lostlockrecord_daylist < 0xFFFFFFFF)
            m_lostlockrecord_daylist++;
      }

   } else
   {
      res = WriteDayListA((void *)ips.c_str(), ips.length(), 1);
   }

   UnLock();

   return res;
}

int TSaveBanNew::WriteDayListD(TBanIpBasic *value)
{
   int      res   = 0;
   TKIPv6   ip    = TKIPv6();

#ifdef ENABLE_WRITE_IDX_FILES

   if (value != NULL)
   {
      ip = value->ip;

      Lock();

      if (m_lock) //lock basa
      {
         if (locklist.size() < MAX_SIZE_LOCK_LIST)
         {
            locklist.push_back(TDataForWrite(KDAYLISTD, (void *)&ip, sizeof(TKIPv6), 1));

         } else
         {
            if (m_lostlockrecord_daylistd < 0xFFFFFFFF)
               m_lostlockrecord_daylistd++;
         }

      } else
      {
         res = WriteDayListDA((void *)&ip, sizeof(TKIPv6), 1);
      }

      UnLock();
   }

#endif //ENABLE_WRITE_IDX_FILES

   return res;
}

void TSaveBanNew::WriteLastWriteMoment()
{
   m_MutexErrorWrite.Acquire();

   writeerror.last_write_moment = time(NULL);

   m_MutexErrorWrite.Release();
}

void TSaveBanNew::WriteErrorIdx()
{
   m_MutexErrorWrite.Acquire();

   if (writeerror.error_write_idx < 0xFFFFFFFF)
      writeerror.error_write_idx++;

   m_MutexErrorWrite.Release();
}

void TSaveBanNew::WriteErrorTxt()
{
   m_MutexErrorWrite.Acquire();

   if (writeerror.error_write_txt < 0xFFFFFFFF)
      writeerror.error_write_txt++;

   m_MutexErrorWrite.Release();
}

void TSaveBanNew::SetLockBasa()
{
   TString text = "";

   Lock();

   if (!m_lock)
   {
      m_lock = true;
      m_lostlockrecord_idx = 0;
      m_lostlockrecord_txt = 0;
      m_lostlockrecord_daylist = 0;
      m_lostlockrecord_daylistd = 0;
      text = "BANIPLIST(" + m_ident + ") : Lock basa - OK.";
      if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
         LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", text.c_str());
   } else
   {
      text = "BANIPLIST(" + m_ident + ") : Basa is already lock.";
      if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
         LogsGroup->ActionLog()->WriteMessageAndDataStatus(KWARNING, "%s", text.c_str());
   }

   UnLock();
}

void TSaveBanNew::UnLockBasa()
{
   TString text = "";

   Lock();

   if (m_lock)
   {
      TLockPDataListIt it;
      ui32             accumulaterecord_txt     = 0;
      ui32             accumulaterecord_idx     = 0;
      ui32             accumulaterecord_daylist = 0;
      ui32             accumulaterecord_daylistd = 0;
      ui32             m_BeginProcTime          = CShingleTime::GetMs();

      it = locklist.begin();
      while (it != locklist.end())
      {
         switch ((*it).is_txt)
         {
          case KTXT:
                        accumulaterecord_txt++;
                        WriteTxtA((*it).buf, (*it).size, (*it).count);
                        break;
          case KIDX:
                        accumulaterecord_idx++;
                        WriteIdxA((*it).buf, (*it).size, (*it).count);
                        break;
          case KDAYLIST:
                        accumulaterecord_daylist++;
                        WriteDayListA((*it).buf, (*it).size, (*it).count);
                        break;
          case KDAYLISTD:
                        accumulaterecord_daylistd++;
                        WriteDayListDA((*it).buf, (*it).size, (*it).count);
                        break;
         };

         ++it;
      }
      locklist.clear();

      m_BeginProcTime = CShingleTime::GetMs() - m_BeginProcTime;

      m_lock = false;

      text = "BANIPLIST(" + m_ident + ") : Basa is unlock (write " + IntToStroka(accumulaterecord_txt) + "(txt), " + IntToStroka(accumulaterecord_idx) + "(idx), " + IntToStroka(accumulaterecord_daylist) + "(daylist) and " + IntToStroka(accumulaterecord_daylistd) + "(daylist_d) accumulated record, lost " + IntToStroka(m_lostlockrecord_txt) + "(txt), " + IntToStroka(m_lostlockrecord_idx) + "(idx), " + IntToStroka(m_lostlockrecord_daylist) + "(daylist) and " + IntToStroka(m_lostlockrecord_daylistd) + "(daylist_d) record) in " + IntToStroka(m_BeginProcTime) + " msec.";
      if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
         LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", text.c_str());

   } else
   {
      text = "BANIPLIST(" + m_ident + ") : Basa isn't lock.";
      if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
         LogsGroup->ActionLog()->WriteMessageAndDataStatus(KWARNING, "%s", text.c_str());
   }

   UnLock();
}

bool TSaveBanNew::IsLock()
{
   return m_lock;
}

bool TSaveBanNew::WriteFullList(TBanIPHashYH *data)
{
    bool           res = false;

   if (!m_lock)
   {
      Lock();

      TBanIPHashYH::iterator  it;
      TKIPv6                  ip           = TKIPv6();
      TBanIpBasic             *pbanip      = NULL;
      int                     count        = 0;
      int                     err          = 0;
      ui32                    value_count  = 0;

      //write text file
      DELETE_FP(htext);
      if (!bantextfile.empty())
         htext = fopen(bantextfile.c_str(), "wb"); //"wbt"
      if (htext != NULL)
      {
         value_count = data->size();
         it = data->begin();
         while ( it != data->end() )
         {
            ip       = (*it).first;
            pbanip   = &((*it).second);

            TString ssip = ip.toStroka() + "\n";
            if (pbanip->chours > 0)
            {
               if ((pbanip->cIntBanIp & 0x01) == 0)
               {
                  count = fwrite(ssip.c_str(), ssip.length(), 1, htext);
                  if (count != 1)
                  {
                     if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
                        LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not save %s : count = %d", m_ident.c_str(), bantextfile.c_str(), value_count);
                     err = 1;
                     break;
                  }
               }
            }

            ++it;
         }
         fflush(htext);

      } else
      {
         DELETE_FP(htext);
         if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not open %s.", m_ident.c_str(), bantextfile.c_str());
         err = 3;
      }

      if ( (CloseFile) && (htext != NULL) )
      {
         fclose(htext);
         htext = NULL;
      }

      //write idx file
      DELETE_FP(hindex);
      if (!banindexfile.empty())
         hindex = fopen(banindexfile.c_str(), "wb"); //"wbt"
      if (hindex != NULL)
      {
         value_count = data->size();
         it = data->begin();
         while ( it != data->end() )
         {
            ip       = (*it).first;
            pbanip   = &((*it).second);

            count = fwrite(pbanip, sizeof(TBanIpBasic), 1, hindex);
            if (count != 1)
            {
               if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
                  LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not save %s : count = %d", m_ident.c_str(), banindexfile.c_str(), value_count);
               err = 2;
               break;
            }

            ++it;
         }
         fflush(hindex);

      } else
      {
         DELETE_FP(hindex);
         if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not open %s.", m_ident.c_str(), banindexfile.c_str());
         err = 3;
      }

      if ( (CloseFile) && (hindex != NULL) )
      {
         fclose(hindex);
         hindex = NULL;
      }

      //
      if (err == 0)
         res = true;

      UnLock();
   }

   return res;
}

bool TSaveBanNew::RewriteDayList(TBanIPHashYH *data, bool &busy)
{
   bool res = false;

   if (!m_lock)
   {
      Lock();

      TBanIPHashYH::iterator  it;
      TKIPv6                  ip           = TKIPv6();
      TBanIpBasic             *pbanip      = NULL;
      int                     count        = 0;
      int                     err          = 0;
      ui32                    value_count  = 0;
      TString                  dls          = "";

      busy = false;

      //rewrite daylist (txt)
      DELETE_FP(hdaylist);
      if (!bandaylistfile.empty())
         hdaylist = fopen(bandaylistfile.c_str(), "wb"); //"wbt"
      if (hdaylist != NULL)
      {
         value_count = data->size();
         it = data->begin();
         while ( it != data->end() )
         {
            ip       = (*it).first;
            pbanip   = &((*it).second);

            dls = ip.toStroka() + "\n";
            if (pbanip->chours > 0)
            {
               if ((pbanip->cIntBanIp & 0x01) == 0)
               {
                  count = fwrite(dls.c_str(), dls.length(), 1, hdaylist);
                  if (count != 1)
                  {
                     if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
                        LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not save %s : count = %d", m_ident.c_str(), bandaylistfile.c_str(), value_count);
                     err = 1;
                     break;
                  }
               }
            }

            ++it;
         }
         fflush(hdaylist);

      } else
      {
         DELETE_FP(hdaylist);
         if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not open %s.", m_ident.c_str(), bandaylistfile.c_str());
         err = 3;
      }

      if ( (CloseFile) && (hdaylist != NULL) )
      {
         fclose(hdaylist);
         hdaylist = NULL;
      }

#ifdef ENABLE_WRITE_IDX_FILES

      //rewrite daylist (dump)
      DELETE_FP(hdaylist_d);
      if (!bandaylistfile_d.empty())
         hdaylist_d = fopen(bandaylistfile_d.c_str(), "wb"); //"wbt"
      if (hdaylist_d != NULL)
      {
         value_count = data->size();
         it = data->begin();
         while ( it != data->end() )
         {
            ip       = (*it).first;
            pbanip   = &((*it).second);

            if (pbanip->chours > 0)
            {
               if ((pbanip->cIntBanIp & 0x01) == 0)
               {
                  count = fwrite((void *)&ip, sizeof(TKIPv6), 1, hdaylist_d);
                  if (count != 1)
                  {
                     if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
                        LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not save %s : count = %d", m_ident.c_str(), bandaylistfile_d.c_str(), value_count);
                     err = 1;
                     break;
                  }
               }
            }

            ++it;
         }
         fflush(hdaylist_d);

      } else
      {
         DELETE_FP(hdaylist_d);
         if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
            LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): Can not open %s.", m_ident.c_str(), bandaylistfile_d.c_str());
         err = 3;
      }

      if ( (CloseFile) && (hdaylist_d != NULL) )
      {
         fclose(hdaylist_d);
         hdaylist_d = NULL;
      }

#endif //ENABLE_WRITE_IDX_FILES

      if (err == 0)
         res = true;

      UnLock();

   } else
   {
      busy = true;
      res  = false;
   }

   return res;
}

TErrorWrite TSaveBanNew::CalcErrorStatistic()
{
   TErrorWrite res;
   time_t      currenttime = 0;
   time_t      tdiff       = 0;

   m_MutexErrorWrite.Acquire();

   currenttime = time(NULL);
   tdiff = currenttime - writeerror.last_calc_error_info;
   if ( (tdiff > 60) && (writeerror.last_write_moment > writeerror.last_calc_error_info) )
   {
      res = writeerror;
      res.last_calc_error_info = tdiff;
      writeerror.Clear();
      writeerror.last_calc_error_info = currenttime;
      writeerror_out = res;
      res.now = true;
   }

   m_MutexErrorWrite.Release();

   return res;
}

TErrorWrite TSaveBanNew::GetErrorStatistic()
{
   return writeerror_out;
}

//*************************************************************************************
//                               TBanIPListItem
//*************************************************************************************

TBanIPListItem::TBanIPListItem(TStorageType stortype, void *statipobj, TLogsGroup *LogsGroupA, TKConfig* configobjA, kipv6::TWhiteIPv6 *WhiteIpA, TNetKIPv6 *m_WhiteNetA, TString BanTextFile, TString BanIndexFile, TChangeProperties *CPOA, TString ident, TString &bandaylistfileA, TString &bandaylistfile_dA)
{
   m_statipobj        = NULL;
   m_stortype         = MST_UNKNOWN;
   m_ident            = ident;
   m_LastBanTime      = 0;
   m_bantextfile      = "";
   m_banindexfile     = "";
   LogsGroup          = NULL;
   CPO                = NULL;
   m_LastIpListCheck  = time(NULL);
   m_ReturnCount      = 0;
   m_BanCount         = 0;
   m_WhiteNet         = NULL;
   m_ban_cps_last     = time(NULL);
   m_ban_cps          = 0;
   m_ban_count_to_cps = 0;
   m_truncdaylist     = false;

   Init(stortype, statipobj, LogsGroupA, configobjA, WhiteIpA, m_WhiteNetA, BanTextFile, BanIndexFile, CPOA, bandaylistfileA, bandaylistfile_dA);
}

TBanIPListItem::~TBanIPListItem()
{
   if (res_o != NULL)
   {
      delete res_o;
      res_o = NULL;
   }
}

bool TBanIPListItem::Init(TStorageType stortype, void *statipobj, TLogsGroup *LogsGroupA, TKConfig* configobjA, kipv6::TWhiteIPv6 *WhiteIpA, TNetKIPv6 *m_WhiteNetA, TString BanTextFile, TString BanIndexFile, TChangeProperties *CPOA, TString &bandaylistfileA, TString &bandaylistfile_dA)
{
   bool closefile = true;

   m_statipobj          = statipobj;
   m_stortype           = stortype;
   m_WhiteIp            = WhiteIpA;
   m_bantextfile        = BanTextFile;
   m_banindexfile       = BanIndexFile;
   LogsGroup            = LogsGroupA;
   CPO                  = CPOA;
   m_WhiteNet           = m_WhiteNetA;
   res_o                = new TSaveBanNew(m_ident, m_bantextfile, m_banindexfile, closefile, LogsGroup, bandaylistfileA, bandaylistfile_dA);

   return true;
}

void TBanIPListItem::Lock()
{
   m_Mutex.Acquire();
}

void TBanIPListItem::UnLock()
{
   m_Mutex.Release();
}

ui32 TBanIPListItem::AddData32(ui32 &value, ui32 addv)
{
   ui32 count = 0;
   ui32 dob   = 0;

   if (value < MAX32BITVALUE)
   {
      count = MAX32BITVALUE - value;
      dob = (addv > count) ? count : addv;
      value += dob;
   }

   return value;
}

void TBanIPListItem::AddToHash(nosql::HashMap &hash, const TString &fname, i64 value)
{
   if (!fname.empty())
   {
      nosql::HashMap::iterator it;
      i64   count = 0;
      i64   dob   = 0;

      it = hash.find(fname);
      if (it != hash.end())
      {
         if (value > 0)
         {
            if (value > MAX32BITVALUE)
               value = MAX32BITVALUE;
            if (value <= MAX32BITVALUE)
            {
               count = MAX32BITVALUE - value;
               dob = (value > count) ? count : value;
               dob += (*it).second.Long();
               (*it).second = dob;
            }

         } else if (value < 0)
         {
            value += (*it).second.Long();
            (*it).second = value;
         }

      } else
      {
         if (value != 0)
         {
            if (value > MAX32BITVALUE)
               hash[fname] = MAX32BITVALUE;
            else
               hash[fname] = value;
         }

      }
   }
}

bool TBanIPListItem::IpAction(TBanIpBasic *pbanip, int addBanTime, time_t lastBanTime, ui32 &remain)
{
    remain = 0;
    time_t tcurr;
    time( &tcurr );
    int xAddTime; //additional time in seconds ( if no new ban was made during last 10 minutes)

    xAddTime = tcurr - lastBanTime;
    if (xAddTime < 600)
        xAddTime = 0;

    if (pbanip->chours && tcurr < pbanip->tAction + pbanip->chours * 3600 + addBanTime * 3600 + xAddTime)
    {
        remain = (pbanip->tAction + pbanip->chours * 3600 + addBanTime * 3600 + xAddTime) - tcurr;
        return true;
    } else
        return false;
}

bool TBanIPListItem::WriteAddBanIpList(TBanIpBasic *pbanip, ui16 m_AddBanTime)
{
    ui32   remainban = 0;

    if (pbanip != NULL)
    {
       if (!IpAction(pbanip, m_AddBanTime, AtomicAdd( m_LastBanTime, 0 ), remainban))
       {
           if (pbanip->chours)
           {
               if (m_AddBanTime)
               {
                   if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
                      LogsGroup->ProtokolLog()->WriteMessage("Return ip = %s hours = %u (%d), mess = %u, strbl=%u", pbanip->ip.toStroka().c_str(), pbanip->chours, m_AddBanTime, pbanip->cMessage, pbanip->sendtorbl);
               } else
               {
                   if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
                        LogsGroup->ProtokolLog()->WriteMessage("Return ip = %s hours = %u, mess = %u, strbl=%u", pbanip->ip.toStroka().c_str(), pbanip->chours, pbanip->cMessage, pbanip->sendtorbl);
               }
               pbanip->chours = 0;

               if (res_o != NULL)
                  res_o->WriteDayList("-" + pbanip->ip.toStroka() + "\n");

           }
           return false;
       }
       //white ip list
       if ( (m_WhiteIp != NULL) && (m_WhiteIp->IsWhiteIp(pbanip->ip)) )
       {
           if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
               LogsGroup->ProtokolLog()->WriteMessage("Removed white ip (whiteip list) %s from reject ip list, strbl=%u", pbanip->ip.toStroka().c_str(), pbanip->sendtorbl);
           pbanip->chours = 0;

           if (res_o != NULL)
              res_o->WriteDayList("-" + pbanip->ip.toStroka() + "\n");

           return false;
       }
       //white net list
       if ( (m_WhiteNet != NULL) && (m_WhiteNet->IsInNet(pbanip->ip)) )
       {
           if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
               LogsGroup->ProtokolLog()->WriteMessage("Removed white ip (whitenet list) %s from reject ip list, strbl=%u", pbanip->ip.toStroka().c_str(), pbanip->sendtorbl);
           pbanip->chours = 0;

           if (res_o != NULL)
              res_o->WriteDayList("-" + pbanip->ip.toStroka() + "\n");

           return false;
       }

     pbanip->cs = pbanip->GetCRC32(0);

       if ( (res_o != NULL) && (pbanip->chours > 0) && ((pbanip->cIntBanIp & 0x01) == 0) )
       {
          res_o->WriteTxt(pbanip->ip.toStroka() + "\n");
          res_o->WriteIdx(pbanip);

          res_o->WriteDayList("+" + pbanip->ip.toStroka() + "\n");
          res_o->WriteDayListD(pbanip);
       }
    }

    return true;
}


bool TBanIPListItem::mongo_read_banip(TStorageType stortype, TKIPv6 ip, bool &mongo_err, TBanIpBasic &data, bool &empty)
{
   bool                    res             = false;

   if ( (m_statipobj != NULL) && (((TStatIPObject *)m_statipobj)->GetStorage() != NULL) )
      res = ((TStatIPObject *)m_statipobj)->GetStorage()->mongo_read_banip(stortype, ip, mongo_err, data, empty);

   return res;
}

bool TBanIPListItem::mongo_update_banip(TStorageType stortype, TKIPv6 ip, bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs)
{
   bool res = false;

   if ( (m_statipobj != NULL) && (((TStatIPObject *)m_statipobj)->GetStorage() != NULL) )
      res = ((TStatIPObject *)m_statipobj)->GetStorage()->mongo_update_banip(stortype, ip, mongo_err, sets, incrs);

   return res;
}

i64 TBanIPListItem::mongo_banip_basa_size(TStorageType stortype)
{
   i64      res             = 0;

   if ( (m_statipobj != NULL) && (((TStatIPObject *)m_statipobj)->GetStorage() != NULL) )
      res = ((TStatIPObject *)m_statipobj)->GetStorage()->mongo_basa_size(stortype);

   return res;
}

bool TBanIPListItem::mongo_find(TStorageType stortype, TVector< nosql::HashMap > &hashes)
{
   bool     res             = false;

   if ( (m_statipobj != NULL) && (((TStatIPObject *)m_statipobj)->GetStorage() != NULL) )
      res = ((TStatIPObject *)m_statipobj)->GetStorage()->mongo_find(stortype, hashes);

   return res;
}

bool TBanIPListItem::mongo_erase(TStorageType stortype, TKIPv6 ip, bool &mongo_err)
{
   bool                    res             = false;

   if ( (m_statipobj != NULL) && (((TStatIPObject *)m_statipobj)->GetStorage() != NULL) )
      res = ((TStatIPObject *)m_statipobj)->GetStorage()->mongo_erase(stortype, ip, mongo_err);

   return res;
}

bool TBanIPListItem::mongo_read_bansetup(bool &mongo_err, TBanSetup &data, bool &empty)
{
   bool                    res             = false;

   if ( (m_statipobj != NULL) && (((TStatIPObject *)m_statipobj)->GetStorage() != NULL) )
      res = ((TStatIPObject *)m_statipobj)->GetStorage()->mongo_read_bansetup(mongo_err, data, empty);

   return res;
}

bool TBanIPListItem::mongo_update_bansetup(bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs)
{
   bool res = false;

   if ( (m_statipobj != NULL) && (((TStatIPObject *)m_statipobj)->GetStorage() != NULL) )
      res = ((TStatIPObject *)m_statipobj)->GetStorage()->mongo_update_bansetup(mongo_err, sets, incrs);

   return res;
}

int TBanIPListItem::IsBanIp(TKIPv6 ip, ui32 *pcMess, ui32 *pcsec)
{
   int            res         = 0;
   bool           mongo_err   = false;
   TBanIpBasic    ipdata;
   bool           ipdata_empty = false;

   if (mongo_read_banip(m_stortype, ip, mongo_err, ipdata, ipdata_empty))
   {
      if (!ipdata_empty)
      {
         ui16 AddBanTime = 0;
         ui32 remainban  = 0;

         if (CPO != NULL)
            AddBanTime = CPO->GetAddBanTime();

         if (IpAction(&ipdata, AddBanTime, AtomicAdd( m_LastBanTime, 0 ), remainban))
         {
            nosql::HashMap   incrs;
            nosql::HashMap   sets;

            incrs.clear();
            sets.clear();

            time_t tcurr = time(NULL);

            AddData32(ipdata.cMessage, 1);
            AddToHash(incrs, BANIP_CMESSAGE, static_cast<i64>(1));       //mongo

            *pcMess = ipdata.cMessage;
            *pcsec = tcurr - ipdata.tAction;

            res = ipdata.cMessage;

            mongo_err = false;
            if (!mongo_update_banip(m_stortype, ip, mongo_err, sets, incrs))
            {
               if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
                  LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (IsBanIp), ip=%s", ip.toStroka().c_str());

            }
         }

      }
   } else
   {
      if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
         LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (IsBanIp), ip=%s", ip.toStroka().c_str());

   }

   return res;
}

int TBanIPListItem::IsBanIpExt(TKIPv6 ip, bool &ban, ui16 &ban_hours, ui8 &ban_pr)
{
   int            res         = 0;
   bool           mongo_err   = false;
   TBanIpBasic    ipdata;
   bool           ipdata_empty = false;

   ban       = false;
   ban_hours = 0;
   ban_pr    = 0;

   if (mongo_read_banip(m_stortype, ip, mongo_err, ipdata, ipdata_empty))
   {
      if (!ipdata_empty)
      {
         ui16 AddBanTime = 0;
         ui32 remainban  = 0;

         if (CPO != NULL)
            AddBanTime = CPO->GetAddBanTime();

         if (IpAction(&ipdata, AddBanTime, AtomicAdd( m_LastBanTime, 0 ), remainban))
         {
            ban       = true;
            ban_hours = ipdata.chours;
            ban_pr    = ipdata.cIntBanIp;

            res = ipdata.cMessage;
         }

      }
   } else
   {
      if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
         LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (IsBanIpExt), ip=%s", ip.toStroka().c_str());

   }

   return res;
}

void TBanIPListItem::CheckBanFunc(const TString &ident_func, TKIPv6 ip, bool err_update, ui32 hours, ui32 sendtorbl)
{
   TString server_id = "";

   if ( (m_statipobj != NULL) && (((TStatIPObject *)m_statipobj)->GetStorage() != NULL) )
      server_id = ((TStatIPObject *)m_statipobj)->GetServerID();

   if ( (LogsGroup != NULL) && (LogsGroup->BanStepLog() != NULL) )
   {
      if (err_update)
      {
         LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KERROR, "%s % 40s update error (%s), hours=%u, strbl=%u", server_id.c_str(), ip.toStroka().c_str(), ident_func.c_str(), hours, sendtorbl);

      } else
      {
         bool        mongo_err_v    = false;
         bool        ipdata_empty_v = false;
         TBanIpBasic ipdata_v;
         ui32        acttime_v      = 0;
         ui32        hours_v        = 0;
         ui32        sendtorbl_v    = 0;
         ui16        m_addbantime   = 0;
         ui32        remainban      = 0;
         bool        is_ban         = false;

         if (mongo_read_banip(m_stortype, ip, mongo_err_v, ipdata_v, ipdata_empty_v))
         {
            if (ipdata_empty_v)
            {
               LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KMESSAGE, "%s % 40s confirm ok (%s), empty", server_id.c_str(), ip.toStroka().c_str(), ident_func.c_str());

            } else
            {
               acttime_v   = ipdata_v.tAction;
               hours_v     = ipdata_v.chours;
               sendtorbl_v = ipdata_v.sendtorbl;

               if (CPO != NULL)
                 m_addbantime = CPO->GetAddBanTime();

               is_ban = IpAction(&ipdata_v, m_addbantime, AtomicAdd( m_LastBanTime, 0 ), remainban);

               if (is_ban)
                  LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KMESSAGE, "%s % 40s confirm ok (%s), BAN, action=%u, hours=%u, strbl=%u, remainban=%u", server_id.c_str(), ip.toStroka().c_str(), ident_func.c_str(), acttime_v, hours_v, sendtorbl_v, remainban);
               else
                  LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KMESSAGE, "%s % 40s confirm ok (%s), RETURN_BAN, action=%u, hours=%u, strbl=%u", server_id.c_str(), ip.toStroka().c_str(), ident_func.c_str(), acttime_v, hours_v, sendtorbl_v);

            }

         } else
         {
            LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KERROR, "%s % 40s confirm error (%s)", server_id.c_str(), ip.toStroka().c_str(), ident_func.c_str());

         }
      }
   }

}

bool TBanIPListItem::AddBanIp(TKIPv6 ip, ui32 hours, bool IntBanIpA, ui32 sendtorbl)
{
   bool           res          = false;
   time_t         tcurr        = time(NULL);
   bool           mongo_err    = false;
   TBanIpBasic    ipdata;
   bool           ipdata_empty = false;
   bool           err_update   = false;

   if (mongo_read_banip(m_stortype, ip, mongo_err, ipdata, ipdata_empty))
   {
      bool              ManualA     = false;
      bool              BlackListA  = false;
      bool              RuleA       = true;
      nosql::HashMap    incrs;
      nosql::HashMap    sets;

      AtomicSwap( &m_LastBanTime, tcurr );

      incrs.clear();
      sets.clear();

      if (!ipdata_empty)
      {
         ipdata.ip        = ip;
         sets[ BANIP_IP ] = ipdata.ip.toStroka();                  //mongo

         ipdata.tAction   = tcurr;
         sets[ BANIP_TACTION ] = ipdata.tAction;                   //mongo

         ipdata.chours    = hours;
         sets[ BANIP_CHOURS ] = ipdata.chours;                     //mongo

         sets[ BANIP_CMESSAGE ] = ipdata.cMessage;                 //mongo

         if (IntBanIpA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xFE) + 0x01;
         if (ManualA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xFD) + 0x02;
         if (BlackListA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xFB) + 0x04;
         if (RuleA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xF7) + 0x08;
         sets[ BANIP_CINTBANIP ] = ipdata.cIntBanIp;               //mongo

         memset(&ipdata.cUser, sizeof(ipdata.cUser), 0);
         sets[ BANIP_CUSERS ] = TString("");                        //mongo

         ipdata.sendtorbl = sendtorbl;
         sendtorbl = ipdata.sendtorbl;
         sets[ BANIP_SENDTORBL ] = ipdata.sendtorbl;               //mongo

         mongo_err = false;
         if (!mongo_update_banip(m_stortype, ip, mongo_err, sets, incrs))
         {
            err_update = true;
            if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
               LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (AddBanIp), ip=%s", ip.toStroka().c_str());

         } else
         {
            err_update = false;

         }

         CheckBanFunc("AddBanIp, exists", ip, err_update, hours, sendtorbl);

      } else
      {
         if (true)
         {
             TGuard< TMutex > g( m_Mutex );
             // cps   ip  
             m_ban_count_to_cps = (m_ban_count_to_cps < 0xFFFFFFFF) ? (m_ban_count_to_cps + 1) : 0xFFFFFFFF;
             if ((tcurr - m_ban_cps_last) >= 10)
             {
                m_ban_cps = (float)m_ban_count_to_cps / (float)(tcurr - m_ban_cps_last);
                m_ban_cps_last = tcurr;
                m_ban_count_to_cps = 0;
             }
         }

         // ip  
         ui16  addbantime = 0;
         if (CPO != NULL)
            addbantime = CPO->GetAddBanTime();

         ipdata.ip        = ip;
         sets[ BANIP_IP ] = ipdata.ip.toStroka();                    //mongo

         ipdata.sendtorbl = sendtorbl;
         sendtorbl = ipdata.sendtorbl;
         sets[ BANIP_SENDTORBL ] = ipdata.sendtorbl;                 //mongo

         ipdata.cMessage  = 0;
         sets[ BANIP_CMESSAGE ] = ipdata.cMessage;                   //mongo

         if (IntBanIpA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xFE) + 0x01;
         if (ManualA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xFD) + 0x02;
         if (BlackListA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xFB) + 0x04;
         if (RuleA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xF7) + 0x08;
         sets[ BANIP_CINTBANIP ] = ipdata.cIntBanIp;                 //mongo

         ipdata.tAction   = tcurr;
         sets[ BANIP_TACTION ] = ipdata.tAction;                     //mongo

         ipdata.chours    = hours;
         sets[ BANIP_CHOURS ] = ipdata.chours;                       //mongo

         memset(&ipdata.cUser, sizeof(ipdata.cUser), 0);
         sets[ BANIP_CUSERS ] = TString("");                          //mongo

         if (!WriteAddBanIpList(&ipdata, addbantime))
         {
            //   , ..   ,   white ip (  WriteAddBanIpList      ip ("-"   )  )
            if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
               LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "BANIPLIST(%s): ban ip list error!", m_ident.c_str());

            res = false;

         } else
         {
            AtomicIncrement( m_BanCount );

            //,   ip  
            mongo_err = false;
            if (!mongo_update_banip(m_stortype, ip, mongo_err, sets, incrs))
            {
               err_update = true;
               if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
                  LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (AddBanIp), ip=%s", ip.toStroka().c_str());

            } else
            {
               err_update = false;
            }

            CheckBanFunc("AddBanIp, new", ip, err_update, hours, sendtorbl);

            res = true;
         }

      }

   } else
   {
      TString server_id = "";

      if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
         LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (AddBanIp), ip=%s", ip.toStroka().c_str());

      if ( (m_statipobj != NULL) && (((TStatIPObject *)m_statipobj)->GetStorage() != NULL) )
         server_id = ((TStatIPObject *)m_statipobj)->GetServerID();

      if ( (LogsGroup != NULL) && (LogsGroup->BanStepLog() != NULL) )
         LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KERROR, "%s % 40s get (AddBanIp), hours=%u, strbl=%u", server_id.c_str(), ip.toStroka().c_str(), hours, sendtorbl);

   }

   return res;
}

bool TBanIPListItem::AddBanIpWOW(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, const TString &user, const bool longb, ui32 &sendtorbl)
{
   bool           res          = false;
   time_t         tcurr        = time(NULL);
   bool           mongo_err    = false;
   TBanIpBasic    ipdata;
   bool           ipdata_empty = false;
   bool           err_update   = false;
   bool           pr_new       = false;

   sendtorbl = 0;
   if (mongo_read_banip(m_stortype, ip, mongo_err, ipdata, ipdata_empty))
   {
      bool              RuleA       = false;
      nosql::HashMap    incrs;
      nosql::HashMap    sets;
      bool              isintban    = false;

      AtomicSwap( &m_LastBanTime, tcurr );

      incrs.clear();
      sets.clear();

      if (!ipdata_empty)
      {
         pr_new = false;

         ipdata.ip        = ip;
         sets[ BANIP_IP ] = ipdata.ip.toStroka();                  //mongo

         ipdata.tAction   = tcurr;
         sets[ BANIP_TACTION ] = ipdata.tAction;                   //mongo

         ipdata.chours    = hours;
         sets[ BANIP_CHOURS ] = ipdata.chours;                     //mongo

         sets[ BANIP_CMESSAGE ] = ipdata.cMessage;                 //mongo

         isintban = ipdata.cIntBanIp & 0x01;
         if (isintban && !IntBanIpA)
            ipdata.cIntBanIp = ipdata.cIntBanIp & 0xFE; //  Intban

         if (IntBanIpA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xFE) + 0x01;
         if (ManualA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xFD) + 0x02;
         if (BlackListA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xFB) + 0x04;
         if (RuleA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xF7) + 0x08;
         sets[ BANIP_CINTBANIP ] = ipdata.cIntBanIp;               //mongo

         memset(ipdata.cUser, 0, sizeof(ipdata.cUser));
         strncpy(ipdata.cUser, user.c_str(), sizeof(ipdata.cUser) - 1);
         sets[ BANIP_CUSERS ] = TString(ipdata.cUser);              //mongo

         ipdata.sendtorbl = 1;
         sendtorbl = ipdata.sendtorbl;
         sets[ BANIP_SENDTORBL ] = ipdata.sendtorbl;               //mongo

         ipdata.cs = ipdata.GetCRC32(0);
         //sets[ BANIP_CS ] = ipdata.cs;                             //mongo

         if (!IntBanIpA)
         {
            if ( (res_o != NULL) && (ipdata.chours > 0) && ((ipdata.cIntBanIp & 0x01) == 0) )
            {
               nosql::HashMap::iterator it = sets.find(BANIP_IP);
               if (it != sets.end())
                  (*it).second = ipdata.ip.toStroka();
               else
                  sets[ BANIP_IP ] = ipdata.ip.toStroka();

               res_o->WriteTxt(ipdata.ip.toStroka() + "\n");
               res_o->WriteIdx(&ipdata);

               res_o->WriteDayList("++" + ipdata.ip.toStroka() + "\n");
               res_o->WriteDayListD(&ipdata);
            }

         }
         res = true;

      } else
      {
         // ip  
         pr_new = true;

         ipdata.ip        = ip;
         sets[ BANIP_IP ] = ipdata.ip.toStroka();                    //mongo

         ipdata.cMessage  = 0;
         sets[ BANIP_CMESSAGE ] = ipdata.cMessage;                   //mongo

         if (IntBanIpA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xFE) + 0x01;
         if (ManualA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xFD) + 0x02;
         if (BlackListA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xFB) + 0x04;
         if (RuleA)
            ipdata.cIntBanIp = (ipdata.cIntBanIp & 0xF7) + 0x08;
         sets[ BANIP_CINTBANIP ] = ipdata.cIntBanIp;                 //mongo

         ipdata.sendtorbl = 1;
         sendtorbl = ipdata.sendtorbl;
         sets[ BANIP_SENDTORBL ] = ipdata.sendtorbl;                 //mongo

         ipdata.tAction   = tcurr;
         sets[ BANIP_TACTION ] = ipdata.tAction;                     //mongo

         ipdata.chours    = hours;
         sets[ BANIP_CHOURS ] = ipdata.chours;                       //mongo

         memset(ipdata.cUser, 0, sizeof(ipdata.cUser));
         strncpy(ipdata.cUser, user.c_str(), sizeof(ipdata.cUser) - 1);
         sets[ BANIP_CUSERS ] = TString(ipdata.cUser);                //mongo

         ipdata.cs = ipdata.GetCRC32(0);
         //sets[ BANIP_CS ] = ipdata.cs;                               //mongo

         if (!IntBanIpA)
         {
            if ( (res_o != NULL) && (ipdata.chours > 0) && ((ipdata.cIntBanIp & 0x01) == 0) )
            {
               nosql::HashMap::iterator it = sets.find(BANIP_IP);
               if (it != sets.end())
                  (*it).second = ipdata.ip.toStroka();
               else
                  sets[ BANIP_IP ] = ipdata.ip.toStroka();

               res_o->WriteTxt(ipdata.ip.toStroka() + "\n");
               res_o->WriteIdx(&ipdata);

               res_o->WriteDayList("++" + ipdata.ip.toStroka() + "\n");
               res_o->WriteDayListD(&ipdata);
            }

         }

      }

      mongo_err = false;
      if (!mongo_update_banip(m_stortype, ip, mongo_err, sets, incrs))
      {
         err_update = true;
         if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (AddBanIpWOW), ip=%s", ip.toStroka().c_str());

      } else
      {
         err_update = false;
      }

      if (pr_new)
         CheckBanFunc("AddBanIpWow, new, user='" + user + "'", ip, err_update, hours, sendtorbl);
      else
         CheckBanFunc("AddBanIpWow, exists, user='" + user + "'", ip, err_update, hours, sendtorbl);

   } else
   {
      TString server_id = "";

      if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
         LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (AddBanIpWOW), ip=%s", ip.toStroka().c_str());

      if ( (m_statipobj != NULL) && (((TStatIPObject *)m_statipobj)->GetStorage() != NULL) )
         server_id = ((TStatIPObject *)m_statipobj)->GetServerID();

      if ( (LogsGroup != NULL) && (LogsGroup->BanStepLog() != NULL) )
         LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KERROR, "%s % 40s get (AddBanIpWOW, user='%s'), hours=%u, strbl=%u", server_id.c_str(), ip.toStroka().c_str(), user.c_str(), hours, sendtorbl);
   }

   return res;
}

ui32 TBanIPListItem::BanIpListCheck(ui32 &allcount, ui32 &returncount, ui32 &whiteipcount, ui32 &rescount, bool &prcheck)
{
   ui32     res         = 0;
   time_t   tcurr       = time(NULL);
   TString   server_id   = "";

   if ( (m_statipobj != NULL) && (((TStatIPObject *)m_statipobj)->GetStorage() != NULL) )
      server_id = ((TStatIPObject *)m_statipobj)->GetServerID();

   prcheck      = false;
   allcount     = 0;
   returncount  = 0;
   whiteipcount = 0;
   rescount     = 0;

   res = CShingleTime::GetMs();

   if ((tcurr - AtomicAdd(m_LastIpListCheck, 0)) >= CHECK_BAN_LIST_TIME)
   {
      TVector< nosql::HashMap > hashes;

      hashes.clear();
      if (mongo_find(m_stortype, hashes))
      {
         TBanIPHashYH   *banhash      = NULL;
         TBanIPHashYH   *banhash_new  = NULL;
         TBanIpBasic    ipdata;
         TString         id            = "";
         TKIPv6         ip;

         banhash = new TBanIPHashYH();
         if (banhash != NULL)
         {
            for( size_t i = 0; i < hashes.size(); i++ )
            {
               ipdata.Clear();
               ip = TBanIpBasicSerialization::IdToKey( hashes[ i ][ "_id" ].String() );
               TBanIpBasicSerialization::Deserialize( hashes[ i ], ipdata );

               if (!ip.Undefined())
                  (*banhash)[ip] = ipdata;

            }

            if (banhash->size() > 0)
            {
               TBanIPHashYH::iterator it;
               TKIPv6         ip           = TKIPv6();
               TBanIpBasic    *pbanip      = NULL;
               ui16           m_addbantime = 0;
               size_t         elem_count   = 0;
               ui32           remainban    = 0;

               if (CPO != NULL)
                  m_addbantime = CPO->GetAddBanTime();

               //  
               elem_count = banhash->size();
               allcount = elem_count;

               it = banhash->begin();
               while (it != banhash->end())
               {
                  ip          = (*it).first;
                  pbanip      = &((*it).second);

                  //,    ?
                  if (!IpAction(pbanip, m_addbantime, AtomicAdd( m_LastBanTime, 0 ), remainban))
                  {
                     if (pbanip->chours)
                     {
                        if (RemoveBanIp(ip))
                        {
                           AtomicIncrement( m_ReturnCount );
                           returncount = IncMax32(returncount, 1);

                           if (m_addbantime)
                           {
                              if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
                                 LogsGroup->ProtokolLog()->WriteMessageAndData("Return ip = %s hours = %u (%d), mess = %u", ip.toStroka().c_str(), pbanip->chours, m_addbantime, pbanip->cMessage);

                              if ( (LogsGroup != NULL) && (LogsGroup->BanStepLog() != NULL) )
                                 LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KMESSAGE, "%s % 40s return ip", server_id.c_str(), ip.toStroka().c_str());

                           } else
                           {
                              if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
                                 LogsGroup->ProtokolLog()->WriteMessageAndData("Return ip = %s hours = %u, mess = %u", ip.toStroka().c_str(), pbanip->chours, pbanip->cMessage);

                              if ( (LogsGroup != NULL) && (LogsGroup->BanStepLog() != NULL) )
                                 LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KMESSAGE, "%s % 40s return ip", server_id.c_str(), ip.toStroka().c_str());

                           }
                           pbanip->chours = 0;

                        }
                     } else
                     {
                        if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
                           LogsGroup->ProtokolLog()->WriteMessageAndData("Return ip = %s FAILED", ip.toStroka().c_str());

                        if ( (LogsGroup != NULL) && (LogsGroup->BanStepLog() != NULL) )
                           LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KERROR, "%s % 40s return ip FAILED", server_id.c_str(), ip.toStroka().c_str());

                     }

                     ++it;
                     continue;
                  }

                  //,      ""  
                  if ((m_WhiteIp != NULL) && (m_WhiteIp->IsWhiteIp(ip)) )
                  {
                     if (RemoveBanIp(ip))
                     {
                        if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
                           LogsGroup->ProtokolLog()->WriteMessageAndData("Removed white ip (whiteip) %s from reject ip list", ip.toStroka().c_str());

                        if ( (LogsGroup != NULL) && (LogsGroup->BanStepLog() != NULL) )
                           LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KMESSAGE, "%s % 40s removed whiteip address", server_id.c_str(), ip.toStroka().c_str());

                        pbanip->chours = 0;
                        AtomicIncrement( m_ReturnCount );
                        whiteipcount = IncMax32(whiteipcount, 1);

                     } else
                     {
                        if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
                           LogsGroup->ProtokolLog()->WriteMessageAndData("Removed white ip (whiteip) %s FAILED", ip.toStroka().c_str());

                        if ( (LogsGroup != NULL) && (LogsGroup->BanStepLog() != NULL) )
                           LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KERROR, "%s % 40s removed whiteip address FAILED", server_id.c_str(), ip.toStroka().c_str());

                     }

                     ++it;
                     continue;
                  }

                  //,      ""  
                  if ((m_WhiteNet != NULL) && (m_WhiteNet->IsInNet(ip)) )
                  {
                     if (RemoveBanIp(ip))
                     {
                        if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
                           LogsGroup->ProtokolLog()->WriteMessageAndData("Removed white ip (whitenet) %s from reject ip list", ip.toStroka().c_str());

                        if ( (LogsGroup != NULL) && (LogsGroup->BanStepLog() != NULL) )
                           LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KMESSAGE, "%s % 40s removed whitenet address", server_id.c_str(), ip.toStroka().c_str());

                        pbanip->chours = 0;
                        AtomicIncrement( m_ReturnCount );
                        whiteipcount = IncMax32(whiteipcount, 1);

                     } else
                     {
                        if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
                           LogsGroup->ProtokolLog()->WriteMessageAndData("Removed white ip (whitenet) %s FAILED", ip.toStroka().c_str());

                        if ( (LogsGroup != NULL) && (LogsGroup->BanStepLog() != NULL) )
                           LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KERROR, "%s % 40s removed whitenet address FAILED", server_id.c_str(), ip.toStroka().c_str());

                     }

                     ++it;
                     continue;
                  }

                  //   
                  if (banhash_new == NULL)
                     banhash_new = new TBanIPHashYH();

                  pbanip->cs = pbanip->GetCRC32(0);
                  if (banhash_new != NULL)
                  {
                     (*banhash_new)[ip] = *pbanip;
                     rescount = IncMax32(rescount, 1);
                  }

                  ++it;
               }

               //   
               if (banhash_new != NULL)
               {
                  DELETE_OBJ(banhash);
                  banhash = banhash_new;
                  banhash_new = NULL;

               }

            }

            if (res_o != NULL)
               res_o->WriteFullList(banhash);

            delete banhash;
            banhash = NULL;
         }

      } else
      {
         if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
            LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "find (BanIpListCheck)");

      }

      prcheck = true;
      AtomicSwap( &m_LastIpListCheck, tcurr );
   }

   res = CShingleTime::GetMs() - res;

   return res;
}

TBanStat TBanIPListItem::GetStat()
{
   TBanStat res;
   i64      banip_storage_size = 0;

   AtomicSwap( &res.m_LastBanTime, m_LastBanTime );
   AtomicSwap( &res.m_LastIpListCheck, m_LastIpListCheck );
   AtomicSwap( &res.m_ReturnCount, m_ReturnCount );
   AtomicSwap( &res.m_BanCount, m_BanCount );

   banip_storage_size = mongo_banip_basa_size(m_stortype);
   if (banip_storage_size < 0)
      res.m_SizeBanList = 0;
   else if (banip_storage_size > 0xFFFFFFFF)
      res.m_SizeBanList = 0xFFFFFFFF;
   else
      res.m_SizeBanList = static_cast<ui32>(banip_storage_size);

   {
       TGuard< TMutex > g( m_Mutex );

       res.m_uniqip_cps      = m_ban_cps;
   }

   return res;
}

bool TBanIPListItem::RemoveBanIp(TKIPv6 ip)
{
   bool           res          = false;
   bool           mongo_err    = false;
   TBanIpBasic    ipdata;
   bool           ipdata_empty = false;
   TString         server_id    = "";

   if ( (m_statipobj != NULL) && (((TStatIPObject *)m_statipobj)->GetStorage() != NULL) )
      server_id = ((TStatIPObject *)m_statipobj)->GetServerID();

   if (mongo_read_banip(m_stortype, ip, mongo_err, ipdata, ipdata_empty))
   {
      if (!ipdata_empty)
      {
         if (mongo_erase(m_stortype, ip, mongo_err))
         {
            if (res_o != NULL)
               res_o->WriteDayList("-" + ip.toStroka() + "\n");

            res = true;

            if ( (LogsGroup != NULL) && (LogsGroup->BanStepLog() != NULL) )
               LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KMESSAGE, "%s % 40s erase (RemoveBanIp)", server_id.c_str(), ip.toStroka().c_str());

         } else
         {
            if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
               LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "erase (RemoveBanIp), ip=%s", ip.toStroka().c_str());

            if ( (LogsGroup != NULL) && (LogsGroup->BanStepLog() != NULL) )
               LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KERROR, "%s % 40s erase (RemoveBanIp)", server_id.c_str(), ip.toStroka().c_str());

         }

      }

   } else
   {
      if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
         LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (RemoveBanIp), ip=%s", ip.toStroka().c_str());

      if ( (LogsGroup != NULL) && (LogsGroup->BanStepLog() != NULL) )
         LogsGroup->BanStepLog()->WriteMessageAndDataStatus(KERROR, "%s % 40s get (RemoveBanIp)", server_id.c_str(), ip.toStroka().c_str());

   }

   return res;
}


TObrabResult TBanIPListItem::GetBanStatus(TKIPv6 ip, ui16 &AddBanTimeA, TBanIpBasic &tbi)
{
   TObrabResult   res;
   bool           mongo_err   = false;
   TBanIpBasic    ipdata;
   bool           ipdata_empty = false;

   res.ip      = ip;
   AddBanTimeA = 0;
   tbi.Clear();

   if (mongo_read_banip(m_stortype, ip, mongo_err, ipdata, ipdata_empty))
   {
      if (!ipdata_empty)
      {
         ui16     addbantime   = 0;
         ui32     remainban    = 0;
         time_t   lastbantime  = 0;

         if (CPO != NULL)
            addbantime = CPO->GetAddBanTime();
         AddBanTimeA = addbantime;

         tbi = ipdata;

         lastbantime = ipdata.tAction;
         if (lastbantime > m_LastBanTime)
            AtomicSwap( &m_LastBanTime, lastbantime );

         if (IpAction(&ipdata, addbantime, AtomicAdd( m_LastBanTime, 0 ), remainban))
         {
            res.ban        = true;
            res.remainban  = remainban;
         }

      }
   } else
   {
      if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
         LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (GetBanStatus), ip=%s", ip.toStroka().c_str());

   }

   return res;
}

ui32 TBanIPListItem::RemainBan(TBanIpBasic &ipdata)
{
   ui32     res          = 0;
   ui16     addbantime   = 0;
   ui32     remainban    = 0;
   time_t   lastbantime  = 0;

   if (CPO != NULL)
      addbantime = CPO->GetAddBanTime();

   lastbantime = ipdata.tAction;
   if (lastbantime > m_LastBanTime)
      AtomicSwap( &m_LastBanTime, lastbantime );

   if (IpAction(&ipdata, addbantime, AtomicAdd( m_LastBanTime, 0 ), remainban))
      res = remainban;

   return res;
}

void TBanIPListItem::SetLastBanTimeNew()
{
   time_t lastbantime = time(NULL);

   if (lastbantime > m_LastBanTime)
      AtomicSwap( &m_LastBanTime, lastbantime );
}

/*
void TBanIPListItem::GetBanList(TDoubleBanIpBasicHash &bih, bool exclude_rule_record, int index)
{
   TVector< nosql::HashMap > hashes;

   hashes.clear();
   if (mongo_find(m_stortype, hashes))
   {
      TBanIPHashYH banhash;
      TBanIpBasic  ipdata;
      TString       id      = "";
      TKIPv6       ip;

      for( size_t i = 0; i < hashes.size(); i++ )
      {
         ipdata.Clear();
         ip = TBanIpBasicSerialization::IdToKey( hashes[ i ][ "_id" ].String() );
         TBanIpBasicSerialization::Deserialize( hashes[ i ], ipdata );

         if (!ip.Undefined())
            banhash[ip] = ipdata;

      }

      if (banhash.size() > 0)
      {
         TBanIPHashYH::iterator  it;
         TDoubleBanIpBasicHashIt dit;

         it = banhash.begin();
         while (it != banhash.end())
         {
            ui8 tv = (*it).second.cIntBanIp;
            if (!(exclude_rule_record && (((*it).second.cIntBanIp & 0x08) > 0)))
            {
               dit = bih.find((*it).first);
               if (dit != bih.end())
               {
                  if ((index >= 0) && (index < TDoubleBanIpBasic::MAX_ELEMENTS))
                     (*dit).second.ban[index] = (*it).second;

               } else
               {
                  TDoubleBanIpBasic dbib;

                  dbib.ip = (*it).first;
                  if ((index >= 0) && (index < TDoubleBanIpBasic::MAX_ELEMENTS))
                     dbib.ban[index] = (*it).second;

                  bih[(*it).first] = dbib;
               }
            }

            ++it;
         }

      }

   } else
   {
      if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
         LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "find (GetBanList)");

   }
}
*/

void TBanIPListItem::GetBanListAll(TDoubleBanIpBasicHash &bih, int index)
{
   TVector< nosql::HashMap > hashes;

   hashes.clear();
   if (mongo_find(m_stortype, hashes))
   {
      TBanIPHashYH banhash;
      TBanIpBasic  ipdata;
      TString       id      = "";
      TKIPv6       ip;

      for( size_t i = 0; i < hashes.size(); i++ )
      {
         ipdata.Clear();
         ip = TBanIpBasicSerialization::IdToKey( hashes[ i ][ "_id" ].String() );
         TBanIpBasicSerialization::Deserialize( hashes[ i ], ipdata );

         if (!ip.Undefined())
            banhash[ip] = ipdata;

      }

      if (banhash.size() > 0)
      {
         TBanIPHashYH::iterator  it;
         TDoubleBanIpBasicHashIt dit;

         it = banhash.begin();
         while (it != banhash.end())
         {
            //ui8 tv = (*it).second.cIntBanIp;
            //if (((*it).second.cIntBanIp & 0x02) > 0)
            //{
               dit = bih.find((*it).first);
               if (dit != bih.end())
               {
                  if ((index >= 0) && (index < TDoubleBanIpBasic::MAX_ELEMENTS))
                     (*dit).second.ban[index] = (*it).second;

               } else
               {
                  TDoubleBanIpBasic dbib;

                  dbib.ip = (*it).first;
                  if ((index >= 0) && (index < TDoubleBanIpBasic::MAX_ELEMENTS))
                     dbib.ban[index] = (*it).second;

                  bih[(*it).first] = dbib;
               }
            //}

            ++it;
         }

      }

   } else
   {
      if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
         LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "find (GetBanListManual)");

   }

}

bool TBanIPListItem::SetSetupBanTime(ui32 bantime, ui32 long_bantime)
{
   bool           res = true;
   bool           mongo_err   = false;
   nosql::HashMap sets;
   nosql::HashMap incrs;

   sets.clear();
   incrs.clear();

   if (bantime > MAX_BAN_HOURS)
      bantime = MAX_BAN_HOURS;
   if (long_bantime > MAX_BAN_HOURS_LONG)
      long_bantime = MAX_BAN_HOURS_LONG;

   sets[ BANSETUP_BANTIME ]     = bantime;
   sets[ BANSETUP_LONGBANTIME ] = long_bantime;

   if (!mongo_update_bansetup(mongo_err, sets, incrs))
   {
      if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
         LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "update (SetSetupBanTime)");

   }

   return res;
}

bool TBanIPListItem::GetSetupBanTime(ui32 &bantime, ui32 &long_bantime)
{
   bool           res          = true;
   bool           mongo_err    = false;
   TBanSetup      ipdata;
   bool           ipdata_empty = false;

   bantime      = MAX_BAN_HOURS;
   long_bantime = MAX_BAN_HOURS_LONG;

   if (mongo_read_bansetup(mongo_err, ipdata, ipdata_empty))
   {
      if (!ipdata_empty)
      {
         bantime      = ipdata.m_bantime;
         long_bantime = ipdata.m_long_bantime;

      }

   } else
   {
      if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
         LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "get (GetSetupBanTime)");

   }

   return res;
}

void TBanIPListItem::SetLockBasa()
{
   if (res_o != NULL)
      res_o->SetLockBasa();
}

void TBanIPListItem::UnLockBasa()
{
   if (res_o != NULL)
      res_o->UnLockBasa();
}

bool TBanIPListItem::IsLock()
{
   bool res = false;

   if (res_o != NULL)
      res = res_o->IsLock();

   return res;
}

TErrorWrite TBanIPListItem::CalcErrorStatistic()
{
   TErrorWrite res;

   if (res_o != NULL)
      res = res_o->CalcErrorStatistic();

   return res;
}

TErrorWrite TBanIPListItem::GetErrorStatistic()
{
   TErrorWrite res;

   if (res_o != NULL)
      res = res_o->GetErrorStatistic();

   return res;
}

void TBanIPListItem::FuncEvent()
{
   time_t tcurr = time(NULL);

   // cps   ip  
   if ((tcurr - m_ban_cps_last) >= 10)
   {
      TGuard< TMutex > g( m_Mutex );

      m_ban_cps = (float)m_ban_count_to_cps / (float)(tcurr - m_ban_cps_last);
      m_ban_cps_last = tcurr;
      m_ban_count_to_cps = 0;
   }

   //   ,   
   if (m_truncdaylist)
      TruncDayListNow();
}

void TBanIPListItem::TruncDayListNow()
{
   bool busy = false;
   TVector< nosql::HashMap > hashes;

   m_MutexTruncDayList.Acquire();

   hashes.clear();
   if (mongo_find(m_stortype, hashes))
   {
      TBanIPHashYH banhash;
      TBanIpBasic  ipdata;
      TString       id      = "";
      TKIPv6       ip;

      for( size_t i = 0; i < hashes.size(); i++ )
      {
         ipdata.Clear();
         ip = TBanIpBasicSerialization::IdToKey( hashes[ i ][ "_id" ].String() );
         TBanIpBasicSerialization::Deserialize( hashes[ i ], ipdata );

         if (!ip.Undefined())
            banhash[ip] = ipdata;

      }

      if (res_o != NULL)
      {
         if (res_o->RewriteDayList(&banhash, busy))
            m_truncdaylist = false;

      }

   } else
   {
      if ( (LogsGroup != NULL) && (LogsGroup->MongoEventLog() != NULL) )
         LogsGroup->MongoEventLog()->WriteMessageAndDataStatus(KERROR, "find (TruncDayListNow)");

   }

   m_MutexTruncDayList.Release();
}

void TBanIPListItem::TruncDayList()
{
   m_MutexTruncDayList.Acquire();

   m_truncdaylist = true;

   m_MutexTruncDayList.Release();
}

//************************************************************************************
//                               TBanIPListGeneral
//************************************************************************************

void  WriteThreadProc(void* par)
{
    TQueueRecord *qrec = NULL;

    TBanIPListGeneral* bilg = (TBanIPListGeneral *)par;

    if (bilg != NULL)
    {
       bilg->WriteThreadIDToLog();

       while( !bilg->WriteThreadShouldStop() )
       {
           if (bilg->GetQueue() != NULL)
           {
               qrec = bilg->GetQueue()->Get();
               if (qrec != NULL)
               {
                  switch (qrec->action)
                  {
                   case KADDBAN:
                                 bilg->AddBanIpA(qrec->ip, qrec->hours, qrec->IntBanIp, qrec->Manual, qrec->BlackList, qrec->Rule, qrec->sendtorbl);
                                 break;
                  };

                  delete qrec;
                  qrec = NULL;
               } else
               {
                  bilg->FuncEvent();
                  ::usleep(10000);
               }
           }
       }
    }

    bilg->WriteThreadStopped(true);
}

TBanIPListGeneral::TBanIPListGeneral(void *statipobj, TLogsGroup *LogsGroupA, TKConfig* configobjA, kipv6::TWhiteIPv6 *WhiteIpA, TNetKIPv6 *m_WhiteNetA, TString BanTextFile, TString BanIndexFile, TString Ban7TextFile, TString Ban7IndexFile, TChangeProperties *CPOA, TString &bandaylistfileA, TString &ban7daylistfileA, TString &bandaylistfile_dA, TString &ban7daylistfile_dA)
{
   BanObj  = NULL;
   Ban7Obj = NULL;

   LogsGroup = LogsGroupA;
   BanObj = new TBanIPListItem(MST_BANIP, statipobj, LogsGroupA, configobjA, WhiteIpA, m_WhiteNetA, BanTextFile, BanIndexFile, CPOA, "BAN", bandaylistfileA, bandaylistfile_dA);
   Ban7Obj = new TBanIPListItem(MST_BAN7IP, statipobj, LogsGroupA, configobjA, WhiteIpA, m_WhiteNetA, Ban7TextFile, Ban7IndexFile, CPOA, "BAN7", ban7daylistfileA, ban7daylistfile_dA);
   m_queue = new TBanQueue(LogsGroupA, "queue");
}

TBanIPListGeneral::~TBanIPListGeneral()
{
   StopWriteThread();
   while(!WriteThreadStopped())
      ::sleep(1);
   delete m_WriteThread;
   m_WriteThread = NULL;

   if (m_queue != NULL)
   {
      delete m_queue;
      m_queue = NULL;
   }
   if (BanObj != NULL)
   {
      delete BanObj;
      BanObj = NULL;
   }
   if (Ban7Obj != NULL)
   {
      delete Ban7Obj;
      Ban7Obj = NULL;
   }
}

bool TBanIPListGeneral::InitAfterFork()
{
   bool res = true;

   StartWriteThread();

   return res;
}

TString TBanIPListGeneral::PrintToText(TDoubleBanIpBasicList &list, TString mainhost)
{
   TString                  res = "";
   TDoubleBanIpBasicListIt  bit;
   TString                  field1 = "";
   TString                  field2 = "";
   TString                  field3 = "";
   TString                  field4 = "";
   TString                  field5 = "";
   TString                  field6 = "";
   TString                  field7 = "";
   TString                  field8 = "";
   TString                  remurl = "";
   TString                  ipurl  = "";
   TKIPv6                  ip     = TKIPv6();

   bit = list.begin();
   while (bit != list.end())
   {
         ip = (*bit).ip;

         remurl = "<A href='" + mainhost + "askdelbanip?ip=" + ip.toStroka() + "'>remove ban</A>";
         ipurl = "<A href='" + mainhost + "viewipstat?ip=" + ip.toStroka() + "'>" + ip.toStroka() + "</A>";
         field1 = ipurl;
         field2 = remurl;

         if ((*bit).ban[0].tAction > 0)
         {
            field3 = ConvertTime3((*bit).ban[0].tAction) + " &nbsp; (" + IntToStroka((*bit).ban[0].chours) + ")";
            field4 = IntToStroka((*bit).ban[0].cMessage);
            field5 = "";
            if (((*bit).ban[0].cIntBanIp & 0x01) > 0)
               field5 = field5 + "INTBAN &nbsp; ";
            if (((*bit).ban[0].cIntBanIp & 0x02) > 0)
            {
               field5 = field5 + "MANUAL (\"" + TString((*bit).ban[0].cUser) + "\") &nbsp; ";
            }
            if (((*bit).ban[0].cIntBanIp & 0x04) > 0)
               field5 = field5 + "BLACKLIST &nbsp; ";
            if (((*bit).ban[0].cIntBanIp & 0x08) > 0)
               field5 = field5 + "RULE &nbsp; ";
            field5 = field5 + " &nbsp; ";
         } else
         {
            field3 = " - ";
            field4 = " &nbsp; ";
            field5 = " &nbsp; ";
         }

         if ((*bit).ban[1].tAction > 0)
         {
            field6 = ConvertTime3((*bit).ban[1].tAction) + " &nbsp; (" + IntToStroka((*bit).ban[1].chours) + ")";
            field7 = IntToStroka((*bit).ban[1].cMessage);
            field8 = "";
            if (((*bit).ban[1].cIntBanIp & 0x01) > 0)
               field8 = field8 + "INTBAN &nbsp; ";
            if (((*bit).ban[1].cIntBanIp & 0x02) > 0)
               field8 = field8 + "MANUAL (\"" + TString((*bit).ban[1].cUser) + "\") &nbsp; ";
            if (((*bit).ban[1].cIntBanIp & 0x04) > 0)
               field8 = field8 + "BLACKLIST &nbsp; ";
            if (((*bit).ban[1].cIntBanIp & 0x08) > 0)
               field8 = field8 + "RULE &nbsp; ";
            field8 = field8 + "&nbsp;";
         } else
         {
            field6 = " - ";
            field7 = " &nbsp; ";
            field8 = " &nbsp; ";
         }

         res = res + "<tr>";
         res = res + "<td>" + field1 + " &nbsp; </td>";
         res = res + "<td align='center'>" + field2 + " &nbsp; </td>";
         res = res + "<td>" + field3 + " &nbsp; </td>";
         res = res + "<td>" + field4 + " &nbsp; </td>";
         res = res + "<td>" + field5 + " &nbsp; </td>";
         res = res + "<td>" + field6 + " &nbsp; </td>";
         res = res + "<td>" + field7 + " &nbsp; </td>";
         res = res + "<td>" + field8 + " &nbsp; </td>";
         res = res + "</tr>";

         ++bit;
   }

   return res;
}

bool TBanIPListGeneral::AddBanIpWOWA(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, const TString &user, const bool longb, ui32 &sendtorbl)
{
   bool res = false;

   if (BanObj != NULL)
      res = BanObj->AddBanIpWOW(ip, hours, IntBanIpA, ManualA, BlackListA, user, longb, sendtorbl);

   return res;
}

bool TBanIPListGeneral::AddBan7IpWOWA(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, const TString &user, ui32 &sendtorbl)
{
   bool res = false;

   if (Ban7Obj != NULL)
      res = Ban7Obj->AddBanIpWOW(ip, hours, IntBanIpA, ManualA, BlackListA, user, false, sendtorbl);

   return res;
}

ui32 TBanIPListGeneral::BanIpListCheck(ui32 &allcount, ui32 &returncount, ui32 &whiteipcount, ui32 &rescount, bool &prcheck)
{
   ui32 res = 0;

   if (BanObj != NULL)
      res = BanObj->BanIpListCheck(allcount, returncount, whiteipcount, rescount, prcheck);

   return res;
}

ui32 TBanIPListGeneral::BanIpListCheck7(ui32 &allcount, ui32 &returncount, ui32 &whiteipcount, ui32 &rescount, bool &prcheck)
{
   ui32 res = 0;

   if (Ban7Obj != NULL)
      res = Ban7Obj->BanIpListCheck(allcount, returncount, whiteipcount, rescount, prcheck);

   return res;
}

int TBanIPListGeneral::IsBanIp(TKIPv6 ip, ui32 *pcMess, ui32 *pcsec, bool &ban7)
{
   int res = 0;

   ban7 = false;

   if (BanObj != NULL)
      res = BanObj->IsBanIp(ip, pcMess, pcsec);

   if (Ban7Obj != NULL)
   {
      ui32 pcMesst = 0;
      ui32 pcsect  = 0;

      if (Ban7Obj->IsBanIp(ip, &pcMesst, &pcsect) > 0)
         ban7 = true;
   }

   return res;
}

void TBanIPListGeneral::IsBanIpExt(TKIPv6 ip, bool &ban, ui16 &ban_hours, ui8 &ban_pr, bool &ban7, ui16 &ban7_hours, ui8 &ban7_pr)
{
   if (BanObj != NULL)
      BanObj->IsBanIpExt(ip, ban, ban_hours, ban_pr);
   if (Ban7Obj != NULL)
      Ban7Obj->IsBanIpExt(ip, ban7, ban7_hours, ban7_pr);
}

bool TBanIPListGeneral::AddBanIp(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, ui32 sendtorbl)
{
   bool         res     = true;
   TQueueRecord *value  = NULL;

   if (m_queue != NULL)
   {
      value = new TQueueRecord(KADDBAN, ip, hours, IntBanIpA, ManualA, BlackListA, RuleA, "", sendtorbl);
      m_queue->Add(value);
   }

   return res;
}

bool TBanIPListGeneral::AddBanIpA(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, ui32 sendtorbl)
{
   bool res = false;

   if (BanObj != NULL)
      res = BanObj->AddBanIp(ip, hours, IntBanIpA, sendtorbl);

   return res;
}

bool TBanIPListGeneral::AddBanIpWOW(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, const TString &user, const bool longb, ui32 &sendtorbl)
{
   bool res = false;

   res = AddBanIpWOWA(ip, hours, IntBanIpA, ManualA, BlackListA, RuleA, user, longb, sendtorbl);

   return res;
}

bool TBanIPListGeneral::AddBan7IpWOW(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, const TString &user, ui32 &sendtorbl)
{
   bool res = false;

   res = AddBan7IpWOWA(ip, hours, IntBanIpA, ManualA, BlackListA, RuleA, user, sendtorbl);

   return res;
}

TBanStat TBanIPListGeneral::GetStat()
{
   TBanStat res;

   if (BanObj != NULL)
      res = BanObj->GetStat();

   return res;
}

TBanStat TBanIPListGeneral::GetStat7()
{
   TBanStat res;

   if (Ban7Obj != NULL)
      res = Ban7Obj->GetStat();

   return res;
}

bool TBanIPListGeneral::RemoveBanIp(TKIPv6 ip)
{
   bool res = false;
   bool res1 = false;
   bool res2 = false;

   if (BanObj != NULL)
      res1 = BanObj->RemoveBanIp(ip);

   if (Ban7Obj != NULL)
      res2 = Ban7Obj->RemoveBanIp(ip);

   res = res1 || res2;

   return res;
}

TBanRes TBanIPListGeneral::GetBanStatus(TKIPv6 ip, ui16 &AddBanTimeA, TBanIpBasic &tban, TBanIpBasic &tban7)
{
   TBanRes     res, res1, res2;
   TBanIpBasic tbib;

   if (BanObj != NULL)
   {
      res1 = BanObj->GetBanStatus(ip, AddBanTimeA, tbib);
      tban = tbib;
   }
   if (Ban7Obj != NULL)
   {
      res2 = Ban7Obj->GetBanStatus(ip, AddBanTimeA, tbib);
      tban7 = tbib;
   }
   res.ip         = ip;
   res.ban        = res1.ban;
   res.remainban  = res1.remainban;
   res.ban7       = res2.ban;
   res.remainban7 = res2.remainban;

   return res;
}

void TBanIPListGeneral::WriteFullListInfo2(TDoubleBanIpBasicList &banstatlist, ui8 sorttype, ui8 sorttype2)
{
   TDoubleBanIpBasicHash   bih;
   TDoubleBanIpBasicHashIt it;

   //BanObj->GetBanList(bih, true, 0);
   //Ban7Obj->GetBanList(bih, true, 1);
   BanObj->GetBanListAll(bih, 0);
   Ban7Obj->GetBanListAll(bih, 1);

   it = bih.begin();
   while ( it != bih.end() )
   {
            (*it).second.sorttype = sorttype2;
            switch (sorttype)
            {
            case 1:
                     for (int i = 0; i < TDoubleBanIpBasic::MAX_ELEMENTS; i++)
                     {
                        if (((*it).second.ban[i].cIntBanIp & 0x01) > 0)
                        {
                           banstatlist.push_back((*it).second);
                           break;
                        }
                     }
                     break;
            case 2:
                     for (int i = 0; i < TDoubleBanIpBasic::MAX_ELEMENTS; i++)
                     {
                        if (((*it).second.ban[i].cIntBanIp & 0x02) > 0)
                        {
                           banstatlist.push_back((*it).second);
                           break;
                        }
                     }
                     break;
            case 3:
                     for (int i = 0; i < TDoubleBanIpBasic::MAX_ELEMENTS; i++)
                     {
                        if (((*it).second.ban[i].cIntBanIp & 0x04) > 0)
                        {
                           banstatlist.push_back((*it).second);
                           break;
                        }
                     }
                     break;
            case 4:
                     for (int i = 0; i < TDoubleBanIpBasic::MAX_ELEMENTS; i++)
                     {
                        if (((*it).second.ban[i].cIntBanIp & 0x08) > 0)
                        {
                           banstatlist.push_back((*it).second);
                           break;
                        }
                     }
                     break;
            default:
                     banstatlist.push_back((*it).second);
            };

            ++it;
   }
   bih.clear();
   banstatlist.sort();
}

/*
TString TBanIPListGeneral::WriteFullListInfo(TString mainhost, ui8 sorttype, ui8 sorttype2)
{
   TString  res = "";

   if ((BanObj != NULL) && (Ban7Obj != NULL))
   {
      TDoubleBanIpBasicHashIt it;
      TString                  field1       = "";
      TString                  field2       = "";
      TString                  field3       = "";
      TString                  field4       = "";
      TString                  field5       = "";
      TString                  field6       = "";
      TString                  field7       = "";
      TDoubleBanIpBasicList   banstatlist;
      TDoubleBanIpBasicListIt bit;
      TString                  remurl       = "";
      TString                  ipurl        = "";
      TString                  title        = "";
      TString                  baninfo_key1 = "";
      TString                  baninfo_key2 = "";
      TString                  baninfo_key3 = "";
      TString                  baninfo_key4 = "";
      TString                  baninfo_key5 = "";
      TString                  baninfo_key  = "";
      TDoubleBanIpBasicHash   bih;
      TString                  sm1 = "", sm2 = "", sm3 = "", sm4 = "", sm5 = "";

      switch (sorttype2)
      {
       case 1:
                sm2 = "*";
                break;
       case 2:
                sm3 = "*";
                break;
       case 3:
                sm4 = "*";
                break;
       case 4:
                sm5 = "*";
                break;
       default:
                sm1 = "*";
      };

      field1 = "<A href='" + mainhost + "baninfo?sorttype=" + IntToStroka(sorttype) + "&sortparam=0'>" + sm1 + "BAN IP</A>";
      field2 = "<A href='" + mainhost + "baninfo?sorttype=" + IntToStroka(sorttype) + "&sortparam=2'>" + sm3 + "BAN TIME</A>&nbsp;<A href='" + mainhost + "baninfo?sorttype=" + IntToStroka(sorttype) + "&sortparam=1'>(" + sm2 + "HOURS)</A>";
      field3 = "MESS COUNT";
      field4 = "BAN KIND";
      field5 = "<A href='" + mainhost + "baninfo?sorttype=" + IntToStroka(sorttype) + "&sortparam=4'>" + sm5 + "BAN TIME</A>&nbsp;<A href='" + mainhost + "baninfo?sorttype=" + IntToStroka(sorttype) + "&sortparam=3'>(" + sm4 + "HOURS)</A>";
      field6 = "MESS COUNT";
      field7 = "BAN KIND";

      if (false)
      {
         if ((sorttype == 0) || (sorttype > 4))
            baninfo_key1 = "<I><B>ALL BAN IP</B></I>";
         else
            baninfo_key1 = "<form action='" + mainhost + "baninfo' method='GET' enctype='text/plain'><input type='hidden' size='10' name='sorttype' value='0'><input type='submit' size='20' value='All ban ip'></form> &nbsp; ";
      }

      if (sorttype == 1)
         baninfo_key2 = "<I><B>INTERNAL BAN IP</B></I>";
      else
         baninfo_key2 = "<form action='" + mainhost + "baninfo' method='GET' enctype='text/plain'><input type='hidden' size='10' name='sorttype' value='1'><input type='submit' size='20' value='Internal ban ip'></form> &nbsp; ";

      if (sorttype == 2)
         baninfo_key3 = "<I><B>MANUAL BAN IP</B></I>";
      else
         baninfo_key3 = "<form action='" + mainhost + "baninfo' method='GET' enctype='text/plain'><input type='hidden' size='10' name='sorttype' value='2'><input type='submit' size='20' value='Manual ban ip'></form> &nbsp; ";

      if (sorttype == 3)
         baninfo_key4 = "<I><B>BLACKLIST BAN IP</B></I>";
      else
         baninfo_key4 = "<form action='" + mainhost + "baninfo' method='GET' enctype='text/plain'><input type='hidden' size='10' name='sorttype' value='3'><input type='submit' size='20' value='Blacklist ban ip'></form> &nbsp; ";

      if (false)
      {
         if (sorttype == 4)
            baninfo_key5 = "<I><B>RULE BAN IP</B></I>";
         else
            baninfo_key5 = "<form action='" + mainhost + "baninfo' method='GET' enctype='text/plain'><input type='hidden' size='10' name='sorttype' value='4'><input type='submit' size='20' value='Rule ban ip'></form> &nbsp; ";
      }

      baninfo_key = "<br><table width='100%' cellspacing='0' cellpadding='0'><tr><td width='20%' align='center'>" + baninfo_key1 + "</td><td width='20%' align='center'>" + baninfo_key2 + "</td><td width='20%' align='center'>" + baninfo_key3 + "</td><td width='20%' align='center'>" + baninfo_key4 + "</td><td width='20%' align='center'>" + baninfo_key5 + "</td></tr></table>";

      if ( (!false) && (sorttype != 1) && (sorttype != 2) && (sorttype != 3) )
      {
         res = res + "Function is disconnected.";

      } else
      {
         res = res + "<table border='1' width='100%' cellspacing='0' cellpadding='4' bgcolor=lemonchiffon>\n";
         res = res + "<tr><td width='100%' colspan=8 align='center'>" + baninfo_key + "</td></tr>";
         res = res + "<tr bgcolor='Moccasin'>";
         res = res + "<td width='20%' colspan='2'>&nbsp;</td>";
         res = res + "<td colspan='3' width='40%' align='center'><b>BAN</b></td>";
         res = res + "<td colspan='3' width='40%' align='center'><b>BAN7</b></td>";
         res = res + "</tr>";
         res = res + "<tr bgcolor='Moccasin' align='center'>";
         res = res + "<td width='20%' colspan='2'><b>" + field1 + "</b></td>";
         res = res + "<td width='15%'><b>" + field2 + "</b></td>";
         res = res + "<td width='10%'><b>" + field3 + "</b></td>";
         res = res + "<td width='15%'><b>" + field4 + "</b></td>";
         res = res + "<td width='15%'><b>" + field5 + "</b></td>";
         res = res + "<td width='10%'><b>" + field6 + "</b></td>";
         res = res + "<td width='15%'><b>" + field7 + "</b></td>";
         res = res + "</tr>";

         BanObj->GetBanList(bih, !false, 0);
         Ban7Obj->GetBanList(bih, !false, 1);

         it = bih.begin();
         while ( it != bih.end() )
         {
            (*it).second.sorttype = sorttype2;
            switch (sorttype)
            {
            case 1:
                     for (int i = 0; i < TDoubleBanIpBasic::MAX_ELEMENTS; i++)
                     {
                        if (((*it).second.ban[i].cIntBanIp & 0x01) > 0)
                        {
                           banstatlist.push_back((*it).second);
                           break;
                        }
                     }
                     break;
            case 2:
                     for (int i = 0; i < TDoubleBanIpBasic::MAX_ELEMENTS; i++)
                     {
                        if (((*it).second.ban[i].cIntBanIp & 0x02) > 0)
                        {
                           banstatlist.push_back((*it).second);
                           break;
                        }
                     }
                     break;
            case 3:
                     for (int i = 0; i < TDoubleBanIpBasic::MAX_ELEMENTS; i++)
                     {
                        if (((*it).second.ban[i].cIntBanIp & 0x04) > 0)
                        {
                           banstatlist.push_back((*it).second);
                           break;
                        }
                     }
                     break;
            case 4:
                     for (int i = 0; i < TDoubleBanIpBasic::MAX_ELEMENTS; i++)
                     {
                        if (((*it).second.ban[i].cIntBanIp & 0x08) > 0)
                        {
                           banstatlist.push_back((*it).second);
                           break;
                        }
                     }
                     break;
            default:
                     banstatlist.push_back((*it).second);
            };

            ++it;
         }

         bih.clear();

         banstatlist.sort();
         res = res + PrintToText(banstatlist, mainhost);
         banstatlist.clear();

         res = res + "</table>";
      }
   }

   return res;
}
*/

void TBanIPListGeneral::SetLockBasa()
{
   if (BanObj != NULL)
      BanObj->SetLockBasa();

   if (Ban7Obj != NULL)
      Ban7Obj->SetLockBasa();
}

void TBanIPListGeneral::UnLockBasa()
{
   if (BanObj != NULL)
      BanObj->UnLockBasa();

   if (Ban7Obj != NULL)
      Ban7Obj->UnLockBasa();
}

bool TBanIPListGeneral::IsLock()
{
   bool res = false;

   if (BanObj != NULL)
      res = BanObj->IsLock();

   return res;
}

void TBanIPListGeneral::Midnight()
{
   if (m_queue != NULL)
      m_queue->Midnight();
}

TErrorWrite TBanIPListGeneral::CalcErrorStatistic()
{
   TErrorWrite res;

   if (BanObj != NULL)
      res = BanObj->CalcErrorStatistic();

   return res;
}

TErrorWrite TBanIPListGeneral::GetErrorStatistic()
{
   TErrorWrite res;

   if (BanObj != NULL)
      res = BanObj->GetErrorStatistic();

   return res;
}

void TBanIPListGeneral::StartWriteThread()
{
    m_MutexWriteThread.Acquire();
    m_StopWriteThread = false;
    m_WriteThread = new TThread((TThread::TThreadProc)&WriteThreadProc, this);
    m_WriteThread->Start();
    m_MutexWriteThread.Release();
}

void TBanIPListGeneral::StopWriteThread()
{
    m_MutexWriteThread.Acquire();
    m_StopWriteThread = true;
    m_MutexWriteThread.Release();
}

void TBanIPListGeneral::WriteThreadStopped(bool Stopped)
{
    m_MutexWriteThread.Acquire();
    m_StopWriteThread = !Stopped;
    m_MutexWriteThread.Release();
}

bool TBanIPListGeneral::WriteThreadStopped()
{
    return !m_StopWriteThread;
}

TBanQueueStat TBanIPListGeneral::GetQueueStat()
{
   TBanQueueStat res;

   if (m_queue != NULL)
      res = m_queue->GetStat();

   return res;
}

void TBanIPListGeneral::FuncEvent()
{
   ui32 msek  = 0;
   ui32 allcount = 0, returncount = 0, whiteipcount = 0, rescount = 0;
   bool prcheck = false;

   msek = BanIpListCheck(allcount, returncount, whiteipcount, rescount, prcheck);
   if ( (prcheck) && (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
   {
      LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "BANIPLIST(BAN): list check in %u msec (allcount=%u, returncount=%u, whiteipcount=%u, rescount=%u)", msek, allcount, returncount, whiteipcount, rescount);
      LogsGroup->ActionLog()->FFlush();

   }

   allcount       = 0;
   returncount    = 0;
   whiteipcount   = 0;
   rescount       = 0;
   prcheck        = false;

   msek = BanIpListCheck7(allcount, returncount, whiteipcount, rescount, prcheck);
   if ( (prcheck) && (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
   {
      LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "BANIPLIST(BAN7): list check in %u msec (allcount=%u, returncount=%u, whiteipcount=%u, rescount=%u)", msek, allcount, returncount, whiteipcount, rescount);
      LogsGroup->ActionLog()->FFlush();

   }

   if (BanObj != NULL)
      BanObj->FuncEvent();

   if (Ban7Obj != NULL)
      Ban7Obj->FuncEvent();
}

void TBanIPListGeneral::TruncDayList()
{
   if (BanObj != NULL)
      BanObj->TruncDayList();

   if (Ban7Obj != NULL)
      Ban7Obj->TruncDayList();
}

void TBanIPListGeneral::WriteThreadIDToLog()
{
   int thread_id = -1;

#ifndef _win_
   thread_id = syscall(SYS_gettid);
#endif

   if ( (LogsGroup != NULL) && (LogsGroup->GetDebugInfoLog() != NULL) )
      LogsGroup->GetDebugInfoLog()->WriteMessageAndDataStatus(KMESSAGE, "THREADID % 9d: BAN_IP_LIST", thread_id);
}

bool TBanIPListGeneral::SetSetupBanTime(ui32 bantime, ui32 long_bantime)
{
   bool res = true;

   if (BanObj != NULL)
      res = BanObj->SetSetupBanTime(bantime, long_bantime);

   return res;
}

bool TBanIPListGeneral::GetSetupBanTime(ui32 &bantime, ui32 &long_bantime)
{
   bool res = true;

   if (BanObj != NULL)
   {
      res = BanObj->GetSetupBanTime(bantime, long_bantime);

   } else
   {
      bantime      = TBanIPListItem::MAX_BAN_HOURS;
      long_bantime = TBanIPListItem::MAX_BAN_HOURS_LONG;
   }

   return res;
}

ui32 TBanIPListGeneral::RemainBan(TBanIpBasic &ipdata)
{
   ui32 res = 0;

   if (BanObj != NULL)
      res = BanObj->RemainBan(ipdata);

   return res;
}

ui32 TBanIPListGeneral::RemainBan7(TBanIpBasic &ipdata)
{
   ui32 res = 0;

   if (Ban7Obj != NULL)
      res = Ban7Obj->RemainBan(ipdata);

   return res;
}

void TBanIPListGeneral::SetLastBanTimeNew()
{
   if (BanObj != NULL)
      BanObj->SetLastBanTimeNew();

   if (Ban7Obj != NULL)
      Ban7Obj->SetLastBanTimeNew();
}
