#pragma once

#include "util/generic/hash.h"
#include "util/system/mutex.h"
#include "util/system/thread.h"
#include "library/cpp/deprecated/atomic/atomic.h"
#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/tools/so-common/tnetipv6.h>
#include <mail/so/spamstop/tools/so-common/tkipv6classes.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "tbasesstore_other.h"
#include "tlogsgroup.h"
#include <list>
#include "tstatiptypes.h"
#include "blackwhiteip_k.h"
#include <mail/so/spamstop/tools/so-common/thashipv6.h>
#include "tbasesstore_types.h"
#include "tbaniplist_types.h"
#include "tstoragenosql.h"

#include <mail/so/spamstop/tools/so-common/serializehelper.h>

typedef enum TAddBanType {KADDBAN, KADDBANWOW, KADDBAN7WOW, KADDBANUNKNOWN};

struct TQueueRecord
{
   TAddBanType action;
   TKIPv6      ip;
   ui32        hours;
   bool        IntBanIp;
   bool        Manual;
   bool        BlackList;
   bool        Rule;
   TString      user;
   ui32        sendtorbl;

   TQueueRecord()
   {
      Clear();
   }

   TQueueRecord(TAddBanType actionA, TKIPv6 ipA, ui32 hoursA, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, const TString &userA, ui32 sendtorblA)
   {
      action    = actionA;
      ip        = ipA;
      hours     = hoursA;
      IntBanIp  = IntBanIpA;
      Manual    = ManualA;
      BlackList = BlackListA;
      Rule      = RuleA;
      user      = userA;
      sendtorbl = sendtorblA;
   }

   void Clear()
   {
      action     = KADDBANUNKNOWN;
      ip         = TKIPv6();
      hours      = 0;
      IntBanIp   = false;
      Manual     = false;
      BlackList  = false;
      Rule       = false;
      user       = "";
      sendtorbl  = 0;
   }
};

struct TBanQueueStat
{
   ui32  m_today_count;
   ui64  m_today_in_count;
   ui64  m_today_out_count;
   ui64  m_today_lost_count;
   ui64  m_yesterday_in_count;
   ui64  m_yesterday_out_count;
   ui64  m_yesterday_lost_count;
   float m_cps;

   TBanQueueStat()
   {
      m_today_count          = 0;
      m_today_in_count       = 0;
      m_today_out_count      = 0;
      m_today_lost_count     = 0;
      m_yesterday_in_count   = 0;
      m_yesterday_out_count  = 0;
      m_yesterday_lost_count = 0;
      m_cps                  = 0;
   }
};

typedef std::list<TQueueRecord *> TBanQueueList;
typedef TBanQueueList::iterator   TBanQueueListIt;

class TBanQueue
{
private:
         static const int  MAX_ELEMENT_COUNT = 15000;

         TBanQueueList     blist;
         TMutex            m_Mutex;
         ui64              m_today_in_count;
         ui64              m_today_out_count;
         ui64              m_today_lost_count;
         ui64              m_yesterday_in_count;
         ui64              m_yesterday_out_count;
         ui64              m_yesterday_lost_count;
         float             m_cps;
         TLogsGroup        *LogsGroup;
         TString            m_ident;

         ui32              m_request;
         time_t            m_last_calc_cps;

         void Lock();
         void UnLock();
         void CalcCPS();
         void ReCalcCPS();
public:
         TBanQueue(TLogsGroup *LogsGroupA, const TString &ident);
         ~TBanQueue();

         void           Add(TQueueRecord *value);
         TQueueRecord   *Get();
         void           Midnight();
         TBanQueueStat  GetStat();

};

typedef THashMap<TKIPv6, TBanIpBasic>  TBanIPHashYH;

typedef enum TBuffType{KIDX, KTXT, KDAYLIST, KDAYLISTD, KUNKNOWN2};

struct TDataForWrite
{
   TBuffType is_txt;
   char      *buf;
   size_t    size;
   size_t    count;

   TDataForWrite()
   {
      is_txt = KUNKNOWN2;
      buf    = NULL;
      size   = 0;
      count  = 0;
   }

   TDataForWrite(TBuffType is_txtA, const void *bufA, size_t sizeA, size_t countA)
   {
      buf   = NULL;
      size  = 0;
      if ( (bufA != NULL) && (sizeA > 0) )
      {
         buf = new char[sizeA];
         memcpy(buf, bufA, sizeA);
         size = sizeA;
      }
      count = countA;
      is_txt = is_txtA;
   }

   TDataForWrite(const TDataForWrite &value)
   {
      buf   = NULL;
      size  = 0;
      if ( (value.buf != NULL) && (value.size > 0) )
      {
         buf = new char[value.size];
         memcpy(buf, value.buf, value.size);
         size = value.size;
      }
      count = value.count;
      is_txt = value.is_txt;
   }

   TDataForWrite &operator=(const TDataForWrite &value)
   {
      if (buf != NULL)
      {
         delete[] buf;
         buf = NULL;
      }
      size  = 0;

      if ( (value.buf != NULL) && (value.size > 0) )
      {
         buf = new char[value.size];
         memcpy(buf, value.buf, value.size);
         size = value.size;
      }
      count = value.count;
      is_txt = value.is_txt;

      return *this;
   }

   ~TDataForWrite()
   {
      if (buf != NULL)
      {
         delete[] buf;
         buf = NULL;
      }
      size  = 0;
      count = 0;
   }
};

typedef std::list<TDataForWrite>        TLockPDataList;
typedef TLockPDataList::iterator        TLockPDataListIt;

//#define ENABLE_WRITE_IDX_FILES

class TSaveBanNew
{
private:
         TString            bantextfile;
         TString            banindexfile;
         TString            bandaylistfile;
         TString            bandaylistfile_d;
         TMutex            m_Mutex;
         FILE              *hindex;
         FILE              *htext;
         FILE              *hdaylist;
         FILE              *hdaylist_d;
         bool              CloseFile;
         TLogsGroup        *LogsGroup;
         bool              m_lock;
         TLockPDataList    locklist;
         ui32              m_lostlockrecord_idx;
         ui32              m_lostlockrecord_txt;
         ui32              m_lostlockrecord_daylist;
         ui32              m_lostlockrecord_daylistd;
         static const ui32 MAX_SIZE_LOCK_LIST = 10000;
         TString            m_ident;

         void              Lock();
         void              UnLock();
         int               WriteIdxA(void *buf, size_t size, size_t count);
         int               WriteTxtA(void *buf, size_t size, size_t count);
         int               WriteDayListA(const void *buf, size_t size, size_t count);
         int               WriteDayListDA(const void *buf, size_t size, size_t count);

         TMutex            m_MutexErrorWrite;
         TErrorWrite       writeerror;
         TErrorWrite       writeerror_out;
         void              WriteLastWriteMoment();
         void              WriteErrorIdx();
         void              WriteErrorTxt();

public:
         TSaveBanNew(TString m_identA, TString bantextfileA, TString banindexfileA, bool CloseFileA, TLogsGroup *LogsGroupA, TString &bandaylistfileA, TString &bandaylistfile_dA);
         ~TSaveBanNew();

         int          WriteTxt(const TString &ips);                    //banip.txt
         int          WriteIdx(TBanIpBasic *value);                   //banip.idx
         int          WriteDayList(const TString &ips);                //bandayip.txt
         int          WriteDayListD(TBanIpBasic *value);              //bandayip.idx

         bool         WriteFullList(TBanIPHashYH *data);              //banip.txt, banip.idx
         bool         RewriteDayList(TBanIPHashYH *data, bool &busy); //bandayip.txt, bandayip.idx

         void         SetLockBasa();
         void         UnLockBasa();
         bool         IsLock();

         TErrorWrite  CalcErrorStatistic();
         TErrorWrite  GetErrorStatistic();
};

class TBanIPListItem
{
public:
      static const ui32 MAX_BAN_HOURS      = 72;
      static const ui32 MAX_BAN_HOURS_LONG = 720;

private:
      void              *m_statipobj;
      TStorageType      m_stortype;
      TMutex            m_Mutex;
      TMutex            m_MutexTruncDayList;
   kipv6::TWhiteIPv6 *m_WhiteIp;
      TNetKIPv6         *m_WhiteNet;
      TString            m_bantextfile, m_banindexfile;
      TChangeProperties *CPO;
      TLogsGroup        *LogsGroup;
      TAtomic           m_LastBanTime;
      TAtomic           m_LastIpListCheck;
      TAtomic           m_ReturnCount;
      TAtomic           m_BanCount;
      TSaveBanNew       *res_o;
      TString            m_ident;

      time_t            m_ban_cps_last;
      float             m_ban_cps;
      ui32              m_ban_count_to_cps;
      bool              m_truncdaylist;

      bool              Init(TStorageType stortype, void *statipobj, TLogsGroup *LogsGroupA, TKConfig* configobjA, kipv6::TWhiteIPv6 *WhiteIpA, TNetKIPv6 *m_WhiteNetA, TString BanTextFile, TString BanIndexFile, TChangeProperties *CPOA, TString &bandaylistfileA, TString &bandaylistfile_dA);

      void              Lock();
      void              UnLock();

      ui32              AddData32(ui32 &value, ui32 addv);
      void              AddToHash(nosql::HashMap &hash, const TString &fname, i64 value);

      bool              IpAction(TBanIpBasic *pbanip, int addBanTime, time_t lastBanTime, ui32 &remain);                       //true - ip in ban
      bool              WriteAddBanIpList(TBanIpBasic *pbanip, ui16 m_AddBanTime);                                          //write to banip.txt and banip.idx                                                 //calc crc summ
      void              CheckBanFunc(const TString &ident_func, TKIPv6 ip, bool err_update, ui32 hours, ui32 sendtorbl);

      bool              mongo_read_banip(TStorageType stortype, TKIPv6 ip, bool &mongo_err, TBanIpBasic &data, bool &empty);
      bool              mongo_update_banip(TStorageType stortype, TKIPv6 ip, bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs);
      i64               mongo_banip_basa_size(TStorageType stortype);
      bool              mongo_find(TStorageType stortype, TVector< nosql::HashMap > &hashes);
      bool              mongo_erase(TStorageType stortype, TKIPv6 ip, bool &mongo_err);
      bool              mongo_read_bansetup(bool &mongo_err, TBanSetup &data, bool &empty);
      bool              mongo_update_bansetup(bool &mongo_err, nosql::HashMap &sets, nosql::HashMap &incrs);

public:
      TBanIPListItem(TStorageType stortype, void *statipobj, TLogsGroup *LogsGroupA, TKConfig* configobjA, kipv6::TWhiteIPv6 *WhiteIpA, TNetKIPv6 *m_WhiteNetA, TString BanTextFile, TString BanIndexFile, TChangeProperties *CPOA, TString ident, TString &bandaylistfileA, TString &bandaylistfile_dA);
      ~TBanIPListItem();

      int            IsBanIp(TKIPv6 ip, ui32 *pcMess, ui32 *pcsec);
      int            IsBanIpExt(TKIPv6 ip, bool &ban, ui16 &ban_hours, ui8 &ban_pr);
      bool           AddBanIp(TKIPv6 ip, ui32 hours, bool IntBanIpA, ui32 sendtorbl);
      bool           AddBanIpWOW(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, const TString &user, const bool longb, ui32 &sendtorbl);
      ui32           BanIpListCheck(ui32 &allcount, ui32 &returncount, ui32 &whiteipcount, ui32 &rescount, bool &prcheck);  //���������� ����������������� ��������� banip ����� � ����
      TBanStat       GetStat();
      bool           RemoveBanIp(TKIPv6 ip);
      TBanRes        GetBanStatus(TKIPv6 ip, ui16 &AddBanTimeA, TBanIpBasic &tbi);
      //void           GetBanList(TDoubleBanIpBasicHash &bih, bool exclude_rule_record, int index);
      void           GetBanListAll(TDoubleBanIpBasicHash &bih, int index);

      bool           SetSetupBanTime(ui32 bantime, ui32 long_bantime);
      bool           GetSetupBanTime(ui32 &bantime, ui32 &long_bantime);

      void           SetLockBasa();
      void           UnLockBasa();
      bool           IsLock();

      TErrorWrite    CalcErrorStatistic();
      TErrorWrite    GetErrorStatistic();

      void           FuncEvent();
      void           TruncDayListNow();
      void           TruncDayList();

      ui32           RemainBan(TBanIpBasic &ipdata);
      void           SetLastBanTimeNew();
};

class TBanIPListGeneral
{
public:
         TBanIPListItem    *BanObj;
         TBanIPListItem    *Ban7Obj;
         TBanQueue         *m_queue;
         TThread           *m_WriteThread;
         bool              m_StopWriteThread;
         TMutex            m_MutexWriteThread;
         TLogsGroup        *LogsGroup;

         TString            PrintToText(TDoubleBanIpBasicList &list, TString mainhost);
         bool              AddBanIpWOWA(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, const TString &user, const bool longb, ui32 &sendtorbl); //���������� true - ���� ����� ����� � ���� ��� ����������
         bool              AddBan7IpWOWA(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, const TString &user, ui32 &sendtorbl);//���������� true - ���� ����� ����� � ���� ��� ����������

         ui32              BanIpListCheck(ui32 &allcount, ui32 &returncount, ui32 &whiteipcount, ui32 &rescount, bool &prcheck); //���������� ����������������� ��������� banip ����� � ����
         ui32              BanIpListCheck7(ui32 &allcount, ui32 &returncount, ui32 &whiteipcount, ui32 &rescount, bool &prcheck);
public:
         TBanIPListGeneral(void *statipobj, TLogsGroup *LogsGroupA, TKConfig* configobjA, kipv6::TWhiteIPv6 *WhiteIpA, TNetKIPv6 *m_WhiteNetA, TString BanTextFile, TString BanIndexFile, TString Ban7TextFile, TString Ban7IndexFile, TChangeProperties *CPOA, TString &bandaylistfileA, TString &ban7daylistfileA, TString &bandaylistfile_dA, TString &ban7daylistfile_dA);
         ~TBanIPListGeneral();

         bool              InitAfterFork();

         int               IsBanIp(TKIPv6 ip, ui32 *pcMess, ui32 *pcsec, bool &ban7);
         void              IsBanIpExt(TKIPv6 ip, bool &ban, ui16 &ban_hours, ui8 &ban_pr, bool &ban7, ui16 &ban7_hours, ui8 &ban7_pr);
         bool              AddBanIp(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, ui32 sendtorbl);
         bool              AddBanIpA(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, ui32 sendtorbl);
         bool              AddBanIpWOW(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, const TString &user, const bool longb, ui32 &sendtorbl); //���������� true - ���� ����� ����� � ���� ��� ����������
         bool              AddBan7IpWOW(TKIPv6 ip, ui32 hours, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, const TString &user, ui32 &sendtorbl);//���������� true - ���� ����� ����� � ���� ��� ����������

         TBanStat          GetStat();
         TBanStat          GetStat7();
         bool              RemoveBanIp(TKIPv6 ip);
         TBanRes           GetBanStatus(TKIPv6 ip, ui16 &AddBanTimeA, TBanIpBasic &tban, TBanIpBasic &tban7);
         //TString            WriteFullListInfo(TString mainhost, ui8 sorttype, ui8 sorttype2);
         void              WriteFullListInfo2(TDoubleBanIpBasicList &banstatlist, ui8 sorttype, ui8 sorttype2);
         void              SetLockBasa();
         void              UnLockBasa();
         bool              IsLock();
         void              Midnight();

         TErrorWrite       CalcErrorStatistic();
         TErrorWrite       GetErrorStatistic();

         bool              WriteThreadShouldStop(){ return m_StopWriteThread;}
         void              WriteThreadStopped(bool Stopped);
         bool              WriteThreadStopped();
         void              StartWriteThread();
         void              StopWriteThread();
         TBanQueue         *GetQueue(){ return m_queue; }
         TBanQueueStat     GetQueueStat();
         void              FuncEvent();
         void              TruncDayList();
         void              WriteThreadIDToLog();

         bool              SetSetupBanTime(ui32 bantime, ui32 long_bantime);
         bool              GetSetupBanTime(ui32 &bantime, ui32 &long_bantime);

         ui32              RemainBan(TBanIpBasic &ipdata);
         ui32              RemainBan7(TBanIpBasic &ipdata);

         void              SetLastBanTimeNew();
};

