#include "blackwhiteip_k.h"
//#include "baniplist.h"

//******************************************************************************************
//                            TRulePrintList
//******************************************************************************************

TRulePrintList::TRulePrintList(TString ruleprintlistfilenameA, TLogsGroup *LogsGroupA)
{
   ruleprintlistfilename = ruleprintlistfilenameA;
   LogsGroup = LogsGroupA;
}

TRulePrintList::~TRulePrintList()
{
   data.clear();
}

bool TRulePrintList::ReloadList()
{
   m_Mutex.Acquire();

   TString err_s = "";

   const auto newState = FileStateWasChanged(ruleprintlistfilename, m_filestat, err_s);

   if (!newState)
   {
       if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
          LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "RULEPRLIST: no changed.");

       m_Mutex.Release();
       return true;
   } else {
       m_filestat = *newState;
   }

   bool                 res = false;
   FILE                 *fhandle;
   char                 m_buff[SP_BUFF_SIZE];
   const char           *pbf;
   int                  len = 0;
   TRulePrintListHashIt it;
   TString               rulename = "";
   ui32                 record = 0, recorddublicat = 0;

   data.clear();
   fhandle = fopen(ruleprintlistfilename.c_str(), "rb");
   if (fhandle != NULL)
   {
      memset(m_buff, 0, SP_BUFF_SIZE - 1);
      while (fgets(m_buff, SP_BUFF_SIZE - 1, fhandle))
      {
         SpTrim(m_buff, &pbf, &len);
         if (len < 1 || pbf[0] == '#')
            continue;

         record++;
         rulename = TString(pbf, len);
         it = data.find(rulename);
         if (it == data.end())
            data[rulename] = 0;
         else
            recorddublicat++;

         memset(m_buff, 0, SP_BUFF_SIZE - 1);
      }

      fclose(fhandle);

      if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
         LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "RULEPRLIST: Read ruleprintlist.txt, records: %u, dublicat: %u", record, recorddublicat);
      res = true;
   }

   m_Mutex.Release();

   return res;
}

bool TRulePrintList::FindRule(TString rulename)
{
   bool                 res = false;
   TRulePrintListHashIt it;

   m_Mutex.Acquire();

   it = data.find(rulename);
   if (it != data.end())
      res = true;

   m_Mutex.Release();

   return res;
}
