#pragma once

#ifndef critrule_H
#define critrule_H

#include <list>
#include "util/generic/stroka.h"

class TCritRule {
private:
public:
    TString RULENAME;
    ui16 Criterion;
    ui16 Hour;

    TCritRule() {
        RULENAME.assign("");
        Criterion = 0;
        Hour = 0;
    }
    TCritRule(char* rulenameA, ui16 criterionA, ui16 hourA) {
        RULENAME.assign(rulenameA);
        Criterion = criterionA;
        Hour = hourA;
    }
    bool operator<(const TCritRule& value) const {
        return (Hour < value.Hour);
    }
};

typedef std::list<TCritRule> TCritRuleList;
typedef TCritRuleList::iterator TCritRuleListIt;
typedef TCritRuleList::reverse_iterator TCritRuleListRIt;

#endif
