#include "helper.h"
#include <limits>

TVector< char > StoreBoxToVector( const TStoreBox& sbox )
{
    TVector< std::pair< ui64, kui16 > > v;
    for( TStoreBox::const_iterator p = sbox.begin(); p != sbox.end(); p++ )
        v.push_back( make_pair( p->first, p->second.mailcount() ) );

    if( v.empty() )
        return TVector< char >();

    const char* pData = reinterpret_cast< const char* >( &v[ 0 ] );
    return TVector< char >( pData, pData + v.size() * sizeof( v[ 0 ] ) );
}

void VectorToStoreBox( const TVector< char >& data, TStoreBox& sbox )
{
    if( data.empty() )
        return;

    TVector< std::pair< ui64, kui16 > > v;
    v.resize( ( data.size() + sizeof( v[ 0 ] ) - 1 ) / sizeof( v[ 0 ] ) );
    memcpy( reinterpret_cast< char* >( &v[ 0 ] ), &data[ 0 ], data.size() );

    for( size_t i = 0; i < v.size(); i++ )
        sbox[ v[ i ].first ] = TUIDValue( v[ i ].second );
}

TVector< nosql::AnyValue > SplitDigits( ui64 value )
{
    TVector< nosql::AnyValue > ret;
    ui64 number = 1;

    while( value )
    {
        if( value % 2 == 1 )
            if( number <= std::numeric_limits< ui32 >::max() )
                ret.push_back( static_cast< ui32 >( number ) );
            else
                ret.push_back( number );

        number *= 2;
        value /= 2;
    }

    return ret;
}
