#pragma once

#include <limits>
#include "util/generic/vector.h"
#include "anyvalue.h"
#include "tforwards.h"

template < class T, class K > void AssignValue( T& lvalue, const K& rvalue )
{
    static const T max_value = std::numeric_limits< T >::max();
    static const T min_lvalue = std::numeric_limits< T >::min();
    static const K min_rvalue = std::numeric_limits< K >::min();

    if( rvalue > max_value )
    {
        lvalue = max_value;
        return;
    }

    if( min_rvalue >= 0 )
        lvalue = static_cast< T >( rvalue );
    else
    {
        if( rvalue < min_lvalue || ( min_lvalue == 0 && rvalue < 0 ) )
            lvalue = min_lvalue;
        else
            lvalue = static_cast< T >( rvalue );
    }
}

template < class T > void SetElement( nosql::HashMap& sets, const Stroka& key, const T& data, const T& data_prev )
{
    if( data != data_prev )
        sets[ key ] = data;
}

template < class T > void IncrElement( nosql::HashMap& incrs, const Stroka& key, const T& data, const T& data_prev )
{
    if( data != data_prev )
        incrs[ key ] = data - data_prev;
}

template < class F, class T > void IncrElement( nosql::HashMap& incrs, const Stroka& key, const T& data, const T& data_prev, nosql::HashMap& sets )
{
    if( data != data_prev )
    {
        static F set_predicate;
        if( set_predicate( data, data_prev ) )
            sets[ key ] = data;
        else
            incrs[ key ] = data - data_prev;
    }
}

class ElementLess
{
public:
    template < class T > bool operator()( const T& data, const T& data_prev ) const
    {
        return data < data_prev;
    }
};

template < class T > TVector< char > PODToVector( const T& data )
{
    const char* pData = reinterpret_cast< const char* >( &data );
    return TVector< char >( pData, pData + sizeof( data ) );
}

TVector< char > StoreBoxToVector( const TStoreBox& sbox );
void VectorToStoreBox( const TVector< char >& data, TStoreBox& sbox );

TVector< nosql::AnyValue > SplitDigits( ui64 value );

