#include <mail/so/spamstop/sp/spamstop.h>
#include "ipmess.h"
#include "tstatipobject.h"

//*****************************************************************************************************************************************
//                                     TIPMess - ������� � ��������� �������� ����� delivery
//*****************************************************************************************************************************************

TIPMess::TIPMess() {
    statipobj = NULL;
    TrafficControl = NULL;
    m_RulesStorage = NULL;
    RuleTrap = NULL;
    PeriodTrap = NULL;
    trap = NULL;
    perstat = NULL;
    RenginePool = NULL;
    whiteip_cache = NULL;
    banip_cache = NULL;
}

TIPMess::~TIPMess() {
}

void TIPMess::Init(void* statipobjA, TLogsGroup* LogsGroupA, TBasesStore* storeA, TTrafficControl* TrafficControlA, TRuleStorage* RulesStorageA, TRuleTrap* RuleTrapA, TPeriodTrap* PeriodTrapA, TTrap* trapA, TPeriodStat* perstatA, TRenginePool* RenginePoolA, TWhiteIPLocalCache* whiteip_cacheA, TBanIPLocalCache* banip_cacheA) {
    statipobj = statipobjA;
    LogsGroup = LogsGroupA;
    store = storeA;
    TrafficControl = TrafficControlA;
    m_RulesStorage = RulesStorageA;
    RuleTrap = RuleTrapA;
    PeriodTrap = PeriodTrapA;
    trap = trapA;
    perstat = perstatA;
    RenginePool = RenginePoolA;
    whiteip_cache = whiteip_cacheA;
    banip_cache = banip_cacheA;
}

ui32 TIPMess::GetStr(const char* source, ui32 source_size, char* destination, ui32 destination_size) {
    long pos = -1;
    ui32 res = 0;
    ui8 dob = 0;

    for (ui32 i = 0; i < source_size; i++) {
        if ((source[i] == 0x0D) && ((i + 1) < source_size) && (source[i + 1] == 0x0A)) {
            pos = i;
            dob = 1;
            break;
        }
        if (source[i] == 0x0A) {
            pos = i;
            dob = 0;
            break;
        }
    }
    res = pos + 1 + dob;
    if (res == 0)
        res = source_size;
    if (res > 0) {
        memset(destination, 0, destination_size);
        if (res <= destination_size) {
            memcpy(destination, source, res);
        } else {
            memcpy(destination, source, destination_size);
        }
    }
    return res;
}

bool TIPMess::IsMalicSpamer(const char* BUFF, ui32 BuffSize) {
    bool res = false;
    const char* p = NULL;

    p = strstr(BUFF, "MALICIOUS_SPAMER");
    if (p != NULL)
        res = true;

    return res;
}

ui32 TIPMess::PrintTraceLog(TLogStatus status, const char* msg, ...) {
    ui32 tt = 0;

    tt = CShingleTime::GetMs();
    if ((LogsGroup != NULL) && (LogsGroup->TraceIpLog() != NULL)) {
        va_list args;
        char buf[2048];

        memset(buf, 0, sizeof(buf));
        va_start(args, msg);
        vsnprintf(buf, sizeof(buf) - 1, msg, args);
        va_end(args);

        LogsGroup->TraceIpLog()->WriteMessageAndDataStatus(status, "%s", buf);
    }
    tt = CShingleTime::GetMs() - tt;

    return tt;
}

ui32 TIPMess::PrintBan3mail(const char* BUFF, ui32 BuffSize, const char* mailnumber, TKIPv6 ip, bool BanIp, bool MalicUser) {
    ui32 tt = 0;
    char shap[512];
    ui32 mailsize = 0;
    ui32 shapsize = 0;
    ui32 banip = 0, malic_spam = 0;

    tt = CShingleTime::GetMs();
    if ((LogsGroup != NULL) && (LogsGroup->Ban3mailLog() != NULL)) {
        if (BanIp)
            banip = 1;
        if (MalicUser)
            malic_spam = 1;

        mailsize = strlen(BUFF);
        memset(shap, 0, sizeof(shap));
        shapsize = 0;
        snprintf(shap, sizeof(shap) - 1, "\n<inf %3u %s %u %s %u %u>\n", shapsize, ip.toStroka().c_str(), mailsize, mailnumber, banip, malic_spam);
        shapsize = strlen(shap);
        snprintf(shap, sizeof(shap) - 1, "\n<inf %3u %s %u %s %u %u>\n", shapsize, ip.toStroka().c_str(), mailsize, mailnumber, banip, malic_spam);

        LogsGroup->Ban3mailLog()->WriteMessage("%s%s", shap, BUFF);

        //LogsGrupp->Ban3mailLog()->WriteMessage("%s**************************end mail %s\n\n", BUFF, mailnumber);
    }
    tt = CShingleTime::GetMs() - tt;

    return tt;
}

ui32 TIPMess::PrintRejectLog(const char* msg, ...) {
    ui32 tt = 0;

    tt = CShingleTime::GetMs();
    if ((LogsGroup != NULL) && (LogsGroup->RejectLog() != NULL)) {
        va_list args;
        char buf[2048];

        memset(buf, 0, sizeof(buf));
        va_start(args, msg);
        vsnprintf(buf, sizeof(buf) - 1, msg, args);
        va_end(args);

        LogsGroup->RejectLog()->WriteMessageAndData("%s", buf);
    }
    tt = CShingleTime::GetMs() - tt;

    return tt;
}

ui32 TIPMess::PrintActionLog(TLogStatus status, const char* msg, ...) {
    ui32 tt = 0;

    tt = CShingleTime::GetMs();
    if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL)) {
        va_list args;
        char buf[2048];

        memset(buf, 0, sizeof(buf));
        va_start(args, msg);
        vsnprintf(buf, sizeof(buf) - 1, msg, args);
        va_end(args);

        LogsGroup->ActionLog()->WriteMessageAndDataStatus(status, "%s", buf);
    }
    tt = CShingleTime::GetMs() - tt;

    return tt;
}

ui32 TIPMess::PBPrintProtokolLog(TReport& rep, ui16 criterion, ui16 hour, const char* mailnumber, TMemRecordCopy* memrec, const TString& host, const TString& geo) {
    ui32 res = CShingleTime::GetMs();
    if ((LogsGroup != NULL) && (LogsGroup->PBProtokolLog() != NULL)) {
        ui32 pos = 0;
        int AddBanTime = 0;
        char logtbuff[1024];
        ui32 spam = 0;
        ui32 ham = 0;
        ui32 dsn = 0;
        ui32 banday = 0;
        ui32 nobanday = 0;

        if (memrec != NULL) {
            spam = memrec->today.ctSpam;
            ham = memrec->today.ctHam;
            dsn = memrec->today.cDsn;
            banday = memrec->history.cDaysRej;
            nobanday = memrec->history.cDaysNoRej;
        }

        if ((store != NULL) && (store->GetCPO() != NULL))
            AddBanTime = store->GetCPO()->GetAddBanTime();
        memset(logtbuff, 0, sizeof(logtbuff));
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "[%s] ", rep.GetTimeStartStroka().c_str());
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "Ban=%d cr=%d (%d) %4s ", hour, criterion, AddBanTime, rep.GetRepeater().c_str());
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "%15s ", rep.GetIps().c_str());
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "%s ", rep.GetMailNumber().c_str());
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "[%u %u %u] ", spam, ham, dsn);
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "b:n=%u:%u ", banday, nobanday);
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "host %s ", host.c_str());
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "geo %s ", geo.c_str());
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "\n");

        LogsGroup->PBProtokolLog()->WriteMessage("%s", logtbuff);
    }
    res = CShingleTime::GetMs() - res;
    return res;
}

ui32 TIPMess::PrintProtokolLog(TReport& rep, ui16 criterion, ui16 hour, const char* mailnumber, TMemRecordCopy* memrec, const TString& host, const TString& geo) {
    ui32 res = CShingleTime::GetMs();
    if ((LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL)) {
        ui32 pos = 0;
        int AddBanTime = 0;
        char logtbuff[1024];
        ui32 spam = 0;
        ui32 ham = 0;
        ui32 dsn = 0;
        ui32 banday = 0;
        ui32 nobanday = 0;

        if (memrec != NULL) {
            spam = memrec->today.ctSpam;
            ham = memrec->today.ctHam;
            dsn = memrec->today.cDsn;
            banday = memrec->history.cDaysRej;
            nobanday = memrec->history.cDaysNoRej;
        }

        if ((store != NULL) && (store->GetCPO() != NULL))
            AddBanTime = store->GetCPO()->GetAddBanTime();
        memset(logtbuff, 0, sizeof(logtbuff));
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "[%s] ", rep.GetTimeStartStroka().c_str());
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "Ban=%d cr=%d (%d) %4s ", hour, criterion, AddBanTime, rep.GetRepeater().c_str());
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "%15s ", rep.GetIps().c_str());
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "%s ", rep.GetMailNumber().c_str());
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "[%u %u %u] ", spam, ham, dsn);
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "b:n=%u:%u ", banday, nobanday);
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "host %s ", host.c_str());
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "geo %s ", geo.c_str());
        pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "\n");

        LogsGroup->ProtokolLog()->WriteMessage("%s", logtbuff);
    }
    res = CShingleTime::GetMs() - res;
    return res;
}

ui32 TIPMess::PrintDaylogh(TReport& rep, TMemRecordCopy* memrec) {
    ui32 tt = 0;

    tt = CShingleTime::GetMs();
    if ((LogsGroup != NULL) && (LogsGroup->DayLoghLog() != NULL))
        LogsGroup->DayLoghLog()->WriteMessageAndData("%s", rep.GetStatMail(memrec).c_str());

    tt = CShingleTime::GetMs() - tt;

    return tt;
}

ui32 TIPMess::PrintStatlog(TReport& rep, TMemRecordCopy* memrec) {
    ui32 tt = 0;

    tt = CShingleTime::GetMs();
    if ((LogsGroup != NULL) && (LogsGroup->StatLog() != NULL))
        LogsGroup->StatLog()->WriteMessageAndData("%s", rep.GetStatMail(memrec).c_str());

    tt = CShingleTime::GetMs() - tt;

    return tt;
}

ui32 TIPMess::PrintTmpBan30(const char* BUFF, ui32 BuffSize, const char* mailnumber) {
    ui32 res = 0;

    res = CShingleTime::GetMs();
    if ((LogsGroup != NULL) && (LogsGroup->TmpBan30Log() != NULL))
        LogsGroup->TmpBan30Log()->WriteMessage("%s************************** end mail %s\n\n", BUFF, mailnumber);

    res = CShingleTime::GetMs() - res;

    return res;
}

ui32 TIPMess::PrintWhiteIPMail(const char* BUFF, ui32 BuffSize, const char* mailnumber) {
    ui32 tt = 0;

    tt = CShingleTime::GetMs();
    if ((LogsGroup != NULL) && (LogsGroup->WhiteIpLog() != NULL))
        LogsGroup->WhiteIpLog()->WriteMessage("%s**************************end mail %s\n\n", BUFF, mailnumber);
    tt = CShingleTime::GetMs() - tt;

    return tt;
}

ui32 TIPMess::PrintMissing(const char* BUFF, ui32 BuffSize, const char* mailnumber) {
    ui32 res = 0;

    res = CShingleTime::GetMs();
    if ((LogsGroup != NULL) && (LogsGroup->MissingMessLog() != NULL))
        LogsGroup->MissingMessLog()->WriteMessage("%s**************************end mail %s\n\n", BUFF, mailnumber);
    res = CShingleTime::GetMs() - res;

    return res;
}

void TIPMess::WriteRuleStatMail(const char* BUFF, ui32 BuffSize, TString filename, bool first) {
    if ((BUFF != NULL) && (BuffSize > 0)) {
        FILE* handle = NULL;

        try {
            if (first)
                handle = fopen(filename.c_str(), "wb");
            else
                handle = fopen(filename.c_str(), "a+b");
            if (handle != NULL) {
                fprintf(handle, "%s************************** end mail\n\n", BUFF);

                fclose(handle);
            }
        } catch (...) {
        }
    }
}

int TIPMess::CalcCountBox(const char* BUFF, ui32 BuffSize) {
    int res = false;
    const char* pb = NULL;
    //char         *pe            = NULL;
    int strlength = 0;
    ui32 newsourcesize = 0;
    char tbuff[256];
    TMailBox mbox;

    pb = strstr(BUFF, "mess: ");
    if (pb != NULL) {
        memset(tbuff, 0, sizeof(tbuff));
        newsourcesize = BuffSize - (pb - BUFF);
        strlength = GetStr(pb, newsourcesize, tbuff, sizeof(tbuff) - 1);
        if (strlength > 0) {
            mbox = TMailBox::Parse_mailboxByID(pb, strlength);
            res = mbox.MailBoxCount;
        }
    }

    return res;
}

TObrabResult TIPMess::ObrabMessage(TParsedDlvLog& pdl, TString& mail, TTimes& DelayT, const TString& MailNumber, float CurrMPS, ui32 mintreshold, const TString& remote_ip, ui32& trap_remain, ui32 sendtorbl, const TStatDBCollInfo stat_ident) {
    TObrabResult res;
    TObrabData odata; // message properties
    bool Writemailnumber = false;
    bool mban7 = false;
    TDobBanResData dobdata;
    ui32 bantick1 = 0;
    ui32 bantick2 = 0;
    ui32 bancachetick = 0;

    odata.stat_ident = stat_ident;
    res.save = false;
    if (true) {
        bool is_ban_ip = false;
        TBanCacheInfo bandata;
        TIPAddresses ts;

        odata.m_mailnumber = MailNumber;
        odata.m_cmess_ban = 0;
        odata.m_curr_time = time(NULL);
        odata.m_rep.Init(MailNumber, true);
        odata.m_rep.SetTimeStart(time(NULL));

        ts = ParsedObj.GetIPAddress(mail.c_str(), mail.length()); //���� � "rcvd:" ���� "source_ip" ��� ����������� ip-������
        odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip = ts.sourceip.m_ip;
        odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns = ts.sourceip.m_rdns;
        odata.pdld.m_exportdata.ipaddresses.sourceip.m_helo = ts.sourceip.m_helo;
        odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2 = ts.sourceip.m_rdns2;
        odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3 = ts.sourceip.m_rdns3;

        if (statipobj != NULL) {
            ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_01, "");
            odata.use_hide_could_not_find_rule = ((TStatIPObject*)statipobj)->HideCouldNotFindRule();
        }

        auto it = ts.nextip.begin();
        while (it != ts.nextip.end()) {
            odata.pdld.m_exportdata.ipaddresses.nextip.push_back((*it));

            ++it;
        }

        odata.m_rep.SetIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip);

        PrintTraceLog(KMESSAGE, "in_ip: %s", odata.m_rep.GetIps().c_str());

        if (trap != NULL)
            trap->AddMail(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, mail);

        //���������, ������� ip ��� ���
        if (banip_cache != NULL) {
            bancachetick = CShingleTime::GetMs();
            if (banip_cache->GetData(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, bandata)) {
                bancachetick = CShingleTime::GetMs() - bancachetick;
                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_GETBANSTATE_CACHE, 1, true, bancachetick);

                is_ban_ip = bandata.m_ban;
                mban7 = bandata.m_ban7;

                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_02, "");

            } else {
                bancachetick = CShingleTime::GetMs() - bancachetick;
                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_GETBANSTATE_CACHE, 1, true, bancachetick);

                bantick1 = CShingleTime::GetMs();
                is_ban_ip = store->GetBanIP()->IsBanIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, &odata.cMess, &odata.csec, mban7);
                bantick1 = CShingleTime::GetMs() - bantick1;
                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_GEGBANSTATE_STOR1, 1, true, bantick1);

                bantick2 = CShingleTime::GetMs();
                banip_cache->AddData(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, TBanCacheInfo(is_ban_ip, mban7));
                bantick2 = CShingleTime::GetMs() - bantick2;
                //if (statipobj != NULL)
                //   ((TStatIPObject *)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_GEGBANSTATE_STOR2, 1, true, bantick2);

                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_03, "");
            }

        } else {
            bantick1 = CShingleTime::GetMs();
            is_ban_ip = store->GetBanIP()->IsBanIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, &odata.cMess, &odata.csec, mban7);
            bantick1 = CShingleTime::GetMs() - bantick1;
            if (statipobj != NULL)
                ((TStatIPObject*)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_GEGBANSTATE_STOR1, 1, true, bantick1);

            if (statipobj != NULL)
                ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_04, "");
        }

        if (is_ban_ip) //ip �������
        {
            bool malic_spamer = odata.pdld.m_exportdata.m_malicspam;
            int mailcount = odata.pdld.m_exportdata.mbox.MailBoxCount;
            TSpClass messclass = odata.pdld.m_exportdata.m_messclass;

            store->GetMemBasa()->mGetStatBanMongo(odata, malic_spamer, DelayT, mailcount);
            if (odata.cMess <= 3) {
                PrintBan3mail(odata.pdld_totext.c_str(), odata.pdld_totext.length(), odata.m_rep.GetMailNumberShort().c_str(), odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, true, malic_spamer);
                res.save = true;
            }

            //������� ���������� �����
            if (PeriodTrap != NULL)
                PeriodTrap->AddBanMailBan(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, messclass, odata.m_curr_time, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3, mail.c_str(), mail.length(), malic_spamer, remote_ip, "");

            res.ban = true;

            if (statipobj != NULL)
                ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_05, "");

        } else //ip �� �������
        {
            odata.m_inc_malicspam_count = false;
            odata.m_need_print_ban3log = false;

            if (mban7) //������� ������ ������� "�������� ������" � �� ��������� �� ���
            {
                res.ban = false;
                res.ban2 = false;
                res.ban7 = true;
                res.ban8 = false;
                res.dobdata.Clear();

                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_06, "");

            } else {
                res.ban = ReadMessage2Mongo(false, mail.c_str(), mail.length(), odata, DelayT, CurrMPS, dobdata, mintreshold, remote_ip, trap_remain, sendtorbl);

                res.ban2 = odata.m_ban2;
                res.ban7 = odata.m_ban7;
                res.ban8 = odata.m_ban8;
                res.dobdata = dobdata;

                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_07, "");
            }

            bool malicspam = odata.pdld.m_exportdata.m_malicspam && (odata.pdld.m_exportdata.m_messclass == TSpClass::SPAM);
            if (res.ban || res.ban2 || res.ban7 || res.ban8 || malicspam) {
                TString stat = "";

                if (res.ban)
                    stat = stat + " b1";
                if (res.ban2)
                    stat = stat + " b2";
                if (res.ban7)
                    stat = stat + " b7";
                if (res.ban8)
                    stat = stat + " b8";
                if (malicspam)
                    stat = stat + " mlc";

                PrintRejectLog("%40s, %s", odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip.toStroka().c_str(), stat.c_str());
            }
            if ((!res.ban) && (!res.ban2) && (res.ban7)) //only ban7
                store->GetMemBasa()->mIncBan7Mongo(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, malicspam, odata.m_inc_malicspam_count, odata.m_need_print_ban3log);

            if (res.ban || res.ban2 || res.ban7 || res.ban8) {
                if (banip_cache != NULL)
                    banip_cache->RemoveData(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip);
            }

            if (odata.m_need_print_ban3log)
                PrintBan3mail(odata.pdld_totext.c_str(), odata.pdld_totext.length(), odata.m_rep.GetMailNumberShort().c_str(), odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, false, malicspam);
        }

        if (res.ban)
            isban_counter.Increment();
        if (res.ban2)
            ban2_counter.Increment();
        if (odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip.IsIPv6())
            ipv6_counter.Increment();
    }

    return res;
}

TObrabResult TIPMess::ObrabMessageSerializeData(TParsedDlvLogDataEx& pdlde, TTimes& DelayT, const TString& MailNumber, float CurrMPS, ui32 mintreshold, const TString& remote_ip, ui32& trap_remain, ui32 sendtorbl, const TStatDBCollInfo stat_ident) {
    TObrabResult res;
    TObrabData odata; // message properties
    bool Writemailnumber = false;
    bool mban7 = false;
    TDobBanResData dobdata;
    ui32 bantick1 = 0;
    ui32 bantick2 = 0;
    ui32 bancachetick = 0;

    odata.stat_ident = stat_ident;
    res.save = false;
    if (!pdlde.data.m_exportdata.ipaddresses.sourceip.m_ip.Undefined()) {
        //correct input data
        {
            TString dslfirst_rule = "__RDSL_OR_NORESOLVED_FIRST";

            //pdlde.data.m_exportdata.m_fDsl_first = false;
            if ((!pdlde.data.m_exportdata.m_fDsl_first) && (pdlde.data.Find_rsp_rule(dslfirst_rule)))
                pdlde.data.m_exportdata.m_fDsl_first = true;

            if ((!pdlde.data.m_exportdata.m_fDsl_first) && (pdlde.data.Find_rdl_rule(dslfirst_rule)))
                pdlde.data.m_exportdata.m_fDsl_first = true;

            if ((!pdlde.data.m_exportdata.m_fDsl_first) && (pdlde.data.Find_rnl_rule(dslfirst_rule)))
                pdlde.data.m_exportdata.m_fDsl_first = true;
        }

        {
            TString dslfirst_new_rule = "DSLFIRST";

            //odata.m_dslfirst = false;
            if (pdlde.data.Find_rsp_rule(dslfirst_new_rule))
                odata.m_dslfirst = true;

            if (pdlde.data.Find_rdl_rule(dslfirst_new_rule))
                odata.m_dslfirst = true;

            if (pdlde.data.Find_rnl_rule(dslfirst_new_rule))
                odata.m_dslfirst = true;
        }

        //next algorithm
        if (statipobj != NULL) {
            ((TStatIPObject*)statipobj)->PrintFollowIp(pdlde.data.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_01, "");
            odata.use_hide_could_not_find_rule = ((TStatIPObject*)statipobj)->HideCouldNotFindRule();
        }

        bool is_ban_ip = false;
        TBanCacheInfo bandata;

        odata.pdld = pdlde.data;
        if (!pdlde.data.dlv_log.empty())
            odata.pdld_totext = pdlde.data.dlv_log;
        else
            odata.pdld_totext = pdlde.PrintToStroka("\n");
        odata.m_mailnumber = MailNumber;
        odata.m_cmess_ban = 0;
        odata.m_curr_time = time(NULL);
        odata.m_rep.Init(MailNumber, true);
        odata.m_rep.SetTimeStart(time(NULL));
        odata.m_rep.SetIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip);

        PrintTraceLog(KMESSAGE, "in_ip: %s", odata.m_rep.GetIps().c_str());

        if (trap != NULL)
            trap->AddMail(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.pdld_totext);

        //���������, ������� ip ��� ���
        if (banip_cache != NULL) {
            bancachetick = CShingleTime::GetMs();
            if (banip_cache->GetData(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, bandata)) {
                bancachetick = CShingleTime::GetMs() - bancachetick;
                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_GETBANSTATE_CACHE, 1, true, bancachetick);

                is_ban_ip = bandata.m_ban;
                mban7 = bandata.m_ban7;

                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(pdlde.data.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_02, "");

            } else {
                bancachetick = CShingleTime::GetMs() - bancachetick;
                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_GETBANSTATE_CACHE, 1, true, bancachetick);

                bantick1 = CShingleTime::GetMs();
                is_ban_ip = store->GetBanIP()->IsBanIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, &odata.cMess, &odata.csec, mban7);
                bantick1 = CShingleTime::GetMs() - bantick1;
                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_GEGBANSTATE_STOR1, 1, true, bantick1);

                bantick2 = CShingleTime::GetMs();
                banip_cache->AddData(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, TBanCacheInfo(is_ban_ip, mban7));
                bantick2 = CShingleTime::GetMs() - bantick2;
                //if (statipobj != NULL)
                //   ((TStatIPObject *)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_GEGBANSTATE_STOR2, 1, true, bantick2);

                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(pdlde.data.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_03, "");
            }

        } else {
            bantick1 = CShingleTime::GetMs();
            is_ban_ip = store->GetBanIP()->IsBanIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, &odata.cMess, &odata.csec, mban7);
            bantick1 = CShingleTime::GetMs() - bantick1;
            if (statipobj != NULL)
                ((TStatIPObject*)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_GEGBANSTATE_STOR1, 1, true, bantick1);

            if (statipobj != NULL)
                ((TStatIPObject*)statipobj)->PrintFollowIp(pdlde.data.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_04, "");
        }

        if (is_ban_ip) //ip �������
        {
            bool malic_spamer = odata.pdld.m_exportdata.m_malicspam;
            int mailcount = odata.pdld.m_exportdata.mbox.MailBoxCount;
            TSpClass messclass = odata.pdld.m_exportdata.m_messclass;

            store->GetMemBasa()->mGetStatBanMongo(odata, malic_spamer, DelayT, mailcount);
            if (odata.cMess <= 3) {
                PrintBan3mail(odata.pdld_totext.c_str(), odata.pdld_totext.length(), odata.m_rep.GetMailNumberShort().c_str(), odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, true, malic_spamer);
                res.save = true;
            }

            //������� ���������� �����
            if (PeriodTrap != NULL) {
                TString mess_source_s = "";
                const char* mess_source = NULL;
                ui32 mess_source_size = 0;

                //mess_source      = odata.pdld_totext.c_str();
                //mess_source_size = odata.pdld_totext.length();
                mess_source_s = odata.pdld.PrintVirtualDlvLog();
                mess_source = mess_source_s.c_str();
                mess_source_size = mess_source_s.length();

                PeriodTrap->AddBanMailBan(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, messclass, odata.m_curr_time, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3, mess_source, mess_source_size, malic_spamer, remote_ip, "");
            }

            res.ban = true;

            if (statipobj != NULL)
                ((TStatIPObject*)statipobj)->PrintFollowIp(pdlde.data.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_05, "");

        } else //ip �� �������
        {
            odata.m_inc_malicspam_count = false;
            odata.m_need_print_ban3log = false;

            if (mban7) //������� ������ ������� "�������� ������" � �� ��������� �� ���
            {
                res.ban = false;
                res.ban2 = false;
                res.ban7 = true;
                res.ban8 = false;
                res.dobdata.Clear();

                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(pdlde.data.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_06, "");

            } else {
                res.ban = ReadMessage2Mongo(true, odata.pdld_totext.c_str(), odata.pdld_totext.length(), odata, DelayT, CurrMPS, dobdata, mintreshold, remote_ip, trap_remain, sendtorbl);

                res.ban2 = odata.m_ban2;
                res.ban7 = odata.m_ban7;
                res.ban8 = odata.m_ban8;
                res.dobdata = dobdata;

                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(pdlde.data.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_07, "");
            }

            bool malicspam = odata.pdld.m_exportdata.m_malicspam && (odata.pdld.m_exportdata.m_messclass == TSpClass::SPAM);
            if (res.ban || res.ban2 || res.ban7 || res.ban8 || malicspam) {
                TString stat = "";

                if (res.ban)
                    stat = stat + " b1";
                if (res.ban2)
                    stat = stat + " b2";
                if (res.ban7)
                    stat = stat + " b7";
                if (res.ban8)
                    stat = stat + " b8";
                if (malicspam)
                    stat = stat + " mlc";

                PrintRejectLog("%40s, %s", odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip.toStroka().c_str(), stat.c_str());
            }
            if ((!res.ban) && (!res.ban2) && (res.ban7)) //only ban7
                store->GetMemBasa()->mIncBan7Mongo(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, malicspam, odata.m_inc_malicspam_count, odata.m_need_print_ban3log);

            if (res.ban || res.ban2 || res.ban7 || res.ban8) {
                if (banip_cache != NULL)
                    banip_cache->RemoveData(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip);
            }

            if (odata.m_need_print_ban3log)
                PrintBan3mail(odata.pdld_totext.c_str(), odata.pdld_totext.length(), odata.m_rep.GetMailNumberShort().c_str(), odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, false, malicspam);
        }

        if (res.ban)
            isban_counter.Increment();
        if (res.ban2)
            ban2_counter.Increment();
        if (odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip.IsIPv6())
            ipv6_counter.Increment();

    } else {
        if (Writemailnumber)
            PrintActionLog(KERROR, "MESS:       bad structure message (%s), ip is undefined!", MailNumber.c_str());
        else
            PrintActionLog(KERROR, "MESS:       bad structure message, ip is undefined!");

        if (statipobj != NULL)
            ((TStatIPObject*)statipobj)->PrintFollowIp(pdlde.data.m_exportdata.ipaddresses.sourceip.m_ip, MailNumber.c_str(), FIE_08, "");
    }

    return res;
}

/*bool TIPMess::ReadMessage2(bool no_parse, const char *BUFF, ui32 BUFFSize, TObrabData &odata, TTimes &DelayT, float CurrMPS, TDobBanResData &dobdata, ui32 mintreshold, const TString &remote_ip, ui32 &trap_remain)
{
   bool res          = false;
   bool bad_struct   = false;
   bool parse_res    = false;

   if (no_parse)
      parse_res = true;
   else
      parse_res = ParsedObj.ParseDlvLog(BUFF, BUFFSize, odata.pdld, false, false);

   if (parse_res)
   {
      if (odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip.Undefined())
      {
         bad_struct = true;
         PrintActionLog(KERROR, "MESS:       fault, ip undefined (%s)!", odata.m_rep.GetMailNumberShort().c_str());
      } else
      {
         res = TreatMessage(odata, BUFF, BUFFSize, DelayT, CurrMPS, dobdata, mintreshold, remote_ip, trap_remain);
      }
   } else
      bad_struct = true;

   if (bad_struct)
      PrintActionLog(KERROR, "MESS:       bad structure message (%s)!", odata.m_rep.GetMailNumberShort().c_str());

   return res;
}*/

bool TIPMess::ReadMessage2Mongo(bool no_parse, const char* BUFF, ui32 BUFFSize, TObrabData& odata, TTimes& DelayT, float CurrMPS, TDobBanResData& dobdata, ui32 mintreshold, const TString& remote_ip, ui32& trap_remain, ui32 sendtorbl) {
    bool res = false;
    bool bad_struct = false;
    bool parse_res = false;

    if (no_parse)
        parse_res = true;
    else
        parse_res = ParsedObj.ParseDlvLog(BUFF, BUFFSize, odata.pdld, false, false);

    if (parse_res) {
        if (odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip.Undefined()) {
            bad_struct = true;
            PrintActionLog(KERROR, "MESS:       fault, ip undefined (%s)!", odata.m_rep.GetMailNumberShort().c_str());

            if (statipobj != NULL)
                ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_09, "");

        } else {
            res = TreatMessageMongo(odata, BUFF, BUFFSize, DelayT, CurrMPS, dobdata, mintreshold, remote_ip, trap_remain, sendtorbl, &changeday1_counter, &changeday2_counter);
        }

    } else {
        bad_struct = true;

        if (statipobj != NULL)
            ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_10, "");
    }

    if (bad_struct)
        PrintActionLog(KERROR, "MESS:       bad structure message (%s)!", odata.m_rep.GetMailNumberShort().c_str());

    return res;
}

ui32 TIPMess::PrintParseError(const TString& id) {
    return PrintActionLog(KERROR, "MESS:       bad structure message (%s)!", id.c_str());
}

void TIPMess::CleanupWhiteCache() {
    if (whiteip_cache != NULL) {
        ui32 tick = CShingleTime::GetMs();
        ui32 worktime = 0;
        ui32 all_record = 0;
        ui32 erase_count = 0;
        TWeightIPLocalCacheItemExList erase_list;
        TWeightIPLocalCacheItemExListIt it;

        whiteip_cache->Cleanup(worktime, all_record, erase_list);
        erase_count = erase_list.size();

        it = erase_list.begin();
        while (it != erase_list.end()) {
            //if ( (LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL) )
            //   LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "WHITEIPCACHE: debug='%s'", (*it).toLog().c_str());
            if ((store != NULL) && (store->GetMemBasa() != NULL))
                store->GetMemBasa()->SendTailsByWhiteIP((*it).m_ip, &(*it).m_value, ChangeDay1Counter(), ChangeDay2Counter());

            (*it).m_value = {};

            ++it;
        }

        tick = CShingleTime::GetMs() - tick;
        if ((LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "WHITEIPCACHE: cleanup to %u(%u) msec (erase %u record from %u)", tick, worktime, erase_count, all_record);
    }
}

static const PcreTool m_pcre(NRegexp::TSettings{}, MakeArrayRef(ipmessre, Y_ARRAY_SIZE(ipmessre)));

bool TIPMess::TreatMessageMongo(TObrabData& odata, const char* BUFF, ui32 BuffSize, TTimes& DelayT, float CurrMPS, TDobBanResData& dobdata, ui32 mintreshold, const TString& remote_ip, ui32& trap_remain, ui32 sendtorbl, TDiffCounter* changeday1_counter, TDiffCounter* changeday2_counter) {
    bool res = false;
    bool fBanNew = false;
    bool fBanOld = false;
    int ipMassSpam = 0;
    const char* pErrorText = "";
    bool fban = false;
    bool fIsWhiteIp = false;
    bool fIsWhiteIpFromWNet = false;
    bool fIsWhiteIpFromWNetRDNS = false;
    bool fIsWhiteIpFromWNetRDNS2 = false;
    bool fIsWhiteIpFromWNetRDNS3 = false;
    bool fIsWhiteIpTrace = false;
    ui32 cMess = 0;
    ui32 csec = 0;
    TString str_repeater = "";
    ui64 scount = 0;
    ui32 writelogtime = 0;
    ui32 dslcount = 0;
    ui32 dslmailcount = 0;
    ui32 banipcount = 0;
    int memory_index = 0;
    bool pr_flag = false;
    T_enum_ip_level stattype = enSpLevel1;
    ui32 lists_tick = 0;
    ui32 mem_tick = 0;

    if ((store != NULL) && (store->GetZoneStat() != NULL))
        store->GetZoneStat()->AddZoneTwice(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2.c_str(), odata.pdld.m_exportdata.m_messclass, odata.pdld.m_exportdata.m_fDSN);

    {
        const char* p = odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2.c_str();
        while (*p && *p != '.') {
            p++;
        }
        if (*p == '.')
            strncpy(odata.m_zn, p + 1, 10);
    }

    if (m_pcre.Check("net_org", odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns)) {
        odata.m_fNetOrg = true;
    }
    if (m_pcre.Check("ip_dsl", odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns)) {
        odata.m_fIpDsl = true;
    }

    lists_tick = CShingleTime::GetMs();
    //bad1
    if ((store != NULL) && (store->GetBad1() != NULL)) {
        odata.m_bad_type1 = store->GetBad1()->Find(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2.c_str());
        odata.m_bad_type1 |= store->GetBad1()->Find(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3.c_str());
        if (odata.m_bad_type1 > 0)
            odata.m_bad_type += 0x01;
    }
    //bad2
    if ((store != NULL) && (store->GetBad2() != NULL)) {
        odata.m_bad_type2 = store->GetBad2()->Find(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2.c_str());
        odata.m_bad_type2 |= store->GetBad2()->Find(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3.c_str());
        if (odata.m_bad_type2 > 0)
            odata.m_bad_type += 0x02;
    }
    //bad3
    if ((store != NULL) && (store->GetBad3() != NULL)) {
        odata.m_bad_type3 = store->GetBad3()->Find(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2.c_str());
        odata.m_bad_type3 |= store->GetBad3()->Find(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3.c_str());
        if (odata.m_bad_type3 > 0)
            odata.m_bad_type += 0x04;
    }
    //bad4
    if ((store != NULL) && (store->GetBad4() != NULL)) {
        odata.m_bad_type4 = store->GetBad4()->Find(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2.c_str());
        odata.m_bad_type4 |= store->GetBad4()->Find(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3.c_str());
        if (odata.m_bad_type4 > 0)
            odata.m_bad_type += 0x08;
    }
    //bad5
    if ((store != NULL) && (store->GetBad5() != NULL)) {
        odata.m_bad_type5 = store->GetBad5()->Find(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2.c_str());
        odata.m_bad_type5 |= store->GetBad5()->Find(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3.c_str());
        if (odata.m_bad_type5 > 0)
            odata.m_bad_type += 0x10;
    }

    if ((store != NULL) && (store->GetRBL() != NULL)) {
        odata.m_fRBL_hash = store->GetRBL()->GetRBL(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip);
        odata.pdld.m_exportdata.m_fRBL = odata.m_fRBL_hash;
    }

    if ((store != NULL) && (store->GetWhiteIP() != NULL))
        fIsWhiteIp = store->GetWhiteIP()->IsWhiteIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip);

    if ((store != NULL) && (store->GetWhiteNet() != NULL)) {
        if (!fIsWhiteIp) {
            fIsWhiteIpFromWNet = store->GetWhiteNet()->IsInNet(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip);
            fIsWhiteIp |= fIsWhiteIpFromWNet;
        }
        if ((!fIsWhiteIp) && (!odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns.empty())) {
            fIsWhiteIpFromWNetRDNS = store->GetWhiteNet()->IsInNet(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns.c_str());
            fIsWhiteIp |= fIsWhiteIpFromWNetRDNS;
        }
        if ((!fIsWhiteIp) && (!odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2.empty())) {
            fIsWhiteIpFromWNetRDNS2 = store->GetWhiteNet()->IsInNet(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2.c_str());
            fIsWhiteIp |= fIsWhiteIpFromWNetRDNS2;
        }
        if ((!fIsWhiteIp) && (!odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3.empty())) {
            fIsWhiteIpFromWNetRDNS3 = store->GetWhiteNet()->IsInNet(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3.c_str());
            fIsWhiteIp |= fIsWhiteIpFromWNetRDNS3;
        }
    }

    if (fIsWhiteIp) {
        white_counter.Increment();
        //spmessage(m_TraceIpfp, "white ip %s", xIP);
        //spmessage(m_WhiteIpfp, "white ip %s", xIP);

        //if (statipobj != NULL)
        //  ((TStatIPObject *)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_12, "");
    }

    //greylists
    store->GetGreyListsStatus(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns, odata.m_graylists_status);

    lists_tick = CShingleTime::GetMs() - lists_tick;
    if (statipobj != NULL)
        ((TStatIPObject*)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_CHECK_LISTS, 1, true, lists_tick);

    if (statipobj != NULL) {
        bool is_ham = false;
        bool is_spam = false;
        bool is_malic = false;
        TString dbg_info = "";

        if ((odata.pdld.m_exportdata.m_messclass == TSpClass::HAM) || (odata.pdld.m_exportdata.m_messclass == TSpClass::DLVR))
            dbg_info = dbg_info + "HAM,";
        else if (odata.pdld.m_exportdata.m_messclass == TSpClass::SPAM) {
            dbg_info = dbg_info + "SPAM,";
            if (odata.pdld.m_exportdata.m_malicspam)
                dbg_info = dbg_info + "MALIC,";
        }

        dbg_info = dbg_info + "MAILBOXCNT=" + IntToStroka(odata.pdld.m_exportdata.mbox.MailBoxCount) + ",";

        if (fIsWhiteIp)
            dbg_info = dbg_info + "WHT,";

        if (odata.pdld.m_exportdata.m_fRBL)
            dbg_info = dbg_info + "RBL,";

        dbg_info = dbg_info + "BADTYPE=" + IntToStroka(odata.m_bad_type);

        ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_11, dbg_info);
    }

    if ((store != NULL) && (store->GetWhiteIP() != NULL))
        fIsWhiteIpTrace = store->GetWhiteIP()->IsWhiteIpTrace(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.pdld.m_exportdata.m_uid);

    odata.m_rep.SetIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip);
    odata.m_rep.SetHost(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns);
    odata.m_rep.SetMessClass(odata.pdld.m_exportdata.m_messclass);
    odata.m_rep.SetDsn(odata.pdld.m_exportdata.m_fDSN);
    odata.m_rep.SetUwl(odata.pdld.m_exportdata.m_Uwl);
    odata.m_rep.SetDsl_first(odata.pdld.m_exportdata.m_fDsl_first);
    odata.m_rep.SetNoresolv_first(odata.pdld.m_exportdata.m_fNoresolv_first);
    odata.m_rep.SetFixedByRule(odata.pdld.m_exportdata.m_fFixedByRule);
    odata.m_rep.SetFixedSource(odata.pdld.m_exportdata.m_fFixedSource);
    odata.m_rep.SetRBL(odata.pdld.m_exportdata.m_fRBL);
    odata.m_rep.SetBounce(odata.pdld.m_exportdata.m_fBounce);
    odata.m_rep.SetWhiteIp(fIsWhiteIp);

    if (TrafficControl != NULL) {
        if ((odata.pdld.m_exportdata.m_messclass == TSpClass::HAM) || (odata.pdld.m_exportdata.m_messclass == TSpClass::DLVR))
            TrafficControl->IncHamCount();
        else if (odata.pdld.m_exportdata.m_messclass == TSpClass::SPAM) {
            TrafficControl->IncSpamCount();
            if (odata.pdld.m_exportdata.m_malicspam)
                TrafficControl->IncMalicCount();
        }
    }

    mem_tick = CShingleTime::GetMs();

    TMemRecordCopy pip_m = TMemRecordCopy();
    if ((store != NULL) && (store->GetMemBasa() != NULL)) {
        if ((!fIsWhiteIp) || ((whiteip_cache != NULL) && (whiteip_cache->NeedRequestToStorage(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip)))) {
            pip_m = store->GetMemBasa()->mAddStatMongo(memory_index, odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, stattype, &ipMassSpam, fIsWhiteIp, DelayT, odata, whiteip_cache, ChangeDay1Counter(), ChangeDay2Counter());
            if (!pip_m.empty()) {
                if ((fIsWhiteIp) && (whiteip_cache != NULL))
                    whiteip_cache->AddStorageInfo(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, pip_m);

                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_13, "");
            }

        } else {
            if (statipobj != NULL)
                ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_14, "");

            if ((fIsWhiteIp) && (whiteip_cache != NULL)) {
                whiteip_cache->AddDiffData(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata);

                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_15, "");
            }
        }
    }

    mem_tick = CShingleTime::GetMs() - mem_tick;
    if (statipobj != NULL) {
        if (odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip.IsIPv4())
            ((TStatIPObject*)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_IPV4MEM, 1, true, mem_tick);
        else if (odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip.IsIPv6())
            ((TStatIPObject*)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_IPV6MEM, 1, true, mem_tick);
    }

    if ((odata.m_dslfirst) && (store != NULL) && (store->GetMemBasa() != NULL))
        odata.m_dslfirst_rps = store->GetMemBasa()->CalcFirstDslRPS();

    if (odata.pdld.m_exportdata.m_fDsl_first) {
        dslmailcount = 1;
        ui32 tv = IncMax32(pip_m.today.ctSpam, pip_m.today.ctHam);
        if (tv == 1)
            dslcount = 1;
    }

    if (PeriodTrap != NULL) {
        TString mess_source_s = "";
        const char* mess_source = NULL;
        ui32 mess_source_size = 0;

        //mess_source      = BUFF;
        //mess_source_size = BuffSize;
        mess_source_s = odata.pdld.PrintVirtualDlvLog();
        mess_source = mess_source_s.c_str();
        mess_source_size = mess_source_s.length();

        bool visfrwd = odata.pdld.m_exportdata.m_frwd_pr1 || odata.pdld.m_exportdata.m_frwd_pr2;

        PeriodTrap->AddMail(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.pdld.m_exportdata.m_messclass, odata.m_curr_time, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3, mess_source, mess_source_size, odata.pdld.m_exportdata.m_malicspam, pip_m, visfrwd, fIsWhiteIp, remote_ip, trap_remain, odata.pdld.m_exportdata.m_geo);

        if (statipobj != NULL)
            ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_16, "");
    }

    pr_flag = true;
    if ((mintreshold > 0) && (CurrMPS > mintreshold)) //��������� �������� ���� (� ip ��������� >10 ����� � �������) ��� ����������� �������
        pr_flag = false;

    if (!pip_m.empty()) {
        if ((odata.pdld.m_exportdata.m_messclass == TSpClass::SPAM) || (pr_flag && (odata.m_cps > 10))) {
            if (TestAddBanIp(fIsWhiteIp, odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip.toStroka(), odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3)) //�� � "�����" ������� ip � net
            {
                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_20, "");

                //=============================================
                ui32 hours = TestBanCriterion(BUFF, BuffSize, &pip_m, odata.m_rep, odata, DelayT, CurrMPS, memory_index);
                //=============================================

                if (hours > 0) {
                    if (statipobj != NULL)
                        ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_21, "");

                    if ((store != NULL) && (store->GetBanIP() != NULL)) {
                        ui8 IntBanIp = 0;

                        if (odata.m_baninternal)
                            IntBanIp = 1;
                        store->GetBanIP()->AddBanIpA(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, hours, IntBanIp, false, false, true, sendtorbl);
                        actionban_counter.Increment();

                        banipcount = 1;
                    }

                    //����������
                    if (odata.m_repeater) {
                        if ((store != NULL) && (store->GetCPO() != NULL))
                            hours = hours + odata.m_repeater * store->GetCPO()->GetRepeaterBase();
                        odata.m_rep.SetBanHour(hours);
                    }
                    writelogtime += PrintProtokolLog(odata.m_rep, odata.m_rep.GetCriterion(), hours, odata.m_rep.GetMailNumber().c_str(), &pip_m, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns, odata.pdld.m_exportdata.m_geo);
                    res = true;

                } else {
                    if (statipobj != NULL)
                        ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_22, "");
                }
                //������� ��������� ��������
                if (odata.m_probbancriterion > 0) {
                    writelogtime += PrintTmpBan30(BUFF, BuffSize, odata.m_rep.GetMailNumberShort().c_str());
                    if (hours == 0)
                        writelogtime += PBPrintProtokolLog(odata.m_rep, odata.m_rep.GetPROBBANCriterion(), hours, odata.m_rep.GetMailNumber().c_str(), &pip_m, odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns, odata.pdld.m_exportdata.m_geo);
                }

            } else //ip-�����, ����� 2 ������ ��� ����� 3 ������ ��������� � "����� �������" ������� ��� �����
            {
                odata.m_rep.SetWhiteIp(true);
                writelogtime += PrintWhiteIPMail(BUFF, BuffSize, odata.m_rep.GetMailNumberShort().c_str());

                if (statipobj != NULL)
                    ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_19, "");
            }

            SetForwardStat(odata.m_rep, &pip_m); //���� ���������� �� ��������� ����� - ��������� � (����� ��� ����������� � TestBanCriterion)

            scount = pip_m.today.ctSpam + pip_m.yesterday.ctSpam + pip_m.history.ctSpam;
            if ((scount > 0) && ((scount % 100) == 0))
                writelogtime += PrintStatlog(odata.m_rep, &pip_m);

        } else {
            if (statipobj != NULL)
                ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_18, "");
        }

        if (odata.pdld.m_exportdata.IsMalicSpam()) {
            if (statipobj != NULL)
                ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_23, "");

            if ((!odata.m_inc_malicspam_count) || (odata.m_Forwards > 0) || (odata.m_probbancriterion > 0) || (odata.m_criterion_n > 0))
                odata.m_need_print_ban3log = store->GetMemBasa()->mIncMSCwFlagMongo(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_inc_malicspam_count, odata.m_Forwards, odata.m_probbancriterion, odata.m_criterion_n);

        } else if (res || odata.m_ban2) {
            if (statipobj != NULL)
                ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_24, "");

            store->GetMemBasa()->mIncOnlyMalicwFlagMongo(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.pdld.m_exportdata.mbox.MailBoxCount, odata.m_Forwards, odata.m_probbancriterion, odata.m_criterion_n);
        }

        dobdata.cDaysRej = pip_m.history.cDaysRej;
        dobdata.cDaysNoRej = pip_m.history.cDaysNoRej;
        dobdata.tSpam = pip_m.today.ctSpam;
        dobdata.tHam = pip_m.today.ctHam;
        dobdata.tMalicSpam = pip_m.today.ctMalicSpam;
        dobdata.ySpam = pip_m.yesterday.ctSpam;
        dobdata.yHam = pip_m.yesterday.ctHam;
        dobdata.yMalicSpam = pip_m.yesterday.ctMalicSpam;
        dobdata.hSpam = pip_m.history.ctSpam;
        dobdata.hHam = pip_m.history.ctHam;
        dobdata.hMalicSpam = pip_m.history.ctMalicSpam;
        dobdata.isforward = IS_SF_FORWARD(pip_m.today.bMask);
        dobdata.age = (time(NULL) - pip_m.history.tFirstDeal) / 86400;

        SetForwardStat(odata.m_rep, &pip_m); //���� ���������� �� ��������� ����� - ��������� � (����� ��� ����������� � TestBanCriterion)

        writelogtime += PrintDaylogh(odata.m_rep, &pip_m);

        if (perstat != NULL)
            perstat->AddData(dslcount, dslmailcount, banipcount);

    } else {
        if (statipobj != NULL)
            ((TStatIPObject*)statipobj)->PrintFollowIp(odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, odata.m_rep.GetMailNumberShort().c_str(), FIE_17, "");
    }

    return res;
}

bool TIPMess::TestAddBanIp(bool fIsWhiteIp, TKIPv6 xIp, const TString& sip, const TString& rdns2, const TString& rdns3) {
    if (fIsWhiteIp)
        return false;

    if ((store != NULL) && (store->GetWhiteNet() != NULL) && (store->GetWhiteNet()->IsInNet(xIp))) {
        PrintTraceLog(KMESSAGE, "white net list ip %s", sip.c_str());
        return false;
    }

    if ((store != NULL) && (store->GetWhiteNet() != NULL) && (store->GetWhiteNet()->IsInNet(rdns2.c_str()))) {
        PrintTraceLog(KMESSAGE, "white net host list ip %s", rdns2.c_str());
        return false;
    }

    if ((store != NULL) && (store->GetWhiteNet() != NULL) && (store->GetWhiteNet()->IsInNet(rdns3.c_str()))) {
        PrintTraceLog(KMESSAGE, "white net host list ip %s", rdns3.c_str());
        return false;
    }

    return true;
}

void TIPMess::SetForwardStat(TReport& rep, TMemRecordCopy* memrec) {
    if ((rep.Getforward_comments() == "") && (memrec != NULL)) {
        //rep.Setforward_comments(TString(memrec->today.frwddata.forward_comments));
    }
}

ui64 TIPMess::SpCheckFieldTick(TRengine* sph, const char* pFieldName, const char* pField, int FieldLen, const char* coding, bool fValid, bool fMime) {
    ui64 res = 0;

    res = CShingleTime::GetMicroSec();

    sph->CheckField(pFieldName, {pField, size_t(FieldLen)}, coding, fValid, fMime);

    res = CShingleTime::GetMicroSec() - res;

    return res;
}

ui32 TIPMess::TestBanCriterion(const char* BUFF, ui32 BuffSize, TMemRecordCopy* memrec, TReport& m_repo, TObrabData& odata, TTimes& DelayT, float CurrMPS, int memory_index) {
    if (odata.pdld.m_exportdata.m_fPop3 || odata.pdld.m_exportdata.m_Uwl || odata.pdld.m_exportdata.m_fDSN || odata.pdld.m_exportdata.m_fSource_level_1 || odata.pdld.m_exportdata.m_fOurUser)
        return 0;

    ui32 res = 0;
    ui32 tSpam = 0, tDSN = 0, tPop3 = 0, tHam = 0, sSpam = 0, sW = 0, sMc = 0;
    ui32 sumSpam = 0, sumDSN = 0, sumPop3 = 0, sumHam = 0, sumWMess = 0, sumWeightSum = 0, sumMcount = 0, sumMalic = 0;
    ui32 sumSpamMail = 0, sumHamMail = 0, sumMalicMail = 0, sumAllMail = 0;
    float prcSpamMail = 0, prcHamMail = 0, prcMalicMail = 0, prcSpamMailBox = 0;
    ui8 prcSpamMailb = 0, prcHamMailb = 0, prcMalicMailb = 0;
    bool sRBL4 = false;
    bool f_bad_zone = false;
    ui32 dSpamHam = 0;
    //ui32       uidscount     = 0;
    ui32 aHam = 0, aSpam = 0, aDSN = 0, allSpam = 0, aSpamToHam = 0, aSpamAndHam = 0;
    ui16 aAutoRejects = 0, aNoRejects = 0, aForwards = 0, aPop3 = 0;
    ui32 aRejects = 0;
    TString title = "";
    TString rulename = "";
    ui16 criterion = 0, hour = 0, repeater = 0, forward = 0, probbancriterion = 0;
    char sbuff[16];
    int bad_type = 0;
    float koef = 0, koef1 = 0, koef2 = 0;
    ui32 totnDSNtoAll = 0, totnPop3toAll = 0, hotnDSNtoAll = 0, hotnPop3toAll = 0;
    ui32 totnMalictoSpam = 0, hotnMalictoSpam = 0;
    ui32 tdDSN = 0, tAll = 0, hDSN = 0, hAll = 0, tPOP3 = 0, hPOP3 = 0, tMalic = 0, aMalic = 0;
    ui32 tHamT = 0, tSpamT = 0, tMalicT = 0, tAllT = 0;
    //ui32       otnmailcounttoboxcount = 0, summ500toboxcount = 0;
    //bool       is_moreonemailinbox = false, is_moretwomailinbox = false;
    TString ps = "", si_spam = "", si_dsn = "", si_pop3 = "", si_ham = "", si_malic = "", si_cps = "", si_longcps = "";
    TString sourceip = "";
    kipv6::TStringsLists* RPL = NULL;
    TString panratios = "";
    bool ban2 = false, ban7 = false, ban8 = false;
    bool obad1 = false, obad2 = false, obad3 = false, obad4 = false, obad5 = false;
    float tcps = 0;
    TString skoef = "";
    time_t tdiff = 0;
    float longcps = 0;
    TListRule *listrule = NULL, *listrulenew = NULL;
    TPStatF periodstat;
    ui32 in_mps_koef = 0;
    //ui32       today_manual_ban_count = 0;
    //ui32       yesterday_manual_ban_count = 0;
    ui32 history_manual_ban_count = 0;
    ui32 filter_work_tick = 0;
    ui32 filter_get_tick = 0;
    TString fdsl_stor_text = "-";

    if (store != NULL)
        RPL = store->GetRulePrintList();
    if (perstat != NULL)
        periodstat = perstat->GetLastCalcData();
    if (TrafficControl != NULL)
        in_mps_koef = TrafficControl->GetKoef();

    if (memrec != NULL) {
        koef1 = (float)1 - (float)(((float)(odata.m_curr_time - memrec->today.tFixDay)) / ((float)3600 * 24));
        koef2 = memrec->today.koef2;
        koef = (float)koef1 * (float)koef2;

        skoef = FloatToStr(koef) + " (k1=" + FloatToStr(koef1) + ", k2=" + FloatToStr(koef2) + ")";

        sumSpam = memrec->today.ctSpam + ((float)koef * (float)memrec->yesterday.ctSpam);
        sumDSN = memrec->today.cDsn + ((float)koef * (float)memrec->yesterday.cDsn);
        sumPop3 = memrec->today.cPop3 + ((float)koef * (float)memrec->yesterday.cPop3);
        sumHam = memrec->today.ctHam + ((float)koef * (float)memrec->yesterday.ctHam);
        sumWMess = memrec->today.cWMess + ((float)koef * (float)memrec->yesterday.cWMess);
        sumWeightSum = memrec->today.cWeightSum + ((float)koef * (float)memrec->yesterday.cWeightSum);
        sumMcount = memrec->today.cMcount + ((float)koef * (float)memrec->yesterday.cMcount);
        sumMalic = memrec->today.ctMalicSpam + ((float)koef * (float)memrec->yesterday.ctMalicSpam);

        sumSpamMail = memrec->today.ctSpamMail + ((float)koef * (float)memrec->yesterday.ctSpamMail);
        sumHamMail = memrec->today.ctHamMail + ((float)koef * (float)memrec->yesterday.ctHamMail);
        sumMalicMail = memrec->today.ctMalicSpamMail + ((float)koef * (float)memrec->yesterday.ctMalicSpamMail);
        sumAllMail = sumSpamMail + sumHamMail;
        if (sumAllMail > 0) //������ ���������
        {
            prcSpamMail = (float)sumSpamMail / (float)sumAllMail * (float)100;
            prcHamMail = (float)sumHamMail / (float)sumAllMail * (float)100;
            prcMalicMail = (float)sumMalicMail / (float)sumAllMail * (float)100;

            prcSpamMailb = (ui8)prcSpamMail;
            prcHamMailb = (ui8)prcHamMail;
            prcMalicMailb = (ui8)prcMalicMail;
        }
        //if (memrec->today.frwddata.box_count > 0)
        //   prcSpamMailBox = (float)memrec->today.SpamMailBoxCount / (float)memrec->today.frwddata.box_count * (float)100;

        si_spam = IntToStroka(sumSpam) + " (" + IntToStroka(sumSpamMail) + "): " + IntToStroka(memrec->today.ctSpam) + " (" + IntToStroka(memrec->today.ctSpamMail) + ") / " + IntToStroka(memrec->yesterday.ctSpam) + " (" + IntToStroka(memrec->yesterday.ctSpamMail) + ") / " + IntToStroka(memrec->history.ctSpam);
        si_dsn = IntToStroka(sumDSN) + ": " + IntToStroka(memrec->today.cDsn) + " / " + IntToStroka(memrec->yesterday.cDsn) + " / " + IntToStroka(memrec->history.cDsn);
        si_pop3 = IntToStroka(sumPop3) + ": " + IntToStroka(memrec->today.cPop3) + " / " + IntToStroka(memrec->yesterday.cPop3) + " / " + IntToStroka(memrec->history.cPop3_Auth) + " days";
        si_ham = IntToStroka(sumHam) + " (" + IntToStroka(sumHamMail) + "): " + IntToStroka(memrec->today.ctHam) + " (" + IntToStroka(memrec->today.ctHamMail) + ") / " + IntToStroka(memrec->yesterday.ctHam) + " (" + IntToStroka(memrec->yesterday.ctHamMail) + ") / " + IntToStroka(memrec->history.ctHam);
        si_malic = IntToStroka(sumMalic) + " (" + IntToStroka(sumMalicMail) + "): " + IntToStroka(memrec->today.ctMalicSpam) + " (" + IntToStroka(memrec->today.ctMalicSpamMail) + ") / " + IntToStroka(memrec->yesterday.ctMalicSpam) + " (" + IntToStroka(memrec->yesterday.ctMalicSpamMail) + ") / " + IntToStroka(memrec->history.ctMalicSpam);

        tHamT = memrec->today.ctHam;
        tSpamT = memrec->today.ctSpam;
        tMalicT = memrec->today.ctMalicSpam;
        tAllT = tSpamT + tHamT;

        //today_manual_ban_count     = memrec->today.cManualBanCount;
        //yesterday_manual_ban_count = memrec->yesterday.cManualBanCount;
        history_manual_ban_count = memrec->history.cManualBanCount;

        //today
        tAll = sumSpam + sumHam;
        tdDSN = sumDSN;
        tPOP3 = sumPop3;
        if (tAll > 0)
            totnDSNtoAll = (ui32)((float)tdDSN / (float)tAll * (float)100);
        if (tAll > 0)
            totnPop3toAll = (ui32)((float)tPop3 / (float)tAll * (float)100);
        if (sumSpam > 0)
            totnMalictoSpam = (ui32)((float)sumMalic / (float)sumSpam * (float)100);

        tSpam = sumSpam;
        tDSN = sumDSN;
        tPop3 = sumPop3;
        tDSN += tPop3;
        tHam = sumHam;
        tMalic = sumMalic;
        sSpam = (tSpam > tDSN) ? (tSpam - tDSN) : 0;
        if (sumWMess > 0)
            sW = sumWeightSum / sumWMess; //average rules-weight
        sMc = sumMcount;
        sRBL4 = odata.pdld.m_exportdata.m_fRBL && odata.pdld.m_exportdata.m_fRBL4;
        if (tHam > 0)
            dSpamHam = sSpam / tHam;
        //if (memrec != NULL)
        //   uidscount  = memrec->today.frwddata.box_count;
        tcps = odata.m_cps;

        tdiff = odata.m_curr_time - memrec->today.tFixDay;
        if (tdiff > 900)
            longcps = (float)(memrec->today.ctSpam + memrec->today.ctHam) / (float)tdiff;

        si_cps = FloatToStr(tcps);
        si_longcps = FloatToStr(longcps);

        //history
        hAll = memrec->history.ctHam + memrec->history.ctSpam;
        hDSN = memrec->history.cDsn;
        hPOP3 = memrec->history.cPop3_Auth;
        aMalic = memrec->history.ctMalicSpam;
        if (hAll > 0)
            hotnDSNtoAll = (ui32)((float)hDSN / (float)hAll * (float)100);
        if (hAll > 0)
            hotnPop3toAll = (ui32)((float)hPOP3 / (float)hAll * (float)100);
        if (memrec->history.ctSpam > 0)
            hotnMalictoSpam = (ui32)((float)memrec->history.ctMalicSpam / (float)memrec->history.ctSpam * (float)100);

        aHam = memrec->history.ctHam;
        aSpam = memrec->history.ctSpam;
        aDSN = memrec->history.cDsn;
        allSpam = (aSpam > aDSN) ? (aSpam - aDSN) : 0;
        if (aHam > 0)
            aSpamToHam = allSpam / aHam;
        aSpamAndHam = aSpam + aHam;
        aRejects = IncMax32(static_cast<ui32>(memrec->history.cDaysRej), memrec->history.cManualBanCount);
        aAutoRejects = memrec->history.cDaysRej;
        aNoRejects = memrec->history.cDaysNoRej;
        aForwards = memrec->history.cFwdDays;
        aPop3 = memrec->history.cPop3_Auth;

        //forwards
        //m_repo.Setforward_comments(TString(memrec->today.frwddata.forward_comments));

        //if (memrec->today.frwddata.box_count > 0)
        //{
        //  otnmailcounttoboxcount = (ui32)((float)memrec->today.frwddata.mail_count / (float)memrec->today.frwddata.box_count);
        //  summ500toboxcount = (ui32)((float)memrec->today.frwddata.summ_500 / (float)memrec->today.frwddata.box_count);
        //}
        //is_moreonemailinbox = (memrec->today.frwddata.a_count_mail[1] < (memrec->today.frwddata.mail_count - memrec->today.frwddata.a_count_mail[1]));
        //is_moretwomailinbox = ( (memrec->today.frwddata.a_count_mail[1] + memrec->today.frwddata.a_count_mail[2]) < (memrec->today.frwddata.mail_count - memrec->today.frwddata.a_count_mail[1] - memrec->today.frwddata.a_count_mail[2]) );

        f_bad_zone = strcmp(odata.m_zn, "br") == 0 ||
                     strcmp(odata.m_zn, "cn") == 0 ||
                     strcmp(odata.m_zn, "cr") == 0 ||
                     strcmp(odata.m_zn, "cy") == 0 ||
                     strcmp(odata.m_zn, "hk") == 0 ||
                     strcmp(odata.m_zn, "jp") == 0 ||
                     strcmp(odata.m_zn, "kr") == 0 ||
                     strcmp(odata.m_zn, "my") == 0 ||
                     strcmp(odata.m_zn, "pk") == 0 ||
                     strcmp(odata.m_zn, "pl") == 0 ||
                     strcmp(odata.m_zn, "tw") == 0;

        bad_type = odata.m_bad_type; //��������� � ������: 1 - � bad1.txt, 2 - � bad2.txt (����� �������� ��� �������� ���� ������)

        if (RuleTrap != NULL) {
            //��������� ������� �� ��������� ������� �����
            RuleTrap->CheckLiveTrap(odata.m_curr_time);
            //���������� ������ ������, ������� ���� ���������
            listrule = RuleTrap->GetCheckRule((size_t)odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip);
        }

        //******************** RULES (FILTER WORK) *********************
        if (RenginePool != NULL) {
            filter_get_tick = CShingleTime::GetMs();

            TRengineElement* tre = RenginePool->GetFilter();

            filter_get_tick = CShingleTime::GetMs() - filter_get_tick;
            if (statipobj != NULL)
                ((TStatIPObject*)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_GET_FILTER, 1, true, filter_get_tick);

            filter_work_tick = CShingleTime::GetMs();
            if (tre != NULL) {
                int filter_index = tre->GetIndex();
                TString rules_cs = tre->GetRulesCS();

                TRengine* m_hSp = &tre->GetFilterHandle();
                if (m_hSp != NULL) {
                    DelayT.timesn[0] = CShingleTime::GetMs();

                    rules_mon_stat.AddFilterCall(rules_cs);

                    if (odata.pdld.m_exportdata.m_MessId == "")
                        odata.pdld.m_exportdata.m_MessId = "???";
                    title = odata.pdld.m_exportdata.messfull;
                    m_hSp->InitMessage(title, nullptr, nullptr, "", TSpClass::UNKNOWN, SysLogger());

                    for (unsigned short iz : memrec->today.PANNERN_STAT)
                        ps = ps + IntToStroka2(iz) + ", ";

                    sourceip = "ip: " + memrec->today.ip.toStroka() + ", rdns: " + TString(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns) + ", helo: " + TString(odata.pdld.m_exportdata.ipaddresses.sourceip.m_helo) + ", geo: " + odata.pdld.m_exportdata.m_geo + " (" + odata.pdld.m_exportdata.m_geotime + ")";

                    m_hSp->AddStat("fidx", IntToStroka(filter_index) + "=" + rules_cs);
                    m_hSp->AddStat("fixd", ConvertTime2(memrec->today.tFixDay));
                    m_hSp->AddStat("bad ", IntToStroka(bad_type) + ", " + IntToStroka(odata.m_bad_type1) + " - " + IntToStroka(odata.m_bad_type2) + " - " + IntToStroka(odata.m_bad_type3) + " - " + IntToStroka(odata.m_bad_type4) + " - " + IntToStroka(odata.m_bad_type5));
                    m_hSp->AddStat("ip  ", sourceip);
                    m_hSp->AddStat("msid", odata.messageid);
                    if (odata.m_rep.GetMailNumberShort().size() > 0)
                        m_hSp->AddStat("mnmb", odata.m_rep.GetMailNumberShort());
                    m_hSp->AddStat("pst ", ps);
                    m_hSp->AddStat("frwd", m_repo.Getforward_comments());
                    m_hSp->AddStat("ispm", si_spam);
                    m_hSp->AddStat("idsn", si_dsn);
                    m_hSp->AddStat("ipp3", si_pop3);
                    m_hSp->AddStat("iham", si_ham);
                    m_hSp->AddStat("imlc", si_malic);
                    m_hSp->AddStat("mps ", si_cps + " (avrt=" + si_longcps + ", D1=" + IntToStroka(memrec->today.cps5mcount) + ", D2=" + IntToStroka(memrec->today.cps20mcount) + ", D3=" + IntToStroka(memrec->today.cps50mcount) + ", D4=" + IntToStroka(memrec->today.cps100mcount) + ", D5=" + IntToStroka(memrec->today.cpsGreatmcount) + ")");
                    m_hSp->AddStat("koef", skoef);
                    m_hSp->AddStat("gmps", FloatToStr2(CurrMPS));
                    if (odata.m_dslfirst)
                        fdsl_stor_text = FloatToStr(odata.m_dslfirst_rps);
                    m_hSp->AddStat("hmps", "fdsl_stor " + fdsl_stor_text + " dsl " + FloatToStr(periodstat.dsl_count) + " dslm " + FloatToStr(periodstat.dsl_mail_count) + " ban " + FloatToStr(periodstat.banip_count) + " divkoef " + IntToStroka(in_mps_koef));
                    m_hSp->AddStat("hrej", "r=" + IntToStroka(aRejects) + ", n=" + IntToStroka(aNoRejects));
                    m_hSp->AddStat("mbnc", IntToStroka(history_manual_ban_count));

                    //forwards
                    //m_hSp->CheckRange("fBoxCount",     memrec->today.frwddata.box_count);
                    //m_hSp->CheckRange("fAllMailCount", memrec->today.frwddata.mail_count);
                    //m_hSp->CheckRange("fSumm500",      memrec->today.frwddata.summ_500);
                    //m_hSp->CheckRange("faMail00",      memrec->today.frwddata.a_all); //������ ������������ ���� ��-�� ����������� �� ����.���-�� �����
                    //for (int i = 1; i < 16; i++) //������� ��������� ��-�� ����������� ���-�� ����� �� 65535
                    //   m_hSp->CheckRange(("faMail" + IntToStroka2(i)).c_str(), memrec->today.frwddata.a_count_mail[i]);
                    //m_hSp->CheckRange("fMailCountToBoxCount", otnmailcounttoboxcount);
                    //m_hSp->CheckRange("fSumm500ToBoxCount",   summ500toboxcount);
                    //if (is_moreonemailinbox)
                    //   SpSetRuleK(m_hSp, "fIsMoreOneMailInBox"); //���� �����, � ������� ��������� ����� ������ ������
                    //if (is_moretwomailinbox)
                    //   SpSetRuleK(m_hSp, "fIsMoreTwoMailInBox"); //���� �����, � ������� ��������� ����� ���� �����

                    //today
                    m_hSp->CheckRange("tHamT", tHamT);     //���������� ���� �� ������� (��� ����� �����)
                    m_hSp->CheckRange("tSpamT", tSpamT);   //���������� ����� �� ������� (��� ����� �����)
                    m_hSp->CheckRange("tMalicT", tMalicT); //���������� ������ �� ������� (��� ����� �����)
                    m_hSp->CheckRange("tAllT", tAllT);     //���������� ����� �� ������� (��� ����� �����)

                    m_hSp->CheckRange("tHamMail", sumHamMail);           //���-�� ������� ����� (�� uid'��)
                    m_hSp->CheckRange("tSpamMail", sumSpamMail);         //���-�� �������� ����� (�� uid'��)
                    m_hSp->CheckRange("tMalicMail", sumMalicMail);       //���-�� ����� ������ (�� uid'��)
                    m_hSp->CheckRange("tPrHamMail", prcHamMail);         //������� ����
                    m_hSp->CheckRange("tPrSpamMail", prcSpamMail);       //������� �����
                    m_hSp->CheckRange("tPrMalicMail", prcMalicMail);     //������� ������
                    m_hSp->CheckRange("tPrSpamMailBox", prcSpamMailBox); //������� ������, ���������� ���� ���� �������� ������

                    m_hSp->CheckRange("tAll", tAll);        //���������� ����� �� �������
                    m_hSp->CheckRange("tHam", tHam);        //���������� ���� + �������� �� �������
                    m_hSp->CheckRange("tSpamWoDSN", sSpam); //���������� ����� �� ������� ��� DSN
                    m_hSp->CheckRange("tWeight", sW);       //average rules-weight
                    m_hSp->CheckRange("tMcount", sMc);
                    m_hSp->CheckRange("tSpamToHam", dSpamHam); //��������� ����� � ����
                    //m_hSp->CheckRange("tUidsCount",      uidscount);                      //���������� ������
                    m_hSp->CheckRange("tdDSN", tdDSN);                              //���-�� DSN
                    m_hSp->CheckRange("tPOP3", tPOP3);                              //���-�� Pop3
                    m_hSp->CheckRange("totnDSNtoAll", totnDSNtoAll);                //��������� DSN � ������ ���-�� �����
                    m_hSp->CheckRange("totnPop3toAll", totnPop3toAll);              //��������� Pop3 � ������ ���-�� �����
                    m_hSp->CheckRange("totnMalictoSpam", totnMalictoSpam);          //������� malic �� ������ ���-�� �����
                    m_hSp->CheckRange("tMalic", tMalic);                            //���-�� malic �� �������
                    m_hSp->CheckRange("tCPS", tcps);                                //����� � ������� � ������� ip (��� �� ����� 15 ���)
                    m_hSp->CheckRange("tAVRCPS", longcps);                          //������� ����� � ������� � ������� ip �� ������� (��������� �� ������ 15 ����� �� ������ �����)
                    m_hSp->CheckRange("tMPSD1COUNT", memrec->today.cps5mcount);     //���-�� �����, ����������, ����� mps ���� � ��������� �� 0 �� 5
                    m_hSp->CheckRange("tMPSD2COUNT", memrec->today.cps20mcount);    //���-�� �����, ����������, ����� mps ���� � ��������� �� 5 �� 20
                    m_hSp->CheckRange("tMPSD3COUNT", memrec->today.cps50mcount);    //���-�� �����, ����������, ����� mps ���� � ��������� �� 20 �� 50
                    m_hSp->CheckRange("tMPSD4COUNT", memrec->today.cps100mcount);   //���-�� �����, ����������, ����� mps ���� � ��������� �� 50 �� 100
                    m_hSp->CheckRange("tMPSD5COUNT", memrec->today.cpsGreatmcount); //���-�� �����, ����������, ����� mps ���� ������ 100

                    //m_hSp->CheckRange("tMANBANCOUNT",    today_manual_ban_count);         //��� ���� �������� ������� �� �������
                    //m_hSp->CheckRange("yMANBANCOUNT",    yesterday_manual_ban_count);     //��� ���� �������� ������� �� �����
                    m_hSp->CheckRange("hMANBANCOUNT", history_manual_ban_count); //��� ���� �������� ������� (�������)

                    char sbuff[17];
                    for (int iz = 0; iz < 15; iz++) {
                        snprintf(sbuff, sizeof(sbuff) - 1, "PANNERN_STAT_%u", iz + 1);
                        m_hSp->CheckRange(sbuff, memrec->today.PANNERN_STAT[iz]);
                    }
                    ui32 psproc = 0;
                    for (int iz = 0; iz < 15; iz++) {
                        snprintf(sbuff, sizeof(sbuff) - 1, "PANNERN_RATIO_%u", iz + 1);

                        if (tAll > 0)
                            psproc = (ui32)((double)100 * (double)memrec->today.PANNERN_STAT[iz] / (double)tAll);
                        else
                            psproc = 0;

                        panratios = panratios + IntToStroka(psproc) + ", ";
                        m_hSp->CheckRange(sbuff, psproc);
                    }
                    m_hSp->AddStat("prat", panratios);

                    if (memrec->today.ip.IsIPv6())
                        SpSetRule(m_hSp, "ISIPV6");
                    else
                        SpSetRule(m_hSp, "ISIPV4");

                    //history
                    m_hSp->CheckRange("aHam", aHam);                 //���������� ���� + �������� �� �������
                    m_hSp->CheckRange("aSpamWoDSN", allSpam);        //���������� ����� �� ������� ��� DSN
                    m_hSp->CheckRange("aSpamToHam", aSpamToHam);     //��������� ����� � ���� �� �������
                    m_hSp->CheckRange("aSpamAndHam", aSpamAndHam);   //����� ����� � ����
                    m_hSp->CheckRange("aRejects", aRejects);         //�� ������� ���������
                    m_hSp->CheckRange("hAutoRejects", aAutoRejects); //�� ������� ���������
                    m_hSp->CheckRange("aNoRejects", aNoRejects);     //�� ������� �� ���������
                    m_hSp->CheckRange("aForwards", aForwards);       //�� ������� ���������
                    m_hSp->CheckRange("aPop3", aPop3);               //�� ������� POP3

                    m_hSp->CheckRange("adDSN", hDSN);                      //���-�� DSN
                    m_hSp->CheckRange("aotnDSNtoAll", hotnDSNtoAll);       //��������� DSN � ������ ���-�� �����
                    m_hSp->CheckRange("aotnPop3toAll", hotnPop3toAll);     //��������� Pop3 � ������ ���-�� �����
                    m_hSp->CheckRange("aotnMalictoSpam", hotnMalictoSpam); //������� malic �� ������ ���-�� �����
                    m_hSp->CheckRange("aMalic", aMalic);                   //���-�� malic �� �������

                    //general MPS
                    m_hSp->CheckRange("generalmps", CurrMPS);

                    //other
                    m_hSp->CheckRange("oBadType", bad_type); //��������� � ������: 1 - � bad1.txt, 2 - � bad2.txt (����� �������� ��� �������� ���� ������)
                    if (odata.m_bad_type1 > 0)
                        SpSetRule(m_hSp, "oBad1");
                    if (odata.m_bad_type2 > 0)
                        SpSetRule(m_hSp, "oBad2");
                    if (odata.m_bad_type3 > 0)
                        SpSetRule(m_hSp, "oBad3");
                    if (odata.m_bad_type4 > 0)
                        SpSetRule(m_hSp, "oBad4");
                    if (odata.m_bad_type5 > 0)
                        SpSetRule(m_hSp, "oBad5");

                    if (odata.m_dslfirst)
                        m_hSp->CheckRange("rps_dslfirst", odata.m_dslfirst_rps);  //dslfirst request per second
                    m_hSp->CheckRange("mps_dsl", periodstat.dsl_count);           //dsl count per second
                    m_hSp->CheckRange("mps_dsl_mail", periodstat.dsl_mail_count); //dsl mail count per second
                    m_hSp->CheckRange("mps_banip", periodstat.banip_count);       //banip count per second
                    m_hSp->CheckRange("in_mps_koef", in_mps_koef);                //����������� ������� �������� ������

                    //flags
                    if (f_bad_zone)
                        SpSetRule(m_hSp, "F_BAD_ZONE");
                    if (odata.m_fIpDsl)
                        SpSetRule(m_hSp, "F_HOST_IP_DSL");
                    if (odata.m_fRBL_hash)
                        SpSetRule(m_hSp, "F_RBL");
                    if ((store != NULL) && (store->GetShadyHosts() != NULL) && (store->GetShadyHosts()->Find(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns2.c_str()) || store->GetShadyHosts()->Find(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns3.c_str())))
                        SpSetRule(m_hSp, "F_SHADY_HOSTS");
                    if (odata.pdld.m_exportdata.m_fDsl_first)
                        SpSetRule(m_hSp, "F_DSL_FIRST");
                    if (odata.pdld.m_exportdata.m_fNoresolv_first)
                        SpSetRule(m_hSp, "F_NORESOLV_FIRST");
                    if (odata.pdld.m_exportdata.m_fDsl_first8)
                        SpSetRule(m_hSp, "F_DSL_FIRST8");
                    if (sRBL4)
                        SpSetRule(m_hSp, "F_RBL4");

                    if (odata.pdld.m_exportdata.m_fSpf)
                        SpSetRule(m_hSp, "F_SPF");
                    if (odata.pdld.m_exportdata.m_fDsl_first67891014)
                        SpSetRule(m_hSp, "F_DSL_FIRST67891014");
                    if (odata.pdld.m_exportdata.m_fBW)
                        SpSetRule(m_hSp, "F_BW");
                    if (odata.pdld.m_exportdata.m_fCOMBL)
                        SpSetRule(m_hSp, "F_COMBL");
                    if (odata.pdld.m_exportdata.m_fSHM)
                        SpSetRule(m_hSp, "F_SHM");
                    if (odata.pdld.m_exportdata.m_f20)
                        SpSetRule(m_hSp, "F_20");
                    if (odata.pdld.m_exportdata.m_f21)
                        SpSetRule(m_hSp, "F_21");
                    if (odata.pdld.m_exportdata.m_f22)
                        SpSetRule(m_hSp, "F_22");
                    if (odata.pdld.m_exportdata.m_f__HELO_LOCALHOST)
                        SpSetRule(m_hSp, "F_HELO_LOCALHOST");

                    for (ui32 i = 0; i < TGrayListStatus::GREYLIST_COUNT; i++) {
                        if (odata.m_graylists_status.addr[i])
                            SpSetRule(m_hSp, ("GL_ADDR_" + IntToStroka(i + 1)).c_str());

                        if (odata.m_graylists_status.net[i])
                            SpSetRule(m_hSp, ("GL_NET_" + IntToStroka(i + 1)).c_str());

                        if (odata.m_graylists_status.host[i])
                            SpSetRule(m_hSp, ("GL_HOST_" + IntToStroka(i + 1)).c_str());
                    }

                    //r_sp rule
                    auto lit = odata.pdld.rsp_list.begin();
                    while (lit != odata.pdld.rsp_list.end()) {
                        if (odata.use_hide_could_not_find_rule)
                            m_hSp->m_cur->rulesContext.SetRule((*lit).first.c_str());
                        else
                            SpSetRule(m_hSp, (*lit).first.c_str());

                        ++lit;
                    }
                    //r_dl rule
                    lit = odata.pdld.rdl_list.begin();
                    while (lit != odata.pdld.rdl_list.end()) {
                        if (odata.use_hide_could_not_find_rule)
                            m_hSp->m_cur->rulesContext.SetRule((*lit).first.c_str());
                        else
                            SpSetRule(m_hSp, (*lit).first.c_str());

                        ++lit;
                    }
                    //r_nl rule
                    lit = odata.pdld.rnl_list.begin();
                    while (lit != odata.pdld.rnl_list.end()) {
                        if (odata.use_hide_could_not_find_rule)
                            m_hSp->m_cur->rulesContext.SetRule((*lit).first.c_str());
                        else
                            SpSetRule(m_hSp, (*lit).first.c_str());

                        ++lit;
                    }

                    if (m_hSp != NULL) {
                        char sip[32];

                        memset(sip, 0, sizeof(sip));
                        IntToIp((size_t)odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, sip);

                        ((TRengine*)m_hSp)->CheckIP(sip);
                        ((TRengine*)m_hSp)->CheckRdns(odata.pdld.m_exportdata.ipaddresses.sourceip.m_rdns);
                        ((TRengine*)m_hSp)->CheckGEO(odata.pdld.m_exportdata.m_geo);
                    }

                    if (!odata.pdld.m_exportdata.m_geotime.empty())
                        SpCheckFieldTick(m_hSp, "iptm", odata.pdld.m_exportdata.m_geotime.c_str(), (int)odata.pdld.m_exportdata.m_geotime.length(), "cp1251", true, false);
                    //SpCheckField(m_hSp, "iptm", odata.pdld.m_exportdata.m_geotime.c_str(), (int)odata.pdld.m_exportdata.m_geotime.length(), "cp1251", true, false);

                    NProf::Profiler prof;
                    TCheckedMessage checkedMessage;
                    m_hSp->CheckMessage(prof, nullptr, checkedMessage);
                    TSpClass spamresv = checkedMessage.spClass;
                    //if (spamresv == spSpam)
                    if (true) {
                        TCritRuleList critlist;
                        TCritRuleListRIt rit;

                        //find rulename BAN_INTERNAL
                        odata.m_baninternal = m_hSp->ExistsbanInternal("BAN_INTERNAL");

                        //find rulename UNDO_BAN_IP
                        odata.m_undoban = m_hSp->ExistsbanInternal("UNDO_BAN_IP");

                        //find rulename UNDO_BAN_MESS
                        odata.m_undobanmess = m_hSp->ExistsbanInternal("UNDO_BAN_MESS");

                        if (listrule != NULL) {
                            TListRuleIt lrit;

                            listrulenew = new TListRule();
                            if (listrulenew != NULL) {
                                lrit = listrule->begin();
                                while (lrit != listrule->end()) {
                                    if (m_hSp->ExistsbanInternal((*lrit).c_str()))
                                        listrulenew->push_back((*lrit));

                                    ++lrit;
                                }
                            }
                            listrule->clear();
                            delete listrule;
                            listrule = NULL;
                        }

                        if (memrec->today.ip.IsIPv4()) //IPv4
                        {
                            //ban rule
                            m_hSp->GetWorkedCriterionBanRule(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                criterion = (*rit).Criterion;
                                hour = (*rit).Hour;

                                if (odata.m_undoban) //undo ban
                                {
                                    rulename = "";
                                    criterion = 0;
                                    hour = 0;
                                } else {
                                    m_repo.SetRulename(rulename);
                                    m_repo.SetCriterion(criterion);
                                    m_repo.SetHour(hour);
                                    m_repo.SetBanHour(hour);
                                }
                            }
                            critlist.clear();

                            //repeater rule
                            m_hSp->GetWorkedCriterionRPTRule(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                repeater = (*rit).Hour;

                                if (repeater > 0)
                                    m_repo.SetRepeaterType(repeater);
                            }
                            critlist.clear();

                            //forward rule
                            m_hSp->GetWorkedCriterionFRWDRule(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                forward = (*rit).Hour;

                                if (forward > 0) {
                                    m_repo.SetFrwd(forward);
                                    //if (memrec != NULL)
                                    //   SET_SF_FORWARD(memrec->today.bMask);
                                }
                            }
                            critlist.clear();

                            //probban rule
                            m_hSp->GetWorkedCriterionPROBBANRule(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                probbancriterion = (*rit).Hour;

                                if (probbancriterion > 0) {
                                    m_repo.SetPROBBANCriterion(probbancriterion);
                                    //if (memrec != NULL)
                                    //   SET_SF_BAN_PROB(memrec->today.bMask);
                                }
                            }
                            critlist.clear();

                            //ban2 rule
                            m_hSp->GetWorkedCriterionBAN2Rule(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                ban2 = true;

                                if (odata.m_undobanmess) {
                                    rulename = "";
                                    ban2 = false;
                                }
                            }
                            critlist.clear();

                            //ban7 rule
                            m_hSp->GetWorkedCriterionBAN7Rule(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                ban7 = true;
                            }
                            critlist.clear();

                            //ban8 rule
                            m_hSp->GetWorkedCriterionBAN8Rule(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                ban8 = true;
                            }
                            critlist.clear();

                        } else //IPv6
                        {
                            //ban rule
                            m_hSp->GetWorkedCriterionBanRuleIPv6(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                criterion = (*rit).Criterion;
                                hour = (*rit).Hour;

                                if (odata.m_undoban) //undo ban
                                {
                                    rulename = "";
                                    criterion = 0;
                                    hour = 0;
                                } else {
                                    m_repo.SetRulename(rulename);
                                    m_repo.SetCriterion(criterion);
                                    m_repo.SetHour(hour);
                                    m_repo.SetBanHour(hour);
                                }
                            }
                            critlist.clear();

                            //repeater rule
                            m_hSp->GetWorkedCriterionRPTRuleIPv6(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                repeater = (*rit).Hour;

                                if (repeater > 0)
                                    m_repo.SetRepeaterType(repeater);
                            }
                            critlist.clear();

                            //forward rule
                            m_hSp->GetWorkedCriterionFRWDRuleIPv6(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                forward = (*rit).Hour;

                                if (forward > 0) {
                                    m_repo.SetFrwd(forward);
                                    //if (memrec != NULL)
                                    //   SET_SF_FORWARD(memrec->today.bMask);
                                }
                            }
                            critlist.clear();

                            //probban rule
                            m_hSp->GetWorkedCriterionPROBBANRuleIPv6(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                probbancriterion = (*rit).Hour;

                                if (probbancriterion > 0) {
                                    m_repo.SetPROBBANCriterion(probbancriterion);
                                    //if (memrec != NULL)
                                    //   SET_SF_BAN_PROB(memrec->today.bMask);
                                }
                            }
                            critlist.clear();

                            //ban2 rule
                            m_hSp->GetWorkedCriterionBAN2RuleIPv6(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                ban2 = true;

                                if (odata.m_undobanmess) {
                                    rulename = "";
                                    ban2 = false;
                                }
                            }
                            critlist.clear();

                            //ban7 rule
                            m_hSp->GetWorkedCriterionBAN7RuleIPv6(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                ban7 = true;
                            }
                            critlist.clear();

                            //ban8 rule
                            m_hSp->GetWorkedCriterionBAN8RuleIPv6(critlist);
                            rit = critlist.rbegin();
                            if (rit != critlist.rend()) {
                                rulename = (*rit).RULENAME;
                                ban8 = true;
                            }
                            critlist.clear();

                            m_hSp->EndMessage(LogsGroup->DelivryLog, {});
                        }
                    }

                    DelayT.timesn[0] = CShingleTime::GetMs() - DelayT.timesn[0];
                }
                RenginePool->ReturnFilter(tre);
            }

            filter_work_tick = CShingleTime::GetMs() - filter_work_tick;
            if (statipobj != NULL)
                ((TStatIPObject*)statipobj)->AddInStatCount(odata.stat_ident.m_db, odata.stat_ident.m_coll, STATTICK_WORK_FILTER, 1, true, filter_work_tick);
        }
        //********************** END WORK FILTER *************************

        if (RuleTrap != NULL) {
            TString ruledir = RuleTrap->GetDir();
            TListRuleIt lrit;
            TString filename = "";
            bool first = false;

            if ((!ruledir.empty()) && (listrulenew != NULL)) {
                lrit = listrulenew->begin();
                while (lrit != listrulenew->end()) {
                    filename = ruledir + (*lrit);
                    first = RuleTrap->IsFirst((*lrit));
                    WriteRuleStatMail(BUFF, BuffSize, filename, first);

                    ++lrit;
                }
            }
            RuleTrap->SetPriznak((size_t)odata.pdld.m_exportdata.ipaddresses.sourceip.m_ip, listrulenew);
        }

#ifndef MONGO_OPTM
        if (((forward > 0) || (probbancriterion > 0) || (criterion > 0)) && (store != NULL) && (store->GetMemBasa() != NULL)) {
            printf("mSetFrwdPrbn\n");
            store->GetMemBasa()->mSetFrwdPrbn(memrec->today.ip, forward, probbancriterion, criterion);
        }
#endif //MONGO_OPTM

        odata.m_repeater = repeater;
        odata.m_criterion_n = criterion;
        odata.m_Forwards = forward;
        odata.m_probbancriterion = probbancriterion;
        odata.m_ban2 = ban2;
        odata.m_ban7 = ban7;
        odata.m_ban8 = ban8;

        if (odata.m_Forwards) {
            res = 0;
            odata.m_ban2 = false;
            odata.m_ban7 = false;
            odata.m_ban8 = false;
        } else {
            res = hour;
        }
    }
    return res;
}

void TIPMess::Midnight() {
    CleanupWhiteCache();

    if ((store != NULL) && (store->GetMemBasa() != NULL))
        store->GetMemBasa()->Midnight();
}

void TIPMess::EventTick() {
}

void TIPMess::IsBanIpExt(TKIPv6 ip, bool& ban, ui16& ban_hours, ui8& ban_pr, bool& ban7, ui16& ban7_hours, ui8& ban7_pr) {
    ban = false;
    ban_hours = 0;
    ban_pr = 0;
    ban7 = false;
    ban7_hours = 0;
    ban7_pr = 0;

    if ((store != NULL) && (store->GetBanIP() != NULL))
        store->GetBanIP()->IsBanIpExt(ip, ban, ban_hours, ban_pr, ban7, ban7_hours, ban7_pr);
}

void TIPMess::AddMonStat(const TString& rules_cs) {
}
