#pragma once

#include "util/generic/hash.h"
#include "util/system/mutex.h"
#include "tlogsgroup.h"
#include "tbasesstore.h"
#include "tstatiptypes.h"
#include "trulestorage.h"
#include "truletrap.h"
#include "tperiodiptrap.h"
#include "ttrap.h"
#include "tperiodstat.h"
#include "trenginepool.h"
#include "tparsedlvlog.h"
#include "tsrvcerror.h"
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/ttrafficcontrol.h>
#include <mail/so/spamstop/tools/so-common/critrule.h>
#include <mail/so/spamstop/sp/setlistrule.h>

#define ST_GEO             7770

//*****************************************************************************************************************************************
//                                     TIPMess - ������� � ��������� �������� ����� delivery
//*****************************************************************************************************************************************

class TIPMess
{
private:
         TLogsGroup        *LogsGroup;
         void              *statipobj;
         TBasesStore       *store;
         TTrafficControl   *TrafficControl;
         TRuleStorage      *m_RulesStorage;
         TRuleTrap         *RuleTrap;
         TPeriodTrap       *PeriodTrap;
         TTrap             *trap;
         TPeriodStat       *perstat;
         TRenginePool      *RenginePool;
         TParsedDlvLog     ParsedObj;
         //TSrvcErrorClass   SrvcErrorsObj;
         TCalcRulesCSStat  rules_mon_stat;
         TDiffCounter      white_counter;
         TDiffCounter      isban_counter;
         TDiffCounter      ban2_counter; //reject
         TDiffCounter      ipv6_counter;
         TDiffCounter      actionban_counter;
         TDiffCounter      changeday1_counter;
         TDiffCounter      changeday2_counter;
         TWhiteIPLocalCache *whiteip_cache;
         TBanIPLocalCache   *banip_cache;

         ui32              PrintTraceLog(TLogStatus status, const char *msg, ...);
         ui32              PrintBan3mail(const char *BUFF, ui32 BuffSize, const char *mailnumber, TKIPv6 ip, bool BanIp, bool MalicUser);
         ui32              PrintRejectLog(const char *msg, ...);
         ui32              PrintActionLog(TLogStatus status, const char *msg, ...);
         ui32              PBPrintProtokolLog(TReport &rep, ui16 criterion, ui16 hour, const char *mailnumber, TMemRecordCopy *memrec, const TString &host, const TString &geo);
         ui32              PrintProtokolLog(TReport &rep, ui16 criterion, ui16 hour, const char *mailnumber, TMemRecordCopy *memrec, const TString &host, const TString &geo);
         ui32              PrintDaylogh(TReport &rep, TMemRecordCopy *memrec);
         ui32              PrintStatlog(TReport &rep, TMemRecordCopy *memrec);
         ui32              PrintTmpBan30(const char *BUFF, ui32 BuffSize, const char *mailnumber);
         ui32              PrintWhiteIPMail(const char *BUFF, ui32 BuffSize, const char *mailnumber);
         ui32              PrintMissing(const char *BUFF, ui32 BuffSize, const char *mailnumber);
         void              WriteRuleStatMail(const char *BUFF, ui32 BuffSize, TString filename, bool first);

         ui32              GetStr(const char *source, ui32 source_size, char *destination, ui32 destination_size);
         void              SetForwardStat(TReport &rep, TMemRecordCopy *memrec); //��������� ���������� rep ������� �� ��������� �� memrec
         bool              TestAddBanIp(bool fIsWhiteIp, TKIPv6 xIp, const TString &sip, const TString &rdns2, const TString &rdns3);
         TIPAddresses      GetIPAddress(const char *BUFF, ui32 BuffSize, TObrabData &odata);
         int               CalcCountBox(const char *BUFF, ui32 BuffSize);
         bool              IsMalicSpamer(const char *BUFF, ui32 BuffSize);
         //bool              TreatMessage(TObrabData &odata, const char *BUFF, ui32 BuffSize, TTimes &DelayT, float CurrMPS, TDobBanResData &dobdata, ui32 mintreshold, const TString &remote_ip, ui32 &trap_remain);
         //bool              ReadMessage2(bool no_parse, const char *BUFF, ui32 BUFFSize, TObrabData &odata, TTimes &DelayT, float CurrMPS, TDobBanResData &dobdata, ui32 mintreshold, const TString &remote_ip, ui32 &trap_remain);
         ui32              TestBanCriterion(const char *BUFF, ui32 BuffSize, TMemRecordCopy *memrec, TReport &m_repo, TObrabData &odata, TTimes &DelayT, float CurrMPS, int memory_index);
         void              AddMonStat(const TString &rules_cs);
         void              CleanupWhiteCache();
         ui64              SpCheckFieldTick(TRengine* sph, const char* pFieldName, const char* pField, int FieldLen, const char* coding, bool fValid, bool fMime);

         bool              ReadMessage2Mongo(bool no_parse, const char *BUFF, ui32 BUFFSize, TObrabData &odata, TTimes &DelayT, float CurrMPS, TDobBanResData &dobdata, ui32 mintreshold, const TString &remote_ip, ui32 &trap_remain, ui32 sendtorbl);
         bool              TreatMessageMongo(TObrabData &odata, const char *BUFF, ui32 BuffSize, TTimes &DelayT, float CurrMPS, TDobBanResData &dobdata, ui32 mintreshold, const TString &remote_ip, ui32 &trap_remain, ui32 sendtorbl, TDiffCounter *changeday1_counter, TDiffCounter *changeday2_counter);

public:
         TIPMess();
         ~TIPMess();

         void              Init(void *statipobjA, TLogsGroup *LogsGroupA, TBasesStore *storeA, TTrafficControl *TrafficControlA, TRuleStorage *RulesStorageA, TRuleTrap *RuleTrapA, TPeriodTrap *PeriodTrapA, TTrap *trapA, TPeriodStat *perstatA, TRenginePool *RenginePoolA, TWhiteIPLocalCache *whiteip_cacheA, TBanIPLocalCache *banip_cacheA);
         TObrabResult      ObrabMessage(TParsedDlvLog &pdl, TString &mail, TTimes &DelayT, const TString &MailNumber, float CurrMPS, ui32 mintreshold, const TString &remote_ip, ui32 &trap_remain, ui32 sendtorbl, const TStatDBCollInfo stat_ident);
         TObrabResult      ObrabMessageSerializeData(TParsedDlvLogDataEx &pdlde, TTimes &DelayT, const TString &MailNumber, float CurrMPS, ui32 mintreshold, const TString &remote_ip, ui32 &trap_remain, ui32 sendtorbl, const TStatDBCollInfo stat_ident);

         void              Midnight();
         void              EventTick();
         ui32              PrintParseError(const TString &id);
         void              IsBanIpExt(TKIPv6 ip, bool &ban, ui16 &ban_hours, ui8 &ban_pr, bool &ban7, ui16 &ban7_hours, ui8 &ban7_pr);
         TString            GetUniqRulesCount() { return rules_mon_stat.GetUniqRulesCount(); }
         ui32              GetWhiteIPCount()   { return white_counter.GetDiff();            }
         ui32              GetIsBanIPCount()   { return isban_counter.GetDiff();            }
         ui32              GetBan2IPCount()    { return ban2_counter.GetDiff();             }
         ui32              GetIPv6Count()      { return ipv6_counter.GetDiff();             }
         ui32              GetActionBanCount() { return actionban_counter.GetDiff();        }
         ui32              GetChangeDay1Count(){ return changeday1_counter.GetDiff();       }
         ui32              GetChangeDay2Count(){ return changeday2_counter.GetDiff();       }

         TDiffCounter      *ChangeDay1Counter(){ return &changeday1_counter;                }
         TDiffCounter      *ChangeDay2Counter(){ return &changeday2_counter;                }
};

//*****************************************************************************************************************************************
