#!/usr/bin/python
#-*- coding: utf-8 -*-

import sys
import redis
import re
from datetime import datetime
from IPy import IP

REDIS_HOSTS = ( ( "shingler1j.mail.yandex.net", 6379 ),
                ( "shingler1m.mail.yandex.net", 6379 ),
                ( "shingler1o.mail.yandex.net", 6379 ),
                ( "shingler1g.mail.yandex.net", 6379 ),
                ( "shingler1h.mail.yandex.net", 6379 ) )
REDIS_DB = 0
REDIS_HASH = "rbldnsd6"

def redis_reconnect( hosts, db ):
    rediscli = None
    for host in hosts:
        try:
            rediscli = redis.Redis( host = host[ 0 ], port = host[ 1 ], db = db )
            if rediscli.info()[ "role" ] == "master":
                return rediscli
        except:
            pass
    return rediscli

def load_oldspstat( bandayip ):
    ips_spstat = set( [ "::ffff:127.0.0.8" ] )
    for line in open( bandayip ):
        ip = line.strip().strip( "+-" )

        if line.startswith( "+" ):
            ips_spstat.add( "::ffff:%s" % ip )
        elif line.startswith( "-" ):
            ips_spstat.discard( "::ffff:%s" % ip )
        else:
            ips_spstat.add( "::ffff:%s" % ip )
    return ips_spstat

def load_newspstat( bandayip ):
    ips_spstat = set( [ "::ffff:127.0.0.8" ] )
    for line in open( bandayip ):
        ip = line.strip().strip( "+-" )

        if line.startswith( "++" ):
            ips_spstat.add( str( IP( ip ) ) )
        elif line.startswith( "-" ):
            ips_spstat.discard( str( IP( ip ) ) )
    return ips_spstat


print datetime.today().strftime( "[%Y-%m-%d %H:%M:%S]" ), "Parsing started"

rediscli = redis_reconnect( REDIS_HOSTS, REDIS_DB )

ips_db = set( map( lambda ( ip, fake ): ip, rediscli.hgetall( REDIS_HASH ).iteritems() ) )

# Old spamstat /u0/logs/other/_u0_spstat_res_bandayip.txt-current
# New spamstat /u0/logs/sostatip/_opt_spstat2_res_bandayip.txt-current

ips_spstat_old = load_oldspstat( sys.argv[ 1 ] )
ips_spstat_new = load_newspstat( sys.argv[ 2 ] )

ips_spstat = ips_spstat_old | ips_spstat_new

ips_common = ips_db & ips_spstat
ips_delete = ips_db - ips_spstat
ips_add = ips_spstat - ips_db

for key_add in ips_add:
    print "Adding:", key_add
    rediscli.hset( REDIS_HASH, key_add, "" )

for key_delete in ips_delete:
    print "Deleting:", key_delete
    rediscli.hdel( REDIS_HASH, key_delete )

print "Common:", len( ips_common )
print "Added:", len( ips_add )
print "Deleted:", len( ips_delete )

print datetime.today().strftime( "[%Y-%m-%d %H:%M:%S]" ), "Parsing done"

