#!/bin/sh
#
# sostat2redis_v6 - this script starts and stops the sostat2redis_v6 script
#
# processname: sostat2redis_v6
# pidfile:     /var/run/sostat2redis_v6.pid

binary="/opt/spstat2/sostat2redis_v6/sostat2redis_v6.py"
prog=$(basename $binary)

PID_FILE="/var/run/sostat2redis_v6.pid"

start() {
    [ -x $binary ] || exit 5
    echo -n "Starting $prog..."
    $binary
    retval=$?
    echo
    return $retval
}

stop() {
    echo "Stopping $prog..."

    if [ ! -f $PID_FILE ];
    then
        echo "Process not running"
        return 1
    fi

    PROCESS_PID=$(cat $PID_FILE)
    rm -f $PID_FILE

    kill $PROCESS_PID

    for i in `seq 1 15`;
    do
        kill -0 $PROCESS_PID 2>/dev/null
        if [ $? -ne 0 ];
        then
            echo "OK"
            return 0
        fi
        sleep 1
    done

    echo "Process not stopped. Killing..."
    kill -9 $PROCESS_PID
    echo "OK"

    return 0
}

restart() {
    stop
    start
}

case "$1" in
    start)
        $1
        ;;
    stop)
        $1
        ;;
    restart)
        $1
        ;;
    *)
        echo "Usage: $0 {start|stop|restart}"
        exit 2
esac
