#!/usr/bin/python
#-*- coding: utf-8 -*-

import time
import os, errno
import sys
import syslog
import redis
import re
from IPy import IP


# Common variables
syslog.openlog('rblparser')
keys = ['hset', 'hdel', 'addr', 'len']
report = dict()

# Sostatip2 output file
baniplog = '/opt/spstat2/res/bandayip.txt'
pidfile = "/var/run/sostat2redis_v6.pid"
#baniplog = '/tmp/bandayip.txt'

# Regexp strings
addr_add = re.compile('^\+\+(\S+)$')
addr_rem = re.compile('^\-(\S+)$')

# Redis configuration
redis_port = 6379
redis_hash = 'rbldnsd6'
redis_nodes = [ 'shingler1j.mail.yandex.net',
                'shingler1m.mail.yandex.net',
                'shingler1o.mail.yandex.net',
                'shingler1g.mail.yandex.net',
                'shingler1h.mail.yandex.net' ]

def ip_to_v6( ipstr ):
    ip = IP( ipstr )
    return str( ip )

class InitialClass:

    def __init__(self, redis_nodes, redis_port, redis_hash):
        global master
        self.redis_nodes = redis_nodes
        self.redis_port  = redis_port
        self.redis_hash  = redis_hash
        try:
            master = self.get_redis_master()
            if master:
                try:
                    syslog.syslog("Start connection to RedisDB. Master is %s" % master)
                    self.set_redis_pipe(master)
                    self.flush = self.flushdb_redis()
                except:
                    syslog.syslog("Can't flush RedisDB: master %s" % master)
                    raise
        except:
            syslog.syslog("Can't find Redis master")
            raise
        else:
            if self.flush:
                syslog.syslog("Flush RedisDB: +OK")
            else:
                syslog.syslog("Flush RedisDB: -ERR")
                raise

    def call_main_process(self, data):
        global master
        mc = MainClass(data, self.redis_hash)
        try:
            master = self.get_redis_master()
            if master:
                if self.set_redis_pipe(master):
                    mc.mainProcess()
                else:
                    syslog.syslog("Can't create redis connection")
        except:
            syslog.syslog("MainProcess was not completed")
        finally:
            del mc

    def get_redis_master(self):
        for node in self.redis_nodes:
            try:
                #syslog.syslog("Try connection to %s" % node)
                r = redis.Redis(host=node, port=self.redis_port, db=0)
                info = r.info()
            except: pass
            else:
                if (info['role'] == 'master'):
                    master = node
                    break
                else:
                    master = 0
        return master

    ''' Create access to server over pipe or directly '''
    def set_redis_pipe(self, master):
        global server
        global pipe
        try:
            POOL = redis.ConnectionPool(host=master, port=self.redis_port)
            server = redis.Redis(connection_pool= POOL)
            pipe = server.pipeline()
        except:
            return 0
        else:
            return 1
    ''' In first start flush db and hard set address for check '''
    def flushdb_redis(self):
        return True

class MainClass:

    def __init__(self, baniplog, redis_hash):
        global report
        self.baniplog   = baniplog
        self.redis_hash = redis_hash
        for key in keys:
            report[key] = 0

    def __del__(self):
        try:
            syslog.syslog("Commit changes to Redis master: %s" % master)
            pipe.execute()
            report['len'] = self.hlenRedis()
        except:
            syslog.syslog("Can't commit new data to Redis master is %s" % master)
        else:
            syslog.syslog("Commit DONE")
        finally:
            pipe.reset()

    def hsetRedis(self, args):
        reply = pipe.hset(self.redis_hash, args, "")
        return reply

    def hlenRedis(self):
        reply = server.hlen(self.redis_hash)
        return reply

    def hdelRedis(self, args):
        reply = pipe.hdel(self.redis_hash, args)
        return reply

    def mainProcess(self):
        global report
        for line in self.baniplog:
            if addr_add.match(line):
                action = ip_to_v6( addr_add.match(line).group(1).strip() )
                if action:
                    syslog.syslog( "IP added to rbldns: %s" % action )
                    report['hset'] += 1
                    self.hsetRedis(action)
            elif addr_rem.match(line):
                action = ip_to_v6( addr_rem.match(line).group(1).strip() )
                if action:
                    syslog.syslog( "IP removed from rbldns: %s" % action )
                    report['hdel'] += 1
                    self.hdelRedis(action)
            else:
                report['addr'] += 1

##################################################################################
# Daemonize loops
##################################################################################

def daemonize():
    sys.stdout.flush()
    sys.stderr.flush()
    si = file('/dev/null', 'r')
    so = file('/dev/null', 'a+')
    se = file('/dev/null', 'a+', 0)
    os.dup2(si.fileno(), sys.stdin.fileno())
    os.dup2(so.fileno(), sys.stdout.fileno())
    os.dup2(se.fileno(), sys.stderr.fileno())

    print >> open( pidfile, "wt" ), os.getpid()
    m = InitialClass(redis_nodes, redis_port, redis_hash)

    try:
        with open(baniplog): lastsize = os.path.getsize(baniplog)
    except IOError:
        syslog.syslog(syslog.LOG_ERR, 'Can\'t open file %s' % baniplog)
    else:
        syslog.syslog('Starting %s parser' % baniplog)
        while True:
            size = os.path.getsize(baniplog)
            if ((size > 10485760) and (lastsize == 0)):
		lastsize = size-10485760
            if size > lastsize:
                f = open(baniplog, 'r')
                f.seek(lastsize)
                data = f.readlines(size-lastsize)
                if not data:
                    f.close
                    time.sleep(5)
                else:
                    syslog.syslog("Statlog output has changed, start process")
                    m.call_main_process(data)
                    syslog.syslog("Add: %d, Removed: %d, Skip: %d, Total: %s" % (report['hset'], report['hdel'], report['addr'], report['len']))
                    lastsize = f.tell()
            elif size == lastsize:
		#syslog.syslog("Statlog output has no changed, sleep...")
                time.sleep(5)
            elif size < lastsize:
                lastsize = 0
                f.close
                if __debug__ : syslog.syslog("File %s was truncated" % baniplog)
            data = None

##################################################################################

if __name__ == "__main__":

    try:
        pid = os.fork()
        if pid > 0:
            sys.exit(0)
    except OSError, e:
        sys.exit(1)
        os.chdir("/")
        os.umask(0)
        os.setsid()

    try:
        pid = os.fork()
        if pid > 0:
            sys.exit(0)
    except OSError, e:
        syslog.syslog("fork #2 failed: %d (%s)\n" % (e.errno, e.strerror))
        sys.exit(1)

    daemonize()
