#!/bin/sh
#
# spstat2 - this script starts and stops the spstat2 daemon
#
# description:  spstat2 is an fastcgi daemon that collects \
#               reputations for ip addresses
# processname: spstat2
# config:      /opt/spstat2/spstat2.conf
# pidfile:     /var/run/sostatip2.pid


# Set limits
ulimit -c unlimited
ulimit -s 1024
DAEMON_COREFILE_LIMIT=unlimited

spstat2="/opt/spstat2/bin/sostatip"
prog=$(basename $spstat2)

spstat2_CONF_FILE="/opt/spstat2/config/sostatip.conf"
spstat2_PID_FILE="/var/run/sostatip.pid"

start() {
    [ -x $spstat2 ] || exit 5
    [ -f $spstat2_CONF_FILE ] || exit 6
    echo -n "Starting $prog..."
    $spstat2 $spstat2_CONF_FILE
    retval=$?
    echo
    return $retval
}

stop() {
    echo "Stopping $prog..."

    if [ ! -f $spstat2_PID_FILE ];
    then
        echo "Process not running"
        return 1
    fi

    PROCESS_PID=$(cat $spstat2_PID_FILE)
    rm -f $spstat2_PID_FILE

    kill $PROCESS_PID

    for i in `seq 1 15`;
    do
        kill -0 $PROCESS_PID 2>/dev/null
        if [ $? -ne 0 ];
        then
            echo "OK"
            return 0
        fi
        sleep 1
    done

    echo "Process not stopped. Killing..."
    kill -9 $PROCESS_PID
    echo "OK"

    return 0
}

restart() {
    stop
    start
}

case "$1" in
    start)
        $1
        ;;
    stop)
        $1
        ;;
    restart)
        $1
        ;;
    *)
        echo "Usage: $0 {start|stop|restart}"
        exit 2
esac
