#pragma once

#ifdef SPK3

#include <mail/so/spamstop/tools/so-common/tlogclass.h>
#include <mail/so/spamstop/tools/so-common/critrule.h>
#include <mail/so/spamstop/sp/sptypes.h>
#include <mail/so/spamstop/sp/spamstop.h>
#include <mail/so/spamstop/sp/spk3.h>
#include <list>

bool SpOpen(TRengine* * sph, const char *szDirectory, TModSPInit &modspinit, TRulesHolder *pRulesHolder);
bool SpOpenClient(TRengine* *sph, const char *szSpamIni, TModSPInit &modspinit, const char *pPrepare, T_SpParams *p_params, TRulesHolder *pRulesHolder);

//write text to delivery.log
void SpLogField(TRengine* sph, const char *fdname, const char * pfield);
void SpLogFieldS(TRengine* sph, const TString &fdname, const TString &pfield);
void SpCheckRange(TRengine* sph, const char *key, int value, bool fPrintWarning = true);
void SpCheckRange(TRengine* sph, const char *key, ui32 value, bool fPrintWarning = true);
void SpCheckRange(TRengine* sph, const char *key, double value, bool fPrintWarning = true);
bool SpGetPattern(TRengine* sph, const char* PatternName, const TString &Field, TString& Match);
bool SpGetPatternList(TRengine* sph, const char* PatternName, const TString &Field, TStrokaList &strlist, void *FieldCheck);
bool SpIsHTMLText(TRengine* sph, TString &text);

void SpSetRuleHide(TRengine* sph, const char *szRuleName);

void SpGetWorkedCriterionBanRule(TRengine* sph, TCritRuleList &critlist);
void SpGetWorkedCriterionRPTRule(TRengine* sph, TCritRuleList &critlist);
void SpGetWorkedCriterionFRWDRule(TRengine* sph, TCritRuleList &critlist);
void SpGetWorkedCriterionPROBBANRule(TRengine* sph, TCritRuleList &critlist);
void SpGetWorkedCriterionBAN2Rule(TRengine* sph, TCritRuleList &critlist);
void SpGetWorkedCriterionBAN7Rule(TRengine* sph, TCritRuleList &critlist);
void SpGetWorkedCriterionBAN8Rule(TRengine* sph, TCritRuleList &critlist);

void SpGetWorkedCriterionBanRuleIPv6(TRengine* sph, TCritRuleList &critlist);
void SpGetWorkedCriterionRPTRuleIPv6(TRengine* sph, TCritRuleList &critlist);
void SpGetWorkedCriterionFRWDRuleIPv6(TRengine* sph, TCritRuleList &critlist);
void SpGetWorkedCriterionPROBBANRuleIPv6(TRengine* sph, TCritRuleList &critlist);
void SpGetWorkedCriterionBAN2RuleIPv6(TRengine* sph, TCritRuleList &critlist);
void SpGetWorkedCriterionBAN7RuleIPv6(TRengine* sph, TCritRuleList &critlist);
void SpGetWorkedCriterionBAN8RuleIPv6(TRengine* sph, TCritRuleList &critlist);

bool ExistsbanInternal(TRengine* sph, const char *rulename);
bool ExistsRule(TRengine* sph, char *rulename);
TSpClass SpCheckMessage(TRengine* sph, const char *pmes, int meslen, const char **ppCheckReport = 0, char *RULEBUFF = NULL, int SizeRuleBuff = 0);
TSpClass SpCheckMessage(TRengine* sph, const char *pmes, int meslen, const char **ppCheckReport, char *RULEBUFF, int SizeRuleBuff, TExtRengineData &ext_fltr_data);
void CheckSuidRoll(TRengine* sph, const char *word, int len);

void SpGetIPv4RuleWeights(TRengine* sph, float &BanRuleWeight, float &RPTRuleWeight, float &FRWDRuleWeight, float &PROBBANRuleWeight, float &BAN2RuleWeight, float &BAN7RuleWeight, float &BAN8RuleWeight);
void SpGetIPv6RuleWeights(TRengine* sph, float &BanRuleWeight, float &RPTRuleWeight, float &FRWDRuleWeight, float &PROBBANRuleWeight, float &BAN2RuleWeight, float &BAN7RuleWeight, float &BAN8RuleWeight);

#endif
