#pragma once

#include "util/generic/hash.h"
#include <util/generic/string.h>

struct TBanIpBasic
{
    TKIPv6     ip;             //ip
    time_t     tAction;        // 
    ui16       chours;         //- ,    
    ui32       cMessage;       //- ,   ,     (     )
  ui8        cIntBanIp;      // :
                               //    0x01 -   ip   banip.txt (   ,   )
                               //    0x02 -  
                               //    0x04 -   
                               //    0x08 -   
    char       cUser[25];      //,  
    ui32       sendtorbl;      //  rbl (4    )
    char       cReserv[60];    //
    ui32       cs;             //crc

    TBanIpBasic()
    {
       Clear();
    }

    ui32 GetCRC32(ui32 cs)
    {
      ui8  buff[196];
      int  n = 0;
      ui32 i = 0, j = 0;

      memset(buff, 0, sizeof(buff));
      memcpy(buff + n, &ip, sizeof(ip));
      n += sizeof(ip);
      memcpy(buff + n, &tAction, sizeof(tAction));
      n += sizeof(tAction);
      memcpy(buff + n, &chours, sizeof(chours));
      n += sizeof(chours);
      memcpy(buff + n, &cMessage, sizeof(cMessage));
      n += sizeof(cMessage);
      memcpy(buff + n, &cIntBanIp, sizeof(cIntBanIp));
      n += sizeof(cIntBanIp);
      memcpy(buff + n, &cUser, sizeof(cUser));
      n += sizeof(cUser);
      memcpy(buff + n, &sendtorbl, sizeof(sendtorbl));
      n += sizeof(sendtorbl);
      memcpy(buff + n, &cReserv, sizeof(cReserv));
      n += sizeof(cReserv);

      for (i = 0, j = 0; i < n; i++, j++)
      {
        if (j == 4)
            j = 0;

        if (!j)
            cs += (buff[i] & 0xFF);
        else
            cs += (((buff[i] << (8 * j))) & 0xFF);
      }

      return cs;
    }

    void Clear()
    {
       ip               = TKIPv6();
       tAction          = 0;
       chours           = 0;
       cMessage         = 0;
     cIntBanIp        = 0;
       sendtorbl        = 0;
       cs               = 0;
       memset(cUser, 0, sizeof(cUser));
       memset(cReserv, 0, sizeof(cReserv));
    }

    bool operator<(const TBanIpBasic &value) const
    {
      return (ip < value.ip);
    }

};

#define BANIP_IP        "ip"
#define BANIP_TACTION   "tAction"
#define BANIP_CHOURS    "chours"
#define BANIP_CMESSAGE  "cMessage"
#define BANIP_CINTBANIP "cIntBanIp"
#define BANIP_CUSERS    "cUser"
#define BANIP_SENDTORBL "sendtorbl"
#define BANIP_CS        "cs"

class TBanIpBasicSerialization
{
public:
    static void Deserialize( nosql::HashMap& hash, TBanIpBasic& data )
    {
        data.ip = TKIPv6( hash[ BANIP_IP ].String().c_str() );
        AssignValue( data.tAction, hash[ BANIP_TACTION ].Long() );
        AssignValue( data.chours, hash[ BANIP_CHOURS ].Integer() );
        AssignValue( data.cMessage, hash[ BANIP_CMESSAGE ].Integer() );
        AssignValue( data.cIntBanIp, hash[ BANIP_CINTBANIP ].Integer() );
        strncpy( data.cUser, hash[ BANIP_CUSERS ].String().c_str(), sizeof( data.cUser ) - 1 );
        AssignValue( data.sendtorbl, hash[ BANIP_SENDTORBL ].Integer() );
        AssignValue( data.cs, hash[ BANIP_CS ].Integer() );
    }

    static void Serialize( const TBanIpBasic& data, const TBanIpBasic& data_prev, nosql::HashMap& incrs, nosql::HashMap& sets )
    {
        SetElement( sets, BANIP_IP, data.ip.toStroka(), data_prev.ip.toStroka() );
        SetElement( sets, BANIP_TACTION, static_cast< i64 >( data.tAction ), static_cast< i64 >( data_prev.tAction ) );
        SetElement( sets, BANIP_CHOURS, data.chours, data_prev.chours );

        // TODO: Think about incrementing cMessage
        SetElement( sets, BANIP_CMESSAGE, data.cMessage, data_prev.cMessage );
        SetElement( sets, BANIP_CINTBANIP, data.cIntBanIp, data_prev.cIntBanIp );
        SetElement( sets, BANIP_CUSERS, TString( data.cUser ), TString( data_prev.cUser ) );
        SetElement( sets, BANIP_SENDTORBL, data.sendtorbl, data_prev.sendtorbl );
        SetElement( sets, BANIP_CS, data.cs, data_prev.cs );
    }

    static void SerializeWOCheck( const TBanIpBasic& data, /*nosql::HashMap& incrs, */nosql::HashMap& sets )
    {
        SetElementWOCheck( sets, BANIP_IP, data.ip.toStroka() );
        SetElementWOCheck( sets, BANIP_TACTION, static_cast< i64 >( data.tAction ) );
        SetElementWOCheck( sets, BANIP_CHOURS, data.chours );
        SetElementWOCheck( sets, BANIP_CMESSAGE, data.cMessage );
        SetElementWOCheck( sets, BANIP_CINTBANIP, data.cIntBanIp );
        SetElementWOCheck( sets, BANIP_CUSERS, TString( data.cUser ) );
        SetElementWOCheck( sets, BANIP_SENDTORBL, data.sendtorbl );
        SetElementWOCheck( sets, BANIP_CS, data.cs );
    }

    static TString ConvertToId( const TKIPv6& ip )
    {
        return ip.AsShingle128();
    }

 static ui64 ConvertToId2(const TKIPv6& ip)
 {
  return ip.AsShingle64();
 }

    static TKIPv6 IdToKey( const TString& id )
    {
        TKIPv6 ip;
        ip.FromShingle128( id );
        return ip;
    }

    static TString ErrFieldStroka(const TString &field_name, const nosql::HashMap& hash, nosql::AnyValue::TYPE type)
    {
       TString res = "";

       if (!field_name.empty())
       {
           nosql::HashMap::const_iterator it;
           bool  empty_key   = false;
           bool  empty_value = false;

           it = hash.find(field_name);
           if (it == hash.end())
           {
              empty_key = true;

           } else
           {
              switch (type)
              {
              case nosql::AnyValue::NOTYPE:

                                                break;
              case nosql::AnyValue::INTEGER:

                                                break;
              case nosql::AnyValue::INTEGER64:

                                                break;
              case nosql::AnyValue::DOUBLE:

                                                break;
              case nosql::AnyValue::VECTOR:

                                                break;
              case nosql::AnyValue::STRING:
                                                if ((*it).second.String().empty())
                                                   empty_value = true;
                                                break;
              case nosql::AnyValue::LIST:

                                                break;
              case nosql::AnyValue::HASH:

                                                break;
              };

           }
           if (empty_key || empty_value)
           {
               res += field_name + "(";
               if (empty_key)
               {
                  if (empty_value)
                     res += "key,";
                  else
                     res += "key";
               }
               if (empty_value)
                  res += "value";
               res += ")";

           }
       }

       return res;
    }

    static bool ExistsAllFields(const nosql::HashMap& hash, TString &lost_field)
    {
        bool                           res             = true;
        TString                         lost_field_item = "";

        lost_field = "";

        //BANIP_IP
        lost_field_item = ErrFieldStroka(BANIP_IP, hash, nosql::AnyValue::STRING);
        if (!lost_field_item.empty())
        {
           if (lost_field.empty())
              lost_field += lost_field_item;
           else
              lost_field += ", " + lost_field_item;
           res = false;
        }

        //BANIP_TACTION
        lost_field_item = ErrFieldStroka(BANIP_TACTION, hash, nosql::AnyValue::INTEGER64);
        if (!lost_field_item.empty())
        {
           if (lost_field.empty())
              lost_field += lost_field_item;
           else
              lost_field += ", " + lost_field_item;
           res = false;
        }

        //BANIP_CHOURS
        lost_field_item = ErrFieldStroka(BANIP_CHOURS, hash, nosql::AnyValue::INTEGER);
        if (!lost_field_item.empty())
        {
           if (lost_field.empty())
              lost_field += lost_field_item;
           else
              lost_field += ", " + lost_field_item;
           res = false;
        }

        //BANIP_CMESSAGE
        lost_field_item = ErrFieldStroka(BANIP_CMESSAGE, hash, nosql::AnyValue::INTEGER);
        if (!lost_field_item.empty())
        {
           if (lost_field.empty())
              lost_field += lost_field_item;
           else
              lost_field += ", " + lost_field_item;
           res = false;
        }

        //BANIP_CINTBANIP
        lost_field_item = ErrFieldStroka(BANIP_CINTBANIP, hash, nosql::AnyValue::INTEGER);
        if (!lost_field_item.empty())
        {
           if (lost_field.empty())
              lost_field += lost_field_item;
           else
              lost_field += ", " + lost_field_item;
           res = false;
        }

        //BANIP_CUSERS
        lost_field_item = ErrFieldStroka(BANIP_CUSERS, hash, nosql::AnyValue::NOTYPE);
        if (!lost_field_item.empty())
        {
           if (lost_field.empty())
              lost_field += lost_field_item;
           else
              lost_field += ", " + lost_field_item;
           res = false;
        }

        //BANIP_SENDTORBL
        lost_field_item = ErrFieldStroka(BANIP_SENDTORBL, hash, nosql::AnyValue::INTEGER);
        if (!lost_field_item.empty())
        {
           if (lost_field.empty())
              lost_field += lost_field_item;
           else
              lost_field += ", " + lost_field_item;
           res = false;
        }

        return res;
    }
};

struct TBanSetup
{
   ui32 m_bantime;
   ui32 m_long_bantime;

   TBanSetup()
   {
      Clear();
   }

   TBanSetup(ui32 bantime, ui32 long_bantime)
   {
      Clear();
      m_bantime      = bantime;
      m_long_bantime = long_bantime;
   }

   void Clear()
   {
      m_bantime      = 0;
      m_long_bantime = 0;
   }

};

#define BANSETUP_BANTIME      "bantime"
#define BANSETUP_LONGBANTIME  "longbantime"

class TBanSetupSerialization
{
public:
    static void Deserialize( nosql::HashMap& hash, TBanSetup& data )
    {
        AssignValue( data.m_bantime, hash[ BANSETUP_BANTIME ].Long() );
        AssignValue( data.m_long_bantime, hash[ BANSETUP_LONGBANTIME ].Integer() );
    }

    static void Serialize( const TBanSetup& data, const TBanSetup& data_prev, nosql::HashMap& incrs, nosql::HashMap& sets )
    {
        SetElement( sets, BANSETUP_BANTIME, data.m_bantime, data_prev.m_bantime );
        SetElement( sets, BANSETUP_LONGBANTIME, data.m_long_bantime, data_prev.m_long_bantime );
    }

    static void SerializeWOCheck( const TBanSetup& data, nosql::HashMap& incrs, nosql::HashMap& sets )
    {
        SetElementWOCheck( sets, BANSETUP_BANTIME, data.m_bantime );
        SetElementWOCheck( sets, BANSETUP_LONGBANTIME, data.m_long_bantime );
    }

    static TString ConvertToId( const TKIPv6& ip )
    {
        return ip.AsShingle128();
    }

 static ui64 ConvertToId2(const TKIPv6& ip)
 {
  return ip.AsShingle64();
 }

    static TKIPv6 IdToKey( const TString& id )
    {
        TKIPv6 ip;
        ip.FromShingle128( id );
        return ip;
    }

};


struct TDSLRps
{
   double m_rps;
   ui32   m_calctime;
   ui32   m_count;
   ui32   m_prcmb;

   TDSLRps()
   {
      Clear();
   }

   void Clear()
   {
      m_rps      = 0;
      m_calctime = 0;
      m_count    = 0;
      m_prcmb    = 0;
   }

};

#define DSLRPS_RPS      "rps"
#define DSLRPS_CALCTIME "calctime"
#define DSLRPS_COUNT    "cnt"
#define DSLRPS_PR_CMB   "prcmb"

class TDSLRpsSerialization
{
public:
    static void Deserialize( nosql::HashMap& hash, TDSLRps& data )
    {
        AssignValue( data.m_rps,      hash[ DSLRPS_RPS ].Double()    );
        AssignValue( data.m_count,    hash[ DSLRPS_COUNT ].Long()    );
        AssignValue( data.m_calctime, hash[ DSLRPS_CALCTIME ].Long() );
        AssignValue( data.m_prcmb,    hash[ DSLRPS_PR_CMB ].Long()   );
    }

    static void SerializeWOCheck( const TDSLRps& data, nosql::HashMap& incrs, nosql::HashMap& sets )
    {
        SetElementWOCheck( sets, DSLRPS_RPS, data.m_rps );
        SetElementWOCheck( sets, DSLRPS_CALCTIME, data.m_calctime );
        SetElementWOCheck( sets, DSLRPS_COUNT, data.m_count );
        SetElementWOCheck( sets, DSLRPS_PR_CMB, data.m_prcmb );
    }

    static TString ConvertToId( const TKIPv6& ip )
    {
        return ip.AsShingle128();
    }

 static ui64 ConvertToId2(const TKIPv6& ip)
 {
  return ip.AsShingle64();
 }

    static TKIPv6 IdToKey( const TString& id )
    {
        TKIPv6 ip;
        ip.FromShingle128( id );
        return ip;
    }

};

struct TDoubleBanIpBasic
{
   static const int MAX_ELEMENTS = 2;
   TKIPv6      ip;
   TBanIpBasic ban[2];
   ui8         sorttype;

   TDoubleBanIpBasic()
   {
      ip = TKIPv6();
      for (int i = 0; i < MAX_ELEMENTS; i++)
         ban[i].Clear();
      sorttype = 0;
   }

   bool operator<(const TDoubleBanIpBasic &value) const
   {
      bool res = false;

      switch (sorttype)
      {
       case 1:           //sort by ban during time
                res = (ban[0].chours < value.ban[0].chours);
                break;
       case 2:           //sort by ban start time
                res = (ban[0].tAction < value.ban[0].tAction);
                break;
       case 3:           //sort by ban7 during time
                res = (ban[1].chours < value.ban[1].chours);
                break;
       case 4:           //sort by ban7 start time
                res = (ban[1].tAction < value.ban[1].tAction);
                break;
       default:          //sort by ip
                res = (ip < value.ip);
      };

      return res;
   }
};

typedef THashMap<TKIPv6, TDoubleBanIpBasic>  TDoubleBanIpBasicHash;
typedef TDoubleBanIpBasicHash::iterator TDoubleBanIpBasicHashIt;

typedef std::list<TDoubleBanIpBasic>    TDoubleBanIpBasicList;
typedef TDoubleBanIpBasicList::iterator TDoubleBanIpBasicListIt;
