#include "tbasesstore.h"
#include "tlogsgroup.h"

#ifndef _win_
#include <unistd.h>
#include <sys/syscall.h>
#endif

//*******************************************************************************************
//                                  TChangeProperties
//*******************************************************************************************

TBasesStore::TBasesStore()
{
   m_banip           = NULL;
   LogsGroup         = NULL;
   for (ui32 i = 0; i < TGrayListStatus::GREYLIST_COUNT; i++)
   {
      m_greylistaddr[i] = NULL;
      m_greylistnet[i]  = NULL;
   }
   m_whiteip         = NULL;
   m_whitenet        = NULL;
   m_follownet       = NULL;
   m_blackip         = NULL;
   m_shadyhosts      = NULL;
   m_ruleprintlist   = NULL;
   m_bad1            = NULL;
   m_bad2            = NULL;
   m_bad3            = NULL;
   m_bad4            = NULL;
   m_bad5            = NULL;
   m_rbbad           = NULL;
   m_rbgood          = NULL;
   m_excludestat     = NULL;
   m_zonestat        = NULL;
   m_rbl             = NULL;
}

TBasesStore::~TBasesStore()
{
   if (m_rbl != NULL)
   {
      delete m_rbl;
      m_rbl = NULL;
   }
   if (m_zonestat != NULL)
   {
      delete m_zonestat;
      m_zonestat = NULL;
   }
   for (ui32 i = 0; i < TGrayListStatus::GREYLIST_COUNT; i++)
   {
      if (m_greylistaddr[i] != NULL)
      {
         delete m_greylistaddr[i];
         m_greylistaddr[i] = NULL;
      }
      if (m_greylistnet[i] != NULL)
      {
         delete m_greylistnet[i];
         m_greylistnet[i] = NULL;
      }
   }
   if (m_whiteip != NULL)
   {
      delete m_whiteip;
      m_whiteip = NULL;
   }
   if (m_follownet != NULL)
   {
      delete m_follownet;
      m_follownet = NULL;
   }
   if (m_whitenet != NULL)
   {
      delete m_whitenet;
      m_whitenet = NULL;
   }
   if (m_blackip != NULL)
   {
      delete m_blackip;
      m_blackip = NULL;
   }
   if (m_shadyhosts != NULL)
   {
      delete m_shadyhosts;
      m_shadyhosts = NULL;
   }
   if (m_ruleprintlist != NULL)
   {
      delete m_ruleprintlist;
      m_ruleprintlist = NULL;
   }
   if (m_bad1 != NULL)
   {
      delete m_bad1;
      m_bad1 = NULL;
   }
   if (m_bad2 != NULL)
   {
      delete m_bad2;
      m_bad2 = NULL;
   }
   if (m_bad3 != NULL)
   {
      delete m_bad3;
      m_bad3 = NULL;
   }
   if (m_bad4 != NULL)
   {
      delete m_bad4;
      m_bad4 = NULL;
   }
   if (m_bad5 != NULL)
   {
      delete m_bad5;
      m_bad5 = NULL;
   }
   if (m_rbbad != NULL)
   {
      delete m_rbbad;
      m_rbbad = NULL;
   }
   if (m_rbgood != NULL)
   {
      delete m_rbgood;
      m_rbgood = NULL;
   }
   if (m_excludestat != NULL)
   {
      delete m_excludestat;
      m_excludestat = NULL;
   }
   if (m_banip != NULL)
   {
      delete m_banip;
      m_banip = NULL;
   }
}

bool TBasesStore::InitBeforeFork(void *statipobj, TLogsGroup *LogsGroupA, TKConfig *configobjA, TChangeProperties *CPOA)
{
   bool res = true;

   LogsGroup = LogsGroupA;
   CPO       = CPOA;

   if (configobjA != NULL)
   {
      //greylistaddr
      TString greylistaddr_filename = "";
      for (ui32 i = 0; i < TGrayListStatus::GREYLIST_COUNT; i++)
      {
         greylistaddr_filename = configobjA->ReadStroka("lists", "greylistaddr_" + IntToStroka(i + 1), "");
         if (!greylistaddr_filename.empty())
         {
            m_greylistaddr[i] = new kipv6::TWhiteIPv6();
            if (m_greylistaddr[i] != NULL)
            {
               m_greylistaddr[i]->Init("GREYLISTADDR_" + IntToStroka(i + 1), greylistaddr_filename, LogsGroup);
               m_greylistaddr[i]->ReloadFileList();

            }
         } else
         {
            if ( (LogsGroup != NULL) && (LogsGroup->GetServerLog() != NULL) )
               LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", (" GREYLISTADDR_" + IntToStroka(i + 1) + ":   not defined").c_str());
         }
      }

      //greylistnet
      TString greylistnet_filename = "";
      for (ui32 i = 0; i < TGrayListStatus::GREYLIST_COUNT; i++)
      {
         greylistnet_filename = configobjA->ReadStroka("lists", "greylistnet_" + IntToStroka(i + 1), "");
         if (!greylistnet_filename.empty())
         {
            m_greylistnet[i] = new TNetKIPv6("GREYLISTNET_" + IntToStroka(i + 1));
            if (m_greylistnet[i] != NULL)
            {
               m_greylistnet[i]->Init(greylistnet_filename, LogsGroup->ActionLog());
               m_greylistnet[i]->ReloadFileList();

            }
         } else
         {
            if ( (LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL) )
               LogsGroup->ActionLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", ("  GREYLISTNET_" + IntToStroka(i + 1) + ":   not defined").c_str());
         }
      }

      //white ip list
      TString  whiteip_filename = configobjA->ReadStroka("lists", "whiteip", "");
      if (!whiteip_filename.empty())
      {
         m_whiteip = new kipv6::TWhiteIPv6();
         if (m_whiteip != NULL)
         {
            m_whiteip->Init(whiteip_filename, LogsGroup);
            m_whiteip->ReloadFileList();
         }
      }

      //white net list
      TString whitenet_filename = configobjA->ReadStroka("lists", "whitenet", "");
      if (!whitenet_filename.empty())
      {
         //m_whitenet = new TNetIPv6("WHITENET");
         m_whitenet = new TNetKIPv6("WHITENET");
         if ( (m_whitenet != NULL) && (LogsGroup != NULL) )
         {
            m_whitenet->Init(whitenet_filename, LogsGroup->ActionLog());
            m_whitenet->ReloadFileList();
         }
      }

      //follow net list
      TString follownet_filename = configobjA->ReadStroka("lists", "follownet", "");
      if (!follownet_filename.empty())
      {
         m_follownet = new TNetKIPv6("FOLLOWNET");
         if ( (m_follownet != NULL) && (LogsGroup != NULL) )
         {
            m_follownet->Init(follownet_filename, LogsGroup->ActionLog());
            m_follownet->ReloadFileList();
         }
      }

      //banip list
      TString            BanTextFile       = configobjA->ReadStroka("ban", "text_file", "");
      TString            BanIndexFile      = configobjA->ReadStroka("ban", "index_file", "");
      TString            Ban7TextFile      = configobjA->ReadStroka("ban", "text7_file", "");
      TString            Ban7IndexFile     = configobjA->ReadStroka("ban", "index7_file", "");
      TString            bandaylistfile    = configobjA->ReadStroka("ban", "daylist_file", "");
      TString            ban7daylistfile   = configobjA->ReadStroka("ban", "daylist7_file", "");
      TString            bandaylistfile_d  = configobjA->ReadStroka("ban", "daylistD_file", "");
      TString            ban7daylistfile_d = configobjA->ReadStroka("ban", "daylist7D_file", "");
      m_catchdelay                        = configobjA->ReadInteger("ban", "catchdelay", 15 );

      m_banip = new TBanIPListGeneral(statipobj, LogsGroup, configobjA, m_whiteip, m_whitenet, BanTextFile, BanIndexFile, Ban7TextFile, Ban7IndexFile, CPO, bandaylistfile, ban7daylistfile, bandaylistfile_d, ban7daylistfile_d);

      //black ip list
      TString blackip_filename = configobjA->ReadStroka("lists", "blackip", "");
      if (!blackip_filename.empty())
      {
         m_blackip = new TBlackIPv6();
         if (m_blackip != NULL)
         {
            m_blackip->Init(blackip_filename, LogsGroup, m_banip);
            m_blackip->ReloadFileList();
         }
      }

      //shady hosts
      TString         shadyhoststext_s = configobjA->ReadStroka("lists", "shadyhosts", "");
      if (!shadyhoststext_s.empty())
      {
         m_shadyhosts = new kipv6::TStringsLists();
         if (m_shadyhosts != NULL)
         {
            m_shadyhosts->Init("SHADYHOSTS", shadyhoststext_s, LogsGroup);
            m_shadyhosts->ReloadFileList();
         }
      }

      //ruleprint list
      TString         ruleprintlist_s = configobjA->ReadStroka("lists", "ruleprintlist", "");
      if (!ruleprintlist_s.empty())
      {
         m_ruleprintlist = new kipv6::TStringsLists();
         if (m_ruleprintlist != NULL)
         {
            m_ruleprintlist->Init("RULEPRINTLIST", ruleprintlist_s, LogsGroup);
            m_ruleprintlist->ReloadFileList();
         }
      }

      //bad1
      TString         bad1list_s = configobjA->ReadStroka("lists", "bad1", "");
      if (!bad1list_s.empty())
      {
         m_bad1 = new kipv6::TStringsNumberLists();
         if (m_bad1 != NULL)
         {
            m_bad1->Init("BAD1", bad1list_s, LogsGroup, 1);
            m_bad1->ReloadFileList();
         }
      }

      //bad2
      TString         bad2list_s = configobjA->ReadStroka("lists", "bad2", "");
      if (!bad2list_s.empty())
      {
         m_bad2 = new kipv6::TStringsNumberLists();
         if (m_bad2 != NULL)
         {
            m_bad2->Init("BAD2", bad2list_s, LogsGroup, 2);
            m_bad2->ReloadFileList();
         }
      }

      //bad3
      TString         bad3list_s = configobjA->ReadStroka("lists", "bad3", "");
      if (!bad3list_s.empty())
      {
         m_bad3 = new kipv6::TStringsNumberLists();
         if (m_bad3 != NULL)
         {
            m_bad3->Init("BAD3", bad3list_s, LogsGroup, 3);
            m_bad3->ReloadFileList();
         }
      }

      //bad4
      TString         bad4list_s = configobjA->ReadStroka("lists", "bad4", "");
      if (!bad4list_s.empty())
      {
         m_bad4 = new kipv6::TStringsNumberLists();
         if (m_bad4 != NULL)
         {
            m_bad4->Init("BAD4", bad4list_s, LogsGroup, 4);
            m_bad4->ReloadFileList();
         }
      }

      //bad5
      TString         bad5list_s = configobjA->ReadStroka("lists", "bad5", "");
      if (!bad5list_s.empty())
      {
         m_bad5 = new kipv6::TStringsNumberLists();
         if (m_bad5 != NULL)
         {
            m_bad5->Init("BAD5", bad5list_s, LogsGroup, 5);
            m_bad5->ReloadFileList();
         }
      }

      //excludestat
      TString         excludestatlist_s = configobjA->ReadStroka("lists", "excludestat", "");
      if (!excludestatlist_s.empty())
      {
         m_excludestat = new kipv6::TStringsNumberLists();
         if (m_excludestat != NULL)
         {
            m_excludestat->Init("EXCLUDESTAT", excludestatlist_s, LogsGroup, 1);
            m_excludestat->ReloadFileList();
         }
      }

      //rbbad
      TString         rbhosts2list_s = configobjA->ReadStroka("lists", "rbhosts2", "");
      if (!rbhosts2list_s.empty())
      {
         m_rbbad = new kipv6::TStringsNumberLists();
         if (m_rbbad != NULL)
         {
            m_rbbad->Init("RBHOST2", rbhosts2list_s, LogsGroup, 1);
            m_rbbad->ReloadFileList();
         }
      }

      //rbgood
      TString         rbwhitelist_s = configobjA->ReadStroka("lists", "rbwhite", "");
      if (!rbwhitelist_s.empty())
      {
         m_rbgood = new kipv6::TStringsNumberLists();
         if (m_rbgood != NULL)
         {
            m_rbgood->Init("RBWHITE", rbwhitelist_s, LogsGroup, 1);
            m_rbgood->ReloadFileList();
         }
      }

      //zonestat
      TString         zonestat_s = configobjA->ReadStroka("lists", "zones", "");
      if (!zonestat_s.empty())
      {
         m_zonestat = new kipv6::TZoneStat();
         if (m_zonestat != NULL)
         {
            m_zonestat->Init(zonestat_s, LogsGroup);
            m_zonestat->ReloadFileList();
         }
      }

      //rbl
      TString blacklist1    = configobjA->ReadStroka("lists", "blacklist1", "");
      TString blacklist1to  = configobjA->ReadStroka("lists", "blacklist1to", "");
      TString blacklist2    = configobjA->ReadStroka("lists", "blacklist2", "");
      TString blacklist2to  = configobjA->ReadStroka("lists", "blacklist2to", "");
      TString blacklist3    = configobjA->ReadStroka("lists", "blacklist3", "");
      TString blacklist3to  = configobjA->ReadStroka("lists", "blacklist3to", "");
      TString blacklist4    = configobjA->ReadStroka("lists", "blacklist4", "");
      TString blacklist4to  = configobjA->ReadStroka("lists", "blacklist4to", "");
      TString blacklistdiff = configobjA->ReadStroka("lists", "blacklistdiff", "");

      m_rbl = new kipv6::TRblIPv6();
      if (m_rbl != NULL)
      {
         m_rbl->Init(blacklist1, blacklist1to, blacklist2, blacklist2to, blacklist3, blacklist3to, blacklist4, blacklist4to, blacklistdiff, LogsGroup);
         m_rbl->RefreshBLFiles();
      }

      //membasa
      MemBasa.Init(statipobj, LogsGroup, configobjA);
   }

   return res;
}

bool TBasesStore::InitAfterFork()
{
   bool res = true;

   if (m_banip != NULL)
      m_banip->InitAfterFork();

   return res;
}

void TBasesStore::Midnight()
{

}

void TBasesStore::EventTick()
{
   MemBasa.EventTick();
}

void TBasesStore::GetListsStatus(TKIPv6 ip, TString &host, bool &whiteip, bool &whitehost, bool &whitenet, bool &blackip)
{
   whiteip   = false;
   whitenet  = false;
   whitehost = false;
   blackip   = false;
   TString    host2 = "", host3 = "";

   if (m_whiteip != NULL)
      whiteip = m_whiteip->IsWhiteIp(ip);

   if (m_whitenet != NULL)
   {
      whitenet  = m_whitenet->IsInNet(ip);
      whitehost |= m_whitenet->IsInNet(host.c_str());
      if ( (!host.empty()) && (!whitehost) )
      {
         host2 = GetDomen2level(host);
         whitehost |= m_whitenet->IsInNet(host2.c_str());
      }
      if ( (!host.empty()) && (!whitehost) )
      {
         host3 = GetDomen3level(host);
         whitehost |= m_whitenet->IsInNet(host3.c_str());
      }
   }
}

void TBasesStore::GetGreyListsStatus(TKIPv6 ip, TString &host, TGrayListStatus &status)
{
   TString    host2 = "", host3 = "";

   status.Clear();
   for (ui32 i = 0; i < TGrayListStatus::GREYLIST_COUNT; i++)
   {
      if (m_greylistaddr[i] != NULL)
         status.addr[i] = m_greylistaddr[i]->IsWhiteIp(ip);

      if (m_greylistnet[i] != NULL)
      {
         status.net[i]  = m_greylistnet[i]->IsInNet(ip);
         status.host[i] |= m_greylistnet[i]->IsInNet(host.c_str());
         if ( (!host.empty()) && (!status.host[i]) )
         {
            host2 = GetDomen2level(host);
            status.host[i] |= m_greylistnet[i]->IsInNet(host2.c_str());
         }
         if ( (!host.empty()) && (!status.host[i]) )
         {
            host3 = GetDomen3level(host);
            status.host[i] |= m_greylistnet[i]->IsInNet(host3.c_str());
         }
      }
   }
}

bool TBasesStore::AddBlackIP(TKIPv6 ip, ui32 bantime, ui8 IntBanIp, bool &exists_ip, bool Manual, bool Blacklist, bool Auto, const TString &user, const bool longb)
{
   bool   res         = false;
   bool   exists      = false;
   time_t currenttime = time(NULL);
   bool   intbanippr  = false;
   ui32   sendtorbl   = 0;

   exists_ip = false;
   if (m_banip != NULL)
   {
      MemBasa.mSetBanNow(ip, true); //     ip  
      exists = m_banip->AddBanIpWOW(ip, bantime, IntBanIp, Manual, Blacklist, Auto, user, longb, sendtorbl);
      exists_ip = exists;

      if (IntBanIp == 1)
         intbanippr = true;

      PrintProtokolLogByType(KManual, ip, currenttime, bantime, intbanippr, sendtorbl);

      res = true;
   }
   return res;
}

bool TBasesStore::AddBan7IP(TKIPv6 ip, ui32 bantime, bool &exists_ip, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, const TString &user)
{
   bool res       = false;
   bool exists    = false;
   ui32 sendtorbl = 0;

   exists_ip = false;
   if (m_banip != NULL)
   {
      exists = m_banip->AddBan7IpWOW(ip, bantime, IntBanIpA, ManualA, BlackListA, RuleA, user, sendtorbl);
      exists_ip = exists;
      if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
      {
         if (exists)
            LogsGroup->ProtokolLog()->WriteMessageAndData("Manual ban (ban7) ip %s already exists (%u), strbl=%u", ip.toStroka().c_str(), bantime, sendtorbl);
         else
            LogsGroup->ProtokolLog()->WriteMessageAndData("Manual ban (ban7) ip: %s (%u), strbl=%u", ip.toStroka().c_str(), bantime, sendtorbl);
      }
      res = true;
   }
   return res;
}

void TBasesStore::ReloadLists()
{
    for (ui32 i = 0; i < TGrayListStatus::GREYLIST_COUNT; i++)
    {
       if (m_greylistaddr[i] != NULL)
          m_greylistaddr[i]->ReloadFileList();

       if (m_greylistnet[i] != NULL)
          m_greylistnet[i]->ReloadFileList();
    }
    if( m_whiteip )
        m_whiteip->ReloadFileList();
    if( m_whitenet )
        m_whitenet->ReloadFileList();
    if (m_follownet)
        m_follownet->ReloadFileList();
    if( m_blackip )
        m_blackip->ReloadFileList();
    if( m_shadyhosts )
        m_shadyhosts->ReloadFileList();
    if( m_ruleprintlist )
        m_ruleprintlist->ReloadFileList();
    if( m_bad1 )
        m_bad1->ReloadFileList();
    if( m_bad2 )
        m_bad2->ReloadFileList();
    if( m_bad3 )
        m_bad3->ReloadFileList();
    if( m_bad4 )
        m_bad4->ReloadFileList();
    if( m_bad5 )
        m_bad5->ReloadFileList();
    if( m_excludestat )
        m_excludestat->ReloadFileList();
    if( m_rbbad )
        m_rbbad->ReloadFileList();
    if( m_rbgood )
        m_rbgood->ReloadFileList();
    if( m_zonestat )
        m_zonestat->ReloadFileList();
    if( m_rbl )
        m_rbl->RefreshBLFiles();


}

bool TBasesStore::TruncDayList()
{
   bool res = true;

   if (m_banip != NULL)
      m_banip->TruncDayList();

   return res;
}

ui32 TBasesStore::PrintProtokolLogByType(TTypeProtokol type, TKIPv6 ip, time_t stime, ui16 hour, bool intbanip, ui32 sendtorbl)
{
   ui32 res = CShingleTime::GetMs();
   if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
   {
      ui32        pos               = 0;
      int         AddBanTime        = 0;
      char        logtbuff[2048];
      ui32        spam              = 0;
      ui32        ham               = 0;
      ui32        dsn               = 0;
      TString      host              = "";
      TString      geo               = "";
      TIpStatOne  ipstat;
      char        tbuff[128];
      tm          ttime;
      TString      timestart         = "";
      TString      ips               = "";
      ui32        banday            = 0;
      ui32        nobanday          = 0;
      TString      internalbanip_s   = "";
      TString      typerecord        = "";

      switch (type)
      {
       case KManual:
                        typerecord = "manual";
                        break;
       case KBlackList:
                        typerecord = "blacklist";
                        break;
      };

      if (intbanip)
        internalbanip_s = "INTERNALBAN";

      ips = ip.toStroka2();
      //memset(ips, 0, sizeof(ips));
      //IntToIp(ip, ips);

      ttime = *localtime(&stime);
      memset(tbuff, 0, sizeof(tbuff));
      strftime(tbuff, sizeof(tbuff) - 1, "%Y.%m.%d %H:%M:%S", &ttime);
      timestart.assign(tbuff);

      ipstat = MemBasa.GetIpStat(ip);
      if (!ipstat.notfound)
      {
         spam     = ipstat.Spam;
         ham      = ipstat.Ham;
         dsn      = ipstat.Dsn;
         host     = ipstat.rdns;
         geo      = ipstat.geo;
         banday   = ipstat.hDaysRej;
         nobanday = ipstat.hDaysNoRej;

         if (CPO != NULL)
            AddBanTime = CPO->GetAddBanTime();

         memset(logtbuff, 0, sizeof(logtbuff));
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "[%s] ", timestart.c_str());
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "Ban=%d cr=%s (%d) ", hour, typerecord.c_str(), AddBanTime);
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "%s ", ips.c_str());
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "[%u %u %u] ", spam, ham, dsn);
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "b:n=%u:%u ", banday, nobanday);
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "%11s", internalbanip_s.c_str());
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "host %s ", host.c_str());
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "geo %s ", geo.c_str());
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "strbl=%u ", sendtorbl);
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "\n");

      } else
      {
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "[%s] ", timestart.c_str());
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "Ban=%d cr=%s (%d) ", hour, typerecord.c_str(), AddBanTime);
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "%s ", ips.c_str());
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "%11s ", internalbanip_s.c_str());
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "strbl=%u ", sendtorbl);
         pos = pos + snprintf(logtbuff + pos, sizeof(logtbuff) - pos - 1, "\n");

      }

      LogsGroup->ProtokolLog()->WriteMessage("%s", logtbuff);
   }
   res = CShingleTime::GetMs() - res;

   return res;
}

bool TBasesStore::DelBanIP(TKIPv6 ip)
{
   bool res = false;
   bool fok = false;

   if (m_banip != NULL)
   {
      fok = m_banip->RemoveBanIp(ip);
      if (fok)
         MemBasa.mClearBanToday(ip);
      if ( (LogsGroup != NULL) && (LogsGroup->ProtokolLog() != NULL) )
      {
         if (fok)
            LogsGroup->ProtokolLog()->WriteMessageAndData("Manual removed ip %s from reject ip list", ip.toStroka().c_str());
         else
            LogsGroup->ProtokolLog()->WriteMessageAndData("Manual remove ip %s from reject ip list - error, ip not found!", ip.toStroka().c_str());
      }
      res = fok;
   }
   return res;
}

bool TBasesStore::SetSetupBanTime(ui32 bantime, ui32 long_bantime)
{
   bool res = true;

   if (m_banip != NULL)
      res = m_banip->SetSetupBanTime(bantime, long_bantime);

   return res;
}

bool TBasesStore::GetSetupBanTime(ui32 &bantime, ui32 &long_bantime)
{
   bool res = true;

   if (m_banip != NULL)
   {
      res = m_banip->GetSetupBanTime(bantime, long_bantime);

   } else
   {
      bantime      = TBanIPListItem::MAX_BAN_HOURS;
      long_bantime = TBanIPListItem::MAX_BAN_HOURS_LONG;
   }

   return res;
}

//*******************************************************************************************
