#pragma once

#include "util/thread/factory.h"
#include "tforwards.h"
#include "baniplist.h"
#include "tbasesstore_other.h"
#include "tmembasaclass.h"
#include <mail/so/spamstop/tools/so-common/thashipv6.h>
#include <mail/so/spamstop/tools/so-common/tnetipv6.h>
#include <mail/so/spamstop/tools/so-common/tkipv6classes.h>
#include "tblackhashipv6.h"

typedef enum {KManual, KBlackList} TTypeProtokol;


//**********************************************************************************************************************************************
//                                                       TBasesStore
//**********************************************************************************************************************************************

class TBasesStore
{
private:
         //LoggerHandler        m_loghandler;
         TBanIPListGeneral    *m_banip;    //����, � ������� �������� ���������� ip
         TMemBaseMain         MemBasa;     //���� � ������
         TLogsGroup           *LogsGroup;
         TChangeProperties    *CPO;        //"������� ������" ��������

   kipv6::TWhiteIPv6           *m_greylistaddr[TGrayListStatus::GREYLIST_COUNT];
         TNetKIPv6            *m_greylistnet[TGrayListStatus::GREYLIST_COUNT];
   kipv6::TWhiteIPv6           *m_whiteip;
         TNetKIPv6            *m_whitenet;
         TNetKIPv6            *m_follownet;
   TBlackIPv6           *m_blackip;
   kipv6::TStringsLists        *m_shadyhosts;
   kipv6::TStringsLists        *m_ruleprintlist;
   kipv6::TStringsNumberLists  *m_bad1;
   kipv6::TStringsNumberLists  *m_bad2;
   kipv6::TStringsNumberLists  *m_bad3;
   kipv6::TStringsNumberLists  *m_bad4;
   kipv6::TStringsNumberLists  *m_bad5;
   kipv6::TStringsNumberLists  *m_rbbad;
   kipv6::TStringsNumberLists  *m_rbgood;
   kipv6::TStringsNumberLists  *m_excludestat;
   kipv6::TZoneStat            *m_zonestat;
   kipv6::TRblIPv6             *m_rbl;
         int                  m_catchdelay;

         ui32                 PrintProtokolLogByType(TTypeProtokol type, TKIPv6 ip, time_t stime, ui16 hour, bool intbanip, ui32 sendtorbl);
public:
         TBasesStore();
         ~TBasesStore();

         bool InitBeforeFork(void *statipobj, TLogsGroup *LogsGroupA, TKConfig *configobjA, TChangeProperties *CPOA);
         bool InitAfterFork();

         void                    Midnight();
         void                    EventTick();

         TBanIPListGeneral    *GetBanIP()          { return m_banip;          }
         TMemBaseMain         *GetMemBasa()        { return &MemBasa;         }
         TChangeProperties    *GetCPO()            { return CPO;              }

         TNetKIPv6            *GetFollowList()     { return m_follownet;      }
   kipv6::TWhiteIPv6           *GetWhiteIP()        { return m_whiteip;        }
         TNetKIPv6            *GetWhiteNet()       { return m_whitenet;       }
   TBlackIPv6           *GetBlackIP()        { return m_blackip;        }
   kipv6::TStringsLists        *GetShadyHosts()     { return m_shadyhosts;     }
   kipv6::TStringsLists        *GetRulePrintList()  { return m_ruleprintlist;  }
   kipv6::TStringsNumberLists  *GetBad1()           { return m_bad1;           }
   kipv6::TStringsNumberLists  *GetBad2()           { return m_bad2;           }
   kipv6::TStringsNumberLists  *GetBad3()           { return m_bad3;           }
   kipv6::TStringsNumberLists  *GetBad4()           { return m_bad4;           }
   kipv6::TStringsNumberLists  *GetBad5()           { return m_bad5;           }
   kipv6::TStringsNumberLists  *GetRBBad()          { return m_rbbad;          }
   kipv6::TStringsNumberLists  *GetRBGood()         { return m_rbgood;         }
   kipv6::TStringsNumberLists  *GetExcludeStat()    { return m_excludestat;    }
   kipv6::TZoneStat            *GetZoneStat()       { return m_zonestat;       }
   kipv6::TRblIPv6             *GetRBL()            { return m_rbl;            }
         int                  GetCatchDelay()      { return m_catchdelay;     }


         void                 GetListsStatus(TKIPv6 ip, TString &host, bool &whiteip, bool &whitehost, bool &whitenet, bool &blackip);
         void                 GetGreyListsStatus(TKIPv6 ip, TString &host, TGrayListStatus &status);
         bool                 AddBlackIP(TKIPv6 ip, ui32 bantime, ui8 IntBanIp, bool &exists_ip, bool Manual, bool Blacklist, bool Auto, const TString &user, const bool longb);
         bool                 AddBan7IP(TKIPv6 ip, ui32 bantime, bool &exists_ip, bool IntBanIpA, bool ManualA, bool BlackListA, bool RuleA, const TString &user);
         bool                 DelBanIP(TKIPv6 ip);
         void                 ReloadLists();
         bool                 TruncDayList();

         bool                 SetSetupBanTime(ui32 bantime, ui32 long_bantime);
         bool                 GetSetupBanTime(ui32 &bantime, ui32 &long_bantime);
};

//*********************************************************************************************************************************************


